/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.numeric;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public class XVectorWidthBucketDouble
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;
    private final long min;
    private final long max;
    private long nBuckets;

    public XVectorWidthBucketDouble(int inColumnNo, Number inMin, Number inMax, Number inNumBuckets, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
        this.min = inMin.longValue();
        this.max = inMax.longValue();
        this.nBuckets = inNumBuckets.longValue();
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = inputColVector.noNulls;
        double[] vector = inputColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (inputColVector.isRepeating) {
            outputVector[0] = this.widthBucket(vector[0]);
            outputIsNull[0] = inputIsNull[0];
            outputColVector.isRepeating = true;
        } else if (inputColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.widthBucket(vector[i]);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.widthBucket(vector[i]);
                }
            }
            outputColVector.isRepeating = false;
        } else {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputVector[i] = this.widthBucket(vector[i]);
                    outputIsNull[i] = inputIsNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = this.widthBucket(vector[i]);
                }
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            }
            outputColVector.isRepeating = false;
        }
    }

    public long widthBucket(double operand) {
        if (this.min < this.max) {
            if (operand < (double)this.min) {
                return 0L;
            }
            if (operand >= (double)this.max) {
                return this.nBuckets + 1L;
            }
            return (long)(Math.floor((double)this.nBuckets * (operand - (double)this.min) / (double)(this.max - this.min)) + 1.0);
        }
        if (operand > (double)this.min) {
            return 0L;
        }
        if (operand <= (double)this.max) {
            return this.nBuckets + 1L;
        }
        return (long)Math.floor((double)this.nBuckets * ((double)this.min - operand) / (double)(this.min - this.max) + 1.0);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }
}

