/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.regex;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.AbstractLikeColumnScalar;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.CursorFactory;
import com.ibm.xml.xci.RequestInfo;
import com.ibm.xml.xci.SessionContext;
import com.ibm.xml.xci.VolatileCData;
import com.ibm.xml.xci.exec.BasicMutableDynamicContext;
import com.ibm.xml.xci.exec.BasicStaticContext;
import com.ibm.xml.xci.exec.DynamicContext;
import com.ibm.xml.xci.exec.Executable;
import com.ibm.xml.xci.exec.Preparer;
import com.ibm.xml.xci.exec.StaticContext;
import com.ibm.xml.xci.serializer.SerializeParamValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class XVectorFilterNotLikeRegexColumnScalar
extends AbstractLikeColumnScalar {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_FLAGS = "flags";
    private static final List<AbstractLikeColumnScalar.PatternMatcherFactory> MATCHER_FACTORIES = Arrays.asList(new StartsWithCheckerFactory(), new EndsWithCheckerFactory(), new ContainsCheckerFactory(), new NoneCheckerFactory(), new ComplexCheckerFactory());
    private AbstractLikeColumnScalar.PatternMatcher matcher;
    private static final String LITERAL_CHAR = "[^\\[\\]\\\\(){}*?+|$^.]";
    private static final String LITERAL_CHAR_GROUP = "([^\\[\\]\\\\(){}*?+|$^.]+)";
    private static final String DOT_STAR = "\\.\\*";

    public XVectorFilterNotLikeRegexColumnScalar(int inColumnNo, String inPattern, String inFlags) {
        super(inColumnNo, inPattern, inFlags);
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.matcher == null) {
            this.matcher = this.createPatternMatcher(context);
        }
        int[] selected = batch.selected;
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
        boolean[] isNull = inputColumnVector.isNull;
        String[] vector = inputColumnVector.vector;
        if (inputColumnVector.noNulls) {
            if (inputColumnVector.isRepeating) {
                if (this.matcher.check(vector[0].getBytes(), vector[0].length())) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColumnVector.isRepeating) {
            if (!isNull[0]) {
                if (this.matcher.check(vector[0].getBytes(), vector[0].length())) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (isNull[i] || this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        } else {
            int newSize = 0;
            for (int i = 0; i < n; ++i) {
                if (isNull[i] || this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    protected List<AbstractLikeColumnScalar.PatternMatcherFactory> getPatternMatcherFactories() {
        return MATCHER_FACTORIES;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        if (this.escCharOrFlags != null) {
            trace.attribute(ATTRIBUTE_FLAGS, this.escCharOrFlags);
        }
    }

    protected static class ComplexPatternMatcher
    implements AbstractLikeColumnScalar.PatternMatcher {
        private static final String[] XQUERY = new String[]{"matches($s, $p)", "matches($s, $p, $f)"};
        private static SessionContext session = new SessionContext((ClassLoader)null);
        private static CursorFactory factory = session.getSimpleDataFactory();
        private static StaticContext staticCxt = new BasicStaticContext(session.getTypeRegistry());
        private static QName s;
        private static QName p;
        private static QName f;
        private static Preparer preparer;
        private static Map<String, Object> properties;
        private static Executable[] qExpr;
        private DynamicContext dynamicCxt = new BasicMutableDynamicContext(session, staticCxt);
        private Executable matches;

        ComplexPatternMatcher(String pattern, String flags) {
            this.dynamicCxt.bindVariable(p, factory.sequence((CharSequence)pattern, null, false));
            if (flags == null) {
                this.matches = qExpr[0];
            } else {
                this.matches = qExpr[1];
                this.dynamicCxt.bindVariable(f, factory.sequence((CharSequence)flags, null, false));
            }
        }

        @Override
        public boolean check(byte[] byteS, int len) {
            this.dynamicCxt.bindVariable(s, factory.sequence((CharSequence)new String(byteS), null, false));
            Cursor result = this.matches.execute(null, this.dynamicCxt, Cursor.RANDOM_ACCESS, null);
            VolatileCData data = result.serialize(properties);
            return data.getBoolean(1);
        }

        static {
            staticCxt.setLanguageTypeAndVersion(1);
            staticCxt.setBaseURI(System.getProperty("user.dir"));
            s = new QName("s");
            p = new QName("p");
            f = new QName("f");
            preparer = session.getPreparer(RequestInfo.XQuery);
            properties = new HashMap<String, Object>();
            properties.put("omit-xml-declaration", Boolean.TRUE);
            properties.put("method", SerializeParamValue.METHOD_XML);
            properties.put("indent", Boolean.FALSE);
            qExpr = new Executable[2];
            for (int i = 0; i < 2; ++i) {
                ComplexPatternMatcher.qExpr[i] = preparer.prepare(XQUERY[i], staticCxt, -1);
            }
        }
    }

    private static class ComplexCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private ComplexCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String flags) {
            return new ComplexPatternMatcher(pattern, flags);
        }
    }

    private static class NoneCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern NONE_PATTERN = Pattern.compile("([^\\[\\]\\\\(){}*?+|$^.]+)");

        private NoneCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String flags) {
            Matcher matcher;
            if (flags == null && (matcher = NONE_PATTERN.matcher(pattern)).matches()) {
                return new AbstractLikeColumnScalar.NonePatternMatcher(pattern);
            }
            return null;
        }
    }

    private static class ContainsCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern CONTAINS_PATTERN = Pattern.compile("\\.\\*([^\\[\\]\\\\(){}*?+|$^.]+)\\.\\*");

        private ContainsCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String flags) {
            Matcher matcher;
            if (flags == null && (matcher = CONTAINS_PATTERN.matcher(pattern)).matches()) {
                return new AbstractLikeColumnScalar.ContainsPatternMatcher(matcher.group(1));
            }
            return null;
        }
    }

    private static class EndsWithCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern ENDS_WITH_PATTERN = Pattern.compile("\\.\\*([^\\[\\]\\\\(){}*?+|$^.]+)");

        private EndsWithCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String flags) {
            Matcher matcher;
            if (flags == null && (matcher = ENDS_WITH_PATTERN.matcher(pattern)).matches()) {
                return new AbstractLikeColumnScalar.EndsWithPatternMatcher(matcher.group(1));
            }
            return null;
        }
    }

    private static class StartsWithCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern STARTS_WITH_PATTERN = Pattern.compile("([^\\[\\]\\\\(){}*?+|$^.]+)\\.\\*");

        private StartsWithCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String flags) {
            Matcher matcher;
            if (flags == null && (matcher = STARTS_WITH_PATTERN.matcher(pattern)).matches()) {
                return new AbstractLikeColumnScalar.StartsWithPatternMatcher(matcher.group(1));
            }
            return null;
        }
    }
}

