/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.set;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import com.yahoo.sketches.hll.HllSketch;
import org.dom4j.Element;

public class XVectorAggregateApproxCountDistinctString
extends XVectorSetFunction {
    private static final long serialVersionUID = 1L;

    public XVectorAggregateApproxCountDistinctString(int inputColumnNo) {
        super(inputColumnNo);
    }

    public XVectorAggregateApproxCountDistinctString() {
    }

    @Override
    public XVectorSetFunction.AggregateState getAggregateState() {
        return new State();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.dataType = DataTypeFactory.getLongType();
    }

    public static final class State
    implements XVectorSetFunction.AggregateState {
        private int lgk;
        private final HllSketch hllSketch;

        public State() {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            this.lgk = config.getIntProperty("queryExecution.approxAggregates.lgK[@value]", 12);
            if (this.lgk < 4 || this.lgk > 21) {
                this.lgk = 12;
            }
            this.hllSketch = new HllSketch(this.lgk);
        }

        @Override
        public void reset() {
            this.hllSketch.reset();
        }

        @Override
        public void iterate(XDataContext context, ColumnVector inputVector, int i) {
            if (inputVector.isNull[i]) {
                return;
            }
            this.hllSketch.update(inputVector.getString(i));
        }

        @Override
        public void iterateNoNulls(XDataContext context, ColumnVector inputVector, int i) {
            this.hllSketch.update(inputVector.getString(i));
        }

        @Override
        public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex) {
            ((LongColumnVector)batch.columns[targetIndex]).vector[batch.size] = (long)this.hllSketch.getEstimate();
        }
    }
}

