/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.set;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorBatchPartition;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorAggregateCountStar
extends XVectorSetFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public void aggregate(XDataContext context, XVectorSetFunction.AggregateState state, XVectorRowBatch batch) {
        State state2 = (State)state;
        state2.count = state2.count + batch.size;
    }

    @Override
    public void aggregate(XDataContext context, XVectorBatchPartition partition, int index, XVectorRowBatch batch) {
        State state;
        State state2 = state = (State)partition.getAggregateState(index);
        state2.count = state2.count + batch.size;
    }

    @Override
    public void aggregate(XDataContext context, XVectorBatchPartition[] partitions, int index, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        int[] selected = batch.selected;
        if (batch.selectedInUse) {
            for (int i = 0; i < n; ++i) {
                this.getState(partitions, index, i).iterate(context, null, selected[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.getState(partitions, index, i).iterate(context, null, i);
            }
        }
    }

    @Override
    public XVectorSetFunction.AggregateState getAggregateState() {
        return new State();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getLongType();
    }

    private static final class State
    implements XVectorSetFunction.AggregateState {
        private int count;

        private State() {
        }

        @Override
        public void reset() {
            this.count = 0;
        }

        @Override
        public void iterate(XDataContext context, ColumnVector inputVector, int i) {
            ++this.count;
        }

        @Override
        public void iterateNoNulls(XDataContext context, ColumnVector inputVector, int i) {
            ++this.count;
        }

        @Override
        public void getResult(XDataContext context, XVectorRowBatch batch, int targetIndex) {
            ((LongColumnVector)batch.columns[targetIndex]).vector[batch.size] = this.count;
        }
    }
}

