/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellUpdateResultSet;

public class V5MappedCellIterator
extends XCellIterator {
    private V5ResultSet mThisV5ResultSet;
    private XCellIterator mCellIterator;
    private boolean mEod;

    public V5MappedCellIterator(XDataContext dataContext, V5ResultSet v5ResultSet, XCellIterator cellIterator, Integer theNodeId) {
        super(dataContext, theNodeId);
        try {
            this.mThisV5ResultSet = v5ResultSet;
            this.mEod = false;
            if (this.mThisV5ResultSet.mEdges.length == 0 || !this.mThisV5ResultSet.mEdges[0].getDataset().isCrossTabReport()) {
                this.mEod = true;
            }
            this.mCellIterator = cellIterator;
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    @Override
    public void release() {
        if (this.mCellIterator != null) {
            this.mCellIterator.release();
            this.mCellIterator = null;
        }
        this.currentOrdinal = -1L;
        this.mEod = true;
    }

    @Override
    public ICell nextImpl() {
        if (this.hasNext()) {
            ++this.currentOrdinal;
            ICell cell = this.mCellIterator.nextImpl();
            if (cell != null) {
                cell = this.mThisV5ResultSet.processV5Cell(cell);
            }
            return cell;
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        ICell cell;
        String sV5MappedCellIteratorId = "V5MappedCellIterator id = ";
        if (this.mEod) {
            return false;
        }
        if (!this.mCellIterator.hasNext()) {
            this.mEod = true;
            return false;
        }
        long baseCellIndex = this.mThisV5ResultSet.mapV5CellOrdinal(this.currentOrdinal + 1L);
        if (this.mCellIterator.getIndex() >= baseCellIndex) {
            cell = this.mCellIterator.nextImpl();
            if (cell == null) {
                this.mEod = true;
                return false;
            }
            if (this.mThisV5ResultSet instanceof XV5CellUpdateResultSet) {
                this.currentOrdinal = this.mCellIterator.getIndex() - 1L;
                return true;
            }
            boolean bFoundTheCorrectIndex = false;
            long i = this.currentOrdinal + 1L;
            while (!bFoundTheCorrectIndex) {
                if ((baseCellIndex = this.mThisV5ResultSet.mapV5CellOrdinal(++i + 1L)) == -1L) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("V5MappedCellIterator id = ");
                    sb.append(this.getIndex());
                    throw new XQERuntimeException(XQEMessageKeys.PLN_XQEQueryNodeInternalError_INTERNAL, sb.toString(), "baseCellIndex == -1");
                }
                if (this.mCellIterator.getIndex() >= baseCellIndex) continue;
                bFoundTheCorrectIndex = true;
                this.currentOrdinal = i;
            }
        }
        while (this.mCellIterator.getIndex() < baseCellIndex - 1L) {
            cell = this.mCellIterator.nextImpl();
            if (cell != null) continue;
            this.mEod = true;
            return false;
        }
        if (!this.mCellIterator.hasNext()) {
            this.mEod = true;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPipelineIterator() {
        return this.mCellIterator.hasPipelineIterator();
    }
}

