/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultsets.BaseIterator;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class V5OnHybridEdgeIterator
extends XIterator {
    private IIterator mIterator;
    private boolean mEod = false;
    private List<ContextBase> mResults;
    private RSAPIEdge mEdge;
    private Map<Integer, Integer> mRowsetParents;
    private Map<Integer, RowValue> mV5RowCache;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public V5OnHybridEdgeIterator(XDataContext theContext, Integer id, RSAPIEdge edge, IIterator iterator) {
        super(theContext, id);
        try {
            this.mEdge = edge;
            this.mIterator = iterator;
            this.mV5RowCache = new HashMap<Integer, RowValue>();
            if (this.mIterator == null) {
                this.mEod = true;
            }
            this.initializeRowsetParents();
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    private void initializeRowsetParents() {
        RSAPIEdgeRowset[] edgeRowsets;
        if (this.mEdge == null) {
            return;
        }
        this.mRowsetParents = new HashMap<Integer, Integer>();
        for (RSAPIEdgeRowset rowset : edgeRowsets = this.mEdge.getRowsets()) {
            if (rowset.getParentRowset() != null) {
                this.mRowsetParents.put(XQEIntegerPool.getInteger(rowset.getRowsetId()), XQEIntegerPool.getInteger(rowset.getParentRowset().getRowsetId()));
                continue;
            }
            this.mRowsetParents.put(XQEIntegerPool.getInteger(rowset.getRowsetId()), XQEIntegerPool.getInteger(-1));
        }
    }

    @Override
    public Object nextImpl() {
        if (this.mEod) {
            return null;
        }
        this.mResults = new ArrayList<ContextBase>();
        RowValue hybridRow = (RowValue)this.mIterator.next();
        if (hybridRow == null) {
            return null;
        }
        for (int i = 0; i < hybridRow.getNumColumns(); ++i) {
            IValue v = hybridRow.getColumn(i);
            if (v == NullValue.NULLVALUE || v == null) continue;
            if (v instanceof ContextBase) {
                ContextBase contextBase = (ContextBase)((Object)v);
                RSAPIDataset dataset = this.mEdge.getDataset();
                if (dataset.isForOLAPQuery() || dataset.isForRelationalOLAPQuery()) {
                    this.transferContextToRow(contextBase);
                    continue;
                }
                this.mResults.add(contextBase);
                continue;
            }
            ContextValue sContextValue = new ContextValue(v);
            this.mResults.add(sContextValue);
        }
        if (this.mResults.size() == 0) {
            this.mEod = true;
            return null;
        }
        ++this.currentIndex;
        Integer key = XQEIntegerPool.getInteger(this.mResults.size());
        RowValue v5Row = this.mV5RowCache.get(key);
        if (v5Row == null) {
            IValue[] values = new IValue[this.mResults.size()];
            this.mResults.toArray(values);
            v5Row = DataValueFactory.createRowValue(values);
            this.mV5RowCache.put(key, v5Row);
        } else {
            this.mResults.toArray(v5Row.getColumns());
        }
        return v5Row;
    }

    @Override
    public long positionOnRow(long detailRowNumber, boolean fromTop) {
        if (this.mIterator instanceof BaseIterator) {
            return ((BaseIterator)this.mIterator).positionOnRow(detailRowNumber, fromTop);
        }
        return -1L;
    }

    private void transferContextToRow(ContextBase contextBase) {
        if (contextBase == null) {
            return;
        }
        for (ContextBase aMember : this.mResults) {
            if (!this.isEmptySummary(aMember)) continue;
            return;
        }
        RSAPIEdgeRowset baseRowset = (RSAPIEdgeRowset)contextBase.getRowset();
        if (contextBase.getContextMember() != null) {
            if (contextBase.contextIsAMember()) {
                this.transferContextToRow(contextBase.getContextMember());
            } else if (contextBase.isSummary()) {
                if (this.isEmptySummary(contextBase)) {
                    this.transferContextToRow(contextBase.getContextMember());
                } else {
                    ContextMember contextMember = contextBase.getContextMember();
                    if (contextMember.getContextMember() != null && ((ContextBase)contextMember).isQueryCalculation()) {
                        contextMember = contextMember.getContextMember();
                    }
                    RSAPIEdgeRowset cxtRowset = (RSAPIEdgeRowset)contextMember.getRowset();
                    if (contextBase.getContextMember().isSummary() && cxtRowset != null && !cxtRowset.isFooterRowset() && !cxtRowset.isDetailRowset() || contextMember != null && baseRowset != null && this.rowIsDescendant(cxtRowset.getRowsetId(), baseRowset.getRowsetId())) {
                        this.transferContextToRow(contextMember);
                    }
                }
            }
        }
        if (contextBase.contextIsAMember() && contextBase.isSummary() && !this.isEmptySummary(contextBase)) {
            return;
        }
        if (baseRowset == null) {
            return;
        }
        for (ContextBase aMember : this.mResults) {
            if (aMember.getRowset() == baseRowset && aMember.getDataItemIndex() == contextBase.getDataItemIndex()) {
                return;
            }
            if (baseRowset.compareQRDOrderTo((RSAPIEdgeRowset)aMember.getRowset()) >= 0) continue;
            int index = this.mResults.indexOf(aMember);
            this.mResults.add(index, contextBase);
            if (this.isEmptySummary(contextBase)) {
                this.mResults = this.mResults.subList(0, index);
            }
            return;
        }
        this.mResults.add(contextBase);
    }

    private boolean isEmptySummary(ContextBase contextBase) {
        if (!contextBase.isSummary()) {
            return false;
        }
        if (contextBase.getDataItemIndex() == -2) {
            return true;
        }
        for (ContextMember aContextMember = contextBase.getContextMember(); aContextMember != null; aContextMember = aContextMember.getContextMember()) {
            if (aContextMember.getDataItemIndex() != -2) continue;
            return true;
        }
        return false;
    }

    private boolean rowIsDescendant(int parentRowsetId, int rowsetId) {
        while (rowsetId != -1) {
            if (this.mRowsetParents.get(rowsetId) == parentRowsetId) {
                return true;
            }
            rowsetId = this.mRowsetParents.get(rowsetId);
        }
        return false;
    }

    @Override
    public void release() {
        if (this.mIterator != null) {
            try {
                this.mIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.mIterator = null;
            }
        }
    }
}

