/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class V5ScrollableMappedEdgeIterator
extends XScrollableIterator {
    private V5ResultSet mThisV5ResultSet;
    protected RSAPIEdge mEdge;
    private long mNumRows;
    protected IScrollableIterator mBaseIterator;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public V5ScrollableMappedEdgeIterator(XDataContext dataContext, V5ResultSet v5ResultSet, RSAPIEdge edge, IScrollableIterator edgeIterator, Integer id) {
        super(dataContext, id);
        try {
            this.mThisV5ResultSet = v5ResultSet;
            this.mEdge = edge;
            this.mNumRows = this.mThisV5ResultSet.getV5EdgeSize(this.mEdge);
            this.mBaseIterator = edgeIterator;
            this.currentIndex = -1L;
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    @Override
    public Object current() {
        if (this.currentIndex <= -1L || this.currentIndex >= this.mNumRows) {
            return null;
        }
        long newOrdinal = this.mThisV5ResultSet.mapV5EdgeOrdinal(this.mEdge, this.currentIndex);
        this.mBaseIterator.absolute(newOrdinal);
        RowValue rowValue = (RowValue)this.mBaseIterator.current();
        if (rowValue != null) {
            rowValue = this.mThisV5ResultSet.processV5Row(this.mEdge, this.currentIndex, rowValue);
        }
        return rowValue;
    }

    @Override
    public boolean absolute(long theIndex) {
        if (theIndex <= -1L || theIndex >= this.mNumRows) {
            return false;
        }
        this.currentIndex = theIndex;
        return true;
    }

    @Override
    public Object nextImpl() {
        if (this.currentIndex >= this.mNumRows - 1L) {
            return null;
        }
        ++this.currentIndex;
        return this.current();
    }

    @Override
    public boolean hasPrevious() {
        return this.currentIndex > 0L;
    }

    @Override
    public Object previous() {
        if (!this.hasPrevious()) {
            return null;
        }
        --this.currentIndex;
        return this.current();
    }

    @Override
    public void reset() {
        this.currentIndex = -1L;
    }

    @Override
    public void release() {
        if (this.mBaseIterator != null) {
            try {
                this.mBaseIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.mBaseIterator = null;
            }
        }
    }
}

