/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.v5.V5MappedCellIterator;
import com.cognos.xqe.runtree.v5.V5MappedEdgeIterator;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5Demo
extends XNode {
    private static final long serialVersionUID = 0L;
    public static final String NODE_TYPE_NAME = "XV5Demo";
    private static final String V5DEMOSPEC = "V5DemoSpec";
    private static final String EDGENUM = "EdgeNum";
    private static final String ROWSETID = "RowsetId";
    private static final String COLUMNNUM = "ColumnNum";
    private static final String NULL = "NULL";
    private List<XV5DemoSpec> mV5DemoSpecs = new ArrayList<XV5DemoSpec>();
    private int mDebugLevel = 0;
    public static final int KXV5DEMO_DEBUG_NONE = 0;
    public static final int KXV5DEMO_DEBUG_EXECUTE = 1;
    public static final int KXV5DEMO_DEBUG_ROWSETS = 2;
    public static final int KXV5DEMO_DEBUG_ROWS = 3;
    public static final int KXV5DEMO_DEBUG_ALLROWS = 4;
    private static final String BLANK = " ";
    private static final String COLON = ":";

    public void setDebug(int debugLevel) {
        this.mDebugLevel = debugLevel;
    }

    public void addV5DemoSpec(int theEdgeNum, int theRowsetId, int theColumnNum) {
        XV5DemoSpec v5DemoSpec = new XV5DemoSpec(theEdgeNum, theRowsetId, theColumnNum);
        this.mV5DemoSpecs.add(v5DemoSpec);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        if (this.mDebugLevel >= 1) {
            XQEDebugLog.out.println("V5Demo Execute!");
            for (int inx = 0; inx < this.mV5DemoSpecs.size(); ++inx) {
                XV5DemoSpec spec = this.mV5DemoSpecs.get(inx);
                String sOutput = inx + ": E" + spec.getEdgeNum() + " R" + spec.getRowsetId() + " C" + spec.getColumnNum();
                XQEDebugLog.out.println(sOutput);
            }
        }
        IV5ResultSet sourceV5Result = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        return new V5HybridResultSet(context, new XV5DemoResultSet(context, this, sourceV5Result), this.getId());
    }

    @Override
    public int getType() {
        return 501079;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == this.getType()) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List v5DemoSpecsList = inputNode.elements(V5DEMOSPEC);
        ListIterator it = v5DemoSpecsList.listIterator();
        int i = 0;
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            int edgeNum = Integer.parseInt(anElement.attributeValue(EDGENUM));
            int rowsetId = Integer.parseInt(anElement.attributeValue(ROWSETID));
            int columnNum = Integer.parseInt(anElement.attributeValue(COLUMNNUM));
            this.addV5DemoSpec(edgeNum, rowsetId, columnNum);
            it.remove();
            ++i;
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        for (XV5DemoSpec v5DemoSpec : this.mV5DemoSpecs) {
            trace.beginElement(V5DEMOSPEC, -1);
            trace.attribute(EDGENUM, Integer.toString(v5DemoSpec.getEdgeNum()));
            trace.attribute(ROWSETID, Integer.toString(v5DemoSpec.getRowsetId()));
            trace.attribute(COLUMNNUM, Integer.toString(v5DemoSpec.getColumnNum()));
            trace.endElement(-1);
        }
    }

    public static void dumpRowsets(String title, RSAPIEdgeRowset[] myRowsets) {
        XQEDebugLog.out.println(title);
        if (myRowsets == null) {
            XQEDebugLog.out.println("No rowsets");
            return;
        }
        for (int rowInx = 0; rowInx < myRowsets.length; ++rowInx) {
            RSAPIEdgeRowset rowset2;
            RSAPIEdgeRowset rowset = myRowsets[rowInx];
            String sOutput = "RS " + rowInx + ": " + rowset.getName();
            if (rowset.isFooterRowset()) {
                sOutput = sOutput + " isFooter";
            }
            if (rowset.isHeaderRowset()) {
                sOutput = sOutput + " isHeader";
            }
            if (rowset.isMeasureRowset()) {
                sOutput = sOutput + " isMeasure";
            }
            if (rowset.isTimeRowset()) {
                sOutput = sOutput + " isTime";
            }
            if ((rowset2 = rowset.getFooterRowset()) != null) {
                sOutput = sOutput + " Footer=" + rowset2.getName();
            }
            if ((rowset2 = rowset.getHeaderRowset()) != null) {
                sOutput = sOutput + " Header=" + rowset2.getName();
            }
            if ((rowset2 = rowset.getNestedRowset()) != null) {
                sOutput = sOutput + " Nested=" + rowset2.getName();
            }
            if ((rowset2 = rowset.getParentRowset()) != null) {
                sOutput = sOutput + " Parent=" + rowset2.getName();
            }
            if ((rowset2 = rowset.getSiblingRowset()) != null) {
                sOutput = sOutput + " Sibling=" + rowset2.getName();
            }
            XQEDebugLog.out.println(sOutput);
            RSAPIColumn[] columns = rowset.getColumns();
            if (columns == null) {
                XQEDebugLog.out.println(". No columns");
                continue;
            }
            for (int iCol = 0; iCol < columns.length; ++iCol) {
                RSAPIColumn column = columns[iCol];
                sOutput = ". '" + column.getName() + "' '" + column.getLabel() + "'";
                IDataType datatype = column.getDatatype();
                sOutput = datatype == null ? sOutput + " No Datatype" : sOutput + BLANK + datatype.getTypeName();
                if (column.getIsCanonicalProperty()) {
                    sOutput = sOutput + " Prop";
                }
                XQEDebugLog.out.println(sOutput);
            }
        }
    }

    public static void dumpRow(V5ResultSet v5ResultSet, RSAPIEdge edge, long iRow, RowValue rowValue) {
        String sOutput = "Row " + iRow;
        if (v5ResultSet != null) {
            sOutput = sOutput + "/" + v5ResultSet.mapV5EdgeOrdinal(edge, iRow);
        }
        sOutput = sOutput + COLON;
        for (int iCol = 0; iCol < rowValue.getNumColumns(); ++iCol) {
            ContextBase base = (ContextBase)((Object)rowValue.getColumn(iCol));
            sOutput = sOutput + BLANK + iCol + "[";
            if (base.contextIsAMember()) {
                ContextMember member = (ContextMember)base;
                sOutput = sOutput + (base.isNullContext() ? "null" : base.getRowset().getRowsetId() + COLON + base.getDataItemIndex() + COLON + member.getCaption() + BLANK);
            } else {
                sOutput = sOutput + base.toString();
            }
            sOutput = sOutput + "]";
        }
        XQEDebugLog.out.println(sOutput);
    }

    public static void dumpAllRows(String title, V5ResultSet v5ResultSet, RSAPIEdge edge) {
        RowValue rowValue;
        XQEDebugLog.out.println(title);
        XIterator iterator = v5ResultSet.getV5EdgeIterator(edge);
        long iRow = 0L;
        while ((rowValue = (RowValue)iterator.next()) != null) {
            XV5Demo.dumpRow(v5ResultSet, edge, iRow, rowValue);
            ++iRow;
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    private final class XV5DemoSpec {
        private int mEdgeNum;
        private int mRowsetId;
        private int mColumnNum;

        XV5DemoSpec(int edgeNum, int rowsetId, int columnNum) {
            this.mEdgeNum = edgeNum;
            this.mRowsetId = rowsetId;
            this.mColumnNum = columnNum;
        }

        public int getEdgeNum() {
            return this.mEdgeNum;
        }

        public int getRowsetId() {
            return this.mRowsetId;
        }

        public int getColumnNum() {
            return this.mColumnNum;
        }
    }

    private class XV5DemoResultSet
    extends V5ResultSet {
        private XV5DemoEdge[] mV5DemoEdges;

        XV5DemoResultSet(XDataContext context, XNode node, IV5ResultSet sourceResult) {
            super(context, node, sourceResult);
            this.mV5DemoEdges = new XV5DemoEdge[this.mEdges.length];
            for (int iEdge = 0; iEdge < this.mEdges.length; ++iEdge) {
                this.mV5DemoEdges[iEdge] = new XV5DemoEdge(iEdge);
            }
        }

        @Override
        public ICell processV5Cell(ICell cell) {
            return cell;
        }

        @Override
        public RowValue processV5Row(RSAPIEdge edge, long iRow, RowValue rowValue) {
            if (XV5Demo.this.mDebugLevel >= 3) {
                if (rowValue != null) {
                    XV5Demo.dumpRow(this.mThisV5ResultSet, edge, iRow, rowValue);
                } else {
                    XQEDebugLog.out.println(XV5Demo.NULL);
                }
            }
            return rowValue;
        }

        @Override
        public XIterator getV5EdgeIterator(RSAPIEdge edge) {
            return new V5MappedEdgeIterator(this.getDataContext(), this.mThisV5ResultSet, edge, this.getBaseResultSet().getV5EdgeIterator(edge), XV5Demo.this.getId());
        }

        @Override
        public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this.mThisV5ResultSet, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), XV5Demo.this.getId());
        }

        @Override
        public XCellIterator getV5CellIterator() {
            return new V5MappedCellIterator(this.getDataContext(), this.mThisV5ResultSet, this.getBaseResultSet().getV5CellIterator(), XV5Demo.this.getId());
        }

        @Override
        public XScrollableCellIterator getScrollableV5CellIterator() {
            return new V5ScrollableMappedCellIterator(this.getDataContext(), this.mThisV5ResultSet, this.getBaseResultSet().getScrollableV5CellIterator(), XV5Demo.this.getId());
        }

        private final class XV5DemoEdge {
            private RSAPIEdge mEdge;

            XV5DemoEdge(int theEdgeNumber) {
                this.mEdge = XV5DemoResultSet.this.mEdges[theEdgeNumber];
                if (XV5Demo.this.mDebugLevel >= 2) {
                    RSAPIEdgeRowset[] edgeRowsets = this.mEdge.getRowsets();
                    XV5Demo.dumpRowsets("All Rowsets", edgeRowsets);
                }
                if (XV5Demo.this.mDebugLevel >= 4) {
                    this.dumpAllRows("All Rows");
                }
            }

            private void dumpAllRows(String title) {
                RowValue rowValue;
                XQEDebugLog.out.println(title);
                XIterator iterator = XV5DemoResultSet.this.getV5EdgeIterator(this.mEdge);
                long iRow = 0L;
                while ((rowValue = (RowValue)iterator.next()) != null) {
                    XV5Demo.dumpRow(XV5DemoResultSet.this.mThisV5ResultSet, this.mEdge, iRow, rowValue);
                    ++iRow;
                }
            }
        }
    }
}

