/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQEPersistCreate;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.tabstreamwrapper.V5DataItemToMeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XV5Reform
extends XNode {
    private static final long serialVersionUID = 0L;
    private static final String ELEMENT_TARGET_SPEC = "targetSpec";
    private static final String ELEMENT_SOURCE_SPEC = "sourceSpec";
    private static final String ELEMENT_SOURCE_DATASET = "sourceDataset";
    private static final String ELEMENT_REPORT_MEASURE = "reportMeasure";
    private XV5ReformSpec mTargetSpec;
    private XV5ReformSpec mSourceSpec;
    private RSAPIDataset mSourceDataset = null;
    private boolean mAttributeinGroupbody = false;
    private XV5ReportMeasureSpec mReportMeasure = null;

    @Override
    public int getType() {
        return 501096;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == this.getType()) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        IV5ResultSet sourceResult = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        XV5ReformResultSet v5Result = new XV5ReformResultSet(context, this, sourceResult);
        return new V5HybridResultSet(context, v5Result, this.getId());
    }

    public void addTargetSpec(RSAPIEdge[] edges, RSAPIEdge[] allEdges) {
        this.mTargetSpec = new XV5ReformSpec(edges, allEdges);
    }

    public void addReportMeasureSpec(int reportMeasureEdgePos, boolean bNeedCreate, IMember memberObj, String v5MUN, String v5Cap) {
        this.mReportMeasure = new XV5ReportMeasureSpec();
        this.mReportMeasure.mUselessEdgePos = reportMeasureEdgePos;
        this.mReportMeasure.mNeedCreate = bNeedCreate;
        this.mReportMeasure.mMemberObject = memberObj;
        this.mReportMeasure.mV5MUN = v5MUN;
        this.mReportMeasure.mV5Caption = v5Cap;
    }

    public void addSourceSpec(RSAPIEdge[] edges, RSAPIEdge[] allEdges) {
        this.mSourceSpec = new XV5ReformSpec(edges, allEdges);
    }

    public void addDataSet(RSAPIDataset srcDataset) {
        if (this.mSourceDataset == null) {
            this.mSourceDataset = srcDataset;
        }
    }

    public RSAPIDataset getDataSet() {
        return this.mSourceDataset;
    }

    public void setAttributeinGroupbody(boolean attributeinGroupbody) {
        this.mAttributeinGroupbody = attributeinGroupbody;
    }

    public boolean hasAttributeinGroupbody() {
        return this.mAttributeinGroupbody;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    public void release() {
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.mTargetSpec != null) {
            ctx.elementProperty(ELEMENT_TARGET_SPEC, this.mTargetSpec);
        }
        if (this.mSourceSpec != null) {
            ctx.elementProperty(ELEMENT_SOURCE_SPEC, this.mSourceSpec);
        }
        if (this.mSourceDataset != null) {
            ctx.elementProperty(ELEMENT_SOURCE_DATASET, this.mSourceDataset);
        }
        if (this.mReportMeasure != null) {
            ctx.elementProperty(ELEMENT_REPORT_MEASURE, this.mReportMeasure);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_TARGET_SPEC)) {
            Object val = ctx.elementValue(node, new XV5ReformCreator());
            this.mTargetSpec = (XV5ReformSpec)val;
        } else if (pname.equals(ELEMENT_SOURCE_SPEC)) {
            Object val = ctx.elementValue(node, new XV5ReformCreator());
            this.mSourceSpec = (XV5ReformSpec)val;
        } else if (pname.equals(ELEMENT_SOURCE_DATASET)) {
            Object val = ctx.elementValue(node, new XV5ReformCreator());
            this.mSourceDataset = (RSAPIDataset)val;
        } else if (pname.equals(ELEMENT_REPORT_MEASURE)) {
            Object val = ctx.elementValue(node, new XV5ReformCreator());
            this.mReportMeasure = (XV5ReportMeasureSpec)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public class XV5ReformResultSet
    extends V5ResultSet {
        public static final String XV5REFORM_TAG = "_rm_";
        public static final String XV5REFORM_TAGSEP = "_rm_sep_";
        private XV5ReformEdge[] mReformEdges;
        private long[] mEdgeSize;
        protected RSAPIEdge[] mEdgeInfos;
        private long[] mSrcEdgeSize;
        protected RSAPIEdge[] mSrcEdgeInfos;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XV5ReformResultSet(XDataContext context, XNode node, IV5ResultSet sourceResult) {
            super(context, node, sourceResult);
            XV5Reform owner = (XV5Reform)node;
            this.mReformEdges = new XV5ReformEdge[((XV5Reform)owner).mTargetSpec.mAllEdges.length];
            if (owner.mReportMeasure != null && ((XV5Reform)owner).mReportMeasure.mUselessEdgePos >= 0 && ((XV5Reform)owner).mReportMeasure.mMemberObject != null && (((XV5Reform)owner).mReportMeasure.mMemberObject instanceof MeasureWrapper || ((XV5Reform)owner).mReportMeasure.mMemberObject instanceof V5DataItemToMeasureWrapper)) {
                boolean bReplaced = false;
                RSAPIEdge[] rSAPIEdgeArray = ((XV5Reform)owner).mSourceSpec.mAllEdges;
                int n = rSAPIEdgeArray.length;
                for (int i = 0; i < n; ++i) {
                    RSAPIEdge srcEdge = rSAPIEdgeArray[i];
                    XIterator srcIterator = sourceResult.getV5EdgeIterator(srcEdge);
                    try {
                        ContextMember cMember;
                        ICube cube;
                        IValue[] values;
                        RowValue row = (RowValue)srcIterator.next();
                        if (row != null && (values = row.getColumns()).length > 0 && (cube = (cMember = (ContextMember)values[0]).getMember().getDimension().getCube()) != null && cube instanceof DMRCube) {
                            ((XV5Reform)owner).mReportMeasure.mMemberObject = (IMember)((DMRCube)cube).getWrapper(((XV5Reform)owner).mReportMeasure.mMemberObject);
                            bReplaced = true;
                        }
                    }
                    finally {
                        srcIterator.release();
                    }
                    if (bReplaced) break;
                }
                if (!bReplaced) {
                    ((XV5Reform)owner).mReportMeasure.mNeedCreate = false;
                    ((XV5Reform)owner).mReportMeasure.mMemberObject = null;
                }
            }
            for (RSAPIEdge srcEdge : ((XV5Reform)owner).mSourceSpec.mEdges) {
                RSAPIEdge[] targetEdges = this.getTargetEdges(srcEdge);
                XV5ReformEdge[] theReformEdges = new XV5ReformEdge[targetEdges.length];
                for (int j = 0; j < targetEdges.length; ++j) {
                    int pos = targetEdges[j].getPositionalOrdinal();
                    if (this.mReformEdges[pos] == null) {
                        this.mReformEdges[pos] = new XV5ReformEdge(targetEdges[j]);
                    }
                    theReformEdges[j] = this.mReformEdges[pos];
                    theReformEdges[j].mSrcEdgePos = srcEdge.getPositionalOrdinal();
                }
                long srcOrdinal = 0L;
                XIterator srcIterator = sourceResult.getV5EdgeIterator(srcEdge);
                try {
                    RowValue row = (RowValue)srcIterator.next();
                    while (row != null) {
                        this.buildTree(row, theReformEdges, srcOrdinal);
                        ++srcOrdinal;
                        row = (RowValue)srcIterator.next();
                    }
                }
                finally {
                    srcIterator.release();
                }
            }
            this.mEdgeSize = new long[this.mReformEdges.length];
            this.mEdgeInfos = ((XV5Reform)owner).mTargetSpec.mAllEdges;
            int i = 0;
            for (i = 0; i < this.mReformEdges.length; ++i) {
                boolean bUseless;
                boolean bl = bUseless = owner.mReportMeasure != null && i == ((XV5Reform)owner).mReportMeasure.mUselessEdgePos;
                if (this.mReformEdges[i] != null) {
                    this.mReformEdges[i].buildRowCache();
                    this.mEdgeSize[i] = this.mReformEdges[i].mCache.length;
                    if (!bUseless) continue;
                    this.mReformEdges[i].mbUseless = true;
                    if (this.mEdgeSize[i] != 0L) continue;
                    this.mEdgeSize[i] = this.mReformEdges[i].createOneRowFromMun(owner);
                    continue;
                }
                if (bUseless) {
                    this.mReformEdges[i] = new XV5ReformEdge(((XV5Reform)owner).mTargetSpec.mAllEdges[i]);
                    this.mReformEdges[i].mbUseless = true;
                    this.mEdgeSize[i] = this.mReformEdges[i].createOneRowFromMun(owner);
                    continue;
                }
                this.mEdgeSize[i] = this.getBaseResultSet().getV5EdgeSize(this.mEdgeInfos[i]);
            }
            this.mSrcEdgeInfos = ((XV5Reform)owner).mSourceSpec.mAllEdges;
            this.mSrcEdgeSize = new long[this.mSrcEdgeInfos.length];
            for (i = 0; i < this.mSrcEdgeInfos.length; ++i) {
                this.mSrcEdgeSize[i] = this.getBaseResultSet().getV5EdgeSize(this.mSrcEdgeInfos[i]);
            }
        }

        protected RSAPIEdge[] getTargetEdges(RSAPIEdge srcEdge) {
            RSAPIEdgeRowset[] srcRowsets = srcEdge.getRowsets();
            HashSet<String> s = new HashSet<String>();
            int i = 0;
            for (i = 0; i < srcRowsets.length; ++i) {
                String name = srcRowsets[i].getName();
                int idx = name.indexOf(XV5REFORM_TAG);
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                s.add(name);
            }
            ArrayList<RSAPIEdge> list = new ArrayList<RSAPIEdge>();
            block1: for (int e = 0; e < ((XV5Reform)XV5Reform.this).mTargetSpec.mEdges.length; ++e) {
                RSAPIEdgeRowset[] targetRowsets = ((XV5Reform)XV5Reform.this).mTargetSpec.mEdges[e].getRowsets();
                for (i = 0; i < targetRowsets.length; ++i) {
                    if (!s.contains(targetRowsets[i].getName())) continue;
                    list.add(((XV5Reform)XV5Reform.this).mTargetSpec.mEdges[e]);
                    continue block1;
                }
            }
            RSAPIEdge[] rt = new RSAPIEdge[list.size()];
            System.arraycopy(list.toArray(), 0, rt, 0, list.size());
            return rt;
        }

        protected void buildTree(RowValue row, XV5ReformEdge[] theReformEdges, long edgeOrdinal) {
            IValue[] values = row.getColumns();
            HashMap<String, ContextMember> rowsetNames = new HashMap<String, ContextMember>();
            int i = 0;
            for (i = 0; i < values.length; ++i) {
                RSAPIEdgeRowset rsapiRowset;
                RSAPIEdgeRowset nestedRowset;
                ContextMember cMember = (ContextMember)values[i];
                RSAPIRowset rowset = cMember.getRowset();
                if (rowset == null) continue;
                String name = rowset.getName();
                int idx = name.indexOf(XV5REFORM_TAGSEP);
                if (idx != -1) {
                    String firstName = name.substring(0, idx);
                    String otherName = name.substring(idx + XV5REFORM_TAGSEP.length());
                    if ((idx = otherName.indexOf(XV5REFORM_TAG)) != -1) {
                        otherName = otherName.substring(0, idx);
                    }
                    rowsetNames.put(firstName, cMember);
                    rowsetNames.put(otherName, null);
                } else {
                    idx = name.indexOf(XV5REFORM_TAG);
                    if (idx != -1) {
                        name = name.substring(0, idx);
                    }
                    rowsetNames.put(name, cMember);
                }
                if (!XV5Reform.this.mAttributeinGroupbody || !(rowset instanceof RSAPIEdgeRowset) || (nestedRowset = (rsapiRowset = (RSAPIEdgeRowset)rowset).getNestedRowset()) == null || nestedRowset.getDataItems() == null || nestedRowset.getDataItems().length <= 0) continue;
                boolean notFoundInRow = true;
                for (IValue value : values) {
                    ContextMember aMember;
                    RSAPIRowset currRowset;
                    if (!(value instanceof ContextMember) || (currRowset = (aMember = (ContextMember)value).getRowset()) == null || currRowset.getRowsetId() != nestedRowset.getRowsetId()) continue;
                    notFoundInRow = false;
                    break;
                }
                if (!notFoundInRow) continue;
                rowsetNames.put(rsapiRowset.getNestedRowset().getName(), cMember);
            }
            for (i = 0; i < theReformEdges.length; ++i) {
                theReformEdges[i].buildTree(rowsetNames, edgeOrdinal);
            }
        }

        @Override
        public XIterator getV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mReformEdges[edgeNum] == null) {
                return this.getBaseResultSet().getV5EdgeIterator(edge);
            }
            return new XV5ReformScrollableEdgeIterator(this.getDataContext(), this.mReformEdges[edgeNum], XV5Reform.this.getId());
        }

        @Override
        public long getV5EdgeSize(RSAPIEdge edge) {
            for (int i = 0; i < this.mEdgeInfos.length; ++i) {
                if (this.mEdgeInfos[i] != edge) continue;
                return this.mEdgeSize[i];
            }
            return 0L;
        }

        @Override
        public long mapV5CellOrdinal(long thisOrdinal) {
            long[] edgeOrdinalThis = new long[this.mEdgeSize.length];
            this.getEdgeOrdinalThis(thisOrdinal, edgeOrdinalThis);
            long[] edgeOrdinaSrc = new long[this.mSrcEdgeSize.length];
            Arrays.fill(edgeOrdinaSrc, -1L);
            this.getEdgeOrdinalSrc(edgeOrdinalThis, edgeOrdinaSrc);
            return this.computeBaseOrdinal(edgeOrdinaSrc);
        }

        protected void getEdgeOrdinalThis(long thisOrdinal, long[] edgeOrdinalThis) {
            for (int i = 0; i < edgeOrdinalThis.length; ++i) {
                long edgeSize = this.mEdgeSize[i];
                if (edgeSize > 0L) {
                    long edgeOrdinal = thisOrdinal % edgeSize;
                    thisOrdinal /= edgeSize;
                    edgeOrdinalThis[i] = edgeOrdinal;
                    continue;
                }
                if (this.mEdgeInfos[i].getNumRowsets() <= 0) continue;
                return;
            }
        }

        protected long computeBaseOrdinal(long[] edgeOrdinalSrc) {
            long baseOrdinal = 0L;
            long baseSize = 1L;
            for (int i = 0; i < edgeOrdinalSrc.length; ++i) {
                long baseEdgeOrdinal = edgeOrdinalSrc[i];
                if (baseEdgeOrdinal < 0L) {
                    return -1L;
                }
                long baseEdgeSize = this.mSrcEdgeSize[i];
                if (baseEdgeOrdinal >= baseEdgeSize) {
                    return -1L;
                }
                if (baseEdgeSize <= 0L) {
                    return -1L;
                }
                baseOrdinal += baseEdgeOrdinal * baseSize;
                baseSize *= baseEdgeSize;
            }
            return baseOrdinal;
        }

        protected void getEdgeOrdinalSrc(long[] edgeOrdinalThis, long[] edgeOrdinaSrc) {
            HashMap<Integer, ArrayList> srcValues = new HashMap<Integer, ArrayList>();
            int i = 0;
            block0: for (i = 0; i < edgeOrdinalThis.length; ++i) {
                if (this.mReformEdges[i] == null) {
                    for (int j = 0; j < edgeOrdinaSrc.length; ++j) {
                        if (this.mEdgeInfos[i] != this.mSrcEdgeInfos[j]) continue;
                        if (edgeOrdinalThis[i] <= edgeOrdinaSrc[j]) continue block0;
                        edgeOrdinaSrc[j] = edgeOrdinalThis[i];
                        continue block0;
                    }
                    continue;
                }
                if (this.mReformEdges[i].mbUseless) continue;
                XV5ReformRowValue aRowValue = this.mReformEdges[i].mCache[(int)edgeOrdinalThis[i]];
                Integer srcEdgePos = new Integer(this.mReformEdges[i].mSrcEdgePos);
                ArrayList ls = null;
                if (srcValues.containsKey(srcEdgePos)) {
                    ls = (ArrayList)srcValues.get(srcEdgePos);
                } else {
                    ls = new ArrayList();
                    srcValues.put(srcEdgePos, ls);
                }
                ls.add(aRowValue);
            }
            Set srcEdgePosSet = srcValues.keySet();
            for (Integer key : srcEdgePosSet) {
                ArrayList ls = (ArrayList)srcValues.get(key);
                if (ls.size() < 1) {
                    Arrays.fill(edgeOrdinaSrc, -1L);
                    return;
                }
                TreeSet<Long> rs = new TreeSet<Long>();
                rs.addAll(((XV5ReformRowValue)ls.get((int)0)).mEdgeOridinal);
                for (i = 1; i < ls.size(); ++i) {
                    rs.retainAll(((XV5ReformRowValue)ls.get((int)i)).mEdgeOridinal);
                }
                if (rs.size() != 1) {
                    Arrays.fill(edgeOrdinaSrc, -1L);
                    return;
                }
                Object[] a = rs.toArray();
                edgeOrdinaSrc[key.intValue()] = (Long)a[0];
            }
        }

        @Override
        public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
            int edgeNum = edge.getPositionalOrdinal();
            if (this.mReformEdges[edgeNum] == null) {
                return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
            }
            return new XV5ReformScrollableEdgeIterator(this.getDataContext(), this.mReformEdges[edgeNum], XV5Reform.this.getId());
        }

        @Override
        public XCellIterator getV5CellIterator() {
            return new XV5ReformScrollableCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5Reform.this.getId());
        }

        @Override
        public XScrollableCellIterator getScrollableV5CellIterator() {
            return new XV5ReformScrollableCellIterator(this.getDataContext(), this, this.getBaseResultSet().getScrollableV5CellIterator(), XV5Reform.this.getId());
        }

        private final class XV5ReformScrollableCellIterator
        extends V5ScrollableMappedCellIterator {
            private V5ResultSet mThisV5ResultSetReDef;
            private XScrollableCellIterator mBaseCellIteratorReDef;
            private long mNumCellsReDef;

            XV5ReformScrollableCellIterator(XDataContext dataContext, V5ResultSet v5ResultSet, XScrollableCellIterator cellIterator, Integer theNodeId) {
                super(dataContext, v5ResultSet, cellIterator, theNodeId);
                this.mThisV5ResultSetReDef = v5ResultSet;
                this.mBaseCellIteratorReDef = cellIterator;
                this.mNumCellsReDef = this.mThisV5ResultSetReDef.getNumCells();
            }

            @Override
            public ICell byOrdinal(long ordinal) {
                if (ordinal <= -1L || ordinal >= this.mNumCellsReDef) {
                    return null;
                }
                long baseOrdinal = this.mThisV5ResultSetReDef.mapV5CellOrdinal(ordinal);
                ICell cell = null;
                if (baseOrdinal != -1L) {
                    cell = this.mBaseCellIteratorReDef.byOrdinal(baseOrdinal);
                }
                return cell;
            }
        }

        private final class XV5ReformScrollableEdgeIterator
        extends XScrollableIterator {
            XV5ReformEdge mEdgeCache;

            private XV5ReformScrollableEdgeIterator(XDataContext dataContext, XV5ReformEdge edge, Integer id) {
                super(dataContext, id);
                this.mEdgeCache = edge;
            }

            @Override
            public Object current() {
                if (this.mEdgeCache.mCache == null || this.currentIndex <= -1L || this.currentIndex >= (long)this.mEdgeCache.mCache.length) {
                    return null;
                }
                return this.mEdgeCache.mCache[(int)this.currentIndex].mRowValue;
            }

            @Override
            public boolean absolute(long theIndex) {
                if (this.mEdgeCache.mCache == null || theIndex <= -1L || theIndex >= (long)this.mEdgeCache.mCache.length) {
                    return false;
                }
                this.currentIndex = theIndex;
                return true;
            }

            @Override
            public Object nextImpl() {
                if (this.mEdgeCache.mCache == null || this.currentIndex >= (long)(this.mEdgeCache.mCache.length - 1)) {
                    return null;
                }
                ++this.currentIndex;
                return this.current();
            }

            @Override
            public boolean hasPrevious() {
                return this.currentIndex > 0L;
            }

            @Override
            public Object previous() {
                if (!this.hasPrevious()) {
                    return null;
                }
                --this.currentIndex;
                return this.current();
            }

            @Override
            public void reset() {
                this.currentIndex = -1L;
            }

            @Override
            public void release() {
            }
        }

        private final class XV5ReformEdge {
            boolean mbUseless = false;
            RSAPIEdge mEdge;
            ArrayList<ArrayList<RSAPIEdgeRowset>> mRowsetPaths = null;
            ArrayList<ArrayList<String>> mRowsetNamePaths = null;
            XV5ReformTreeNode mDummyRoot;
            int mSrcEdgePos = -1;
            XV5ReformRowValue[] mCache;

            XV5ReformEdge(RSAPIEdge edge) {
                this.mEdge = edge;
                this.mRowsetPaths = new ArrayList();
                this.mRowsetNamePaths = new ArrayList();
                this.mDummyRoot = new XV5ReformTreeNode(null, null, null, 0L);
                ArrayList<RSAPIEdgeRowset> allRowsest = new ArrayList<RSAPIEdgeRowset>();
                HashSet<RSAPIEdgeRowset> parentRowsest = new HashSet<RSAPIEdgeRowset>();
                RSAPIEdgeRowset[] rowsets = this.mEdge.getRowsets();
                int i = 0;
                for (i = 0; i < rowsets.length; ++i) {
                    allRowsest.add(rowsets[i]);
                    if (rowsets[i].getParentRowset() == null) continue;
                    parentRowsest.add(rowsets[i].getParentRowset());
                }
                allRowsest.removeAll(parentRowsest);
                for (i = 0; i < allRowsest.size(); ++i) {
                    RSAPIEdgeRowset aRowset;
                    ArrayList<RSAPIEdgeRowset> aPath = new ArrayList<RSAPIEdgeRowset>();
                    for (aRowset = (RSAPIEdgeRowset)allRowsest.get(i); aRowset != null; aRowset = aRowset.getParentRowset()) {
                        aPath.add(aRowset);
                    }
                    Collections.reverse(aPath);
                    this.mRowsetPaths.add(aPath);
                    ArrayList<String> aNamePath = new ArrayList<String>();
                    for (int j = 0; j < aPath.size(); ++j) {
                        aRowset = (RSAPIEdgeRowset)aPath.get(j);
                        aNamePath.add(aRowset.getName());
                    }
                    this.mRowsetNamePaths.add(aNamePath);
                }
            }

            public void buildTree(HashMap<String, ContextMember> rowsetNames, long edgeOrdinal) {
                int maxMatch = -1;
                Set<String> nameSet = rowsetNames.keySet();
                ArrayList<RSAPIEdgeRowset> aPath = null;
                for (int i = 0; i < this.mRowsetNamePaths.size(); ++i) {
                    ArrayList<String> aNamePath = this.mRowsetNamePaths.get(i);
                    if (!nameSet.containsAll(aNamePath) || maxMatch >= aNamePath.size()) continue;
                    aPath = this.mRowsetPaths.get(i);
                }
                if (aPath != null) {
                    this.insertARow(rowsetNames, aPath, edgeOrdinal);
                }
            }

            protected void insertARow(HashMap<String, ContextMember> row, ArrayList<RSAPIEdgeRowset> aPath, long edgeOrdinal) {
                XV5ReformTreeNode parent = this.mDummyRoot;
                for (int i = 0; i < aPath.size(); ++i) {
                    RSAPIEdgeRowset aRowset = aPath.get(i);
                    ContextMember aMember = row.get(aRowset.getName());
                    IMember realMember = null;
                    if (aMember != null) {
                        realMember = aMember.getMember();
                    }
                    XV5ReformTreeNode aNode = new XV5ReformTreeNode(realMember, aRowset, aMember, edgeOrdinal);
                    parent = parent.insertChild(aNode);
                }
            }

            protected void buildRowCache() {
                ArrayList<XV5ReformRowValue> cache = new ArrayList<XV5ReformRowValue>();
                LinkedList<XV5ReformTreeNode> stack = new LinkedList<XV5ReformTreeNode>();
                this.addRowInCache(this.mDummyRoot, stack, cache);
                this.mDummyRoot = null;
                this.mCache = new XV5ReformRowValue[cache.size()];
                System.arraycopy(cache.toArray(), 0, this.mCache, 0, cache.size());
            }

            protected int createOneRowFromMun(XV5Reform owner) {
                if (!((XV5Reform)owner).mReportMeasure.mNeedCreate) {
                    return 0;
                }
                ContextMember aContextMember = new ContextMember();
                aContextMember.setMember(((XV5Reform)owner).mReportMeasure.mMemberObject);
                aContextMember.setEdgeOrdinal(this.mEdge.getOrdinal());
                if (((XV5Reform)owner).mReportMeasure.mMemberObject != null) {
                    aContextMember.setQueryCalculation(false);
                } else {
                    aContextMember.setQueryCalculation(true);
                    aContextMember.setCalculatedMemberName(((XV5Reform)owner).mReportMeasure.mV5MUN);
                    aContextMember.setCalculatedMemberCaption(((XV5Reform)owner).mReportMeasure.mV5Caption);
                }
                aContextMember.setSummary(false);
                aContextMember.setRowset(this.mEdge.getRowset(0));
                aContextMember.setDataItemIndex(-1);
                IValue[] values = new ContextMember[]{aContextMember};
                XV5ReformRowValue newRow = new XV5ReformRowValue();
                newRow.mRowValue = DataValueFactory.createRowValue(values);
                newRow.mEdgeOridinal.add(new Long(-1L));
                this.mCache = new XV5ReformRowValue[1];
                this.mCache[0] = newRow;
                return 1;
            }

            protected void addRowInCache(XV5ReformTreeNode node, LinkedList<XV5ReformTreeNode> stack, ArrayList<XV5ReformRowValue> cache) {
                block4: {
                    block3: {
                        stack.addLast(node);
                        if (node.mChildren != null) break block3;
                        int size = stack.size();
                        if (size <= 1) break block4;
                        IValue[] values = new ContextMember[size - 1];
                        int i = 1;
                        int j = 0;
                        XV5ReformTreeNode aTreeNode = null;
                        boolean bDummyInStack = false;
                        while (i < size) {
                            aTreeNode = stack.get(i);
                            if (aTreeNode.mSrcMember == null) {
                                bDummyInStack = true;
                                break;
                            }
                            values[j] = (ContextMember)aTreeNode.mSrcMember.copy();
                            ((ContextMember)values[j]).setMember(aTreeNode.mBaseMember);
                            ((ContextBase)((Object)values[j])).setRowset(aTreeNode.mRowset);
                            ((ContextBase)((Object)values[j])).setEdgeOrdinal(aTreeNode.mRowset.getEdge().getOrdinal());
                            ((ContextBase)((Object)values[j])).setContextMember(null);
                            ++i;
                            ++j;
                        }
                        if (bDummyInStack) break block4;
                        XV5ReformRowValue newRow = new XV5ReformRowValue();
                        newRow.mRowValue = DataValueFactory.createRowValue(values);
                        newRow.mEdgeOridinal.addAll(aTreeNode.mSrcEdgeOrdinal);
                        cache.add(newRow);
                        break block4;
                    }
                    ArrayList<XV5ReformTreeNode> sortedChildren = new ArrayList<XV5ReformTreeNode>();
                    this.sortChildrenByRowsets(node, sortedChildren);
                    for (int i = 0; i < sortedChildren.size(); ++i) {
                        this.addRowInCache(sortedChildren.get(i), stack, cache);
                    }
                }
                stack.removeLast();
            }

            private void sortChildrenByRowsets(XV5ReformTreeNode node, ArrayList<XV5ReformTreeNode> sortedChildren) {
                TreeMap<Integer, ArrayList> sortedList = new TreeMap<Integer, ArrayList>();
                int i = 0;
                for (i = 0; i < node.mChildren.size(); ++i) {
                    Integer id = new Integer(((XV5ReformTreeNode)node.mChildren.get(i)).mRowset.getRowsetId());
                    ArrayList ls = null;
                    if (sortedList.containsKey(id)) {
                        ls = (ArrayList)sortedList.get(id);
                    } else {
                        ls = new ArrayList();
                        sortedList.put(id, ls);
                    }
                    ls.add(node.mChildren.get(i));
                }
                if (sortedList.size() == 1) {
                    sortedChildren.addAll(node.mChildren);
                } else {
                    Collection v = sortedList.values();
                    Object[] o = v.toArray();
                    for (i = 0; i < o.length; ++i) {
                        ArrayList l = (ArrayList)o[i];
                        sortedChildren.addAll(l);
                    }
                }
            }

            private final class XV5ReformTreeNode {
                private ArrayList<XV5ReformTreeNode> mChildren = null;
                private IMember mBaseMember;
                private RSAPIEdgeRowset mRowset;
                private ContextMember mSrcMember;
                private TreeSet<Long> mSrcEdgeOrdinal = new TreeSet();

                private XV5ReformTreeNode(IMember baseMemebr, RSAPIEdgeRowset rowset, ContextMember srcMember, long srcEdgeOrdinal) {
                    this.mBaseMember = baseMemebr;
                    this.mRowset = rowset;
                    this.mSrcMember = srcMember;
                    this.mSrcEdgeOrdinal.add(new Long(srcEdgeOrdinal));
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof XV5ReformTreeNode)) {
                        return false;
                    }
                    XV5ReformTreeNode node = (XV5ReformTreeNode)obj;
                    if (node.mRowset != this.mRowset) {
                        return false;
                    }
                    if (node.mSrcMember == null || this.mSrcMember == null) {
                        return true;
                    }
                    if (node.mSrcMember.isCalculatedMember() && this.mSrcMember.isCalculatedMember()) {
                        return node.mBaseMember.getUniqueName().equals(this.mBaseMember.getUniqueName());
                    }
                    if (!node.mSrcMember.isCalculatedMember() && !this.mSrcMember.isCalculatedMember()) {
                        return node.mBaseMember == this.mBaseMember;
                    }
                    return false;
                }

                public int hashCode() {
                    return this.mBaseMember.hashCode() + this.mRowset.getRowsetId();
                }

                private XV5ReformTreeNode insertChild(XV5ReformTreeNode aNode) {
                    int idx = -1;
                    if (this.mChildren != null && (idx = this.mChildren.indexOf(aNode)) == -1 && aNode.mSrcMember != null) {
                        int i = 0;
                        String v5Mun = aNode.mSrcMember.getV5UniqueName();
                        if (v5Mun != null && !v5Mun.equals("")) {
                            for (i = 0; i < this.mChildren.size(); ++i) {
                                String v5ChildMun;
                                XV5ReformTreeNode child = this.mChildren.get(i);
                                if (child.mSrcMember == null || (v5ChildMun = child.mSrcMember.getV5UniqueName()) == null || !v5ChildMun.equals(v5Mun) || aNode.mRowset != child.mRowset) continue;
                                idx = i;
                                break;
                            }
                        } else if (aNode.mSrcMember.isQueryCalculation() || aNode.mSrcMember.isCalculatedMember()) {
                            for (i = 0; i < this.mChildren.size(); ++i) {
                                XV5ReformTreeNode child = this.mChildren.get(i);
                                if (child.mSrcMember == null || !child.mSrcMember.isQueryCalculation() && !child.mSrcMember.isCalculatedMember() || aNode.mRowset != child.mRowset) continue;
                                idx = i;
                                break;
                            }
                        }
                    }
                    if (idx == -1) {
                        if (this.mChildren == null) {
                            this.mChildren = new ArrayList();
                        }
                        this.mChildren.add(aNode);
                        return aNode;
                    }
                    XV5ReformTreeNode aExistingNode = this.mChildren.get(idx);
                    if (aExistingNode.mSrcMember == null && aNode.mSrcMember != null) {
                        aExistingNode.mSrcMember = aNode.mSrcMember;
                        aExistingNode.mBaseMember = aNode.mBaseMember;
                    }
                    aExistingNode.mSrcEdgeOrdinal.addAll(aNode.mSrcEdgeOrdinal);
                    return aExistingNode;
                }
            }
        }

        private final class XV5ReformRowValue {
            RowValue mRowValue;
            TreeSet<Long> mEdgeOridinal = new TreeSet();

            private XV5ReformRowValue() {
            }
        }
    }

    protected final class XV5ReformSpec
    implements IXQEPersist {
        private static final String ELEMENT_EDGES = "edges";
        private static final String ELEMENT_ALL_EDGES = "allEdges";
        protected RSAPIEdge[] mEdges;
        protected RSAPIEdge[] mAllEdges;

        protected XV5ReformSpec() {
        }

        protected XV5ReformSpec(RSAPIEdge[] edges, RSAPIEdge[] allEdges) {
            this.mEdges = edges;
            this.mAllEdges = allEdges;
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistElementProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistElementProperties(XQEPersistContext ctx) {
            if (this.mEdges != null) {
                ctx.elementProperty(ELEMENT_EDGES, this.mEdges);
            }
            if (this.mAllEdges != null) {
                ctx.elementProperty(ELEMENT_ALL_EDGES, this.mAllEdges);
            }
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreChildren(ctx, node);
        }

        protected void restoreChildren(XQERestoreContext ctx, Element node) {
            List childList = node.elements();
            int nChildren = childList.size();
            for (int i = 0; i < nChildren; ++i) {
                Element child = (Element)childList.get(i);
                if (child.getNamespace().getURI().isEmpty()) continue;
                this.restoreElementProperty(ctx, child, node);
            }
        }

        protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
            String pname = node.attributeValue("pname");
            if (pname.equals(ELEMENT_EDGES)) {
                Object val = ctx.elementValue(node);
                this.mEdges = (RSAPIEdge[])val;
            } else if (pname.equals(ELEMENT_ALL_EDGES)) {
                Object val = ctx.elementValue(node);
                this.mAllEdges = (RSAPIEdge[])val;
            }
        }
    }

    protected final class XV5ReportMeasureSpec
    implements IXQEPersist {
        public static final String ATTRIBUTE_USELESS_EDGE_POS = "selessEdgePos";
        public static final String ATTRIBUTE_NEED_CREATE = "needCreate";
        public static final String ATTRIBUTE_MEMBER_OBJECT = "memberObject";
        public static final String ATTRIBUTE_V5_MUN = "V5MUN";
        public static final String ATTRIBUTE_V5_CAPTION = "V5Caption";
        protected int mUselessEdgePos = -1;
        protected boolean mNeedCreate = false;
        protected IMember mMemberObject = null;
        protected String mV5MUN = null;
        protected String mV5Caption = null;

        protected XV5ReportMeasureSpec() {
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                this.persistAttributeProperties(ctx);
                ctx.endElement();
            }
        }

        public void persistAttributeProperties(XQEPersistContext ctx) {
            ctx.property(ATTRIBUTE_USELESS_EDGE_POS, this.mUselessEdgePos);
            ctx.property(ATTRIBUTE_NEED_CREATE, this.mNeedCreate);
            ctx.property(ATTRIBUTE_MEMBER_OBJECT, this.mMemberObject);
            ctx.property(ATTRIBUTE_V5_MUN, this.mV5MUN);
            ctx.property(ATTRIBUTE_V5_CAPTION, this.mV5Caption);
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Attribute att = node.attribute(i);
                this.restoreAttributeProperty(ctx, att, node);
            }
        }

        protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
            String attName = att.getName();
            if (attName.equals(ATTRIBUTE_USELESS_EDGE_POS)) {
                Object val = ctx.attributeValue(att);
                this.mUselessEdgePos = (Integer)val;
            } else if (attName.equals(ATTRIBUTE_NEED_CREATE)) {
                Object val = ctx.attributeValue(att);
                this.mNeedCreate = (Boolean)val;
            } else if (attName.equals(ATTRIBUTE_MEMBER_OBJECT)) {
                Object val = ctx.attributeValue(att);
                this.mMemberObject = (IMember)val;
            } else if (attName.equals(ATTRIBUTE_V5_MUN)) {
                Object val = ctx.attributeValue(att);
                this.mV5MUN = (String)val;
            } else if (attName.equals(ATTRIBUTE_V5_CAPTION)) {
                Object val = ctx.attributeValue(att);
                this.mV5Caption = (String)val;
            }
        }
    }

    private class XV5ReformCreator
    extends XQEPersistCreate {
        private XV5ReformCreator() {
        }

        @Override
        public IXQEPersist create(XQERestoreContext ctx, Element inputNode) {
            IXQEPersist result = null;
            String name = inputNode.getName();
            if (name.equals("XV5ReformSpec")) {
                result = new XV5ReformSpec();
                result.restore(ctx, inputNode);
            } else if (name.equals("XV5ReportMeasureSpec")) {
                result = new XV5ReportMeasureSpec();
                result.restore(ctx, inputNode);
            } else {
                result = super.create(ctx, inputNode);
            }
            return result;
        }
    }
}

