/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.cellupdate;

import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedCellIterator;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdate;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateResultSet;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5AlternateMeasureCellUpdate;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XV5AlternateMeasureCellUpdateResultSet
extends AbstractXV5CellUpdateResultSet {
    static final int ARRAY_INCREMENT = 2000;
    static final long NUM_ORDINALS_MAPPED = 5000L;
    protected Map<AbstractXV5CellUpdateRule, List<Long>[]> ruleToRowIndexListMap;
    private Long[] altMeasureEdgeOrdinals = null;
    protected PrimaryToAlternateMeasureRowIndex mapRuleToPrimaryAlternateMeasureList = new PrimaryToAlternateMeasureRowIndex();
    private HashMap<Long, Long> callerToBaseOrdinalMap = new HashMap();
    long maxOrdinalMapped = -1L;
    RSAPIEdge[] edges = null;
    int altMeasureEdgeNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XV5AlternateMeasureCellUpdateResultSet(XDataContext context, XNode node, IV5ResultSet sourceResult) {
        super(context, node, sourceResult);
        try {
            XV5AlternateMeasureCellUpdate altMeasureCellUpdate = (XV5AlternateMeasureCellUpdate)this.mNode;
            this.altMeasureEdgeNumber = ((AbstractXV5CellUpdateRule)altMeasureCellUpdate.cellUpdateRuleList.get(0)).getPrimaryCellSpec().getEdgeNum();
            RSAPIDataset rsapiDataset = (RSAPIDataset)this.mNode.getAncestorOfType(401005);
            this.edges = rsapiDataset.getEdges();
            this.edgeSizes = new long[this.edges.length];
            Long[] tmpAltMeasureOrdinals = null;
            long rowIndex = 0L;
            if (rsapiDataset.getCellRowset() != null) {
                int numEdges = this.edges.length;
                for (int edgeNum = 0; edgeNum < numEdges; ++edgeNum) {
                    long edgeSize = -1L;
                    this.edgeSizes[edgeNum] = edgeSize = sourceResult.getV5EdgeSize(this.edges[edgeNum]);
                    XIterator edgeIterator = sourceResult.getV5EdgeIterator(this.edges[edgeNum]);
                    try {
                        long rIndex = 0L;
                        RowValue aRow = (RowValue)edgeIterator.next();
                        while (aRow != null) {
                            ((AbstractXV5CellUpdate)this.mNode).acceptRow(aRow, rIndex, this.cellSpecToRowIndexMap);
                            aRow = (RowValue)edgeIterator.next();
                            ++rIndex;
                        }
                        continue;
                    }
                    finally {
                        edgeIterator.release();
                    }
                }
                int ordinalsSize = (int)this.edgeSizes[this.altMeasureEdgeNumber];
                tmpAltMeasureOrdinals = new Long[ordinalsSize];
                this.ruleToRowIndexListMap = this.buildRuleToRowIndexSetMap(this.cellSpecToRowIndexMap, numEdges);
                XIterator edgeIterator = sourceResult.getV5EdgeIterator(this.edges[this.altMeasureEdgeNumber]);
                try {
                    long baseRowIndex = 0L;
                    RowValue aRow = (RowValue)edgeIterator.next();
                    while (aRow != null) {
                        if (this.processAlternateMeasure(aRow, baseRowIndex)) {
                            int n = this.altMeasureEdgeNumber;
                            this.edgeSizes[n] = this.edgeSizes[n] - 1L;
                        } else {
                            tmpAltMeasureOrdinals[(int)rowIndex] = baseRowIndex;
                            ++rowIndex;
                        }
                        aRow = (RowValue)edgeIterator.next();
                        ++baseRowIndex;
                    }
                }
                finally {
                    edgeIterator.release();
                }
            }
            int newOrdinalsSize = (int)rowIndex;
            this.altMeasureEdgeOrdinals = new Long[newOrdinalsSize];
            if (tmpAltMeasureOrdinals != null) {
                System.arraycopy(tmpAltMeasureOrdinals, 0, this.altMeasureEdgeOrdinals, 0, newOrdinalsSize);
            }
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
        this.cellSpecToRowIndexMap = null;
    }

    private List<XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule> getAlternateMeaureUpdateRules() {
        XV5AlternateMeasureCellUpdate altMeasureCellUpdate = (XV5AlternateMeasureCellUpdate)this.mNode;
        return CollectionCast.downcast(altMeasureCellUpdate.cellUpdateRuleList, AbstractXV5CellUpdateRule.class, XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule.class);
    }

    private boolean processAlternateMeasure(RowValue aRow, long rowIndex) {
        boolean matchesAltMeasure = false;
        for (XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule altMeasureUpdateRule : this.getAlternateMeaureUpdateRules()) {
            XV5CellSpec altMeasureCellSpec = altMeasureUpdateRule.getAlternateMeasureCellSpec();
            if (!altMeasureCellSpec.acceptRow(aRow.getColumns())) continue;
            matchesAltMeasure = true;
            ArrayList rowIndexList = (ArrayList)this.cellSpecToRowIndexMap.get(altMeasureUpdateRule.getPrimaryCellSpec());
            if (rowIndexList == null) {
                this.mNode.throwInternalError("Missing row info for alternate measure row.");
            }
            Long lastPrimaryRowIndex = null;
            for (int idx = rowIndexList.size() - 1; idx >= 0; --idx) {
                if ((Long)rowIndexList.get(idx) >= rowIndex) continue;
                lastPrimaryRowIndex = (Long)rowIndexList.get(idx);
                break;
            }
            if (lastPrimaryRowIndex == null) {
                this.mNode.throwInternalError("Couldn't matching measure row for alternate measure row.");
            }
            this.mapRuleToPrimaryAlternateMeasureList.addMapping(altMeasureUpdateRule, lastPrimaryRowIndex, rowIndex);
            break;
        }
        return matchesAltMeasure;
    }

    private void mapOrdinals(long ordinal) {
        long startingOrdinal = this.maxOrdinalMapped + 1L;
        long endingOrdinal = ordinal;
        for (long currentOrdinal = startingOrdinal; currentOrdinal <= endingOrdinal && currentOrdinal < this.getNumCells(); ++currentOrdinal) {
            long[] currentRowIndex = this.convertCellOrdinalToBaseRowIndex(currentOrdinal);
            Iterator<XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule> itRule = this.getAlternateMeaureUpdateRules().iterator();
            boolean mapUpdated = false;
            block1: while (itRule.hasNext() && !mapUpdated) {
                List<Long>[] rowIndicesArray;
                XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule aRule = itRule.next();
                if (!aRule.isMatchingRule(currentRowIndex, rowIndicesArray = this.ruleToRowIndexListMap.get(aRule))) continue;
                long[] alternateMeasureRowIndex = new long[currentRowIndex.length];
                System.arraycopy(currentRowIndex, 0, alternateMeasureRowIndex, 0, currentRowIndex.length);
                List<Long> rowIndices = rowIndicesArray[this.altMeasureEdgeNumber];
                for (Long rowIndex : rowIndices) {
                    if (rowIndex != currentRowIndex[this.altMeasureEdgeNumber]) continue;
                    alternateMeasureRowIndex[this.altMeasureEdgeNumber] = this.mapRuleToPrimaryAlternateMeasureList.getAlternateMeasureRowIndex(aRule, currentRowIndex[this.altMeasureEdgeNumber]);
                    this.callerToBaseOrdinalMap.put(currentOrdinal, this.convertBaseRowIndexToBaseCellOrdinal(alternateMeasureRowIndex));
                    mapUpdated = true;
                    continue block1;
                }
            }
        }
        this.maxOrdinalMapped = endingOrdinal;
    }

    long convertBaseRowIndexToBaseCellOrdinal(long[] baseRowIndex) {
        long baseCellOrdinal = 0L;
        long ordinalMultiplier = 1L;
        for (int edgeIndex = 0; edgeIndex < baseRowIndex.length; ++edgeIndex) {
            if (this.edgeSizes[edgeIndex] <= 0L) continue;
            baseCellOrdinal += baseRowIndex[edgeIndex] * ordinalMultiplier;
            ordinalMultiplier *= this.getBaseResultSet().getV5EdgeSize(this.edges[edgeIndex]);
        }
        return baseCellOrdinal;
    }

    @Override
    public XCellIterator getV5CellIterator() {
        return new V5ScrollableMappedCellIterator(this.getDataContext(), this.mThisV5ResultSet, this.getBaseResultSet().getScrollableV5CellIterator(), this.mNode.getId());
    }

    @Override
    public XIterator getV5EdgeIterator(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        if (edgeNum == this.altMeasureEdgeNumber) {
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), this.mNode.getId());
        }
        return this.getBaseResultSet().getV5EdgeIterator(edge);
    }

    @Override
    public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        if (edgeNum == this.altMeasureEdgeNumber) {
            return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), this.mNode.getId());
        }
        return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
    }

    @Override
    public long mapV5EdgeOrdinal(RSAPIEdge edge, long oldOrdinal) {
        if (oldOrdinal >= (long)this.altMeasureEdgeOrdinals.length) {
            long baseOrdinal = this.getBaseResultSet().getV5EdgeSize(edge);
            return baseOrdinal;
        }
        return this.altMeasureEdgeOrdinals[(int)oldOrdinal];
    }

    @Override
    public long getV5EdgeSize(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        return this.edgeSizes[edgeNum];
    }

    @Override
    public long mapV5CellOrdinal(long thisOrdinal) {
        Long baseOrdinal;
        if (thisOrdinal > this.maxOrdinalMapped) {
            this.mapOrdinals(thisOrdinal);
        }
        if ((baseOrdinal = this.callerToBaseOrdinalMap.get(thisOrdinal)) == null) {
            baseOrdinal = this.convertCellOrdinalToBaseOrdinal(thisOrdinal);
        }
        return baseOrdinal;
    }

    private long[] convertCellOrdinalToBaseRowIndex(long cellOrdinal) {
        long[] currentRowIndex = new long[this.edgeSizes.length];
        for (int edgeIndex = 0; edgeIndex < this.edgeSizes.length - 1; ++edgeIndex) {
            currentRowIndex[edgeIndex] = 0L;
            if (this.edgeSizes[edgeIndex] <= 0L) continue;
            if (edgeIndex == this.altMeasureEdgeNumber) {
                int callerRowIndex = (int)(cellOrdinal % this.edgeSizes[edgeIndex]);
                currentRowIndex[edgeIndex] = this.altMeasureEdgeOrdinals[callerRowIndex];
            } else {
                currentRowIndex[edgeIndex] = cellOrdinal % this.edgeSizes[edgeIndex];
            }
            cellOrdinal /= this.edgeSizes[edgeIndex];
        }
        if (this.edgeSizes.length - 1 == this.altMeasureEdgeNumber) {
            cellOrdinal = this.altMeasureEdgeOrdinals[(int)cellOrdinal];
        }
        currentRowIndex[this.edgeSizes.length - 1] = cellOrdinal;
        return currentRowIndex;
    }

    private long convertCellOrdinalToBaseOrdinal(long cellOrdinal) {
        long[] baseRowIndex = this.convertCellOrdinalToBaseRowIndex(cellOrdinal);
        return this.convertBaseRowIndexToBaseCellOrdinal(baseRowIndex);
    }

    static class PrimaryToAlternateMeasureRowIndex {
        HashMap<XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule, HashMap<Long, Long>> mapCellSpecToPrimaryAlternateMeasureList = new HashMap();

        PrimaryToAlternateMeasureRowIndex() {
        }

        void addMapping(XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule altMeasureUpdateRule, long primaryRowIndex, long alternateRowIndex) {
            HashMap<Long, Long> primaryToAlternateMap = this.mapCellSpecToPrimaryAlternateMeasureList.get(altMeasureUpdateRule);
            if (primaryToAlternateMap == null) {
                primaryToAlternateMap = new HashMap();
                this.mapCellSpecToPrimaryAlternateMeasureList.put(altMeasureUpdateRule, primaryToAlternateMap);
            }
            primaryToAlternateMap.put(primaryRowIndex, alternateRowIndex);
        }

        long getAlternateMeasureRowIndex(XV5AlternateMeasureCellUpdate.XV5AlternateMeasureCellUpdateRule altMeasureUpdateRule, long primaryRowIndex) {
            HashMap<Long, Long> primaryToAlternateMap = this.mapCellSpecToPrimaryAlternateMeasureList.get(altMeasureUpdateRule);
            if (primaryToAlternateMap == null) {
                return primaryRowIndex;
            }
            Long alternateRowIndex = primaryToAlternateMap.get(primaryRowIndex);
            if (alternateRowIndex == null) {
                return primaryRowIndex;
            }
            return alternateRowIndex;
        }
    }
}

