/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.edgeupdate;

import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.v5.V5ResultSet;
import com.cognos.xqe.runtree.v5.V5ScrollableMappedEdgeIterator;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXSuppressEdge;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdate;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressByOrdinalSpec;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressSpec;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressionView;
import java.util.List;

public abstract class AbstractXV5EdgeUpdateResultSet
extends V5ResultSet {
    XScrollableCellIterator mBaseCellIterator;
    protected XSuppressionView mSuppressionView;
    protected int mNumEdges;
    protected int[] axisOrdering;
    protected AbstractXSuppressEdge[] mSuppressedEdges;

    public AbstractXV5EdgeUpdateResultSet(XDataContext theDataContext, AbstractXV5EdgeUpdate xV5EdgeUpdate, IV5ResultSet v5ResultSet) {
        super(theDataContext, xV5EdgeUpdate, v5ResultSet);
        this.initialize();
    }

    protected void initialize() {
        this.mNumEdges = this.mEdges.length;
        this.mSuppressedEdges = new AbstractXSuppressEdge[this.mNumEdges];
        this.mBaseCellIterator = null;
    }

    @Override
    public IRowsetInfo getTabularRowsetInfo() {
        if (this.mBaseV5ResultSet instanceof XResultSetBase) {
            return ((XResultSetBase)((Object)this.mBaseV5ResultSet)).getTabularRowsetInfo();
        }
        return null;
    }

    @Override
    public long getV5EdgeSize(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        if (this.mSuppressedEdges[edgeNum] == null) {
            return this.getUnsuppressedEdgeSize(edgeNum);
        }
        return this.mSuppressedEdges[edgeNum].getNumRows();
    }

    @Override
    public long mapV5EdgeOrdinal(RSAPIEdge edge, long oldOrdinal) {
        int edgeNum = edge.getPositionalOrdinal();
        if (this.mSuppressedEdges[edgeNum] != null) {
            long suppressedSize = this.mSuppressedEdges[edgeNum].mNewOrdinals.length;
            long unsuppressedSize = this.getUnsuppressedEdgeSize(edgeNum);
            if (oldOrdinal >= suppressedSize) {
                return oldOrdinal - suppressedSize + unsuppressedSize;
            }
            return this.mSuppressedEdges[edgeNum].mNewOrdinals[(int)oldOrdinal];
        }
        return oldOrdinal;
    }

    long getUnsuppressedEdgeSize(int edgeNum) {
        return this.mSuppressionView.getNumEdgeRows(edgeNum);
    }

    @Override
    public void releaseImpl() {
        if (this.mBaseCellIterator != null) {
            this.mBaseCellIterator.release();
            this.mBaseCellIterator = null;
        }
        super.releaseImpl();
    }

    protected void setupNewOrdinalsOnSuppressedAxis() {
        for (int edgeNum = 0; edgeNum < this.mNumEdges; ++edgeNum) {
            if (this.mSuppressedEdges[edgeNum] == null) continue;
            this.mSuppressedEdges[edgeNum].setupNewOrdinals();
        }
    }

    @Override
    public XIterator getV5EdgeIterator(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        if (this.mSuppressedEdges[edgeNum] == null) {
            return this.getBaseResultSet().getV5EdgeIterator(edge);
        }
        return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), this.getId());
    }

    @Override
    public IScrollableIterator getScrollableV5EdgeIterator(RSAPIEdge edge) {
        int edgeNum = edge.getPositionalOrdinal();
        if (this.mSuppressedEdges[edgeNum] == null) {
            return this.getBaseResultSet().getScrollableV5EdgeIterator(edge);
        }
        return new V5ScrollableMappedEdgeIterator(this.getDataContext(), this, edge, this.getBaseResultSet().getScrollableV5EdgeIterator(edge), this.getId());
    }

    public Integer getId() {
        return this.mNode.getId();
    }

    public void setupValueBasedSuppression(List<XSuppressSpec> suppressSpecs, boolean checkForSpacers) {
        try {
            this.mSuppressionView.setupValueBasedSuppression(this, suppressSpecs, checkForSpacers);
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    public void setupOrdinalBasedSuppression(List<XSuppressByOrdinalSpec> suppressSpecs) {
        try {
            this.mSuppressionView.setupOrdinalBasedSuppression(this, suppressSpecs);
        }
        catch (RuntimeException e) {
            this.release();
            throw e;
        }
    }

    XScrollableCellIterator getBaseCellIterator() {
        if (this.mBaseCellIterator == null) {
            this.mBaseCellIterator = this.getBaseResultSet().getScrollableV5CellIterator();
        }
        return this.mBaseCellIterator;
    }
}

