/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.edgeupdate;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdate;
import com.cognos.xqe.runtree.v5.edgeupdate.XEdgeUpdateForResult;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressByOrdinalSpec;
import com.cognos.xqe.runtree.v5.edgeupdate.XV5ExternalResultSet;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.TraceLogWriter;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.cognos.xqe.resultsdk.IPostProcessingFilter;
import com.ibm.cognos.xqe.resultsdk.util.DumpResultSetPostProcessingFilter;
import com.ibm.cognos.xqe.resultsdk.util.PostProcessingFilterLoader;
import com.ibm.cognos.xqe.resultsdk.wrapper.V5ResultSetWrapper;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.dom4j.Element;

public final class XV5ExternalUpdate
extends AbstractXV5EdgeUpdate {
    private static final String COULD_NOT_MAKE_DIRECTORY = "Could not make directory: ";
    private static final long serialVersionUID = 0L;
    private static final String TRACE_DIR_NAME = "_resultsdk_";
    public static final String TRACE_FILE_NAME_BEFORE = "_result_before.xml";
    public static final String TRACE_FILE_NAME_AFTER = "_result_after.xml";
    private static final String TRACE_MANUAL_FILE_NAME = "_result_";
    private static final String TRACE_FILE_TYPE = ".xml";
    private static final String INTERNAL_DISPATCHER = "internalDispatcher";
    IPostProcessingFilter mPostProcessingFilter;

    @Override
    public int getType() {
        return 501163;
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        IV5ResultSet sourceResultSet = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        RequestEnvironment reqEnv = (RequestEnvironment)context.getEnvironment().getRequestEnvironment();
        if (reqEnv.isInternal()) {
            return sourceResultSet;
        }
        if (!reqEnv.isInternal()) {
            reqEnv.setExternalQueryId(this.getId());
        }
        BiBusHeader bibusHeader = ContentManager.buildBiBusHeader(reqEnv);
        CAMPassport passport = bibusHeader.getCAM().getCAMPassport();
        String requestID = reqEnv.getRequestID();
        RSAPIDataset rsapiDataset = (RSAPIDataset)this.getAncestorOfType(401005);
        XEdgeUpdateForResult edgeUpdateSpecs = new XEdgeUpdateForResult(rsapiDataset.getNumEdges());
        ArrayList<XSuppressByOrdinalSpec> suppressSpecs = new ArrayList<XSuppressByOrdinalSpec>();
        URL dispatcher = null;
        try {
            ICCLConfiguration cclConfig = null;
            cclConfig = XQECCLConfigurationFactory.getInstance();
            cclConfig.init();
            dispatcher = new URL(cclConfig.getValue(INTERNAL_DISPATCHER, false));
        }
        catch (CCLConfigurationException e) {
            sourceResultSet.release();
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            sourceResultSet.release();
            throw new RuntimeException(e);
        }
        XQETrace manualTrace = this.createManualTrace(context);
        V5ResultSetWrapper resultSetWrapper = new V5ResultSetWrapper(sourceResultSet, rsapiDataset, edgeUpdateSpecs, suppressSpecs, requestID, manualTrace);
        boolean traceConfig = false;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean tracing = config.getBooleanProperty("general.ResultSDKTrace[@enabled]", false);
        if (tracing) {
            traceConfig = true;
        }
        File traceDir = null;
        String traceDirName = PostProcessingFilterLoader.getCustomTraceDirName();
        if (traceDirName == null) {
            if (traceConfig || resultSetWrapper.getTraceResultSet() || resultSetWrapper.getTraceOriginalResultSet()) {
                traceDir = this.createTraceDirectory(reqEnv, config);
            }
            if ((traceConfig || resultSetWrapper.getTraceOriginalResultSet()) && traceDir != null) {
                this.traceResult(context, passport, dispatcher, sourceResultSet, traceDir, TRACE_FILE_NAME_BEFORE);
            }
        } else {
            traceDir = this.createTraceDirectory(reqEnv, traceDirName);
            if (traceDir != null) {
                this.traceResultToCustomDir(context, passport, dispatcher, sourceResultSet, traceDir, TRACE_FILE_NAME_BEFORE);
            }
        }
        try {
            this.mPostProcessingFilter.filterResultSet(requestID, passport, dispatcher, resultSetWrapper);
            resultSetWrapper.endTrace();
        }
        catch (XQERuntimeException e) {
            sourceResultSet.release();
            throw e;
        }
        XV5ExternalResultSet v5ResultSet = new XV5ExternalResultSet(context, this, sourceResultSet, edgeUpdateSpecs, this.mPostProcessingFilter, requestID);
        if (suppressSpecs.size() > 0) {
            v5ResultSet.setupOrdinalBasedSuppression(suppressSpecs);
        }
        if (traceDirName == null) {
            if ((traceConfig || resultSetWrapper.getTraceResultSet()) && traceDir != null) {
                this.traceResult(context, passport, dispatcher, v5ResultSet, traceDir, TRACE_FILE_NAME_AFTER);
            }
        } else if (traceDir != null) {
            this.traceResultToCustomDir(context, passport, dispatcher, v5ResultSet, traceDir, TRACE_FILE_NAME_AFTER);
        }
        return new V5HybridResultSet(context, v5ResultSet, this.getId());
    }

    public void setPostProcessingFilter(IPostProcessingFilter postProcessingFilter) {
        this.mPostProcessingFilter = postProcessingFilter;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    public File createTraceDirectory(RequestEnvironment reqEnv, XQEConfiguration config) {
        String requestId = reqEnv.getRequestID();
        if (requestId == null) {
            throw new XQERuntimeException();
        }
        StringBuilder dirName = new StringBuilder();
        TraceLogManager.appendTimestamp(dirName);
        dirName.append(TRACE_DIR_NAME);
        dirName.append(TraceLogManager.escapeName(requestId));
        return this.createDir(config, dirName.toString());
    }

    public File createTraceDirectory(RequestEnvironment reqEnv, String traceDirName) {
        String parentDir = System.getProperty("user.dir");
        File dir = new File(parentDir, traceDirName);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, COULD_NOT_MAKE_DIRECTORY + dir.getAbsolutePath());
        }
        return dir;
    }

    private void traceResult(XDataContext context, CAMPassport passport, URL dispatcher, IV5ResultSet v5ResultSet, File traceDir, String fileName) {
        XQETrace trace = new XQETrace();
        trace.setTraceLevelAll();
        String requestID = context.getEnvironment().getRequestID();
        RSAPIDataset rsapiDataset = (RSAPIDataset)this.getAncestorOfType(401005);
        StringBuilder sb = new StringBuilder(TraceLogManager.escapeName(rsapiDataset.getUniqueID()));
        sb.append(fileName);
        File logFile = new File(traceDir, sb.toString());
        TraceLogWriter logWriter = new TraceLogWriter(logFile);
        trace.addStream(logWriter);
        V5ResultSetWrapper resultSetWrapper = new V5ResultSetWrapper(v5ResultSet, rsapiDataset, null, null, requestID, trace);
        DumpResultSetPostProcessingFilter traceFilter = new DumpResultSetPostProcessingFilter();
        traceFilter.filterResultSet(requestID, passport, dispatcher, resultSetWrapper);
        resultSetWrapper.endTrace();
    }

    private void traceResultToCustomDir(XDataContext context, CAMPassport passport, URL dispatcher, IV5ResultSet v5ResultSet, File traceDir, String fileName) {
        XQETrace trace = new XQETrace();
        trace.setTraceLevelAll();
        RequestEnvironment reqEnv = (RequestEnvironment)context.getEnvironment().getRequestEnvironment();
        String reportName = reqEnv.getReportName();
        File logFile = new File(traceDir, XV5ExternalUpdate.createTraceFileName(fileName, reportName));
        TraceLogWriter logWriter = new TraceLogWriter(logFile);
        trace.addStream(logWriter);
        RSAPIDataset rsapiDataset = (RSAPIDataset)this.getAncestorOfType(401005);
        String requestID = context.getEnvironment().getRequestID();
        V5ResultSetWrapper resultSetWrapper = new V5ResultSetWrapper(v5ResultSet, rsapiDataset, null, null, reportName, trace);
        DumpResultSetPostProcessingFilter traceFilter = new DumpResultSetPostProcessingFilter();
        traceFilter.filterResultSet(requestID, passport, dispatcher, resultSetWrapper);
        resultSetWrapper.endTrace();
    }

    public static String createTraceFileName(String fileName, String reportName) {
        StringBuilder sb = new StringBuilder();
        if (reportName != null && !reportName.isEmpty()) {
            sb.append(TraceLogManager.escapeName(reportName));
        } else {
            sb.append("unknowReportName");
        }
        sb.append(fileName);
        return sb.toString();
    }

    public XQETrace createManualTrace(XDataContext context) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String dirName = config.getStringProperty("general.ResultSDKManualTrace[@dirName]", "");
        if (dirName.equals("")) {
            return null;
        }
        String requestId = context.getEnvironment().getRequestID();
        if (requestId == null) {
            throw new XQERuntimeException();
        }
        File traceDir = this.createDir(config, dirName);
        RSAPIDataset rsapiDataset = (RSAPIDataset)this.getAncestorOfType(401005);
        XQETrace trace = new XQETrace();
        trace.setTraceLevelAll();
        StringBuilder fileName = new StringBuilder();
        fileName.append(rsapiDataset.getRefQueryName());
        fileName.append(TRACE_MANUAL_FILE_NAME);
        fileName.append(TraceLogManager.escapeName(requestId));
        fileName.append(TRACE_FILE_TYPE);
        File logFile = new File(traceDir, fileName.toString());
        TraceLogWriter logWriter = new TraceLogWriter(logFile);
        trace.addStream(logWriter);
        return trace;
    }

    private File createDir(XQEConfiguration config, String dirName) {
        File dir;
        StringBuilder parentDir = new StringBuilder();
        if (config != null) {
            parentDir.append(config.getXqeLogsDirectory());
            parentDir.append(File.separatorChar);
        }
        if (!(dir = new File(parentDir.toString(), dirName)).exists() && !dir.mkdirs()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, COULD_NOT_MAKE_DIRECTORY + dir.getAbsolutePath());
        }
        return dir;
    }
}

