/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.edgeupdate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IV5ResultSet;
import com.cognos.xqe.resultsets.v5.V5HybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.v5.edgeupdate.AbstractXV5EdgeUpdate;
import com.cognos.xqe.runtree.v5.edgeupdate.XSuppressSpec;
import com.cognos.xqe.runtree.v5.edgeupdate.XV5SuppressResultSet;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import org.dom4j.Element;

public final class XV5Suppress
extends AbstractXV5EdgeUpdate {
    private static final long serialVersionUID = 0L;
    static final String SUPPRESS_SPEC = "SuppressSpec";
    static final String ZERO = "zero";
    static final String DIV_BY_ZERO = "divByZero";
    static final String NULLS = "nulls";
    static final String OVERFLOW = "overflow";
    static final String CHECK_FOR_SPACERS = "checkForSpacers";
    List<XSuppressSpec> mSuppressSpecs = new ArrayList<XSuppressSpec>();
    private boolean mCheckForSpacers;

    @Override
    public int getType() {
        return 501080;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            IV5ResultSet sourceResultSet = (IV5ResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
            XV5SuppressResultSet v5ResultSet = new XV5SuppressResultSet(context, this, sourceResultSet);
            v5ResultSet.setupValueBasedSuppression(this.mSuppressSpecs, this.mCheckForSpacers);
            V5HybridResultSet v5HybridResultSet = new V5HybridResultSet(context, v5ResultSet, this.getId());
            return v5HybridResultSet;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    public void addSuppressSpec(int theEdgeNum, boolean nulls, boolean divByZero, boolean zero, boolean overflow) {
        XSuppressSpec suppressSpec = new XSuppressSpec(theEdgeNum, nulls, divByZero, zero, overflow);
        this.mSuppressSpecs.add(suppressSpec);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.mCheckForSpacers = Boolean.parseBoolean(inputNode.attributeValue(CHECK_FOR_SPACERS));
        List suppressSpecsList = inputNode.elements(SUPPRESS_SPEC);
        ListIterator it = suppressSpecsList.listIterator();
        int i = 0;
        while (it.hasNext()) {
            Element anElement = (Element)it.next();
            int edgeNum = Integer.parseInt(anElement.attributeValue("EdgeNum"));
            boolean nulls = Boolean.valueOf(anElement.attributeValue(NULLS));
            boolean divByZero = Boolean.valueOf(anElement.attributeValue(DIV_BY_ZERO));
            boolean zero = Boolean.valueOf(anElement.attributeValue(ZERO));
            boolean overflow = Boolean.valueOf(anElement.attributeValue(OVERFLOW));
            this.addSuppressSpec(edgeNum, nulls, divByZero, zero, overflow);
            it.remove();
            ++i;
        }
        super.capture(env, inputNode);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(CHECK_FOR_SPACERS, Boolean.toString(this.mCheckForSpacers));
        for (XSuppressSpec suppressSpec : this.mSuppressSpecs) {
            trace.beginElement(SUPPRESS_SPEC, -1);
            trace.attribute("EdgeNum", Integer.toString(suppressSpec.getEdgeNum()));
            trace.attribute(NULLS, Boolean.toString(suppressSpec.getNulls()));
            trace.attribute(DIV_BY_ZERO, Boolean.toString(suppressSpec.getDivByZero()));
            trace.attribute(ZERO, Boolean.toString(suppressSpec.getZero()));
            trace.attribute(OVERFLOW, Boolean.toString(suppressSpec.getOverflow()));
            trace.endElement(-1);
        }
    }

    public void setCheckForSpacers(boolean value) {
        this.mCheckForSpacers = value;
    }

    @Override
    public SortedMap<String, String> getCheckSumPropertiesMap() {
        SortedMap<String, String> propertiesMap = super.getCheckSumPropertiesMap();
        propertiesMap.put(CHECK_FOR_SPACERS, Boolean.toString(this.mCheckForSpacers));
        return propertiesMap;
    }
}

