/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.v5.listupdate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.runtree.v5.listupdate.XV5ListColumnValueSpec;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;

public class XV5ErrorCellUpdateRule {
    private XV5ListColumnValueSpec primaryColValueSpec = null;

    public XV5ErrorCellUpdateRule(XV5ListColumnValueSpec colValueSpec) {
        this.primaryColValueSpec = colValueSpec;
    }

    public XV5ListColumnValueSpec getPrimaryCellSpec() {
        return this.primaryColValueSpec;
    }

    void setPrimaryCellSpec(XV5ListColumnValueSpec colValueSpec) {
        this.primaryColValueSpec = colValueSpec;
    }

    public String getRuleName() {
        return "XV5ErrorCellUpdateRule";
    }

    public boolean isMatchingRule(IValue column) {
        return this.getPrimaryCellSpec().acceptRow(new IValue[]{column});
    }

    public boolean apply(IValue column) {
        Value v = null;
        if (column instanceof ContextValue) {
            ContextValue cv = (ContextValue)column;
            v = (Value)cv.getValue().copy();
            cv.setValue(v);
        } else {
            if (column instanceof ContextMember) {
                return true;
            }
            v = (Value)column.copy();
        }
        if (v != null) {
            v.setState(ValueState.ERROR);
        }
        return true;
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        List xcellSpecList = inputNode.elements();
        ListIterator itSpec = xcellSpecList.listIterator();
        while (itSpec.hasNext()) {
            Element anElement = (Element)itSpec.next();
            if (!"XPrimaryColValueSpec".equals(anElement.getName())) continue;
            XV5ListColumnValueSpec newPrimaryCellSpec = new XV5ListColumnValueSpec();
            newPrimaryCellSpec.capture(env, anElement);
            this.setPrimaryCellSpec(newPrimaryCellSpec);
        }
    }

    public void dump(XQETrace trace) {
        trace.beginElement(this.getRuleName(), -1);
        XV5ListColumnValueSpec aCellSpec = this.getPrimaryCellSpec();
        trace.beginElement("XPrimaryColValueSpec", -1);
        aCellSpec.dumpAdditionalAttributes(trace);
        trace.endElement(-1);
        trace.endElement(-1);
        this.dumpAdditionalElements(trace);
        trace.endElement(-1);
    }

    protected void dumpAdditionalElements(XQETrace trace) {
    }
}

