/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.security;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.security.IEncryptedObject;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;

public final class EncryptedObject<T>
implements Serializable,
IEncryptedObject<T> {
    private static final long serialVersionUID = 1L;
    private static final String UTF_8 = "UTF-8";
    private DataType mType = null;
    private byte[] mSecureData = null;
    private int mCachedHashCode = Integer.MIN_VALUE;
    private byte[] mCachedDigest = null;
    private final MessageDigest mDigester = EncryptedObject.createMD5Digester();

    public static EncryptedObject<String> fromProtectedUTF8(byte[] protectedUT8) {
        return new EncryptedObject<String>(protectedUT8, DataType.STRING);
    }

    private static MessageDigest createMD5Digester() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
        }
    }

    public EncryptedObject() {
    }

    public EncryptedObject(T value) {
        this.set(value);
    }

    private EncryptedObject(byte[] secureData, DataType type) {
        this.mSecureData = secureData;
        this.mType = type;
    }

    @Override
    public boolean hasValue() {
        return this.mSecureData != null;
    }

    public boolean isString() {
        return DataType.STRING == this.mType;
    }

    public boolean isSerialized() {
        return DataType.SERIALIZED == this.mType;
    }

    public void set(T value) {
        this.mCachedHashCode = Integer.MIN_VALUE;
        this.mCachedDigest = null;
        if (null == value) {
            this.mSecureData = null;
            this.mType = null;
            return;
        }
        if (value instanceof String) {
            this.encryptString((String)value);
        } else {
            this.encryptObject(value);
        }
    }

    @Override
    public T decrypt() {
        if (null == this.mSecureData) {
            return null;
        }
        switch (this.mType) {
            case STRING: {
                return (T)this.decryptString();
            }
            case SERIALIZED: {
                return (T)this.decryptObject();
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected type.");
    }

    public byte[] getDigest() {
        if (null != this.mCachedDigest) {
            return this.mCachedDigest;
        }
        if (null == this.mSecureData) {
            return null;
        }
        this.set(this.decrypt());
        return this.mCachedDigest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptedObject)) {
            return false;
        }
        EncryptedObject other = (EncryptedObject)o;
        if (this.mType != other.mType) {
            return false;
        }
        if (Arrays.equals(this.mSecureData, other.mSecureData)) {
            return true;
        }
        return Arrays.equals(this.getDigest(), other.getDigest());
    }

    public int hashCode() {
        if (Integer.MIN_VALUE != this.mCachedHashCode) {
            return this.mCachedHashCode;
        }
        this.mCachedHashCode = Arrays.hashCode(this.getDigest());
        if (Integer.MIN_VALUE == this.mCachedHashCode) {
            this.mCachedHashCode = 0;
        }
        return this.mCachedHashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EncryptedObject[");
        if (null == this.mSecureData) {
            buffer.append("null");
        } else {
            buffer.append("type=").append((Object)this.mType);
            buffer.append(", secureData=").append(Arrays.toString(this.mSecureData));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void encryptString(String value) {
        try {
            byte[] stringData = value.getBytes(UTF_8);
            this.mDigester.reset();
            this.mDigester.update(stringData);
            this.mSecureData = CryptoProvider.encrypt((byte[])stringData);
            this.mType = DataType.STRING;
            this.mCachedDigest = this.mDigester.digest();
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.SEC_EncryptionFailure, (Throwable)ex);
        }
    }

    private String decryptString() {
        try {
            byte[] stringData = CryptoProvider.decrypt((byte[])this.mSecureData);
            return new String(stringData, UTF_8);
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.SEC_DecryptionFailure, (Throwable)ex);
        }
    }

    private void encryptObject(Object value) {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            OutputStream encryptingStream = CryptoProvider.createEncryptingOutputStream((OutputStream)byteStream);
            DigestingStream digestStream = new DigestingStream(encryptingStream, this.mDigester);
            ObjectOutputStream objectStream = new ObjectOutputStream(digestStream);
            this.mDigester.reset();
            objectStream.writeObject(value);
            objectStream.flush();
            objectStream.close();
            this.mSecureData = byteStream.toByteArray();
            this.mType = DataType.SERIALIZED;
            this.mCachedDigest = digestStream.getDigest();
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.SEC_EncryptionFailure, (Throwable)ex);
        }
    }

    private Object decryptObject() {
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(this.mSecureData);
            InputStream decryptingStream = CryptoProvider.createDecryptingInputStream((InputStream)byteStream);
            ObjectInputStream objectStream = new ObjectInputStream(decryptingStream);
            return objectStream.readObject();
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.SEC_DecryptionFailure, (Throwable)ex);
        }
    }

    @Override
    public byte[] getSecureData() {
        return this.mSecureData;
    }

    private static final class DigestingStream
    extends OutputStream {
        private final OutputStream mSink;
        private final MessageDigest mDigester;

        DigestingStream(OutputStream sink, MessageDigest digester) {
            this.mSink = sink;
            this.mDigester = digester;
        }

        public byte[] getDigest() {
            return this.mDigester.digest();
        }

        @Override
        public void write(int b) throws IOException {
            this.mDigester.update((byte)b);
            this.mSink.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (b.length > 0) {
                this.mDigester.update(b);
                this.mSink.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                this.mDigester.update(b, off, len);
                this.mSink.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            this.mSink.flush();
        }

        @Override
        public void close() throws IOException {
            this.mSink.close();
        }
    }

    private static enum DataType {
        STRING,
        SERIALIZED;

    }
}

