/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.trace.TraceLogWriter;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.V5SpecificationGeneration;
import com.cognos.xqe.util.usage.UsageTrackingService;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class CollectXQELogs {
    private File mLogsDir = null;
    private static Boolean collectXQELogs = null;

    public CollectXQELogs(File logsDir) {
        this.mLogsDir = logsDir;
    }

    public void logV5Request(V5QuerySet querySet) {
        String queryName;
        if (!this.loggingEnabled()) {
            return;
        }
        IXQEQueryNode[] qrds = querySet.getChildrenOfType(101055);
        if (qrds.length == 1) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)qrds[0];
            queryName = qrd.getRefQueryProperty();
        } else {
            queryName = "V5Queries";
        }
        Writer logWriter = this.createTraceOutputWriter(queryName, "_v5", ".xml");
        if (logWriter == null) {
            return;
        }
        V5SpecificationGeneration visitor = new V5SpecificationGeneration();
        visitor.visit(querySet);
        String output = visitor.dumpToString();
        try {
            logWriter.write(output);
            logWriter.close();
        }
        catch (IOException e) {
            return;
        }
    }

    public static boolean isLoggingEnabled(IRequestEnvironment reqEnv) {
        if (collectXQELogs == null) {
            Boolean b;
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            collectXQELogs = b = Boolean.valueOf(config.getBooleanProperty("general.collectXQELogs", false));
        }
        return collectXQELogs;
    }

    private Writer createTraceOutputWriter(String baseFileName, String fileSuffix, String fileExtension) {
        String logFileName = baseFileName + fileSuffix + fileExtension;
        File logFile = new File(this.mLogsDir, logFileName);
        if (logFile.exists()) {
            return null;
        }
        return new TraceLogWriter(logFile);
    }

    public void logSQL(String queryName, String sql) {
        if (!this.loggingEnabled()) {
            return;
        }
        Writer logWriter = this.createTraceOutputWriter(queryName, "", ".sql");
        if (logWriter == null) {
            return;
        }
        try {
            logWriter.write(sql);
            logWriter.close();
        }
        catch (IOException e) {
            return;
        }
    }

    public void logRuntree(IRequestEnvironment reqEnv, String queryName, XNode runtree) {
        if (!this.loggingEnabled()) {
            return;
        }
        Writer logWriter = this.createTraceOutputWriter(queryName, "_runtree", ".xml");
        if (logWriter == null) {
            return;
        }
        reqEnv.setCurrentTraceWriter(logWriter);
        XQETrace trace = reqEnv.getExecutionEnvironment().getTrace();
        trace.addStream(logWriter);
        runtree.dump(trace);
        try {
            trace.removeStream(logWriter);
            reqEnv.setCurrentTraceWriter(null);
            logWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logUsage(String reportName) {
        if (!this.loggingEnabled()) {
            return;
        }
        Writer logWriter = this.createTraceOutputWriter("Usage", "", ".xml");
        if (logWriter == null) {
            return;
        }
        UsageTrackingService.writePerfDataForReport(logWriter, reportName);
        try {
            logWriter.close();
        }
        catch (IOException e) {
            return;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        UsageTrackingService.readUsageTrackingFromConfig(configuration);
    }

    private boolean loggingEnabled() {
        return this.mLogsDir != null;
    }

    public void dumpFMModel(String modelContent) {
        if (!this.loggingEnabled()) {
            return;
        }
        Writer logWriter = null;
        logWriter = this.createTraceOutputWriter("model", "", ".xml");
        if (logWriter == null) {
            return;
        }
        try {
            logWriter.write(modelContent);
            logWriter.close();
        }
        catch (IOException e) {
            return;
        }
    }
}

