/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELogDumpWrapper;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQELoggerCppJni;
import com.cognos.xqe.trace.config.CommonsConfig;
import com.cognos.xqe.trace.config.ILoggingConfig;
import com.cognos.xqe.trace.logger.XQELoggerImpl;
import com.cognos.xqe.trace.logger.XQELoggerKey;
import com.cognos.xqe.trace.logger.XQELoggerStub;
import com.cognos.xqe.trace.logger.XQELoggerStubKey;
import com.cognos.xqe.util.xml.serializer.DefaultProcessor;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class XQELog {
    private static boolean inited = false;
    private static volatile Map<XQELoggerKey, XQELoggerImpl> loggers = new ConcurrentHashMap<XQELoggerKey, XQELoggerImpl>();
    private static ILoggingConfig[] logConfigs = new ILoggingConfig[ServiceEnumeration.values().length];
    private static boolean enableCppLogging = false;
    private static final ReadWriteLock LOGGING_CONFIG_LOCK = new ReentrantReadWriteLock();

    public static void init(ServiceEnumeration svc) {
        ILoggingConfig cfg = logConfigs[svc.ordinal()];
        if (cfg == null) {
            XQELog.loadConfiguration(svc, false);
        }
        inited = true;
    }

    public static void init(ServiceEnumeration svc, ILoggingConfig config) {
        XQELog.logConfigs[svc.ordinal()] = config;
        inited = true;
    }

    public static void loadConfiguration(ServiceEnumeration svc, boolean forceRelease) {
        try {
            if (forceRelease) {
                XQELog.release(svc);
            }
            LOGGING_CONFIG_LOCK.writeLock().lock();
            ILoggingConfig config = logConfigs[svc.ordinal()];
            try {
                if (config == null) {
                    XQELog.logConfigs[svc.ordinal()] = config = new CommonsConfig(svc);
                } else {
                    config.load();
                }
            }
            finally {
                LOGGING_CONFIG_LOCK.writeLock().unlock();
            }
            XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            if (config.isEnabled() && !enableCppLogging && xqeConfig.inStandaloneMode()) {
                try {
                    System.loadLibrary("XQELogger");
                    XQELoggerCppJni.enableAllLoggers();
                    enableCppLogging = true;
                }
                catch (UnsatisfiedLinkError e) {
                    enableCppLogging = false;
                    XQEDebugLog.out.println("Warning: XQELogger is missing. C++ logging is disabled");
                }
                catch (SecurityException e) {
                    enableCppLogging = false;
                    XQEDebugLog.out.println("Warning: Failed to load XQELogger due to security error. C++ logging is disabled");
                }
            }
        }
        catch (Throwable e) {
            XQELog.release(svc);
            XQEDebugLog.out.println("Error: Diagnostic logging is disabled for service: " + svc.name() + " due to error " + e);
        }
    }

    public static XQELogger getLogger(ServiceEnumeration aSvc, String aComponent, LogLevel aLogLevel) {
        return XQELog.getLogger(aSvc, aComponent, "Unspecified", aLogLevel);
    }

    public static XQELogger getLogger(ServiceEnumeration aSvc, String aComponent, String anEventGroup, LogLevel defaultLogLevel) {
        XQELog.init(aSvc);
        XQELoggerImpl impl = XQELog.getLoggerImpl(aSvc, aComponent, anEventGroup, defaultLogLevel);
        return new XQELogger(impl);
    }

    protected static XQELoggerImpl getLoggerImpl(ServiceEnumeration aSvc, String aComponent, String anEventGroup, LogLevel defaultLogLevel) {
        ILoggingConfig config = logConfigs[aSvc.ordinal()];
        XQELoggerImpl logger = null;
        if (config == null || !config.isEnabled()) {
            logger = new XQELoggerImpl(null, aSvc, aComponent, anEventGroup, LogLevel.NONE, defaultLogLevel);
            return logger;
        }
        XQELoggerKey key = new XQELoggerKey(aSvc, aComponent, anEventGroup, defaultLogLevel);
        logger = loggers.get(key);
        if (logger == null) {
            logger = XQELog.findLogger(aSvc, aComponent, anEventGroup, anEventGroup, defaultLogLevel);
            logger.setComponent(aComponent);
            logger.setEventGroup(anEventGroup);
            loggers.put(key, logger);
        }
        return logger;
    }

    private static XQELoggerImpl findLogger(ServiceEnumeration aSvc, String aComponent, String anEventGroup, String parentEvGroup, LogLevel defaultLogLevel) {
        String component = aComponent;
        String parentEventGroup = parentEvGroup;
        XQELoggerImpl logger = XQELog.createXQELogger(aSvc, component, parentEventGroup, defaultLogLevel);
        if (logger == null) {
            int evSeparatorIndex = parentEventGroup.lastIndexOf(".");
            int cpSeparatorIndex = component.lastIndexOf(".");
            if (evSeparatorIndex > 0) {
                parentEventGroup = parentEventGroup.substring(0, evSeparatorIndex);
            } else if (!parentEventGroup.equals("Unspecified")) {
                parentEventGroup = "Unspecified";
            } else if (cpSeparatorIndex > 0) {
                component = component.substring(0, cpSeparatorIndex);
                parentEventGroup = anEventGroup;
            } else if (!aComponent.equals("UNSPECIFIED")) {
                component = "UNSPECIFIED";
            } else {
                return null;
            }
            logger = XQELog.findLogger(aSvc, component, anEventGroup, parentEventGroup, defaultLogLevel);
        }
        if (logger == null) {
            logger = new XQELoggerImpl(logConfigs[aSvc.ordinal()].getDefaultAppender(), aSvc, aComponent, anEventGroup, LogLevel.ERROR, defaultLogLevel);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XQELoggerImpl createXQELogger(ServiceEnumeration aSvc, String componentType, String eventGroup, LogLevel defaultLevel) {
        XQELoggerStubKey stubKey = new XQELoggerStubKey(componentType, eventGroup);
        XQELoggerStub loggerStub = null;
        LOGGING_CONFIG_LOCK.readLock().lock();
        ILoggingConfig config = logConfigs[aSvc.ordinal()];
        try {
            loggerStub = config.getLoggerStub(stubKey);
        }
        finally {
            LOGGING_CONFIG_LOCK.readLock().unlock();
        }
        XQELoggerImpl logger = null;
        if (loggerStub != null) {
            logger = new XQELoggerImpl(loggerStub.getAppender(), aSvc, componentType, eventGroup, loggerStub.getLogLevel(), defaultLevel);
        }
        return logger;
    }

    public static boolean isCppLoggingEnabled() {
        return enableCppLogging;
    }

    public static void release() {
        if (!inited) {
            return;
        }
        if (!loggers.isEmpty()) {
            for (XQELoggerImpl logger : loggers.values()) {
                logger.close();
                logger.setReloadFlag();
            }
            loggers.clear();
        }
        LOGGING_CONFIG_LOCK.writeLock().lock();
        try {
            for (int i = 0; i < logConfigs.length; ++i) {
                ILoggingConfig config = logConfigs[i];
                if (config == null) continue;
                config.release();
                XQELog.logConfigs[i] = null;
            }
        }
        finally {
            LOGGING_CONFIG_LOCK.writeLock().unlock();
        }
        if (enableCppLogging) {
            XQELoggerCppJni.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(ServiceEnumeration svc) {
        if (!inited) {
            return;
        }
        if (!loggers.isEmpty()) {
            Set<Map.Entry<XQELoggerKey, XQELoggerImpl>> entries = loggers.entrySet();
            for (Map.Entry<XQELoggerKey, XQELoggerImpl> logger : entries) {
                if (!logger.getValue().getService().equals((Object)svc)) continue;
                logger.getValue().close();
                logger.getValue().setReloadFlag();
                loggers.remove(logger.getKey());
            }
        }
        LOGGING_CONFIG_LOCK.writeLock().lock();
        try {
            ILoggingConfig config = logConfigs[svc.ordinal()];
            if (config != null) {
                config.release();
                XQELog.logConfigs[svc.ordinal()] = null;
            }
        }
        finally {
            LOGGING_CONFIG_LOCK.writeLock().unlock();
        }
    }

    public static void commit() {
        if (!inited) {
            return;
        }
        for (int i = 0; i < logConfigs.length; ++i) {
            ILoggingConfig config = logConfigs[i];
            LOGGING_CONFIG_LOCK.writeLock().lock();
            try {
                if (config == null) continue;
                config.commit();
                continue;
            }
            finally {
                LOGGING_CONFIG_LOCK.writeLock().unlock();
            }
        }
    }

    public static void reloadLoggers(ServiceEnumeration svc) {
        if (!loggers.isEmpty()) {
            for (Map.Entry<XQELoggerKey, XQELoggerImpl> logger : loggers.entrySet()) {
                if (logger.getValue().getService() != svc) continue;
                logger.getValue().setReloadFlag();
                loggers.remove(logger.getKey());
            }
        }
    }

    public static void reload(ServiceEnumeration svc) {
        ILoggingConfig config = logConfigs[svc.ordinal()];
        if (config != null) {
            LOGGING_CONFIG_LOCK.writeLock().lock();
            try {
                config.reload();
            }
            finally {
                LOGGING_CONFIG_LOCK.writeLock().unlock();
            }
        }
        XQELog.reloadLoggers(svc);
    }

    public static void dump(StringWriter writer) {
        if (!inited) {
            return;
        }
        DefaultProcessor proc = new DefaultProcessor();
        try {
            for (ILoggingConfig config : logConfigs) {
                XQELogDumpWrapper wrapper = new XQELogDumpWrapper(loggers, config);
                proc.serialize((Object)wrapper, writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void logConsole(String msg) {
        XQELog.init(ServiceEnumeration.XQE);
        XQELog.logConsole(msg, LogLevel.INFO);
    }

    public static void logConsole(String msg, LogLevel level) {
        XQELog.init(ServiceEnumeration.XQE);
        XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Console", level);
        logger.log(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLogLevel(ServiceEnumeration aSvc, String aComponent, String anEventGroup) {
        LOGGING_CONFIG_LOCK.readLock().lock();
        CommonsConfig config = (CommonsConfig)logConfigs[aSvc.ordinal()];
        try {
            String string = config.getLogLevel(aComponent, anEventGroup);
            return string;
        }
        finally {
            LOGGING_CONFIG_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String setLogLevel(ServiceEnumeration aSvc, String aComponent, String anEventGroup, String logLevel) {
        LOGGING_CONFIG_LOCK.writeLock().lock();
        CommonsConfig config = (CommonsConfig)logConfigs[aSvc.ordinal()];
        try {
            String oldLevel = config.getLogLevel(aComponent, anEventGroup);
            config.setLogLevel(aComponent, anEventGroup, logLevel);
            String string = oldLevel;
            return string;
        }
        finally {
            LOGGING_CONFIG_LOCK.writeLock().unlock();
        }
    }
}

