/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.logger.XQELoggerKey;
import java.util.LinkedList;
import java.util.List;

public class XQELoggerCppJni {
    private static final List<XQELoggerKey> ENABLED_LOGGERS = new LinkedList<XQELoggerKey>();

    private static native void enableLogger(String var0, String var1, int var2, XQELogger var3);

    static native void release();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableLogger(XQELogger logger) {
        if (XQELog.isCppLoggingEnabled() && logger.getLogLevel() != LogLevel.NONE) {
            XQELoggerKey key = new XQELoggerKey(logger.getService(), logger.getComponent(), logger.getEventGroup(), LogLevel.ERROR);
            List<XQELoggerKey> list = ENABLED_LOGGERS;
            synchronized (list) {
                if (!ENABLED_LOGGERS.contains(key)) {
                    XQELoggerCppJni.enableLogger(logger.getComponent(), logger.getEventGroup(), logger.getLogLevel().ordinal(), logger);
                    ENABLED_LOGGERS.add(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void enableAllLoggers() {
        if (XQELog.isCppLoggingEnabled()) {
            XQELoggerCppJni.release();
            if (!ENABLED_LOGGERS.isEmpty()) {
                LinkedList<XQELoggerKey> loggersList = null;
                List<XQELoggerKey> list = ENABLED_LOGGERS;
                synchronized (list) {
                    loggersList = new LinkedList<XQELoggerKey>(ENABLED_LOGGERS);
                    ENABLED_LOGGERS.clear();
                }
                for (XQELoggerKey args : loggersList) {
                    ServiceEnumeration service = args.getService();
                    String component = args.getComponent();
                    String eventGroup = args.getEventGroup();
                    XQELogger logger = XQELog.getLogger(service, component, eventGroup, LogLevel.ERROR);
                    XQELoggerCppJni.enableLogger(logger);
                }
            }
        }
    }
}

