/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.config;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class LoggingOverrides {
    private static final Pattern OVERRIDE_PAT = Pattern.compile("(\\w+):((?:\\w|\\.)+)=(none|critical|error|warn|info|trace)");
    private static final String OVERRIDE_SPLIT = "(\\s|\\n)*\\,(\\s|\\n)*";
    private static final String EVENT_GROUP_SPLIT = "\\.";
    private static final String HDR_SESSION = "hdrSession";
    private static final String FORM_FIELD_VARS = "formFieldVars";
    private static final String COOKIE_VARS = "cookieVars";
    private static final String ITEM = "item";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String QUERIES = "queries";
    private static final String QUERY = "query";
    private static final String SELECTION = "selection";
    private static final String DATA_ITEM = "dataItem";
    private static final String EXPRESSION = "expression";
    private static final String UI_SPEC = "ui.spec";
    private static final String XQE_ENABLE_LOG_OVERRIDES_COOKIE = "xqeEnableLogOverrides";
    private static final String XQE_LOG_LEVELS_COOKIE = "xqeLogLevels";
    private static final String XQE_LOG_APPENDER_COOKIE = "xqeLogAppender";
    private static final String XQE_INHERIT_LOG_LEVELS_COOKIE = "xqeInheritLogLevels";
    private static final String XQE_LOG_LEVELS = "__XQE_LOG_LEVELS__";
    private static final String ILLEGAL_FILENAME_CHARS = "[^ \\w\\.\\-]";
    private final OverrideItem[] mItems;
    private final String mCustomAppenderFilename;
    private final boolean mInheritsDefaultLevels;

    private LoggingOverrides(OverrideItem[] items, String customAppenderFilename, boolean inheritsDefaultLevels) {
        this.mItems = items;
        this.mCustomAppenderFilename = customAppenderFilename;
        this.mInheritsDefaultLevels = inheritsDefaultLevels;
    }

    public LogLevel getLogLevel(String componentType, String eventGroup) {
        if (this.mItems == null || this.mItems.length == 0) {
            return null;
        }
        String[] eventGroupParts = eventGroup.split(EVENT_GROUP_SPLIT);
        LogLevel lvl = null;
        int mostMatches = 0;
        for (OverrideItem item : this.mItems) {
            String[] overrideParts;
            if (!item.getComponentType().equals(componentType) || eventGroupParts.length < (overrideParts = item.getEventGroupParts()).length) continue;
            int matches = 0;
            for (int i = 0; i < overrideParts.length && overrideParts[i].equals(eventGroupParts[i]); ++i) {
                ++matches;
            }
            if (matches != overrideParts.length || matches <= mostMatches) continue;
            mostMatches = matches;
            lvl = item.getLevel();
        }
        if (lvl == null && !this.mInheritsDefaultLevels) {
            lvl = LogLevel.NONE;
        }
        return lvl;
    }

    public boolean hasCustomAppenders() {
        return null != this.mCustomAppenderFilename;
    }

    public String getCustomAppenderFilename() {
        return this.mCustomAppenderFilename;
    }

    public String toString() {
        return Arrays.toString(this.mItems);
    }

    public static LoggingOverrides extractFromBiBusHeader(Element bibusHeader, String sessionId) {
        boolean loggingOverridesEnabledInConfig;
        if (bibusHeader == null) {
            return null;
        }
        String isEnabledStr = LoggingOverrides.extractCookieVar(bibusHeader, XQE_ENABLE_LOG_OVERRIDES_COOKIE);
        if (!Boolean.parseBoolean(isEnabledStr)) {
            return null;
        }
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config != null && !(loggingOverridesEnabledInConfig = config.getBooleanProperty("general.loggingOverrides[@enabled]", false))) {
            return null;
        }
        String overridesStr = LoggingOverrides.extractCookieVar(bibusHeader, XQE_LOG_LEVELS_COOKIE);
        String customAppenderStr = LoggingOverrides.extractCookieVar(bibusHeader, XQE_LOG_APPENDER_COOKIE);
        if (customAppenderStr != null && customAppenderStr.contains("..")) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("The relative path for the custom XQE log appender (%s) cannot contain a \"..\".", customAppenderStr));
        }
        String inheritDefaultLevelsStr = LoggingOverrides.extractCookieVar(bibusHeader, XQE_INHERIT_LOG_LEVELS_COOKIE);
        boolean inheritLogLevels = Boolean.parseBoolean(inheritDefaultLevelsStr);
        if (overridesStr == null && customAppenderStr == null && !inheritLogLevels) {
            return null;
        }
        if (customAppenderStr != null) {
            customAppenderStr = String.format("xqelog-%s", LoggingOverrides.sanitizeForFilename(customAppenderStr));
        } else {
            if (sessionId == null) {
                sessionId = "noSessionId";
            }
            customAppenderStr = String.format("xqelog-session-%s", LoggingOverrides.sanitizeForFilename(sessionId));
        }
        return LoggingOverrides.build(overridesStr, customAppenderStr, inheritLogLevels);
    }

    private static Document extractReportSpec(Element bibusHeader) {
        if (null == bibusHeader) {
            return null;
        }
        Element hdrSessionElem = bibusHeader.element(HDR_SESSION);
        if (hdrSessionElem == null) {
            return null;
        }
        Element formFieldVarsElem = hdrSessionElem.element(FORM_FIELD_VARS);
        if (formFieldVarsElem == null) {
            return null;
        }
        String reportSpec = null;
        for (Element itemElem : formFieldVarsElem.elements(ITEM)) {
            if (!itemElem.elementText(NAME).equals(UI_SPEC)) continue;
            reportSpec = itemElem.elementText(VALUE);
            break;
        }
        if (null == reportSpec) {
            return null;
        }
        reportSpec = StringEscapeUtils.unescapeXml(reportSpec);
        try {
            return DocumentHelper.parseText((String)reportSpec);
        }
        catch (DocumentException ex) {
            return null;
        }
    }

    private static String extractDataItemExpression(Document reportSpecDoc, String dataItemName) {
        Element queriesElem = reportSpecDoc.getRootElement().element(QUERIES);
        if (null == queriesElem) {
            return null;
        }
        for (Element queryElem : queriesElem.elements(QUERY)) {
            Element selectionElem = queryElem.element(SELECTION);
            if (null == selectionElem) continue;
            for (Element dataItemElem : selectionElem.elements(DATA_ITEM)) {
                if (!dataItemElem.attributeValue(NAME).equals(dataItemName)) continue;
                return dataItemElem.elementText(EXPRESSION);
            }
        }
        return null;
    }

    private static String extractCookieVar(Element bibusHeader, String cookieName) {
        if (null == bibusHeader) {
            return null;
        }
        Element hdrSessionElem = bibusHeader.element(HDR_SESSION);
        if (hdrSessionElem == null) {
            return null;
        }
        Element cookieVarsElem = hdrSessionElem.element(COOKIE_VARS);
        if (cookieVarsElem == null) {
            return null;
        }
        String cookieValue = null;
        for (Element itemElem : cookieVarsElem.elements(ITEM)) {
            if (!itemElem.elementText(NAME).equals(cookieName)) continue;
            cookieValue = itemElem.elementText(VALUE);
            if (cookieValue.length() != 0 && !cookieValue.equals("null")) break;
            cookieValue = null;
            break;
        }
        if (cookieValue != null) {
            try {
                cookieValue = URLDecoder.decode(cookieValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return cookieValue;
    }

    private static String sanitizeForFilename(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(ILLEGAL_FILENAME_CHARS, "_");
    }

    private static LoggingOverrides build(String overridesStr, String customAppenderStr, boolean inheritsDefaultLevels) {
        if (null != overridesStr && overridesStr.length() >= 2) {
            if ((overridesStr = overridesStr.trim()).charAt(0) == '\'') {
                overridesStr = overridesStr.substring(1);
            }
            if (overridesStr.charAt(overridesStr.length() - 1) == '\'') {
                overridesStr = overridesStr.substring(0, overridesStr.length() - 1);
            }
            ArrayList<OverrideItem> items = new ArrayList<OverrideItem>(2);
            for (String s : overridesStr.split(OVERRIDE_SPLIT)) {
                Matcher m = OVERRIDE_PAT.matcher(s);
                if (!m.matches()) continue;
                items.add(new OverrideItem(m.group(1), m.group(2).split(EVENT_GROUP_SPLIT), LogLevel.valueOf(m.group(3).toUpperCase())));
            }
            return new LoggingOverrides(items.toArray(new OverrideItem[items.size()]), customAppenderStr, inheritsDefaultLevels);
        }
        return new LoggingOverrides(null, customAppenderStr, inheritsDefaultLevels);
    }

    private static final class OverrideItem {
        private final String mComponentType;
        private final String[] mEventGroupParts;
        private final LogLevel mLevel;

        OverrideItem(String componentType, String[] eventGroupParts, LogLevel level) {
            this.mComponentType = componentType;
            this.mEventGroupParts = eventGroupParts;
            this.mLevel = level;
        }

        String getComponentType() {
            return this.mComponentType;
        }

        String[] getEventGroupParts() {
            return this.mEventGroupParts;
        }

        LogLevel getLevel() {
            return this.mLevel;
        }

        public String toString() {
            return String.format("OverrideItem[componentType=%s, eventGroup=%s, level=%s]", new Object[]{this.mComponentType, Arrays.toString(this.mEventGroupParts), this.mLevel});
        }
    }
}

