/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.decomposition.LogicalDecomposition;
import java.util.ArrayList;
import java.util.List;

public final class CloneQueryRefByFilter
extends Transformation {
    public CloneQueryRefByFilter() {
        this.mName = "Clone query referenced by filter.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{101013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<V5BoundDataItemReference> dataItemRefs = this.getDataItemRefsInFilter(node);
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
        for (V5BoundDataItemReference dataItemRef : dataItemRefs) {
            String queryToClone = dataItemRef.getNameParts()[0] + "_referenced_by_filer_in_" + query.getV5QueryName();
            if (querySet.getV5Query(queryToClone) == null) {
                V5Query refQuery = querySet.getV5Query(dataItemRef.getNameParts()[0]);
                XQENodeFactory factory = environment.getNodeFactory();
                V5Query clone = (V5Query)factory.deepCopyNode(refQuery);
                clone.setPropertyValue("name", queryToClone);
                clone.setBooleanPropertyValue("isTabular", "true");
                querySet.addChild(clone);
            }
            query.getV5Source().removeQueryReference(dataItemRef.getNameParts()[0]);
            query.getV5Source().addReferencedQuery(queryToClone);
            dataItemRef.getNameParts()[0] = queryToClone;
            query.removeProperty("isTabular");
            query.removeProperty("isRelStyle");
            query.removeProperty("qrdDecomposed");
            List<V5QueryResultDefinition> qrds = querySet.getReferencedQRDs(query);
            LogicalDecomposition transformation = new LogicalDecomposition();
            for (IXQEQueryNode iXQEQueryNode : qrds) {
                if (!transformation.passesQueryCondition(iXQEQueryNode, environment)) continue;
                ((Transformation)transformation).apply(iXQEQueryNode, environment);
            }
        }
    }

    private List<V5BoundDataItemReference> getDataItemRefsInFilter(IXQEQueryNode filter) {
        ArrayList<V5BoundDataItemReference> diRefs = new ArrayList<V5BoundDataItemReference>();
        IXQEQueryNode[] dataItemRefs = filter.getDescendantsOfType(201060, false);
        V5Query query = (V5Query)filter.getAncestorOfType(101006);
        List<String> queryRefs = this.getQueriesReferencedByDataItems(query);
        for (IXQEQueryNode dataItemRef : dataItemRefs) {
            V5QuerySet querySet;
            V5Query refQuery;
            V5BoundDataItemReference di = (V5BoundDataItemReference)dataItemRef;
            String refName = di.getNameParts()[0];
            if (!di.isQueryRefItem() || queryRefs.contains(refName) || refName.equals(query.getV5QueryName()) || (refQuery = (querySet = (V5QuerySet)query.getAncestorOfType(101002)).getV5Query(refName)).isTabular()) continue;
            diRefs.add(di);
        }
        return diRefs;
    }

    private List<String> getQueriesReferencedByDataItems(IXQEQueryNode query) {
        IXQEQueryNode[] dataItemRefs;
        ArrayList<String> queries = new ArrayList<String>();
        for (IXQEQueryNode dataItemRef : dataItemRefs = query.getFirstChildByType(101009).getDescendantsOfType(201060, false)) {
            V5BoundDataItemReference di = (V5BoundDataItemReference)dataItemRef;
            queries.add(di.getNameParts()[0]);
        }
        return queries;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return node.getParent().getType() == 101008 && !this.getDataItemRefsInFilter(node).isEmpty();
    }
}

