/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.v5.DetectFilterJoinOptimization;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import com.cognos.xqe.transformation.v5tocogsql.util.SummaryQuerySubjectUtilities;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CreateJoinOperationForJoinData
extends Transformation {
    public CreateJoinOperationForJoinData() {
        this.mName = "Create join operation for join refresh data.";
        this.mPassNumbers = new int[]{18};
        this.mTypes = new int[]{101006};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query = (V5Query)node;
        if (v5Query.getPropertyValue("referencedByRootQRD") == null) {
            return false;
        }
        if (v5Query.isDMR()) {
            return false;
        }
        Boolean testingJoins = v5Query.getBooleanPropertyValue("queryForTestJoin");
        if (testingJoins == null || !testingJoins.booleanValue()) {
            return false;
        }
        MetadataConnection md = environment.getMetadataConnection();
        if (!(md instanceof MoserMetadataConnection)) {
            return false;
        }
        if (!this.queryFromMultipleSourcesInvolvingPackage((MoserMetadataConnection)md, v5Query)) {
            return false;
        }
        if (!this.packageQSIsModelQS((MoserMetadataConnection)md, v5Query)) {
            return false;
        }
        List<IMetadata> joinsToPackage = CollectionCast.upcast(((MoserMetadataConnection)environment.getMetadataConnection()).getModule().getRelationships(), IMetadata.class);
        return joinsToPackage != null && !joinsToPackage.isEmpty();
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query = (V5Query)node;
        IRelationship join = this.getJoinToTest(environment, v5Query);
        Map<String, V5Query> mdConnectionToV5Query = this.distributeDataItemsToV5Queries((V5Query)node, environment);
        this.createJoinOperation(environment, join, v5Query, mdConnectionToV5Query);
    }

    private void createJoinOperation(PlanningEnvironment environment, IRelationship join, V5Query v5Query, Map<String, V5Query> mdConnectionToV5Query) {
        MoserMetadataConnection moserMDConnection = (MoserMetadataConnection)environment.getMetadataConnection();
        V5Query leftQuery = mdConnectionToV5Query.get(this.getMetadataConnectionOfMetadataObject(moserMDConnection, join.getLeftRefObject()).getModelName());
        V5Query rightQuery = mdConnectionToV5Query.get(this.getMetadataConnectionOfMetadataObject(moserMDConnection, join.getRightRefObject()).getModelName());
        V5JoinOperation joinOp = null;
        if (leftQuery != null && rightQuery != null) {
            joinOp = CreateV5QueryForDynamicSQS.buildJoinOperation(environment, v5Query, join, leftQuery.getV5QueryName(), rightQuery.getV5QueryName());
            this.distributeJoinKeys(mdConnectionToV5Query, joinOp, environment);
        }
        DetectFilterJoinOptimization dfjo = new DetectFilterJoinOptimization(1);
        if (joinOp != null && dfjo.passesNodeCondition((IXQEQueryNode)joinOp, environment)) {
            dfjo.apply((IXQEQueryNode)joinOp, environment);
        }
    }

    private IRelationship getJoinToTest(PlanningEnvironment environment, V5Query v5Query) {
        IXQEQueryNode[] bmIDs;
        HashSet<IMetadata> leftRightQS = new HashSet<IMetadata>();
        for (IXQEQueryNode b : bmIDs = v5Query.getDescendantsOfType(201116, false)) {
            V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)b;
            IQuerySubject qs = v5BoundID.getQuerySubject();
            if (qs instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)((Object)qs)).isAccessedViaShortcut()) {
                leftRightQS.add(((IAccessedViaShortcut)((Object)qs)).getShortcut());
                continue;
            }
            leftRightQS.add(qs);
        }
        List<IMetadata> joinsToPackage = CollectionCast.upcast(((MoserMetadataConnection)environment.getMetadataConnection()).getModule().getRelationships(), IMetadata.class);
        for (IMetadata j : joinsToPackage) {
            IRelationship r = (IRelationship)j;
            if (!leftRightQS.contains(r.getLeftRefObject()) || !leftRightQS.contains(r.getRightRefObject())) continue;
            return r;
        }
        return null;
    }

    private void distributeJoinKeys(Map<String, V5Query> mdConnectionToV5Query, V5JoinOperation joinOp, PlanningEnvironment environment) {
        IXQEQueryNode[] bmID = joinOp.getDescendantsOfType(201116, false);
        MoserMetadataConnection mdMoser = (MoserMetadataConnection)environment.getMetadataConnection();
        int i = 0;
        for (IXQEQueryNode b : bmID) {
            V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)b;
            MetadataConnection md = this.getMetadataConnectionOfMetadataObject(mdMoser, v5BoundID.getMetadata());
            V5Query v5Query = mdConnectionToV5Query.get(md.getModelName());
            V5DataItem newDataItem = (V5DataItem)environment.getNodeFactory().createNode(101003);
            newDataItem.setNameProperty("joinKey" + ++i);
            newDataItem.setAggregateProperty("none");
            newDataItem.setIsOriginal();
            newDataItem.addChild(environment.getNodeFactory().deepCopyNode(v5BoundID));
            v5Query.getV5Selection().addChild(newDataItem);
            V5BoundDataItemReference diRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(environment.getNodeFactory(), newDataItem, v5Query.getV5QueryName());
            v5BoundID.exchange(diRef);
        }
    }

    private Map<String, V5Query> distributeDataItemsToV5Queries(V5Query v5Query, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItems;
        TreeMap<String, V5Query> mdConnToV5Query = new TreeMap<String, V5Query>();
        v5Query.getV5Source().detachChildren();
        for (IXQEQueryNode v5DataItem : dataItems = v5Query.getV5Selection().getChildren()) {
            this.dispatchDataItemToSubquery(environment, mdConnToV5Query, v5Query, (V5DataItem)v5DataItem);
        }
        return mdConnToV5Query;
    }

    private void dispatchDataItemToSubquery(PlanningEnvironment environment, Map<String, V5Query> mdConnToV5Query, V5Query parentV5Query, V5DataItem v5DataItem) {
        MoserMetadataConnection moserMDConnection = (MoserMetadataConnection)environment.getMetadataConnection();
        this.throwExceptionIfExpressionSpansMultipleSources(v5DataItem, moserMDConnection, EXPRTYPE.DATAITEM);
        IXQEQueryNode v5BoundID = v5DataItem.getFirstDescendantOfTypeOrdered(201116, false);
        if (v5BoundID == null) {
            return;
        }
        IMetadata md = ((V5BoundModelIdentifier)v5BoundID).getMetadata();
        MetadataConnection metadataConnection = this.getMetadataConnectionOfMetadataObject(moserMDConnection, md);
        V5Query pushToV5Query = this.getOrCreateV5QueryForMDConnection(environment, mdConnToV5Query, parentV5Query, metadataConnection);
        V5DataItem newV5DataItem = (V5DataItem)environment.getNodeFactory().deepCopyNode(v5DataItem);
        pushToV5Query.getV5Selection().addChild(newV5DataItem);
        V5BoundDataItemReference diRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(environment.getNodeFactory(), newV5DataItem, pushToV5Query.getV5QueryName());
        v5DataItem.detachChildren();
        v5DataItem.addChild(diRef);
    }

    private V5Query getOrCreateV5QueryForMDConnection(PlanningEnvironment environment, Map<String, V5Query> mdConnToV5Query, V5Query parentV5Query, MetadataConnection metadataConnection) {
        V5Query v5Query = mdConnToV5Query.get(metadataConnection.getModelName());
        if (v5Query == null) {
            String name = metadataConnection instanceof MoserMetadataConnection ? "v5QueryFile" : "v5QueryPackage";
            v5Query = SummaryQuerySubjectUtilities.createV5Query(environment, null, parentV5Query, name);
            v5Query.getV5Selection().setAutoSummary(parentV5Query.getV5Selection().getAutoSummary());
            mdConnToV5Query.put(metadataConnection.getModelName(), v5Query);
        }
        return v5Query;
    }

    private MetadataConnection getMetadataConnectionOfMetadataObject(MoserMetadataConnection moserMDConnection, IMetadata md) {
        MetadataConnection metadataConnection = md.getConnection();
        if (metadataConnection == null) {
            metadataConnection = moserMDConnection;
        }
        return metadataConnection;
    }

    private boolean packageQSIsModelQS(MoserMetadataConnection mdMoser, V5Query v5Query) {
        IXQEQueryNode[] allBoundID;
        for (IXQEQueryNode b : allBoundID = v5Query.getDescendantsOfType(201116, false)) {
            IQuerySubject qs;
            V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)b;
            if (!this.isFromPackage(mdMoser, v5BoundID.getMetadata()) || (qs = v5BoundID.getQuerySubject()) == null || !"modelQuery".equals(qs.getDefinitionType())) continue;
            return true;
        }
        return false;
    }

    boolean isFromPackage(MoserMetadataConnection mdMoser, IMetadata md) {
        MetadataConnection metadataConnection = this.getMetadataConnectionOfMetadataObject(mdMoser, md);
        return !(metadataConnection instanceof MoserMetadataConnection);
    }

    void throwExceptionIfExpressionSpansMultipleSources(IXQEQueryNode expr, MoserMetadataConnection moserMDConnection, EXPRTYPE type) {
        IXQEQueryNode[] projectionBoundIDs;
        MDSource mdSource = null;
        for (IXQEQueryNode boundID : projectionBoundIDs = expr.getDescendantsOfType(201116, false)) {
            IMetadata md = ((V5BoundModelIdentifier)boundID).getMetadata();
            if (mdSource == null) {
                mdSource = this.getMDSourceOfMetadataObject(moserMDConnection, md);
                continue;
            }
            if (mdSource.equals(this.getMDSourceOfMetadataObject(moserMDConnection, md))) continue;
            if (type == EXPRTYPE.DATAITEM) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_CalcsSpanMDSources);
            }
            throw new XQERuntimeException(XQEMessageKeys.PLN_FiltersSpanMDSources);
        }
    }

    private MDSource getMDSourceOfMetadataObject(MoserMetadataConnection moserMDConnection, IMetadata md) {
        MetadataConnection metadataConnection = md.getConnection();
        if (metadataConnection == null || metadataConnection instanceof MoserMetadataConnection) {
            String idAndName = md instanceof IQuerySubject || md instanceof IShortcut ? md.getV5UniqueName() : ((IQueryItem)md).getQuerySubject().getV5UniqueName();
            return new MDSource(idAndName, idAndName);
        }
        String modelPath = metadataConnection.getModelPath();
        String name = metadataConnection.getPackageName();
        if (name == null) {
            name = metadataConnection.getModelPath();
        }
        return new MDSource(modelPath, name);
    }

    boolean queryFromMultipleSourcesInvolvingPackage(MoserMetadataConnection mdMoser, V5Query v5Query) {
        IXQEQueryNode[] allBoundID = v5Query.getDescendantsOfType(201116, false);
        TreeSet<MDSource> sources = new TreeSet<MDSource>();
        boolean somethingFromPackage = false;
        for (IXQEQueryNode b : allBoundID) {
            V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)b;
            if (this.isFromPackage(mdMoser, v5BoundID.getMetadata())) {
                somethingFromPackage = true;
            }
            sources.add(this.getMDSourceOfMetadataObject(mdMoser, v5BoundID.getMetadata()));
        }
        return somethingFromPackage && sources.size() > 1;
    }

    private class MDSource
    implements Comparable<MDSource> {
        private String mID;
        private String mName;

        MDSource(String id, String name) {
            this.mID = id;
            this.mName = name;
        }

        public boolean equals(Object that) {
            if (!(that instanceof MDSource)) {
                return false;
            }
            MDSource thatMDSource = (MDSource)that;
            return this.mID.equals(thatMDSource.mID);
        }

        public int hashCode() {
            return this.mID.hashCode();
        }

        public String getName() {
            return this.mName;
        }

        @Override
        public int compareTo(MDSource o) {
            return this.mID.compareTo(o.mID);
        }
    }

    public static enum EXPRTYPE {
        DATAITEM,
        FILTER;

    }
}

