/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.query.V5SummaryFilterLevel;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ScalarFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.v5.ExpandDataItemReferences;
import com.cognos.xqe.transformation.v5.SetV5DataItemIsProjected;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DecomposeScalarFunction
extends Transformation {
    private static int[] scalarTypes = new int[]{201041, 201109, 201055, 201051, 201040, 201042, 201065, 201033, 201014, 201035, 201025, 201004};
    private static int[] aggrFuncTypes = new int[]{201033, 201035};
    private int[] filterTypes = new int[]{101010, 101008, 101011};
    public static final String PROP_BOOLEAN_IS_DECOMPOSED = "isDecomposed";
    public static final String PROP_OLAP_SUB_QUERY = "OLAPSubQuery";

    public DecomposeScalarFunction() {
        this.mName = "Scalar Operation Logical Decomposition.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101055};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        if (!qrd.isList() && !query.isRelStyle()) {
            query.getV5Source().setNeedTabularStream();
        } else {
            this.applyRecursevely(node, qName, environment);
            this.preserveMemberCustomPropertyMetadata(qrd);
        }
    }

    private V5DataItem getReferencedDataItem(V5Query query, V5DataItemRef dataItemRef) {
        return query.getV5Selection().getDataItemByRefName(dataItemRef.getDataItemRefProperty());
    }

    private void preserveExplicitPropertyDataItemMetadata(V5DataItem dataItem) {
        if (dataItem.getChild(0).getType() == 201060) {
            V5BoundDataItemReference ref = (V5BoundDataItemReference)dataItem.getChild(0);
            V5DataItem dataItemOrg = ref.getRefDataItem();
            IXQEQueryNode exp = dataItemOrg.getChild(0);
            if (exp.getType() == 101004) {
                exp = exp.getChild(0);
            }
            if (exp.getType() == 201116 && ((V5BoundModelIdentifier)exp).isExplicitProperty()) {
                dataItemOrg.setPropPreserveMetadata(Boolean.TRUE);
            }
        }
    }

    private void preserveMemberCustomPropertyMetadata(V5QueryResultDefinition qrd) {
        V5Query query = qrd.getV5Query();
        if (!query.getV5Selection().getAutoSummary()) {
            IXQEQueryNode[] nodes;
            for (IXQEQueryNode dataItemRef : nodes = qrd.getDescendantsOfType(101015, false)) {
                V5DataItem dataItem = this.getReferencedDataItem(query, (V5DataItemRef)dataItemRef);
                this.preserveExplicitPropertyDataItemMetadata(dataItem);
            }
            for (IXQEQueryNode current : nodes = qrd.getDescendantsOfType(101057, false)) {
                V5ValueSet valueSet = (V5ValueSet)current;
                String refDataItemName = valueSet.getRefDataItemProperty();
                if (refDataItemName == null) continue;
                V5DataItem dataItem = query.getV5Selection().getDataItemByRefName(refDataItemName);
                this.preserveExplicitPropertyDataItemMetadata(dataItem);
            }
        }
    }

    private void updateV5DataItemLabelProperty(V5Query query) {
        V5Selection v5Selection = query.getV5Selection();
        int[] types = new int[]{201060, 101004};
        for (IXQEQueryNode dataItem : v5Selection.getChildren()) {
            V5DataItem v5DataItem = (V5DataItem)dataItem;
            if (v5DataItem.getPropertyValue("label") != null) continue;
            IXQEQueryNode expression = v5DataItem.getDetailExpression();
            while (expression.isOfTypes(types)) {
                if (expression.getType() == 101004) {
                    expression = expression.getChild(0);
                    continue;
                }
                V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)expression;
                if (!dataItemRef.isQueryRefItem()) break;
                expression = dataItemRef.getRefDataItem().getDetailExpression();
            }
            if (expression.getType() != 201116) continue;
            IMetadata metadata = ((V5BoundModelIdentifier)expression).getMetadata();
            String label = metadata.getCaption();
            v5DataItem.setPropertyValue("label", label);
            v5DataItem.setPropertyValue("isLabelFromModel", Boolean.TRUE);
        }
    }

    public void applyRecursevely(IXQEQueryNode node, String qName, PlanningEnvironment environment) {
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (query != null) {
            if (query.getBooleanPropertyValue(PROP_BOOLEAN_IS_DECOMPOSED, false).booleanValue()) {
                return;
            }
            Set<String> queryRefNames = query.getV5Source().getReferencedQueries();
            if (queryRefNames != null && query.getV5Source().getNumberChildren() == 0) {
                for (String string : queryRefNames) {
                    this.applyRecursevely(query, string, environment);
                    V5Query subQuery = querySet.getV5Query(string);
                    if (subQuery == null) continue;
                    int isTabular = Boolean.valueOf(subQuery.isTabular()).booleanValue() ? 1 : 0;
                    query.setPropertyValue("isTabular", isTabular != 0);
                    List<V5Query> refQueries = querySet.getReferencingQueries(string, environment);
                    if (refQueries != null && refQueries.size() > 0) {
                        for (V5Query refQuery : refQueries) {
                            refQuery.setPropertyValue("isTabular", isTabular != 0);
                        }
                    }
                    query.setPropertyValue("hasOlapOperand", Boolean.TRUE);
                    query.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.REL_DECOMPOSITION_FROM_OLAP.getName());
                }
            } else if (query.getV5Source().getNumberChildren() != 0) {
                if (query.getV5Source().getChild(0).getType() == 101018) {
                    IXQEQueryNode[] subQs;
                    for (IXQEQueryNode subQ : subQs = query.getV5Source().getChild(0).getChildrenOfType(101023)) {
                        this.applyRecursevely(query, (String)subQ.getPropertyValue("refQuery"), environment);
                    }
                } else if (query.getV5Source().getChild(0).getType() == 101019) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedJoinRelationalFunctionOLAP, query.getV5QueryName());
                }
            }
            if (!query.isTabular() && DecomposeScalarFunction.containsNotSupportedByOlapFunction(query)) {
                Object forceAutosummary;
                boolean needOLAP;
                this.expandMemberCustomProperty(query, environment);
                this.removeUnprojectedDataItems(node, query, environment);
                int[] types = new int[]{101052, 101053};
                boolean bl = node.getDescendantsOfTypes(types, false).length != 0;
                DecomposeScalarFunction.markDataModelSwitch(query, nodeFactory, bl, query.isDMR(), DecomposeScalarFunction.isUnwound(query));
                V5Query olapSubQuery = (V5Query)nodeFactory.deepCopyNode(query);
                if (query.getPropertyValue("referencedByRootQRD") != null) {
                    olapSubQuery.removeProperty("referencedByRootQRD");
                    olapSubQuery.setPropertyValue("rootQueryName", query.getV5QueryName());
                }
                String olapSubQueryName = olapSubQuery.getV5QueryName() + "__SFD_tr__";
                olapSubQuery.setPropertyValue("name", olapSubQueryName);
                olapSubQuery.setPropertyValue(PROP_OLAP_SUB_QUERY, true);
                HashMap<String, V5BoundDataItemReference> mapItems = new HashMap<String, V5BoundDataItemReference>();
                V5QueryResultDefinition qrd = null;
                if (node.getType() == 101055) {
                    qrd = (V5QueryResultDefinition)node;
                }
                boolean checkForGrouping = qrd != null;
                ArrayList<String> decomposedDataItems = null;
                if (checkForGrouping) {
                    decomposedDataItems = new ArrayList<String>();
                }
                if (needOLAP = this.setUpReferencingQuery(query, olapSubQueryName, mapItems, decomposedDataItems, environment)) {
                    V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, query);
                    rootQuerySet.addChild(olapSubQuery, 0);
                    this.copyReferencedQuerySourceToScalarQuery(environment, olapSubQuery);
                    this.refineSubQuery(olapSubQuery, mapItems, environment, query.isDMR(), DecomposeScalarFunction.isUnwound(query));
                }
                this.updateV5DataItemLabelProperty(query);
                V5Selection selection = query.getV5Selection();
                if (checkForGrouping && this.forceAutoSummarize(qrd, query, decomposedDataItems) || DecomposeScalarFunction.aggregationRequiresSummary(selection) || bl && DecomposeScalarFunction.headerFooterRequiresSummary(query, qrd)) {
                    selection.setPropertyValue("EnforceAutosummary", true);
                }
                if (selection.getAutoSummary() && (forceAutosummary = selection.getPropertyValue("EnforceAutosummary")) == null) {
                    selection.setAutoSummary(false);
                    query.setDistinct(true);
                }
                query.setPropertyValue(PROP_BOOLEAN_IS_DECOMPOSED, true);
            }
        }
    }

    private void expandMemberCustomProperty(V5Query node, PlanningEnvironment environment) {
        ArrayList<IXQEQueryNode> refItems = this.getRefItems(node, null);
        for (IXQEQueryNode refItem : refItems) {
            if (!((V5BoundDataItemReference)refItem).isExplicitProperty()) continue;
            ExpandDataItemReferences.processNode(refItem, environment);
        }
    }

    boolean forceAutoSummarize(V5QueryResultDefinition qrd, V5Query query, List<String> decomposedDataItems) {
        boolean groupedOnDecomposedDI = false;
        boolean detailHasValues = false;
        boolean detailHasSets = false;
        for (IXQEQueryNode valueSetNode : qrd.getDescendantsOfTypeOrdered(101057, false)) {
            V5ValueSet valueSet = (V5ValueSet)valueSetNode;
            String refDataItemName = valueSet.getRefDataItemProperty();
            if (refDataItemName == null) {
                V5GroupBody groupBody = (V5GroupBody)valueSet.getFirstChildByType(101051);
                if (groupBody == null) continue;
                for (IXQEQueryNode dataItemRef : groupBody.getChildrenOfType(101015)) {
                    V5DataItem dataItem = this.getReferencedDataItem(query, (V5DataItemRef)dataItemRef);
                    if (dataItem == null) continue;
                    V5ExpressionTypeEnum exprType = V5ExpressionCheck.getExpressionType(dataItem);
                    if (exprType == V5ExpressionTypeEnum.SET || exprType == V5ExpressionTypeEnum.HIERARCHY || exprType == V5ExpressionTypeEnum.LEVEL) {
                        detailHasSets = true;
                        continue;
                    }
                    detailHasValues = true;
                }
                continue;
            }
            if (!decomposedDataItems.contains(refDataItemName)) continue;
            groupedOnDecomposedDI = true;
        }
        return groupedOnDecomposedDI && detailHasValues && !detailHasSets;
    }

    private void copyReferencedQuerySourceToScalarQuery(PlanningEnvironment environment, V5Query olapSubQuery) {
        V5Source sourceOfQueryRef;
        V5Query queryRef;
        Iterator<String> it;
        V5Source source = olapSubQuery.getV5Source();
        Set<String> queryRefs = source.getReferencedQueries();
        if (queryRefs != null && queryRefs.size() > 0 && (it = queryRefs.iterator()).hasNext() && (queryRef = ((V5QuerySet)environment.getRoot()).getV5Query(it.next())) != null && (sourceOfQueryRef = queryRef.getV5Source()).getNumberChildren() > 0 && sourceOfQueryRef.getChild(0).getType() == 1007) {
            IXQEQueryNode cloneCube = environment.getNodeFactory().copyNode(sourceOfQueryRef.getChild(0));
            source.addChild(cloneCube);
        }
    }

    static boolean markDataModelSwitch(IXQEQueryNode node, IXQENodeFactory nodeFactory, boolean headerOrFooterContext, boolean isDMR, boolean isUnwound) {
        IXQEQueryNode[] nodes;
        boolean ret = false;
        if (isDMR && node.getType() == 101008 && DecomposeScalarFunction.isPushedDetailFilterForDMR((V5DetailFilter)node, isUnwound)) {
            return ret;
        }
        if (node.getType() == 101077) {
            return ret;
        }
        if (node.getType() == 101003 && node.getParent().getType() == 101009 && (nodes = node.getDescendantsOfType(201060, false)).length == 0 && !DecomposeScalarFunction.containsNotSupportedByOlapFunction(node) && !DecomposeScalarFunction.isHeaderOrFooterCalculationToBePushedToRel(node, headerOrFooterContext)) {
            IXQEQueryNode marker = nodeFactory.createNode(601024);
            node.getChild(0).insertParent(marker);
            ((RelationalOlapDecorationNode)marker).generateSubtreeIdentifier();
            return true;
        }
        if (DecomposeScalarFunction.isMdxNode(node) && (node.getType() != 201060 || ((V5BoundDataItemReference)node).isQueryRefItem())) {
            if (DecomposeScalarFunction.containsNotSupportedByOlapFunction(node)) {
                StringBuilder buffer = new StringBuilder();
                node.writeFormattedText(buffer);
                throw new XQERuntimeException(XQEMessageKeys.GEN_NotSupportedNesting, buffer.toString());
            }
            IXQEQueryNode marker = nodeFactory.createNode(601024);
            node.insertParent(marker);
            ((RelationalOlapDecorationNode)marker).generateSubtreeIdentifier();
            return true;
        }
        for (IXQEQueryNode child : nodes = node.getChildren()) {
            ret = DecomposeScalarFunction.markDataModelSwitch(child, nodeFactory, headerOrFooterContext, isDMR, isUnwound) || ret;
        }
        return ret;
    }

    void refineSubqueryFilters(V5Query subQuery, PlanningEnvironment environment, boolean isDMR, boolean isUnwound) {
        List<IXQEQueryNode> nodes = subQuery.getDescendantsOfTypesOrdered(this.filterTypes, false);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (IXQEQueryNode current : nodes) {
            IXQEQueryNode[] nodeRODs;
            if (isDMR && current.getType() == 101008 && DecomposeScalarFunction.isPushedDetailFilterForDMR((V5DetailFilter)current, isUnwound)) continue;
            if (DecomposeScalarFunction.containsNotSupportedByOlapFunction(current) || this.referencesNotSupportedByOlapDataItem(current)) {
                IXQEQueryNode[] dataItemRODs;
                if (current.getType() == 101010) {
                    XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedValueExpressionInSlicer, current);
                    throw new XQERuntimeException(message);
                }
                for (IXQEQueryNode nodeROD : dataItemRODs = current.getDescendantsOfType(601024, false)) {
                    RelationalOlapDecorationNode node = (RelationalOlapDecorationNode)nodeROD;
                    V5DataItem dataItem = (V5DataItem)nodeFactory.createNode(101003);
                    IXQEQueryNode exp = nodeFactory.createNode(101004);
                    dataItem.addChild(exp);
                    dataItem.setNameProperty(node.getSubtreeIdentifier());
                    dataItem.setIsOriginal();
                    if (node.getParent().getParent().getType() == 101003) {
                        V5DataItem parent = (V5DataItem)node.getParent().getParent();
                        dataItem.setAggregateProperty(parent.getAggregateProperty());
                        dataItem.setRollupAggregateProperty(parent.getRollupAggregateProperty());
                    } else {
                        dataItem.setAggregateProperty("automatic");
                        dataItem.setRollupAggregateProperty("automatic");
                    }
                    node.detach();
                    exp.addChild(node);
                    subQuery.getV5Selection().addChild(dataItem);
                }
                current.detach();
                continue;
            }
            if (current.getType() == 101011) {
                current.detach();
                continue;
            }
            for (IXQEQueryNode nodeROD : nodeRODs = current.getDescendantsOfType(601024, false)) {
                nodeROD.extract();
            }
        }
    }

    private void refineSubQuery(V5Query query, Map<String, V5BoundDataItemReference> mapItems, PlanningEnvironment environment, boolean isDMR, boolean isUnwound) {
        IXQEQueryNode[] dataItems;
        this.refineSubqueryFilters(query, environment, isDMR, isUnwound);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        for (IXQEQueryNode di : dataItems = query.getV5Selection().getChildrenOfType(101003)) {
            V5DataItem dataItem = (V5DataItem)di;
            IXQEQueryNode[] dataItemRODs = dataItem.getDescendantsOfType(601024, false);
            boolean used = false;
            for (IXQEQueryNode current : dataItemRODs) {
                IXQEQueryNode exp;
                RelationalOlapDecorationNode node = (RelationalOlapDecorationNode)current;
                if (used) {
                    dataItem = (V5DataItem)nodeFactory.deepCopyNode(dataItem);
                    query.getV5Selection().addChild(dataItem);
                }
                if ((exp = dataItem.getFirstChildByType(101004)) != null) {
                    exp.exchangeChildNode(exp.getChild(0), node.getChild(0));
                } else {
                    dataItem.exchangeChildNode(dataItem.getChild(0), node.getChild(0));
                }
                dataItem.setNameProperty(node.getSubtreeIdentifier());
                V5BoundDataItemReference refDI = mapItems.get(node.getSubtreeIdentifier());
                if (refDI != null) {
                    refDI.setRefDataItem(dataItem);
                }
                used = true;
            }
            if (used) continue;
            dataItem.detach();
        }
        query.setPropertyValue("isDMR", null);
    }

    static boolean isMdxNode(IXQEQueryNode node) {
        int[] mdxNodeTypes = new int[]{201050, 201098, 201073, 201082, 201083, 201034, 201032, 201113, 201116, 201117, 201127, 201060, 201138};
        int[] mdxNodeCategories = new int[]{201121, 201122, 201123};
        return node.isOfCategories(mdxNodeCategories) || node.isOfTypes(mdxNodeTypes);
    }

    private boolean setUpReferencingQuery(V5Query query, String subQueryName, Map<String, V5BoundDataItemReference> mapItems, List<String> decomposedDataItems, PlanningEnvironment environment) {
        IXQEQueryNode[] allRODs;
        IXQEQueryNode[] allV5CubeCalculatedDefaultMembers;
        this.refineReferencingQueryFilters(query);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        query.setPropertyValue("isTabular", true);
        query.setPropertyValue("hasOlapOperand", true);
        query.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.REL_DECOMPOSITION_FROM_OLAP.getName());
        query.setPropertyValue("isDMR", Boolean.FALSE);
        for (IXQEQueryNode current : allV5CubeCalculatedDefaultMembers = query.getDescendantsOfType(101077, false)) {
            current.detach();
        }
        for (IXQEQueryNode current : allRODs = query.getDescendantsOfType(601024, false)) {
            V5DataItem dataItem;
            RelationalOlapDecorationNode node = (RelationalOlapDecorationNode)current;
            if (decomposedDataItems != null && node.getParent().getType() != 101003 && (dataItem = (V5DataItem)node.getAncestorOfType(101003)) != null) {
                decomposedDataItems.add(dataItem.getNameProperty());
            }
            String newName = UniqueNameGenerator.createUniqueName(subQueryName, node.getSubtreeIdentifier());
            V5BoundDataItemReference newNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
            newNode.setIdentifier(newName);
            mapItems.put(node.getSubtreeIdentifier(), newNode);
            newNode.setIsQueryRefItem();
            node.exchange(newNode);
        }
        if (allRODs.length != 0) {
            V5Source source = (V5Source)query.getFirstChildByType(101007);
            source.setQueryRef(subQueryName);
            source.detachChildren();
        }
        this.refineNoneSort(query);
        return allRODs.length != 0;
    }

    private void refineNoneSort(V5Query query) {
        IXQEQueryNode[] dateItems;
        String sort = "sort";
        String none = "none";
        for (IXQEQueryNode dataItem : dateItems = query.getV5Selection().getChildrenOfType(101003)) {
            Object sortProp = dataItem.getPropertyValue("sort");
            if (sortProp == null || !sortProp.equals("none")) continue;
            dataItem.removeProperty("sort");
        }
    }

    private void refineReferencingQueryFilters(V5Query query) {
        List<IXQEQueryNode> nodes = query.getDescendantsOfTypesOrdered(this.filterTypes, false);
        for (IXQEQueryNode current : nodes) {
            if (query.isDMR() && current.getType() == 101008 && DecomposeScalarFunction.isPushedDetailFilterForDMR((V5DetailFilter)current, DecomposeScalarFunction.isUnwound(query))) {
                current.detach();
                continue;
            }
            if (current.getType() == 101011 || DecomposeScalarFunction.containsNotSupportedByOlapFunction(current) || this.referencesNotSupportedByOlapDataItem(current)) continue;
            current.detach();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        V5Query query = qrd.getV5Query();
        boolean isGetParam = ((RequestEnvironment)environment.getRequestEnvironment()).isGetParametersRequest();
        if (isGetParam && query.getPropertyValue("notClonedDespiteBeingRefByMultipleQRDs") != null) {
            return false;
        }
        status = DecomposeScalarFunction.passesQueryAndSubqueryCondition(query);
        if (status) {
            this.traceQueryCondition(status, "The Scalar Operation Logical Decomposition will be applied.", trace);
        }
        return status;
    }

    public static boolean passesQueryAndSubqueryCondition(V5Query query) {
        boolean status;
        block10: {
            int type;
            block11: {
                V5QuerySet querySet;
                status = false;
                if (Boolean.TRUE == query.getPropertyValue("forceDMRtoRQP")) {
                    return false;
                }
                if (!(query.getBooleanPropertyValue(PROP_BOOLEAN_IS_DECOMPOSED, false).booleanValue() || query.isTabular() || query.isRelStyle() || (status = query.isDMR() ? DecomposeScalarFunction.containsNotSupportedByOlapFunctionExcludePushedDetailFilters(query) : DecomposeScalarFunction.containsNotSupportedByOlapFunction(query)))) {
                    V5Source src = query.getV5Source();
                    querySet = (V5QuerySet)src.getFirstChildByType(101002);
                    if (querySet != null) {
                        IXQEQueryNode[] subQueries = querySet.getChildrenOfType(101006);
                        for (IXQEQueryNode current : subQueries) {
                            V5Query v5Query = (V5Query)current;
                            if (!DecomposeScalarFunction.passesQueryAndSubqueryCondition(v5Query)) continue;
                            return true;
                        }
                    } else {
                        Set<String> subQNames = src.getReferencedQueries();
                        if (subQNames != null) {
                            IXQEQueryNode theParent = query.getParent();
                            querySet = (V5QuerySet)query.getAncestorOfType(101002);
                            IXQEQueryNode[] subQueries = null;
                            subQueries = theParent.getType() != 101073 ? querySet.getChildrenOfType(101006) : querySet.getChildrenOfType(101073);
                            for (String subQName : subQNames) {
                                for (IXQEQueryNode current : subQueries) {
                                    V5Query subQuery2 = null;
                                    subQuery2 = current.getType() != 101073 ? (V5Query)current : (V5Query)current.getFirstChildByType(101006);
                                    if (subQuery2 == null || !subQName.equals(subQuery2.getV5QueryName()) || !DecomposeScalarFunction.passesQueryAndSubqueryCondition(subQuery2)) continue;
                                    return true;
                                }
                            }
                        }
                    }
                }
                if (status || query.getV5Source().getNumberChildren() == 0) break block10;
                type = query.getV5Source().getChild(0).getType();
                if (type != 101018) break block11;
                querySet = (V5QuerySet)query.getAncestorOfType(101002);
                IXQEQueryNode[] subQs = query.getV5Source().getChild(0).getChildrenOfType(101023);
                for (IXQEQueryNode subQ : subQs) {
                    V5Query v5Query = querySet.getV5Query((String)subQ.getPropertyValue("refQuery"));
                    if (!DecomposeScalarFunction.passesQueryAndSubqueryCondition(v5Query)) continue;
                    return true;
                }
                break block10;
            }
            if (type != 101019) break block10;
            Set<String> joinOperands = ((V5JoinOperation)query.getV5Source().getChild(0)).getJoinOperandNames();
            V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
            for (String jOperands : joinOperands) {
                V5Query subQuery = querySet.getV5Query(jOperands);
                if (subQuery.isTabular() || !DecomposeScalarFunction.passesQueryAndSubqueryCondition(subQuery)) continue;
                return true;
            }
        }
        return status;
    }

    public static boolean isUnwound(V5Query query) {
        if (query.getParent().getType() == 101073) {
            return true;
        }
        return Boolean.TRUE == query.getPropertyValue("unwound");
    }

    protected static boolean containsNotSupportedByOlapFunctionExcludePushedDetailFilters(V5Query query) {
        IXQEQueryNode[] children;
        ArrayList<IXQEQueryNode> scalarFunctions = new ArrayList<IXQEQueryNode>();
        boolean inUnwind = DecomposeScalarFunction.isUnwound(query);
        block4: for (IXQEQueryNode child : children = query.getChildren()) {
            int[] types = scalarTypes;
            switch (child.getType()) {
                case 101009: {
                    if (inUnwind) {
                        IXQEQueryNode[] dataItems;
                        IXQEQueryNode querySet = query.getAncestorOfType(101002);
                        IXQEQueryNode[] qrds = querySet.getChildrenOfType(101055);
                        HashSet<String> projectedNames = new HashSet<String>();
                        for (IXQEQueryNode qrd : qrds) {
                            projectedNames.addAll(DecomposeScalarFunction.getProjectedDataItemNames(qrd, query));
                        }
                        if (projectedNames.size() <= 0) continue block4;
                        for (IXQEQueryNode dataItem : dataItems = child.getChildrenOfType(101003)) {
                            if (!projectedNames.contains(((V5DataItem)dataItem).getNameProperty())) continue;
                            scalarFunctions.addAll(Arrays.asList(dataItem.getDescendantsOfTypes(types, false)));
                        }
                        continue block4;
                    }
                    scalarFunctions.addAll(Arrays.asList(child.getDescendantsOfTypes(types, false)));
                    continue block4;
                }
                case 101008: {
                    if (DecomposeScalarFunction.isPushedDetailFilterForDMR((V5DetailFilter)child, inUnwind)) {
                        types = aggrFuncTypes;
                    }
                }
                default: {
                    scalarFunctions.addAll(Arrays.asList(child.getDescendantsOfTypes(types, false)));
                }
            }
        }
        return DecomposeScalarFunction.checkScalarFunctionsDMR(scalarFunctions.toArray(new IXQEQueryNode[scalarFunctions.size()]), null);
    }

    public static boolean isPushedDetailFilterForDMR(V5DetailFilter filter, boolean inUnwind) {
        Boolean masterDetail = (Boolean)filter.getPropertyValue("masterDetailDFilter");
        if (masterDetail != null && masterDetail.booleanValue()) {
            return false;
        }
        boolean postAggregation = filter.getPostAutoAggregation();
        if (postAggregation) {
            return false;
        }
        return inUnwind && DMRUtilities.allOLAPFunctionsCanBeConvertedToRelationalExpr(filter) && !RQPUtilities.hasAggregateInExpression(filter);
    }

    public static boolean containsNotSupportedByOlapFunction(IXQEQueryNode node) {
        IXQEQueryNode[] scalarFunctions = node.getDescendantsOfTypes(scalarTypes, false);
        return DecomposeScalarFunction.checkScalarFunctions(scalarFunctions, null);
    }

    public static boolean isHeaderOrFooterCalculationToBePushedToRel(IXQEQueryNode node, boolean headerOrFooterContext) {
        IXQEQueryNode[] valueExpressions = node.getDescendantsOfType(201014, false);
        boolean bRet = false;
        for (IXQEQueryNode valueExpression : valueExpressions) {
            V5ValueExpression valueExp = (V5ValueExpression)valueExpression;
            int subType = valueExp.getSubType();
            if (subType != 3 && subType != 4) continue;
            bRet = true;
            break;
        }
        return bRet && headerOrFooterContext;
    }

    public static boolean checkScalarFunctions(IXQEQueryNode[] scalarFunctions, IXQEQueryNode[] whichOne) {
        return DecomposeScalarFunction.checkScalarFunctionsOLAPOrDMR(scalarFunctions, whichOne, false);
    }

    public static boolean checkScalarFunctionsDMR(IXQEQueryNode[] scalarFunctions, IXQEQueryNode[] whichOne) {
        return DecomposeScalarFunction.checkScalarFunctionsOLAPOrDMR(scalarFunctions, whichOne, true);
    }

    protected static boolean checkScalarFunctionsOLAPOrDMR(IXQEQueryNode[] scalarFunctions, IXQEQueryNode[] whichOne, boolean bDMR) {
        boolean bRet = false;
        block6: for (IXQEQueryNode scalarFunction : scalarFunctions) {
            switch (scalarFunction.getType()) {
                case 201041: {
                    int strFctType = ((V5StringFunction)scalarFunction).getSubType();
                    if (strFctType != 1 && strFctType != 0 && (bDMR || !DecomposeScalarFunction.containRelationalMetadataObjects(scalarFunction)) && (!bDMR || DecomposeScalarFunction.containDMRMetadataObjects(scalarFunction))) break;
                    continue block6;
                }
                case 201040: {
                    int scaFctType = ((V5ScalarFunction)scalarFunction).getSubType();
                    if (scaFctType == 6 && (bDMR || !DecomposeScalarFunction.containRelationalMetadataObjects(scalarFunction)) && (!bDMR || DecomposeScalarFunction.containDMRMetadataObjects(scalarFunction))) break;
                    continue block6;
                }
                case 201014: {
                    V5ValueExpression exp = (V5ValueExpression)scalarFunction;
                    int subType = exp.getSubType();
                    if (subType == 0 && (bDMR || !DecomposeScalarFunction.containRelationalMetadataObjects(scalarFunction)) && (!bDMR || DecomposeScalarFunction.containDMRMetadataObjects(scalarFunction))) break;
                    continue block6;
                }
                case 201025: {
                    break;
                }
                default: {
                    if (!bDMR && DecomposeScalarFunction.containRelationalMetadataObjects(scalarFunction) || bDMR && !DecomposeScalarFunction.containDMRMetadataObjects(scalarFunction)) continue block6;
                }
            }
            if (whichOne != null) {
                whichOne[0] = scalarFunction;
            }
            bRet = true;
            break;
        }
        return bRet;
    }

    protected static boolean containRelationalMetadataObjects(IXQEQueryNode scalarFunction) {
        IXQEQueryNode[] modelObjects;
        for (IXQEQueryNode obj : modelObjects = scalarFunction.getDescendantsOfType(201116, false)) {
            IMetadata metaData = ((V5BoundModelIdentifier)obj).getMetadata();
            if (metaData.getObjectType() != MetadataType.QUERY_ITEM || ((IQueryItem)metaData).getHierarchy() != null) continue;
            return true;
        }
        return false;
    }

    public static boolean containDMRMetadataObjects(IXQEQueryNode node) {
        IXQEQueryNode[] identifiers = node.getChildrenOfCategory(101064);
        if (identifiers.length == 0) {
            V5SimpleNode v5SimpleNodeChild;
            IMetadata metadata;
            if (node instanceof V5SimpleNode && ((metadata = (v5SimpleNodeChild = (V5SimpleNode)node).getMetadata()) == null ? node instanceof V5BoundDataItemReference && DecomposeScalarFunction.containDMRMetadataObjects(((V5BoundDataItemReference)node).getRefDataItem()) : metadata.isDMR())) {
                return true;
            }
        } else {
            for (IXQEQueryNode anIdentifier : identifiers) {
                if (!DecomposeScalarFunction.containDMRMetadataObjects(anIdentifier)) continue;
                return true;
            }
        }
        return false;
    }

    boolean referencesNotSupportedByOlapDataItem(IXQEQueryNode node) {
        List<IXQEQueryNode> items = node.getDescendantsOfTypeOrdered(201060, false);
        for (IXQEQueryNode item : items) {
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)item;
            V5DataItem dataItem = dataItemRef.getRefDataItem();
            if (dataItem == null || this.wholeExpressionMarkedAsOlap(dataItem)) continue;
            return true;
        }
        items = node.getDescendantsOfTypeOrdered(101012, false);
        for (IXQEQueryNode item : items) {
            V5SummaryFilterLevel scope = (V5SummaryFilterLevel)item;
            String name = scope.getRefDataItem();
            V5Query query = (V5Query)node.getAncestorOfType(101006);
            V5DataItem dataItem = query.getV5Selection().getDataItemByRefName(name);
            if (dataItem == null || this.wholeExpressionMarkedAsOlap(dataItem)) continue;
            return true;
        }
        return false;
    }

    private boolean wholeExpressionMarkedAsOlap(IXQEQueryNode node) {
        while (!node.isOfCategory(201120)) {
            node = node.getChild(0);
        }
        return node.getType() == 601024 || node.getType() == 201060;
    }

    protected void removeUnprojectedDataItems(IXQEQueryNode aNode, V5Query query, PlanningEnvironment environment) {
        if (aNode.getType() != 101055) {
            return;
        }
        HashSet<String> projectedItemNames = DecomposeScalarFunction.getProjectedDataItemNames(aNode, query);
        V5Selection selection = query.getV5Selection();
        IXQEQueryNode[] items = selection.getChildrenOfType(101003);
        if (items.length == projectedItemNames.size()) {
            return;
        }
        ArrayList<IXQEQueryNode> itemToRemove = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode item : items) {
            if (projectedItemNames.contains(((V5DataItem)item).getNameProperty())) continue;
            itemToRemove.add(item);
            this.expandRefItems(item, environment, null);
        }
        IXQEQueryNode[] children = query.getChildren();
        for (IXQEQueryNode child : children) {
            if (child.getType() == 101007) continue;
            this.expandRefItems(child, environment, itemToRemove);
        }
        for (IXQEQueryNode itemDel : itemToRemove) {
            selection.detachChild(itemDel);
        }
    }

    public static HashSet<String> getProjectedDataItemNames(IXQEQueryNode aNode, V5Query query) {
        IXQEQueryNode[] summaryFilters;
        IXQEQueryNode[] sortNodes;
        IXQEQueryNode[] nodes;
        HashSet<String> projectedItemNames = new HashSet<String>();
        int[] types = new int[]{101015, 101057};
        for (IXQEQueryNode node : nodes = aNode.getDescendantsOfTypes(types, false)) {
            String name = SetV5DataItemIsProjected.getDataItemName(node);
            if (name == null) continue;
            projectedItemNames.add(name);
        }
        for (IXQEQueryNode sortNode : sortNodes = aNode.getDescendantsOfType(101056, false)) {
            String refName = ((V5SortItem)sortNode).getRefDataItem();
            if (refName == null) continue;
            projectedItemNames.add(refName);
        }
        for (IXQEQueryNode summaryFilter : summaryFilters = query.getChildrenOfTypeOrdered(101011)) {
            IXQEQueryNode[] dataItemRefs;
            for (IXQEQueryNode dataItemRef : dataItemRefs = summaryFilter.getDescendantsOfType(201060, false)) {
                projectedItemNames.add(((V5BoundDataItemReference)dataItemRef).getDataItemName());
            }
        }
        return projectedItemNames;
    }

    protected void expandRefItems(IXQEQueryNode node, PlanningEnvironment environment, List<IXQEQueryNode> checkList) {
        ArrayList<IXQEQueryNode> refItems = this.getRefItems(node, checkList);
        while (!refItems.isEmpty()) {
            for (IXQEQueryNode refItem : refItems) {
                ExpandDataItemReferences.processNode(refItem, environment);
            }
            refItems = this.getRefItems(node, checkList);
        }
    }

    protected ArrayList<IXQEQueryNode> getRefItems(IXQEQueryNode node, List<IXQEQueryNode> checkList) {
        IXQEQueryNode[] refs;
        ArrayList<IXQEQueryNode> refItems = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode ref : refs = node.getDescendantsOfType(201060, false)) {
            V5BoundDataItemReference refItem = (V5BoundDataItemReference)ref;
            if (refItem.isQueryRefItem() || checkList != null && !checkList.contains(refItem.getRefDataItem())) continue;
            refItems.add(ref);
        }
        return refItems;
    }

    private static boolean aggregationRequiresSummary(IXQEQueryNode node) {
        for (IXQEQueryNode aggrFunc : node.getDescendantsOfType(201031, false)) {
            String aggregate;
            V5DataItem dataItem = (V5DataItem)aggrFunc.getAncestorOfType(101003);
            if (dataItem == null || (aggregate = dataItem.getAggregateProperty()) == null || aggregate.equals("calculated") || aggregate.equals("automatic")) continue;
            return true;
        }
        return false;
    }

    private static boolean headerFooterRequiresSummary(V5Query query, V5QueryResultDefinition qrd) {
        IXQEQueryNode[] headerFooters;
        int[] types = new int[]{101052, 101053};
        for (IXQEQueryNode headerFooter : headerFooters = qrd.getDescendantsOfTypes(types, false)) {
            IXQEQueryNode[] dataItemRefs;
            for (IXQEQueryNode dataItemRef : dataItemRefs = headerFooter.getDescendantsOfType(101015, false)) {
                V5DataItem dataItem = query.getV5Selection().getDataItemByRefName(((V5DataItemRef)dataItemRef).getDataItemRefProperty());
                String aggregate = dataItem.getAggregateProperty();
                if (aggregate == null || aggregate.equals("calculated") || aggregate.equals("automatic")) continue;
                return true;
            }
        }
        return false;
    }
}

