/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.Iterator;
import java.util.Set;

public class MoveReportAggregatedItemsToMainQuery
extends Transformation {
    public MoveReportAggregatedItemsToMainQuery() {
        this.mName = "Move report aggregated Items to main query.";
        this.mPassNumbers = new int[]{12};
        this.mTypes = new int[]{101006};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dataItems;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5Query queryMain = (V5Query)node;
        V5Query querySub = MoveReportAggregatedItemsToMainQuery.getSubQuery(queryMain, environment);
        for (IXQEQueryNode dataItem : dataItems = querySub.getV5Selection().getChildren()) {
            IXQEQueryNode[] aggs;
            boolean bDecompose = false;
            for (IXQEQueryNode agg : aggs = dataItem.getDescendantsOfType(201037, false)) {
                V5AggregateBreakClause an = (V5AggregateBreakClause)agg;
                if (an.getSubType() != 0) continue;
                bDecompose = DecomposeScalarFunction.markDataModelSwitch(dataItem.getChild(0), nodeFactory, false, queryMain.isDMR(), DecomposeScalarFunction.isUnwound(queryMain)) || bDecompose;
            }
            if (!bDecompose) continue;
            IXQEQueryNode[] nodes = dataItem.getDescendantsOfType(601024, false);
            this.optimizeDataModelSwitch(nodes);
            this.decomposeDataItem(nodeFactory, querySub, (V5DataItem)dataItem);
            dataItem.detach();
            this.replaceDataItemReference((V5DataItem)dataItem, queryMain.getV5Selection());
        }
    }

    void optimizeDataModelSwitch(IXQEQueryNode[] nodes) {
        for (IXQEQueryNode node : nodes) {
            this.optimizeSingleDataModelSwitch((RelationalOlapDecorationNode)node);
        }
    }

    void optimizeSingleDataModelSwitch(RelationalOlapDecorationNode node) {
        IXQEQueryNode[] children;
        int[] mdxNodeTypes = new int[]{201031};
        IXQEQueryNode parent = node.getParent();
        for (IXQEQueryNode child : children = parent.getChildren()) {
            if (child.getType() == 601024) continue;
            return;
        }
        if (parent.isOfTypes(mdxNodeTypes)) {
            for (IXQEQueryNode child : children) {
                child.extract();
            }
        }
        parent.insertParent(node);
        this.optimizeSingleDataModelSwitch(node);
    }

    boolean decomposeDataItem(XQENodeFactory nodeFactory, V5Query querySub, V5DataItem dataItemDecompose) {
        IXQEQueryNode[] dataItemRODs;
        String subQueryName = querySub.getV5QueryName();
        for (IXQEQueryNode current : dataItemRODs = dataItemDecompose.getDescendantsOfType(601024, false)) {
            RelationalOlapDecorationNode n = (RelationalOlapDecorationNode)current;
            V5DataItem dataItem = (V5DataItem)nodeFactory.copyNode(dataItemDecompose);
            querySub.getV5Selection().addChild(dataItem);
            dataItem.addChild(n.detachChild(0));
            dataItem.setNameProperty(n.getSubtreeIdentifier());
            V5BoundDataItemReference newNode = (V5BoundDataItemReference)nodeFactory.createNode(201060);
            String newName = UniqueNameGenerator.createUniqueName(subQueryName, n.getSubtreeIdentifier());
            newNode.setIdentifier(newName);
            newNode.setIsQueryRefItem();
            newNode.setRefDataItem(dataItem);
            n.exchange(newNode);
        }
        return dataItemRODs.length != 0;
    }

    void replaceDataItemReference(V5DataItem dataItem, IXQEQueryNode node) {
        String dataItemName = dataItem.getNameProperty();
        IXQEQueryNode[] diRefs = node.getDescendantsOfType(201060, false);
        boolean bReplaced = false;
        for (IXQEQueryNode current : diRefs) {
            V5BoundDataItemReference diRef = (V5BoundDataItemReference)current;
            if (diRef.getRefDataItem().getNameProperty() != dataItemName) continue;
            if (bReplaced) {
                node.throwInternalError("Subtree has multiple references to data item " + dataItemName + ". Single reference is expected.");
            }
            diRef.exchange(dataItem);
            bReplaced = true;
        }
        if (!bReplaced) {
            node.throwInternalError("Subtree does not have reference to data item " + dataItemName);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        Boolean status = node.getBooleanPropertyValue("isDecomposed");
        if (status == null) {
            status = false;
        }
        if (!status.booleanValue()) {
            this.traceQueryCondition(status, "Query node is not created by DecomposeScalarFunction.", trace);
            return false;
        }
        if (node.getChildrenOfType(101008).length == 0) {
            this.traceQueryCondition(false, "There is no filter in main query.", trace);
            return false;
        }
        V5Query subQuery = MoveReportAggregatedItemsToMainQuery.getSubQuery(node, environment);
        if (subQuery == null) {
            this.traceQueryCondition(false, "There is no sub-query of main query.", trace);
            return false;
        }
        IXQEQueryNode[] aggs = subQuery.getDescendantsOfType(201037, false);
        status = false;
        for (IXQEQueryNode agg : aggs) {
            V5AggregateBreakClause an = (V5AggregateBreakClause)agg;
            if (an.getSubType() != 0) continue;
            status = true;
            break;
        }
        if (status.booleanValue()) {
            this.traceQueryCondition(status, "Data item with report aggregation scope in sub query and filter in main query.", trace);
        } else {
            this.traceQueryCondition(status, "There is not data item with report aggregation scope.", trace);
        }
        return status;
    }

    public static V5Query getSubQuery(IXQEQueryNode mainQuery, PlanningEnvironment environment) {
        V5QuerySet rootQuerySet;
        V5Source source = ((V5Query)mainQuery).getV5Source();
        Set<String> queryRefs = source.getReferencedQueries();
        if (queryRefs == null || queryRefs.size() == 0) {
            return null;
        }
        Iterator<String> it = queryRefs.iterator();
        if (it.hasNext() && (rootQuerySet = V5QuerySet.getRootQuerySet(environment, mainQuery)) != null) {
            return rootQuerySet.getV5Query(it.next());
        }
        return null;
    }
}

