/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Slicer;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.dmr.WrapMetadataObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReplicateSubQueryFilters
extends Transformation {
    public ReplicateSubQueryFilters() {
        this.mName = "Replicate super-query filters.";
        this.mPassNumbers = new int[]{17};
        this.mTypes = new int[]{101006};
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        Set<String> queryRefs;
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        if (query.isTabular()) {
            this.traceQueryCondition(false, "Sub query check is not required: query is tabular.", trace);
            return false;
        }
        V5Source source = query.getV5Source();
        if ((source.getNumberChildren() == 0 || source.getNumberChildren() == 1 && source.getChild(0).getType() == 1007) && (queryRefs = source.getReferencedQueries()) != null) {
            for (String queryRef : queryRefs) {
                V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
                V5Query subQuery = querySet.getV5QueryExternal(queryRef);
                if (subQuery.isTabular()) continue;
                IXQEQueryNode[] slicers = subQuery.getDescendantsOfType(101010, false);
                if (slicers.length > 0) {
                    this.traceQueryCondition(true, "Replicate super-query slicers.", trace);
                    return true;
                }
                IXQEQueryNode[] filters = subQuery.getDescendantsOfType(101008, false);
                if (filters.length <= 0) continue;
                boolean flag = false;
                for (int i = 0; i < filters.length; ++i) {
                    V5DetailFilter v5DetailFilter = (V5DetailFilter)filters[i];
                    IDimension dimension = this.isEmbeddedFilter(v5DetailFilter);
                    if (dimension == null) {
                        flag = true;
                        continue;
                    }
                    if (!this.getProjectedDims(query).contains(dimension.getV5UniqueName())) continue;
                    flag = true;
                }
                if (!flag) continue;
                this.traceQueryCondition(true, "Replicate super-query filter.", trace);
                return true;
            }
        }
        this.traceQueryCondition(false, "The query is not referencing any other query.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        V5Source source = query.getV5Source();
        ArrayList<IXQEQueryNode> reWrapObjs = new ArrayList<IXQEQueryNode>();
        Set<String> subQueryNames = source.getReferencedQueries();
        V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
        Boolean subAutoSummary = null;
        for (String subQueryName : subQueryNames) {
            V5Selection subSelect;
            V5Query subQuery = querySet.getV5QueryExternal(subQueryName);
            if (subQueryNames.size() == 1 && (subSelect = subQuery.getV5Selection()) != null) {
                subAutoSummary = subSelect.getAutoSummary();
            }
            boolean dmrReWrap = subQuery.isDMR();
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            List<IXQEQueryNode> slicers = subQuery.getDescendantsOfTypeOrdered(101010, false);
            for (IXQEQueryNode iter : slicers) {
                V5Slicer slicer = (V5Slicer)iter;
                V5Slicer clonedSlicer = (V5Slicer)nodeFactory.deepCopyNode(slicer);
                if (dmrReWrap) {
                    this.getReWrapObjects(environment, reWrapObjs, subQuery, clonedSlicer);
                }
                query.addChild(clonedSlicer);
            }
            List<IXQEQueryNode> filters = subQuery.getDescendantsOfTypeOrdered(101008, false);
            ArrayList<V5DetailFilter> deferredEmbeddedFilters = new ArrayList<V5DetailFilter>();
            for (IXQEQueryNode filter : filters) {
                if (this.isEmbeddedFilter((V5DetailFilter)filter) == null) {
                    V5DetailFilter clonedFilter = (V5DetailFilter)nodeFactory.deepCopyNode(filter);
                    if (dmrReWrap) {
                        this.getReWrapObjects(environment, reWrapObjs, subQuery, clonedFilter);
                    }
                    query.addChild(clonedFilter);
                    continue;
                }
                deferredEmbeddedFilters.add((V5DetailFilter)filter);
            }
            if (deferredEmbeddedFilters.isEmpty()) continue;
            Set<String> projectedDimNames = this.getProjectedDims(query);
            for (V5DetailFilter f : deferredEmbeddedFilters) {
                IDimension dimension = this.isEmbeddedFilter(f);
                if (!projectedDimNames.contains(dimension.getV5UniqueName())) continue;
                V5DetailFilter clonedFilter = (V5DetailFilter)nodeFactory.deepCopyNode(f);
                if (dmrReWrap) {
                    this.getReWrapObjects(environment, reWrapObjs, subQuery, clonedFilter);
                }
                query.addChild(clonedFilter);
            }
        }
        if (!reWrapObjs.isEmpty()) {
            CubeWrapper cube = DMRUtilities.findCubeWrapper(query, environment, true);
            INamespace namespace = environment.getMetadataConnection().getRootNamespace();
            DMRUtilities.createCubeWrapperDimensionsNodes(reWrapObjs, cube, namespace.getConnection());
            this.reWrap(environment, cube, reWrapObjs);
            query.setPropertyValue("isDMR", Boolean.TRUE);
            source.resetReferencedQueries();
            V5Selection select = query.getV5Selection();
            if (select != null && Boolean.TRUE.equals(subAutoSummary) && !select.getAutoSummary()) {
                select.setAutoSummary(true);
            }
        }
    }

    private void getReWrapObjects(PlanningEnvironment environment, ArrayList<IXQEQueryNode> reWrapObjs, V5Query subQuery, IXQEQueryNode node) {
        int[] types = new int[]{201024, 201127, 201117, 201116};
        IXQEQueryNode[] objs = node.getDescendantsOfTypes(types, false);
        CubeWrapper subCube = DMRUtilities.findCubeWrapper(subQuery, environment, true);
        for (IXQEQueryNode obj : objs) {
            IMetadata meta;
            V5BoundToMetadata boundToMetadata = (V5BoundToMetadata)obj;
            IMetadata metadataWrapper = boundToMetadata.getMetadata();
            if (metadataWrapper == null || (meta = subCube.getWrapped(metadataWrapper)) == null) continue;
            boundToMetadata.setMetadata(meta);
            reWrapObjs.add(obj);
        }
    }

    private void reWrap(PlanningEnvironment environment, CubeWrapper cube, ArrayList<IXQEQueryNode> reWrapObjs) {
        for (IXQEQueryNode obj : reWrapObjs) {
            V5BoundToMetadata boundToMetadata = (V5BoundToMetadata)obj;
            WrapMetadataObject.wrapDMRObject(environment, cube, boundToMetadata);
        }
    }

    private IDimension isEmbeddedFilter(V5DetailFilter v5DetailFilter) {
        IMetadata metadata = v5DetailFilter.getIntroducingFilterOwner();
        if (metadata == null) {
            metadata = v5DetailFilter.getFilterOwner();
        }
        if (metadata != null && metadata instanceof IDimension) {
            return (IDimension)metadata;
        }
        return null;
    }

    private Set<String> getProjectedDims(V5Query query) {
        IXQEQueryNode[] boundModelIdentifiers = query.getDescendantsOfType(201116, true, 101008);
        HashSet<String> dimNames = new HashSet<String>();
        for (int j = 0; j < boundModelIdentifiers.length; ++j) {
            V5BoundModelIdentifier boundModelIdentifier = (V5BoundModelIdentifier)boundModelIdentifiers[j];
            IHierarchy hierarchy = boundModelIdentifier.getHierarchy();
            if (hierarchy == null) continue;
            dimNames.add(hierarchy.getDimension().getV5UniqueName());
        }
        return dimNames;
    }
}

