/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class SetV5QueryReferencedByRootQRD
extends Transformation {
    public SetV5QueryReferencedByRootQRD() {
        this.mName = "SetV5QueryReferencedByRootQRD";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{101002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet rootQuerySet = (V5QuerySet)node;
        IXQEQueryNode[] rootQRDs = rootQuerySet.getChildrenOfType(101055);
        HashSet<String> allQueriesReferencedByRootQRD = new HashSet<String>();
        HashSet<String> allQueryRefs = new HashSet<String>();
        for (IXQEQueryNode qrd : rootQRDs) {
            V5QueryResultDefinition qrdNode = (V5QueryResultDefinition)qrd;
            V5Query v5Query = rootQuerySet.getV5Query(qrdNode.getRefQueryProperty());
            v5Query.setPropertyValue("referencedByRootQRD", true);
            String queryName = v5Query.getV5QueryName();
            allQueriesReferencedByRootQRD.add(queryName);
            rootQuerySet.addQueryInQueryMap(queryName, v5Query);
            Set<String> queryRefs = v5Query.getSubQueryNames(environment);
            if (queryRefs.size() <= 0) continue;
            allQueryRefs.addAll(queryRefs);
        }
        if (allQueryRefs.size() == 0) {
            return;
        }
        for (String queryName : allQueriesReferencedByRootQRD) {
            List<V5Query> referencingQueries = rootQuerySet.getReferencingQueries(queryName, environment);
            if (referencingQueries.isEmpty()) continue;
            V5Query v5Query = rootQuerySet.getV5Query(queryName);
            if (V5SubQueryBuilder.containsAggregateWithinDetail(v5Query)) {
                IXQEQueryNode[] v5DataItems;
                XQENodeFactory nodeFactory = environment.getNodeFactory();
                V5Query cloneQuery = (V5Query)nodeFactory.deepCopyNode(v5Query);
                String queryOriginalName = v5Query.getV5QueryName();
                String queryNewName = queryOriginalName + "_ReferencedByRootQRD";
                cloneQuery.setPropertyValue("name", queryNewName);
                rootQuerySet.addChild(cloneQuery);
                List<V5QueryResultDefinition> queryQRDs = rootQuerySet.getReferencedQRDs(v5Query);
                for (V5QueryResultDefinition qrd : queryQRDs) {
                    qrd.setRefQueryProperty(queryNewName);
                }
                for (IXQEQueryNode item : v5DataItems = v5Query.getV5Selection().getChildrenOfTypeOrdered(101003)) {
                    if (!V5SubQueryBuilder.containsAggregateWithinDetail(item)) continue;
                    item.detach();
                }
            }
            v5Query.removeProperty("referencedByRootQRD");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, node);
        if (rootQuerySet != null && rootQuerySet.getFirstChildByType(101055) == null) {
            this.traceNodeCondition(false, "No QRD in the request.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Set V5 queries referenced by root QRD.", trace);
        return true;
    }
}

