/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXDetailFilter;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqe.transformation.v5tocogmdx.V5ToCogMDXUtilities;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.HashSet;
import java.util.TreeSet;

public final class AddDetailFilterToCube
extends Transformation {
    public AddDetailFilterToCube() {
        this.mName = "Add detail filter to the cube.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{1010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXDetailFilter detailFilter = (CogMDXDetailFilter)node;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        CubeWrapper cubeWrapper = (CubeWrapper)mdxQuery.getMDXFrom().getCube();
        this.addSubQueriesToCubewrapper(environment, cubeWrapper, detailFilter, mdxQuery);
        cubeWrapper.addDetailFilter(detailFilter);
        node.getParent().detachChild(node);
    }

    private void addSubQueriesToCubewrapper(PlanningEnvironment environment, CubeWrapper cubeWrapper, CogMDXDetailFilter detailFilter, MDXQuery mdxQuery) {
        IXQEQueryNode[] dataItems;
        V5QuerySet thisV5QuerySet = (V5QuerySet)detailFilter.getAncestorOfType(101002);
        if (thisV5QuerySet == null) {
            return;
        }
        TreeSet<String> subQueryNames = new TreeSet<String>();
        for (IXQEQueryNode dataItem : dataItems = detailFilter.getDescendantsOfType(101003, false)) {
            V5Query v5Query;
            String[] nameParts;
            Boolean b = (Boolean)dataItem.getPropertyValue("subQueryDataItemRef");
            String orgDef = (String)dataItem.getPropertyValue("orgDefined");
            if (b != Boolean.TRUE || orgDef == null || (nameParts = UniqueNameParser.parseNoThrow(orgDef)) == null || nameParts.length != 2 || (v5Query = thisV5QuerySet.getV5Query(nameParts[0])) == null) continue;
            if (!v5Query.isDMR()) {
                subQueryNames.add(nameParts[0]);
                continue;
            }
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidDMRQueryAsSubquery, nameParts[0], mdxQuery.getRefQueryProperty());
        }
        if (subQueryNames.isEmpty()) {
            return;
        }
        V5QuerySet subV5QuerySet = cubeWrapper.getV5QuerySetForV5DetailFilter();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (subV5QuerySet == null) {
            subV5QuerySet = (V5QuerySet)nodeFactory.createNode(101002);
            cubeWrapper.setV5QuerySetForV5DetailFilter(subV5QuerySet);
        }
        HashSet<String> subInsubQueryNames = new HashSet<String>();
        for (String subQueryName : subQueryNames) {
            V5Query v5Query = thisV5QuerySet.getV5Query(subQueryName);
            MixedDMRRelUtil.getAllSubQueryNamesFromV5Query(v5Query, environment, thisV5QuerySet, subInsubQueryNames);
        }
        subQueryNames.addAll(subInsubQueryNames);
        for (String subQueryName : subQueryNames) {
            V5Query orgV5Query;
            if (subV5QuerySet.getV5Query(subQueryName) != null || (orgV5Query = thisV5QuerySet.getV5Query(subQueryName)) == null) continue;
            subV5QuerySet.addChild(nodeFactory.deepCopyNode(orgV5Query));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXDetailFilter mdxDetailFilter = (CogMDXDetailFilter)node;
        if (mdxDetailFilter != null && mdxDetailFilter.pushDetailFilterToRelationalProvider()) {
            this.traceNodeCondition(true, "Detail filter expression pushed to relational planning.", environment.getTrace());
            return true;
        }
        this.traceNodeCondition(false, "Detail filter expression not pushed to relational planning.", environment.getTrace());
        return false;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!V5ToCogMDXUtilities.isNodeWithinMDXQuery(this, node, environment)) {
            this.traceNodeCondition(false, "Detail filter is not within the MDX Query.", environment.getTrace());
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery != null && mdxQuery.isDMR()) {
            this.traceQueryCondition(true, "Query is DMR.", environment.getTrace());
            return true;
        }
        this.traceQueryCondition(false, "Query is not DMR.", environment.getTrace());
        return false;
    }
}

