/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLCoalesce;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItemOfLevel;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.CastGroupedProperties;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqe.transformation.dmr.ReplaceDMRBoundIdentifierWithExpression;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5.tabstream.DetectBridgeInRelationalXtab;
import com.cognos.xqe.transformation.v5.tabstream.dmrtorel.DMRToRelUtil;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InitializeDMRQuery
extends Transformation {
    public static final int OLAP = 0;
    public static final int RELATIONAL = 1;

    public InitializeDMRQuery(int[] passNumbers) {
        this.mName = "Initialize DMR Query.";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{101006};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        block22: {
            V5Query query = (V5Query)node;
            try (MetadataConnectionContext metadataConnContext = null;){
                List<IMetadata> querySubjects;
                metadataConnContext = environment.pushMetadataConnectionContext(query);
                boolean isDMR = false;
                boolean isDMRtoRQP = false;
                LoopDetectionChain ldc = new LoopDetectionChain();
                if (environment.getMultiRequestContext().fetchBooleanConfiguration("dmr.d115[@enabled]", true)) {
                    Boolean inSubQuery;
                    isDMR = this.checkDMRMetaDataChildNodes(ldc, query);
                    if (isDMR && (inSubQuery = query.getBooleanPropertyValue("relationalSubquery")) != null && inSubQuery.booleanValue()) {
                        isDMR = false;
                        isDMRtoRQP = true;
                    }
                } else {
                    int[] countItems;
                    List<IModelDataSource> ds = environment.getMetadataConnection().getModelDataSources();
                    boolean foundNotRelational = false;
                    if (ds.size() > 1) {
                        for (IModelDataSource datasource : ds) {
                            if (datasource.isRelational()) continue;
                            foundNotRelational = true;
                        }
                    }
                    if (!(isDMR = this.checkDMRChildNodes(environment, ldc, query, countItems = new int[]{0, 0}, foundNotRelational))) {
                        isDMR = countItems[0] != 0;
                        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
                        if (querySet.getDescendantsOfType(101049, true).length == 1 && isDMR) {
                            boolean bl = isDMRtoRQP = countItems[1] != 0;
                            if (!foundNotRelational && !isDMRtoRQP) {
                                boolean bl2 = isDMRtoRQP = query.getV5Source().getPropertyValue("relational") != null;
                            }
                            if (isDMRtoRQP) {
                                isDMR = false;
                            }
                        }
                    }
                }
                if (isDMR && !query.getV5Selection().getAutoSummary()) {
                    ExecutionEnvironment ee = (ExecutionEnvironment)environment.getExecutionEnvironment();
                    String nagMsg = XQEMessages.getMessage(XQEMessageKeys.WRN_IgnoreAutoSummaryFalse, XQEMessages.getCurrProductLocale());
                    ee.addNag(nagMsg);
                }
                query.setPropertyValue("isDMR", isDMR);
                query.setPropertyValue("isDMRtoRQP", isDMRtoRQP);
                if (isDMR) {
                    if (DMRToRelUtil.forceDMRToRelational(query)) {
                        query.setPropertyValue("forceDMRtoRQP", Boolean.TRUE);
                    } else if (this.isLocalProcessing(query) || this.hasRelationalFunction(query, environment)) {
                        isDMR = false;
                        query.setPropertyValue("isDMR", Boolean.FALSE);
                        query.setPropertyValue("isDMRtoRQP", Boolean.FALSE);
                        query.setPropertyValue("REL_OVER_DMR", Boolean.FALSE);
                        if (query.getPropertyValue("allJoins") == null && !query.isSingleQueryMasterDetail()) {
                            query.setPropertyValue("REL_OVER_DMR", Boolean.TRUE);
                        }
                    }
                }
                if (!isDMR || this.useMetadataContext(query, environment) || MetadataContext.hasWrappers(querySubjects = this.getQuerySubjectsInvolved(query, environment))) break block22;
                try {
                    if (DetectBridgeInRelationalXtab.queryUsesBridge(querySubjects, query.getGovernors(), environment)) {
                        query.setPropertyValue("queryUsesBridge", true);
                    }
                }
                catch (XQERuntimeException xQERuntimeException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean isLocalProcessing(V5Query query) {
        V5Source src = query.getV5Source();
        return src.getNumberChildren() != 0 && (src.getChild(0).getType() == 101018 || src.getChild(0).getType() == 101019);
    }

    protected boolean hasRelationalFunction(V5Query query, PlanningEnvironment environment) {
        boolean decomposed = DecomposeScalarFunction.passesQueryAndSubqueryCondition(query);
        if (!decomposed) {
            V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
            List<V5QueryResultDefinition> qrds = querySet.getReferencedQRDs(query);
            for (V5QueryResultDefinition qrd : qrds) {
                if (CastGroupedProperties.getGroupedDataItems(qrd).size() <= 0) continue;
                decomposed = true;
                break;
            }
        }
        return decomposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        if (query.getPropertyValue("isDMR") != null) {
            this.traceNodeCondition(false, "InitializeDMRQuery transformation has already been applied", trace);
            return false;
        }
        boolean foundRelational = false;
        try (MetadataConnectionContext mc = null;){
            mc = environment.pushMetadataConnectionContext(query);
            for (IModelDataSource ds : environment.getMetadataConnection().getModelDataSources()) {
                if (!ds.isRelational()) continue;
                foundRelational = true;
                break;
            }
        }
        if (!foundRelational) {
            this.traceNodeCondition(false, "No relational datasource found", trace);
            return false;
        }
        this.traceNodeCondition(true, "PROP_BOOLEAN_IS_DMR has not been set", trace);
        return true;
    }

    private boolean checkDMRChildNodes(PlanningEnvironment environment, LoopDetectionChain ldc, IXQEQueryNode node, int[] countItems, boolean foundNotRelational) {
        V5DataItem v5DataItem;
        IXQEQueryNode[] identifiers = null;
        LDCWrapper ldcWrapper = new LDCWrapper(ldc);
        if (node instanceof V5BoundMultiPartIdentifier) {
            V5BoundMultiPartIdentifier v5bmpi = (V5BoundMultiPartIdentifier)node;
            ldcWrapper.push(v5bmpi.getIdentifier());
        }
        if (node.getType() == 201097) {
            v5DataItem = ((V5BoundQueryItemReference)node).getRefDataItem();
            identifiers = v5DataItem.getChildrenOfCategory(101064);
        } else if (node.getType() == 201060) {
            v5DataItem = ((V5BoundDataItemReference)node).getRefDataItem();
            identifiers = v5DataItem.getChildrenOfCategory(101064);
        } else {
            identifiers = node.getChildrenOfCategory(101064);
        }
        if (identifiers.length == 0) {
            IMetadata metadata;
            if (node instanceof V5SimpleNode && (metadata = ((V5SimpleNode)node).getMetadata()) != null) {
                if (metadata.isDMR() && ((V5SimpleNode)node).isDMRInQueryContext(metadata)) {
                    countItems[0] = countItems[0] + 1;
                    if (!ReplaceDMRBoundIdentifierWithExpression.isConvertibleToRelational(environment, metadata, RoleTypeEnum.MEMBER_CAPTION.toV5Keyword()) || node.getType() == 201024) {
                        ldcWrapper.pop();
                        return true;
                    }
                } else {
                    countItems[1] = countItems[1] + 1;
                }
            }
        } else {
            for (IXQEQueryNode anIdentifier : identifiers) {
                if (((V5QueryNode)anIdentifier).isOLAPFunctionNotRelational() && anIdentifier.getNumberChildren() > 0) {
                    int[] countItemsThisNode = new int[]{countItems[0], countItems[1]};
                    if (this.checkDMRChildNodes(environment, ldc, anIdentifier, countItems, true) || countItems[0] > countItemsThisNode[0]) {
                        ldcWrapper.pop();
                        return true;
                    }
                    if (foundNotRelational || countItems[1] != countItemsThisNode[1]) continue;
                    ldcWrapper.pop();
                    return true;
                }
                if (this.checkDMRChildNodes(environment, ldc, anIdentifier, countItems, foundNotRelational)) {
                    ldcWrapper.pop();
                    return true;
                }
                if (!((V5QueryNode)anIdentifier).isOLAPFunctionNotRelational() || countItems[1] <= 0 || countItems[0] <= 0) continue;
                ldcWrapper.pop();
                return true;
            }
        }
        ldcWrapper.pop();
        return false;
    }

    protected boolean checkDMRMetaDataChildNodes(LoopDetectionChain ldc, IXQEQueryNode node) {
        IXQEQueryNode[] identifiers;
        LDCWrapper ldcWrapper = new LDCWrapper(ldc);
        boolean bPushed = false;
        if (node instanceof V5BoundMultiPartIdentifier) {
            V5BoundMultiPartIdentifier v5bmpi = (V5BoundMultiPartIdentifier)node;
            ldcWrapper.push(v5bmpi.getIdentifier());
            bPushed = true;
        }
        if ((identifiers = node.getChildrenOfCategory(101064)).length == 0) {
            V5SimpleNode v5SimpleNodeChild;
            IMetadata metadata;
            if (node instanceof V5SimpleNode && (metadata = (v5SimpleNodeChild = (V5SimpleNode)node).getMetadata()) != null && metadata.isDMR()) {
                if (bPushed) {
                    ldcWrapper.pop();
                }
                return true;
            }
        } else {
            for (IXQEQueryNode anIdentifier : identifiers) {
                if (!this.checkDMRMetaDataChildNodes(ldc, anIdentifier)) continue;
                if (bPushed) {
                    ldcWrapper.pop();
                }
                return true;
            }
        }
        if (bPushed) {
            ldcWrapper.pop();
        }
        return false;
    }

    private Set<IMetadata> getLevelsAndMeasuresInvolved(IXQEQueryNode v5Query) {
        HashSet<IMetadata> set = new HashSet<IMetadata>();
        List<IXQEQueryNode> boundNodes = v5Query.getDescendantsOfTypesOrdered(new int[]{201116, 201117}, false);
        for (IXQEQueryNode n : boundNodes) {
            V5BoundToMetadata boundToMetadata = (V5BoundToMetadata)n;
            IMetadata metadata = boundToMetadata.getMetadata();
            set.add(metadata);
        }
        return set;
    }

    private Set<IXQEQueryNode> getQuerySubjectsInvolved(Set<IMetadata> levelsAndMeasures, PlanningEnvironment environment) {
        HashSet<IXQEQueryNode> set = new HashSet<IXQEQueryNode>();
        for (IMetadata metadata : levelsAndMeasures) {
            V5BoundModelIdentifier boundNode;
            IXQEQueryNode[] identifiers;
            String expression1 = null;
            String expression2 = null;
            if (metadata instanceof ILevel) {
                expression1 = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpressionFromMetadata(environment, metadata, RoleTypeEnum.BUSINESS_KEY.toV5Keyword());
                expression2 = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpressionFromMetadata(environment, metadata, RoleTypeEnum.MEMBER_CAPTION.toV5Keyword());
            } else {
                if (metadata != null && metadata.getObjectType() == MetadataType.QUERY_ITEM && !(metadata instanceof IQueryItemOfLevel)) {
                    XQENodeFactory nodeFactory = environment.getNodeFactory();
                    V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
                    newNode.setIdentifier(metadata.getV5UniqueName());
                    newNode.setMetadata(metadata);
                    set.add(newNode);
                    continue;
                }
                expression1 = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpressionFromMetadata(environment, metadata, null);
            }
            IXQEQueryNode expressionTree1 = RQPUtilities.createV5ValueExpressionMetadata(expression1, environment, null, metadata);
            IXQEQueryNode expressionTree2 = RQPUtilities.createV5ValueExpressionMetadata(expression2, environment, null, metadata);
            if (expressionTree1 != null) {
                if (metadata instanceof ILevel) {
                    MetadataContext.flagMetadataObjectIfRequired(metadata, expressionTree1);
                }
                for (IXQEQueryNode identifier : identifiers = expressionTree1.getDescendantsOfType(201030, true)) {
                    boundNode = BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)identifier);
                    if (!boundNode.isQueryItem()) continue;
                    set.add(boundNode);
                }
            }
            if (expressionTree2 == null) continue;
            if (metadata instanceof ILevel) {
                MetadataContext.flagMetadataObjectIfRequired(metadata, expressionTree2);
            }
            for (IXQEQueryNode identifier : identifiers = expressionTree2.getDescendantsOfType(201030, true)) {
                boundNode = BindV5MultiPartIdentifierToModel.bindV5MultiPartIdentifierToModel(environment, (V5MultiPartIdentifier)identifier);
                if (!boundNode.isQueryItem()) continue;
                set.add(boundNode);
            }
        }
        return set;
    }

    private List<IMetadata> getQuerySubjectsInvolved(IXQEQueryNode v5Query, PlanningEnvironment environment) {
        Set<IMetadata> listOfLevelsAndMeasures = this.getLevelsAndMeasuresInvolved(v5Query);
        Set<IXQEQueryNode> listOfQuerySubjects = this.getQuerySubjectsInvolved(listOfLevelsAndMeasures, environment);
        SQLCoalesce coalesce = (SQLCoalesce)environment.getNodeFactory().createNode(301072);
        for (IXQEQueryNode boundNode : listOfQuerySubjects) {
            coalesce.addChild(boundNode);
        }
        List<IMetadata> querySubjects = DetectBridgeInRelationalXtab.getQuerySubjectsInvolved(coalesce, environment);
        return querySubjects;
    }

    private boolean useMetadataContext(V5Query v5Query, PlanningEnvironment environment) {
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        boolean disableBridge = providerCapabilities.getBooleanValue("disableBridge", false);
        if (disableBridge) {
            return true;
        }
        MetadataConnection conn = environment.getMetadataConnection();
        if (conn == null || conn.getMetadataContextManager() == null) {
            return false;
        }
        Set<IMetadata> listOfLevelsAndMeasures = this.getLevelsAndMeasuresInvolved(v5Query);
        for (IMetadata meta : listOfLevelsAndMeasures) {
            String desc;
            IDimension dim;
            IHierarchy hier = V5BoundModelIdentifier.getHierarchyFromIMetadata(meta);
            if (hier == null || (dim = hier.getDimension()) == null || dim.isMeasuresDimension() || (desc = dim.getDescription()) == null || desc.isEmpty() || !conn.getMetadataContextManager().requireMetadataContext(desc)) continue;
            return true;
        }
        return false;
    }

    class LDCWrapper {
        private boolean pushedInLDC = false;
        LoopDetectionChain wrappedLDC;

        LDCWrapper(LoopDetectionChain ldc) {
            this.wrappedLDC = ldc;
        }

        private void push(String identifier) {
            if (!this.wrappedLDC.push(identifier)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInQuery, this.wrappedLDC.serialize());
            }
            this.pushedInLDC = true;
        }

        private void pop() {
            if (this.pushedInLDC) {
                this.wrappedLDC.pop();
            }
        }
    }
}

