/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class RemoveRedundantSubquery
extends Transformation {
    public RemoveRedundantSubquery() {
        this.mName = "Remove redundant subquery.";
        this.mPassNumbers = new int[]{6};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        V5Source src = query.getV5Source();
        IXQEQueryNode qs = src.getFirstChildByType(101002);
        if (qs != null) {
            if (src.getFirstChildByType(1007) == null) {
                IXQEQueryNode cube = qs.getFirstDescendantOfTypeOrdered(1007, false);
                src.addChild(cube.detach());
            }
            src.detachChild(qs);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        if (query.isTabular()) {
            this.traceNodeCondition(false, "Tabular query is not processed.", trace);
            return false;
        }
        this.traceQueryCondition(true, "OLAP query node meet condition.", trace);
        return true;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        for (IXQEQueryNode current : query.getChildren()) {
            if (current.getType() == 101007) {
                IXQEQueryNode qs = current.getFirstChildByType(101002);
                if (qs == null) {
                    this.traceNodeCondition(false, "There is no sub query.", trace);
                    return false;
                }
                if (qs.getFirstDescendantOfTypeOrdered(1007, false) != null) continue;
                this.traceNodeCondition(false, "There is no cube as source.", trace);
                return false;
            }
            if (current.getFirstDescendantOfTypeOrdered(201060, false) == null) continue;
            this.traceQueryCondition(false, "Data item reference exists.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Sub query should be removed.", trace);
        return true;
    }
}

