/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.util.UniqueNameGenerator;

public class ReplaceDMRMemberInDetailFilterExpression
extends Transformation {
    public ReplaceDMRMemberInDetailFilterExpression() {
        this.mName = "Update DMR member filter expression.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{201117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ReplaceDMRMemberInDetailFilterExpression.replaceDMRMember(node, environment);
    }

    public static void replaceDMRMember(IXQEQueryNode node, PlanningEnvironment environment) {
        V5ComparisonExpression eqExpr;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundMemberUniqueName currentMUN = (V5BoundMemberUniqueName)node;
        ILevel level = currentMUN.getLevel();
        IXQEQueryNode parentNode = node.getParent();
        if (parentNode.getType() == 101003) {
            parentNode.extract();
        }
        int[] types = new int[]{201011, 201013};
        IXQEQueryNode compOp = node.getAncestorOfTypes(types);
        boolean singleMemberFilter = false;
        if (compOp.getType() == 201011) {
            eqExpr = (V5ComparisonExpression)nodeFactory.createNode(201013);
            eqExpr.setSubType(2);
            if (compOp.getDescendantsOfType(201117, false).length == 1) {
                singleMemberFilter = true;
                if (node.getParent().getType() == 201101) {
                    node.getParent().extract();
                }
                compOp.exchange(eqExpr, true);
            } else {
                eqExpr.addChild(nodeFactory.deepCopyNode(compOp.getChild(0)));
                eqExpr.addChild(node.extract());
            }
        } else {
            singleMemberFilter = true;
            eqExpr = (V5ComparisonExpression)compOp;
        }
        if (eqExpr.getChild(0).getType() == 201116) {
            V5BoundModelIdentifier modelId = (V5BoundModelIdentifier)eqExpr.getChild(0);
            modelId.setMetadata(level);
            modelId.setIdentifier(level.getV5UniqueName());
        }
        AbstractV5BooleanExpression nextExpr = eqExpr;
        if (!level.isUnique() && level.getPreviousLevel() != null && !level.getPreviousLevel().isRootLevel()) {
            V5ComparisonExpression parentLevelMemberFilter = ReplaceDMRMemberInDetailFilterExpression.createParentLevelMemberFilter(currentMUN, nodeFactory);
            V5LogicalExpression andExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
            andExpr.setSubType(0);
            if (singleMemberFilter) {
                eqExpr.insertParent(andExpr);
                andExpr.addChild(parentLevelMemberFilter);
                if (eqExpr.getSubType() == 3) {
                    eqExpr.setSubType(2);
                    V5LogicalExpression notExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
                    notExpr.setSubType(2);
                    andExpr.insertParent(notExpr);
                    andExpr = notExpr;
                }
            } else {
                andExpr.addChild(eqExpr);
                andExpr.addChild(parentLevelMemberFilter);
            }
            nextExpr = andExpr;
        }
        if (!singleMemberFilter) {
            V5LogicalExpression orExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
            orExpr.setSubType(1);
            compOp.insertParent(orExpr);
            orExpr.addChild(nextExpr);
        }
        node.setPropertyValue("updatedInDMRMemberFilter", Boolean.TRUE);
    }

    private static V5ComparisonExpression createParentLevelMemberFilter(V5BoundMemberUniqueName v5MUN, IXQENodeFactory nodeFactory) {
        String parentUniqueName;
        ILevel level = v5MUN.getLevel();
        ILevel parentLevel = level.getPreviousLevel();
        UniqueNameParser p = new UniqueNameParser();
        try {
            String[] currentNameParts = p.parse(v5MUN.getExternalMemberUniqueName());
            String[] parentNameParts = new String[currentNameParts.length - 1];
            System.arraycopy(currentNameParts, 0, parentNameParts, 0, currentNameParts.length - 1);
            parentUniqueName = UniqueNameGenerator.createEscapedUniqueName(parentNameParts);
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        V5BoundMemberUniqueName parentMUN = (V5BoundMemberUniqueName)nodeFactory.createNode(201117);
        parentMUN.setMetadata(parentLevel);
        parentMUN.setExternalMemberUniqueName(parentUniqueName);
        V5BoundModelIdentifier parentMember = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        parentMember.setMetadata(parentLevel);
        V5ComparisonExpression eqExpr = (V5ComparisonExpression)nodeFactory.createNode(201013);
        eqExpr.setSubType(2);
        eqExpr.addChild(parentMember);
        eqExpr.addChild(parentMUN);
        return eqExpr;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getBooleanPropertyValue("updatedInDMRMemberFilter") != null) {
            this.traceNodeCondition(false, "The MUN has been updated.", trace);
            return false;
        }
        IXQEQueryNode detailFilter = node.getAncestorOfType(101008);
        if (detailFilter == null) {
            this.traceNodeCondition(false, "The MUN is not within a detail filter.", trace);
            return false;
        }
        V5Query query = DMRUtilities.findQuery(node);
        if (!query.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Query is not a DMR query amnageable by RQP.", environment.getTrace());
            return false;
        }
        int[] types = new int[]{201011, 201013};
        IXQEQueryNode compOp = node.getAncestorOfTypes(types);
        if (compOp == null) {
            this.traceNodeCondition(false, "The MUN is not in a member comparison expression.", trace);
            return false;
        }
        IXQEQueryNode filteredSet = compOp.getChild(0);
        if (filteredSet.isOfCategory(201122) && ((AbstractV5Set)filteredSet).getMetadata().getObjectType() != MetadataType.LEVEL) {
            this.traceNodeCondition(false, "The set to be filtered has to be a level.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MUN in a detail filter needs to be updated.", trace);
        return true;
    }
}

