/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5IsNullExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralNull;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.Iterator;

public final class ReplaceDMRMemberWithRelationalLiteral
extends Transformation {
    public ReplaceDMRMemberWithRelationalLiteral() {
        this.mName = "Update bound member unique name with literal value.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{201117};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        ReplaceDMRMemberWithRelationalLiteral.replaceMemberWithItsBusinessKeyValue((V5BoundMemberUniqueName)node, environment);
    }

    public static void replaceMemberWithItsBusinessKeyValue(V5BoundMemberUniqueName v5BoundId, PlanningEnvironment environment) {
        MDXQuery mdxQuery;
        ReplaceDMRMemberWithRelationalLiteral.validateMUN(v5BoundId);
        Governors gv = null;
        V5Query v5Query = (V5Query)v5BoundId.getAncestorOfType(101006);
        if (v5Query == null && (mdxQuery = (MDXQuery)v5BoundId.getAncestorOfType(1002)) != null) {
            v5Query = mdxQuery.getRefV5Query();
        }
        if (v5Query != null) {
            gv = v5Query.getGovernors();
        }
        V5LiteralValue v5LiteralValue = ReplaceDMRMemberWithRelationalLiteral.getBusinessKeyValueOfMember(v5BoundId, environment);
        v5BoundId.exchange(v5LiteralValue);
        if (v5LiteralValue.getParent().getType() == 101003) {
            v5LiteralValue.getParent().extract();
        }
        if (v5LiteralValue.getParent().getType() == 201050) {
            v5LiteralValue.getParent().extract();
        }
        if (v5LiteralValue.getParent().getType() == 201098) {
            v5LiteralValue.getParent().getChild(0).extract();
            v5LiteralValue.getParent().extract();
        }
        if (v5LiteralValue.getParent().getType() == 201101) {
            v5LiteralValue.getParent().extract();
        }
        if (Boolean.TRUE != v5LiteralValue.getPropertyValue("null")) {
            return;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        Governors.DMREmptyMUNTreatment emptyTreatment = ReplaceDMRMemberWithRelationalLiteral.getDMREmptyMUNTreatment(v5BoundId, gv);
        if (emptyTreatment == Governors.DMREmptyMUNTreatment.ASNULL) {
            ReplaceDMRMemberWithRelationalLiteral.treatEmptyAsNull(nodeFactory, v5LiteralValue);
        } else if (emptyTreatment == Governors.DMREmptyMUNTreatment.EMPTY_OR_NULL) {
            ReplaceDMRMemberWithRelationalLiteral.treatEmptyAsEmptyOrNull(nodeFactory, v5LiteralValue);
        }
    }

    private static Governors.DMREmptyMUNTreatment getDMREmptyMUNTreatment(V5BoundMemberUniqueName v5BoundId, Governors gv) {
        Governors.DMREmptyMUNTreatment rt = v5BoundId.getDMREmptyMUNTreatment();
        if (rt != null) {
            return rt;
        }
        rt = Governors.DMREmptyMUNTreatment.ASNULL;
        if (gv != null) {
            rt = gv.getTreatEmptyDMRMUN();
        }
        return rt;
    }

    private static AbstractV5BooleanExpression createComparisonForNull(XQENodeFactory nodeFactory, V5ComparisonExpression cmp, V5LiteralValue v5LiteralValue) {
        int subType = cmp.getSubType();
        if (subType != 2 && subType != 3) {
            return null;
        }
        IXQEQueryNode sibling = null;
        Iterator<IXQEQueryNode> itChildren = cmp.getChildrenIterator();
        while (itChildren.hasNext() && (sibling = itChildren.next()) == v5LiteralValue) {
        }
        if (sibling == null) {
            return null;
        }
        V5IsNullExpression isNull = (V5IsNullExpression)nodeFactory.createNode(201010);
        isNull.addChild(nodeFactory.deepCopyNode(sibling));
        if (subType == 2) {
            return isNull;
        }
        V5LogicalExpression notNode = (V5LogicalExpression)nodeFactory.createNode(201003);
        notNode.setSubType(2);
        notNode.addChild(isNull);
        return notNode;
    }

    public static void treatEmptyAsNull(XQENodeFactory nodeFactory, V5LiteralValue v5LiteralValue) {
        IXQEQueryNode parentNode = v5LiteralValue.getParent();
        int tp = parentNode.getType();
        if (tp == 201013) {
            V5ComparisonExpression cmp = (V5ComparisonExpression)parentNode;
            AbstractV5BooleanExpression cmpNull = ReplaceDMRMemberWithRelationalLiteral.createComparisonForNull(nodeFactory, cmp, v5LiteralValue);
            if (cmpNull != null) {
                cmp.exchange(cmpNull);
            }
        } else {
            V5LiteralNull v5LiteralNull = (V5LiteralNull)nodeFactory.createNode(201023);
            v5LiteralValue.exchange(v5LiteralNull);
        }
    }

    public static void treatEmptyAsEmptyOrNull(XQENodeFactory nodeFactory, V5LiteralValue v5LiteralValue) {
        if (!v5LiteralValue.getDataType().isTextType()) {
            ReplaceDMRMemberWithRelationalLiteral.treatEmptyAsNull(nodeFactory, v5LiteralValue);
            return;
        }
        IXQEQueryNode parentNode = v5LiteralValue.getParent();
        int tp = parentNode.getType();
        if (tp == 201011) {
            V5LiteralNull v5LiteralNull = (V5LiteralNull)nodeFactory.createNode(201023);
            parentNode.addChild(v5LiteralNull);
        } else if (tp == 201013) {
            V5ComparisonExpression cmp = (V5ComparisonExpression)parentNode;
            AbstractV5BooleanExpression cmpNull = ReplaceDMRMemberWithRelationalLiteral.createComparisonForNull(nodeFactory, cmp, v5LiteralValue);
            if (cmpNull != null) {
                int subType = cmp.getSubType();
                V5LogicalExpression orAnd = (V5LogicalExpression)nodeFactory.createNode(201003);
                if (subType == 2) {
                    orAnd.setSubType(1);
                } else {
                    orAnd.setSubType(0);
                }
                parentNode.insertParent(orAnd);
                orAnd.addChild(cmpNull);
            } else {
                V5LiteralNull v5LiteralNull = (V5LiteralNull)nodeFactory.createNode(201023);
                v5LiteralValue.exchange(v5LiteralNull);
            }
        } else {
            V5LiteralNull v5LiteralNull = (V5LiteralNull)nodeFactory.createNode(201023);
            v5LiteralValue.exchange(v5LiteralNull);
        }
    }

    public static V5LiteralValue getBusinessKeyValueOfMember(V5BoundMemberUniqueName v5BoundId, PlanningEnvironment environment) {
        String memberKey;
        try {
            memberKey = UniqueNameParser.parseLastIdentifier(v5BoundId.getExternalMemberUniqueName());
            memberKey = UniqueNameParser.undoEscapedSquareBracket(memberKey);
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        ILevel levelOfMember = v5BoundId.getLevel();
        IQueryItem key = DMRLevel.getQueryItemWithRole(levelOfMember, RoleTypeEnum.BUSINESS_KEY.toV5Keyword(), true);
        return ReplaceDMRMemberWithRelationalLiteral.createV5LiteralValue(environment.getNodeFactory(), key, memberKey, DMRUtilities.isAllLevel(v5BoundId.getMetadata()));
    }

    public static V5LiteralValue createV5LiteralValue(XQENodeFactory nodeFactory, IMetadata key, String memberKey, boolean allLevel) {
        V5LiteralValue v5LiteralValue = (V5LiteralValue)nodeFactory.createNode(201026);
        IDataType dType = null;
        if (key != null) {
            dType = key.getDataType().isTextType() || key.getDataType().getTypeName() == "variant" ? DataTypeFactory.getVarcharType(memberKey.length()) : DataTypeFactory.getType(key.getDataType().toString());
        } else if (allLevel) {
            dType = DataTypeFactory.getVarcharType(memberKey.length());
        }
        v5LiteralValue.setDataType(dType);
        if (memberKey.length() == 0) {
            if (key.getDataType().isTextType()) {
                v5LiteralValue.setValue(memberKey);
            } else {
                v5LiteralValue.setValue((Value)dType.createValue());
            }
            v5LiteralValue.setPropertyValue("null", Boolean.TRUE);
        } else {
            v5LiteralValue.setValue(memberKey);
        }
        return v5LiteralValue;
    }

    public static void validateMUN(V5BoundMemberUniqueName v5BoundMUN) {
        ILevel level = v5BoundMUN.getLevel();
        if (level != null) {
            int indexLevel = level.getIndex();
            String logical = v5BoundMUN.getLogical();
            if (logical != null) {
                String[] parts;
                try {
                    parts = UniqueNameParser.parse(logical, -1);
                }
                catch (UniqueNameParserException e) {
                    throw new XQERuntimeException(e);
                }
                if (parts.length != indexLevel + 1) {
                    throw new XQERuntimeException(XQEMessageKeys.PLN_IncompatibleMembers, v5BoundMUN.getNativeName(), level.getV5UniqueName());
                }
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode filterNode = node.getAncestorOfType(101008);
        if (filterNode == null) {
            this.traceNodeCondition(false, "The bound identifier is not within a detail filter.", trace);
            return false;
        }
        if (node.getBooleanPropertyValue("updatedInDMRMemberFilter") == null) {
            this.traceNodeCondition(false, "This MUN is not part of a detail filter.", trace);
            return false;
        }
        IMetadata metadata = ((V5BoundToMetadata)node).getMetadata();
        if (metadata == null || !metadata.isDMR()) {
            this.traceNodeCondition(false, "Identifier is not a DMR expression.", trace);
            return false;
        }
        IXQEQueryNode parentNode = node.getParent();
        if (parentNode.getType() == 101003) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201101) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201050) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201098) {
            parentNode = parentNode.getParent();
        }
        if (parentNode.getType() == 201011 || parentNode.getType() == 201013) {
            this.traceNodeCondition(true, "The bound identifier is for a member to be converted simply to literal value.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The bound identifier is not a member to be converted simply to literal value", trace);
        return false;
    }
}

