/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class WrapIfThenElseV5DataItem
extends Transformation {
    public WrapIfThenElseV5DataItem() {
        this.mName = "Wrap ifThenElse V5DataItem.";
        this.mPassNumbers = new int[]{4};
        this.mTypes = new int[]{201017};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5DataItem v5dataItem = (V5DataItem)node.getAncestorOfType(101003);
        IXQEQueryNode thenNode = node.getChild(1).getFirstDescendantOfTypeOrdered(201116, true);
        IXQEQueryNode elseNode = node.getChild(2).getFirstDescendantOfTypeOrdered(201116, true);
        IMetadata metadata = null;
        if (thenNode instanceof V5BoundModelIdentifier && elseNode == null) {
            metadata = ((V5BoundModelIdentifier)thenNode).getMetadata();
        }
        if (thenNode == null && elseNode instanceof V5BoundModelIdentifier) {
            metadata = ((V5BoundModelIdentifier)elseNode).getMetadata();
        }
        MeasureWrapper wrapper = (MeasureWrapper)metadata;
        String aggregate = wrapper.getRegularAggregateV5Type();
        CubeWrapper cube = DMRUtilities.findCubeWrapper(node, environment, false);
        wrapper = cube.createMeasureWrapper(wrapper);
        wrapper.setV5AggregateAttribute(aggregate);
        wrapper.setReUseable(false);
        IXQEQueryNode expression = v5dataItem.getDetailExpression();
        IXQEQueryNode[] v5Parameters = expression.getDescendantsOfType(201024, true);
        if (v5Parameters.length > 0) {
            for (int i = 0; i < v5Parameters.length; ++i) {
                V5Parameter v5Parameter = (V5Parameter)v5Parameters[i];
                v5Parameter.setMetadata(null);
            }
        }
        IXQEQueryNode copy = environment.getNodeFactory().deepCopyNode(expression);
        wrapper.setBinaryExpression(copy);
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        newNode.setIdentifier(v5dataItem.getNameProperty());
        newNode.setMetadata(wrapper);
        v5dataItem.getChild(0).exchange(newNode);
        v5dataItem.setPropertyValue("label", v5dataItem.getNameProperty());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode v5DataItem = node.getParent().getParent();
        if (!(v5DataItem instanceof V5DataItem)) {
            return false;
        }
        V5Query query = (V5Query)v5DataItem.getAncestorOfType(101006);
        V5QuerySet querySet = (V5QuerySet)v5DataItem.getAncestorOfType(101002);
        List<V5QueryResultDefinition> qrds = querySet.getReferencedQRDs(query);
        if (qrds.size() != 1) {
            return false;
        }
        V5QueryResultDefinition qrd = qrds.get(0);
        if (!query.isDMR()) {
            return false;
        }
        if (node.getAncestorsOfType(201031).length != 0 || node.getDescendantsOfType(201031, true).length != 0) {
            return false;
        }
        IXQEQueryNode thenNode = node.getChild(1).getFirstDescendantOfTypeOrdered(201116, true);
        IXQEQueryNode elseNode = node.getChild(2).getFirstDescendantOfTypeOrdered(201116, true);
        IMetadata metadata = null;
        if (thenNode instanceof V5BoundModelIdentifier && elseNode == null) {
            metadata = ((V5BoundModelIdentifier)thenNode).getMetadata();
        }
        if (thenNode == null && elseNode instanceof V5BoundModelIdentifier) {
            metadata = ((V5BoundModelIdentifier)elseNode).getMetadata();
        }
        if (metadata == null || !(metadata instanceof MeasureWrapper)) {
            this.traceNodeCondition(false, "Not a measure wrapper.", trace);
            return false;
        }
        IXQEQueryNode ifClause = node.getChild(0).getChild(0);
        if (!(ifClause instanceof V5BoundModelIdentifier)) {
            return false;
        }
        if (!V5ExpressionCheck.isExplicitProperty(ifClause)) {
            this.traceNodeCondition(false, "If clause condition does not reference a property.", trace);
            return false;
        }
        String ifClauseIdentifier = ((V5BoundModelIdentifier)ifClause).getIdentifier();
        List<IXQEQueryNode> refDataItems = qrd.getDescendantsOfTypeOrdered(101015, true);
        for (IXQEQueryNode refDataItem : refDataItems) {
            String projectedItem;
            String dataItemName = ((V5DataItemRef)refDataItem).getDataItemRefProperty();
            String refQuery = qrd.getRefQueryProperty();
            V5Query v5Query = querySet.getV5Query(refQuery);
            V5Selection v5Selection = v5Query.getV5Selection();
            V5DataItem di = v5Selection.getDataItemByRefName(dataItemName);
            if (di.getDescendantsOfType(201116, true).length != 1 || !ifClauseIdentifier.equals(projectedItem = ((V5BoundModelIdentifier)di.getFirstDescendantOfTypeOrdered(201116, true)).getIdentifier())) continue;
            return false;
        }
        return true;
    }
}

