/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class BuildMACollectionTree
extends Transformation {
    public BuildMACollectionTree() {
        this.mName = "Build collection tree.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MetadataConnection connection = environment.getMetadataConnection();
        if (null == connection) {
            this.traceNodeCondition(false, "The MA datasource has not been bound.", trace);
            return false;
        }
        int parentNodeType = node.getParent().getType();
        if (parentNodeType == 1101019) {
            this.traceNodeCondition(false, "The MA collection is already in the collection tree.", trace);
            return false;
        }
        MACollection collection = (MACollection)node;
        String parentName = collection.getParentName();
        if (parentName != null && parentName.equals("")) {
            this.traceNodeCondition(false, "The MA collection is a root collection node.", trace);
            return false;
        }
        if (collection.getName().equals("namespace")) {
            this.traceNodeCondition(false, "The MA collection is a namespace node.", trace);
            return false;
        }
        short resourceId = MFWModelRes.getInstance().getResourceID(collection.getName());
        if (-1 == resourceId) {
            this.traceNodeCondition(false, "The MA collection does not have a resource ID.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MA collection is set to the collection tree.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MACollection self = (MACollection)node;
        short resourceId = MFWModelRes.getInstance().getResourceID(self.getName());
        MFWModel mfwModel = MFWModel.getInstance();
        MFWInfo resourceInfo = mfwModel.findInfoByRID(resourceId);
        MFWInfoObject[] modelParents = resourceInfo.getParents();
        MAQuery maQuery = (MAQuery)node.getParent();
        List<MACollection> siblings = maQuery.getCollectionList();
        String parentName = "";
        boolean bCopyNode = false;
        for (MFWInfoObject modelParent : modelParents) {
            String modelParentName = modelParent.getName();
            for (MACollection sibling : siblings) {
                if (bCopyNode || !sibling.getName().equals(modelParentName) || self == sibling) continue;
                boolean skipMove = false;
                for (MACollection ancestor = sibling.getParentCollection(); ancestor != null; ancestor = ancestor.getParentCollection()) {
                    if (self != ancestor) continue;
                    skipMove = true;
                }
                if (skipMove) continue;
                self.move(sibling);
                parentName = modelParentName;
                bCopyNode = true;
            }
        }
        self.setParentName(parentName);
    }
}

