/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MAProperty;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class PropagateProperties
extends Transformation {
    public PropagateProperties() {
        this.mName = "Propagate collection properties.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101020};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        this.traceNodeCondition(true, "The collection property is propagated.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MAProperty property = (MAProperty)node;
        MAQuery maQuery = (MAQuery)node.getParent();
        List<MACollection> collections = maQuery.getCollectionList();
        String collectionName = property.getCollection();
        for (MACollection collection : collections) {
            if (!collection.getName().equals(collectionName)) continue;
            collection.addProperty(property.getName());
            break;
        }
        property.detach();
    }
}

