/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import java.util.ArrayList;

public class SetRestrictionsForGenerateV5EqualsFalse
extends Transformation {
    public static final String METADATQUERY_NULL = "Metadata query cannot be null";

    public SetRestrictionsForGenerateV5EqualsFalse() {
        this.mName = "Set the restrictions for member queries where GenerateV5 is false.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101015};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MAMetadataQuery maMetadataQuery = (MAMetadataQuery)node;
        if (maMetadataQuery.getGenerateV5()) {
            this.traceNodeCondition(false, "Metadata query should generate V5.", trace);
            return false;
        }
        if (maMetadataQuery.isSAPVariableMAQuery() || maMetadataQuery.isSAPVariableMemberOperator()) {
            this.traceNodeCondition(false, "The metadata query is an SAP variable query.", trace);
            return false;
        }
        MACollection memberCollection = maMetadataQuery.getMemberCollection();
        if (!memberCollection.getDescendantsOfCategory(501113, false).isEmpty()) {
            this.traceNodeCondition(false, "The run tree is already generated.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The member query should be sent to the provider as is.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MetadataRestriction maRestriction = new MetadataRestriction();
        this.buildRestriction(node, environment, maRestriction);
        MetadataHelper.addMemberResponse(node, environment, maRestriction);
    }

    public void buildRestriction(IXQEQueryNode node, PlanningEnvironment environment, MetadataRestriction restriction) {
        MAMetadataItem mdi;
        MAMetadataQuery maMetadataQuery = (MAMetadataQuery)node;
        IModelDataSource dataSource = environment.getMADataSource();
        if (dataSource.getCube() != null) {
            restriction.add(RestrictionType.CUBE, dataSource.getCube().getUniqueName());
        }
        if (dataSource.getCatalog() != null) {
            restriction.add(RestrictionType.CATALOG, dataSource.getCatalog().getUniqueName());
        }
        if ((mdi = maMetadataQuery.getReferencedMetaItem()) != null) {
            if (mdi.getMetadata() instanceof IHierarchy) {
                restriction.add(RestrictionType.HIERARCHY_UNIQUE_NAME, mdi.getHierarchy().getUniqueName());
            } else if (mdi.getMetadata() instanceof IDimension) {
                restriction.add(RestrictionType.DIMENSION_UNIQUE_NAME, mdi.getDimension().getUniqueName());
            } else if (mdi.getMetadata() instanceof ILevel) {
                restriction.add(RestrictionType.LEVEL_UNIQUE_NAME, mdi.getLevel().getUniqueName());
            } else if (mdi.getMetadata() instanceof IMember) {
                restriction.add(RestrictionType.MEMBER_UNIQUE_NAME, mdi.getMemberUniqueName());
            }
        }
        IXQEQueryNode[] constraints = maMetadataQuery.getDescendantsOfType(1101021, false);
        ArrayList<String> ppdsCodes = new ArrayList<String>();
        for (IXQEQueryNode constraintNode : constraints) {
            MAConstraint constraint = (MAConstraint)constraintNode;
            String constraintType = constraint.getConstraint().substring(1);
            if (constraintType.equals("PPDS_CODE")) {
                ppdsCodes.add(constraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
                continue;
            }
            if (constraintType.equals("memberUniqueName")) {
                restriction.add(RestrictionType.MEMBER_UNIQUE_NAME, constraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
                continue;
            }
            if (constraintType.equals("dimensionUniqueName")) {
                restriction.add(RestrictionType.DIMENSION_UNIQUE_NAME, constraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
                continue;
            }
            if (constraintType.equals("hierarchyUniqueName")) {
                restriction.add(RestrictionType.HIERARCHY_UNIQUE_NAME, constraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
                continue;
            }
            if (constraintType.equals("levelUniqueName")) {
                restriction.add(RestrictionType.LEVEL_UNIQUE_NAME, constraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
                continue;
            }
            if (!constraintType.equals("levelNumber")) continue;
            restriction.add(RestrictionType.LEVEL_NUMBER, constraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
        }
        if (ppdsCodes != null) {
            restriction.add(RestrictionType.PPDS_CODES, ppdsCodes);
        }
    }
}

