/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5ChildrenFunction;
import com.cognos.xqe.ast.v5Exp.V5DescendantsFunction;
import com.cognos.xqe.ast.v5Exp.V5FilterFunction;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MembersFunction;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.convertMAQuery.WithSingleStartAt;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MAQuerytoV5QueryforMemberSearch
extends WithSingleStartAt {
    public static final String MABLOCKCONSTRAINT_EMPTY = "The MANode is a block constraint and it empty.";

    public MAQuerytoV5QueryforMemberSearch() {
        this.mName = "Convert MAMetadataQuery to V5QuerySet for MA member search.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101017, 1101021};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (node.getParent().getType() == 1101017) {
            this.traceNodeCondition(false, "The MAConstraint is a child of a MABlockConstraint. In such case, this tranformation should apply to root MABlockConstraint.", trace);
            return false;
        }
        MAMetadataQuery maMetadataQuery = this.getMAMetadataQuery(node);
        if (maMetadataQuery.isMemberSearchMAQuery()) {
            this.traceNodeCondition(true, "The MAMetadataQuery is a member search query.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MAMetadataQuery is NOT a member search query. Other transformation will apply.", trace);
        return false;
    }

    @Override
    public AbstractV5Set buildFilterOrOtherSetExpr(IXQEQueryNode node, String startAtRef, IXQENodeFactory factory, MAMetadataQuery maMetadataQuery) {
        MAMetadataItem metaItem = maMetadataQuery.getReferencedMetaItem();
        IHierarchy hierarchy = metaItem.getHierarchy();
        boolean searchWithDescendants = metaItem.searchWithDescendants(maMetadataQuery);
        V5FilterFunction v5Filter = (V5FilterFunction)factory.createNode(201066);
        if (maMetadataQuery.isExplicitMemberQuery()) {
            this.buildExplicitMemberFilter(startAtRef, searchWithDescendants, v5Filter, factory);
        } else {
            V5MembersFunction v5Members = this.buildV5MemberFunction(startAtRef, !searchWithDescendants, factory);
            v5Filter.addChild(v5Members);
        }
        V5SimpleNode logicaExpr = this.buildLogicalExpr(node, startAtRef, hierarchy, factory);
        v5Filter.addChild(logicaExpr);
        return v5Filter;
    }

    private void buildExplicitMemberFilter(String startAtRef, boolean withDescendants, V5FilterFunction filter, IXQENodeFactory factory) {
        if (withDescendants) {
            V5DescendantsFunction v5Descendants = (V5DescendantsFunction)factory.createNode(201062);
            this.buildDescendantsFunction(v5Descendants, startAtRef, factory);
            filter.addChild(v5Descendants);
        } else {
            V5ChildrenFunction v5Children = (V5ChildrenFunction)factory.createNode(201053);
            this.buildChildrenFunction(v5Children, startAtRef, factory);
            filter.addChild(v5Children);
        }
    }

    private void buildDescendantsFunction(V5DescendantsFunction v5Descendants, String startAtRef, IXQENodeFactory factory) {
        V5Expression munExpr = (V5Expression)factory.createNode(101004);
        munExpr.setExpression(startAtRef);
        v5Descendants.addChild(munExpr);
        V5LiteralValue distance = (V5LiteralValue)factory.createNode(201026);
        IntegerValue intValue = DataValueFactory.createIntegerValue(1);
        distance.setDataType(intValue.getDataType());
        distance.setValue(intValue.toString());
        v5Descendants.addChild(distance);
        v5Descendants.setOption(9);
    }

    private void buildChildrenFunction(V5ChildrenFunction v5Children, String startAtRef, IXQENodeFactory factory) {
        V5Expression munExpr = (V5Expression)factory.createNode(101004);
        munExpr.setExpression(startAtRef);
        v5Children.addChild(munExpr);
    }

    private V5SimpleNode buildLogicalExpr(IXQEQueryNode node, String startAtRef, IMetadata metadataObject, IXQENodeFactory factory) {
        V5LogicalExpression v5LogicalExpr = (V5LogicalExpression)factory.createNode(201003);
        V5SimpleNode singleLogicalExpr = null;
        MASimpleNode constraint = (MASimpleNode)node;
        if (constraint.getType() == 1101017) {
            MABlockConstraint.Operation operation = ((MABlockConstraint)constraint).getOperation();
            v5LogicalExpr.setSubType(operation.ordinal());
            List<IXQEQueryNode> maConstraints = constraint.getDescendantsOfTypeOrdered(1101021, false);
            if (maConstraints.size() > 1) {
                v5LogicalExpr = this.buildV5LogicalExpr(maConstraints, operation, metadataObject, factory);
                return v5LogicalExpr;
            }
            if (maConstraints.size() == 1) {
                singleLogicalExpr = this.buildChildLogicalExpr((MAConstraint)maConstraints.get(0), metadataObject, factory);
            } else {
                constraint.throwInternalError(MABLOCKCONSTRAINT_EMPTY);
            }
        } else {
            singleLogicalExpr = this.buildChildLogicalExpr((MAConstraint)constraint, metadataObject, factory);
        }
        return singleLogicalExpr;
    }

    private V5SimpleNode buildChildLogicalExpr(MAConstraint childConstraint, IMetadata metadataObject, IXQENodeFactory factory) {
        MAConstraint.Function function = childConstraint.getFunction();
        V5SimpleNode conditionExpr = null;
        MASearchCriteria searchCriteria = new MASearchCriteria(function, null);
        MASearchCriteria.SearchCondition condition = searchCriteria.getSearchCondition();
        if (condition == MASearchCriteria.SearchCondition.STARTS_WITH) {
            conditionExpr = (V5SimpleNode)factory.createNode(201006);
        } else if (condition == MASearchCriteria.SearchCondition.CONTAINS) {
            conditionExpr = (V5SimpleNode)factory.createNode(201005);
        } else if (condition == MASearchCriteria.SearchCondition.ENDS_WITH) {
            conditionExpr = (V5SimpleNode)factory.createNode(201007);
        } else if (condition == MASearchCriteria.SearchCondition.EQUALS) {
            conditionExpr = (V5SimpleNode)factory.createNode(201013);
            conditionExpr.setSubType(2);
        }
        V5RoleValueFunction v5RoleValue = (V5RoleValueFunction)factory.createNode(201098);
        V5LiteralValue memberCaption = (V5LiteralValue)factory.createNode(201026);
        StringValue memberCaptionValue = DataValueFactory.createStringValue();
        memberCaption.setDataType(memberCaptionValue.getDataType());
        memberCaption.setValue(RoleTypeEnum.MEMBER_CAPTION.toV5Keyword());
        V5MultiPartIdentifier multiPartIdentifier = (V5MultiPartIdentifier)factory.createNode(201030);
        multiPartIdentifier.setIdentifier(metadataObject.getV5UniqueName());
        v5RoleValue.addChild(memberCaption);
        v5RoleValue.addChild(multiPartIdentifier);
        V5LiteralValue value = (V5LiteralValue)factory.createNode(201026);
        TextValue stringValue = null;
        stringValue = !metadataObject.isDMR() ? DataValueFactory.createStringValue() : DataValueFactory.createVarcharValue();
        value.setDataType(stringValue.getDataType());
        if (childConstraint.getCaseSensitive().booleanValue()) {
            value.setValue(childConstraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
            conditionExpr.addChild(v5RoleValue);
        } else {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            value.setValue(childConstraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND).toUpperCase(runLocale));
            V5StringFunction v5StringFunc = (V5StringFunction)factory.createNode(201041);
            v5StringFunc.setSubType(0);
            v5StringFunc.setNativeName("UPPER");
            v5StringFunc.addChild(v5RoleValue);
            conditionExpr.addChild(v5StringFunc);
        }
        conditionExpr.addChild(value);
        return conditionExpr;
    }

    private V5LogicalExpression buildV5LogicalExpr(List<IXQEQueryNode> maConstraints, MABlockConstraint.Operation operation, IMetadata metadataObject, IXQENodeFactory factory) {
        V5LogicalExpression v5LogicalExpression = (V5LogicalExpression)factory.createNode(201003);
        v5LogicalExpression.setSubType(operation.ordinal());
        int size = maConstraints.size();
        V5SimpleNode iLogicalExpr = null;
        if (size == 2) {
            for (IXQEQueryNode child : maConstraints) {
                MAConstraint childConstraint = (MAConstraint)child;
                iLogicalExpr = this.buildChildLogicalExpr(childConstraint, metadataObject, factory);
                v5LogicalExpression.addChild(iLogicalExpr);
            }
        } else {
            iLogicalExpr = this.buildChildLogicalExpr((MAConstraint)maConstraints.get(size - 1), metadataObject, factory);
            maConstraints.remove(size - 1);
            V5LogicalExpression subLogicalExpression = this.buildV5LogicalExpr(maConstraints, operation, metadataObject, factory);
            v5LogicalExpression.addChild(subLogicalExpression);
            v5LogicalExpression.addChild(iLogicalExpr);
        }
        return v5LogicalExpression;
    }

    @Override
    protected void buildV5Query(IXQEQueryNode node, V5Query v5Query, PlanningEnvironment environment, MAMetadataQuery maMetadataQuery, MACollection memberCollection) {
        super.buildV5Query(node, v5Query, environment, maMetadataQuery, memberCollection);
        if (maMetadataQuery.isExplicitMemberQuery()) {
            this.addRootMemberToV5Query(v5Query, environment.getNodeFactory(), maMetadataQuery);
        }
    }

    @Override
    protected boolean applyDMR(IXQEQueryNode node, PlanningEnvironment environment) {
        IDataSourceCapabilities providerCapabilities;
        String sizeValue;
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MAMetadataItem metaItem = maMetadataQuery.getReferencedMetaItem();
        IMetadata meta = metaItem.getMetadata();
        if (!meta.isDMR()) {
            return false;
        }
        if (maMetadataQuery.isDMRMultipleExplicitMembersMAQuery()) {
            return false;
        }
        if (meta.getObjectType() != MetadataType.HIERARCHY && meta.getObjectType() != MetadataType.LEVEL) {
            return false;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        List<ILevel> levels = null;
        V5DetailFilter explicitMundetailFilter = null;
        if (!maMetadataQuery.isExplicitMemberQuery()) {
            levels = this.getLevels(meta);
        } else {
            levels = this.getDescendantLevelsForExplicitMun(meta, metaItem.searchWithDescendants(maMetadataQuery));
            if (!levels.isEmpty() && meta.getObjectType() == MetadataType.LEVEL && !((ILevel)meta).isRootLevel()) {
                explicitMundetailFilter = this.createMunRestriction(factory, meta, maMetadataQuery.getStartAtRefValue());
            }
        }
        if (levels.isEmpty()) {
            return false;
        }
        XMAGenerateMemberResponse xMemberResponse = MetadataHelper.generateMemberResponse(factory, maMetadataQuery);
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        xMemberResponse.addChild(querySet);
        int queryOffSet = 0;
        if (maMetadataQuery.isExplicitMemberQuery()) {
            this.buildV5QueryExplicitMun(node, environment, querySet, maMetadataQuery.getStartAtRefValue());
            queryOffSet = 1;
        }
        int i = 0;
        for (ILevel level : levels) {
            this.buildV5QueryPerLevel(node, environment, querySet, level, i, explicitMundetailFilter);
            ++i;
        }
        int[] startAndCount = new int[]{0, Integer.MAX_VALUE};
        String fromValue = (String)maMetadataQuery.getPropertyValue("ResultStart");
        if (fromValue != null) {
            startAndCount[0] = Integer.valueOf(fromValue);
            if (startAndCount[0] < 0) {
                startAndCount[0] = 0;
            }
        }
        if ((sizeValue = (String)maMetadataQuery.getPropertyValue("ResultCount")) != null) {
            startAndCount[1] = Integer.valueOf(sizeValue);
            if (startAndCount[1] < 0) {
                startAndCount[1] = Integer.MAX_VALUE;
            }
        }
        if (startAndCount[1] > 0 && startAndCount[1] < Integer.MAX_VALUE && (providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR")).isSupported("CustomSetUseTopN")) {
            IXQEQueryNode[] queries = querySet.getChildrenOfType(101006);
            for (int nQ = queryOffSet; nQ < queries.length; ++nQ) {
                queries[nQ].setPropertyValue("topNRows", Integer.toString(startAndCount[1]));
            }
        }
        xMemberResponse.setPropertyValue("multiQuery", startAndCount);
        return true;
    }

    private List<ILevel> getLevels(IMetadata metadata) {
        IHierarchy hier;
        ArrayList<ILevel> levels = new ArrayList<ILevel>();
        if (metadata.getObjectType() == MetadataType.LEVEL) {
            ILevel aLevel = (ILevel)metadata;
            IHierarchy hier2 = aLevel.getHierarchy();
            if (!hier2.getDimension().isMeasuresDimension() && aLevel.getIndex() > 0) {
                levels.add(aLevel);
            }
        } else if (metadata.getObjectType() == MetadataType.HIERARCHY && !(hier = (IHierarchy)metadata).getDimension().isMeasuresDimension()) {
            List<ILevel> lvls = hier.getLevels();
            levels.addAll(lvls.subList(1, lvls.size()));
        }
        return levels;
    }

    private List<ILevel> getDescendantLevelsForExplicitMun(IMetadata metadata, boolean searchInDescendant) {
        ILevel lvl;
        ILevel aLevel;
        IHierarchy hier;
        ArrayList<ILevel> levels = new ArrayList<ILevel>();
        if (metadata.getObjectType() == MetadataType.LEVEL && !(hier = (aLevel = (ILevel)metadata).getHierarchy()).getDimension().isMeasuresDimension() && !aLevel.isLeafLevel() && (lvl = aLevel.getNextLevel()) != null) {
            if (searchInDescendant) {
                while (lvl != null) {
                    levels.add(lvl);
                    lvl = lvl.getNextLevel();
                }
            } else {
                levels.add(lvl);
            }
        }
        return levels;
    }

    private V5DetailFilter createMunRestriction(XQENodeFactory factory, IMetadata meta, String mun) {
        V5DetailFilter explicitMundetailFilter = (V5DetailFilter)factory.createNode(101008);
        explicitMundetailFilter.setPostAutoAggregation(false);
        IXQEQueryNode inExpr = factory.createNode(201011);
        V5MultiPartIdentifier multiPartIdentifier = (V5MultiPartIdentifier)factory.createNode(201030);
        multiPartIdentifier.setIdentifier(meta.getV5UniqueName());
        inExpr.addChild(multiPartIdentifier);
        V5Expression munExpr = (V5Expression)factory.createNode(101004);
        munExpr.setExpression(mun);
        inExpr.addChild(munExpr);
        explicitMundetailFilter.addChild(inExpr);
        return explicitMundetailFilter;
    }

    protected void buildV5QueryExplicitMun(IXQEQueryNode node, PlanningEnvironment environment, V5QuerySet querySet, String mun) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        String queryName = "query1_explicitMun";
        v5Query.setPropertyValue("name", queryName);
        v5Query.setStringPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName(), "metadata");
        v5Query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
        V5Source source = (V5Source)factory.createNode(101007);
        String modelPath = environment.getMetadataConnection().getModelName();
        source.setModel(modelPath);
        V5Selection selection = (V5Selection)factory.createNode(101009);
        v5Query.addChild(source);
        v5Query.addChild(selection);
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        dataItem.setAggregateProperty("none");
        dataItem.setNameProperty("member");
        dataItem.setRollupAggregateProperty("none");
        V5Expression v5Expression = (V5Expression)factory.createNode(101004);
        v5Expression.setExpression(mun);
        dataItem.addChild(v5Expression);
        selection.addChild(dataItem);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(qrd);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        MACollection memberCollection = this.getMemberCollection(node);
        this.buildEdgeGroup(edgeGroup, factory, memberCollection);
        edge.addChild(edgeGroup);
        edge.setPropertyValue("name", "edge1");
        qrd.setPropertyValue("name", queryName);
        qrd.setRefQueryProperty(v5Query.getV5QueryName());
    }

    protected void buildV5QueryPerLevel(IXQEQueryNode node, PlanningEnvironment environment, V5QuerySet querySet, ILevel level, int pos, V5DetailFilter explicitMundetailFilter) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        v5Query.setPropertyValue("name", "query1" + pos);
        v5Query.setStringPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName(), "metadata");
        v5Query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
        V5Source source = (V5Source)factory.createNode(101007);
        String modelPath = environment.getMetadataConnection().getModelName();
        source.setModel(modelPath);
        V5Selection selection = (V5Selection)factory.createNode(101009);
        v5Query.addChild(source);
        v5Query.addChild(selection);
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        dataItem.setAggregateProperty("none");
        dataItem.setNameProperty("member");
        dataItem.setRollupAggregateProperty("none");
        V5Expression v5Expression = (V5Expression)factory.createNode(101004);
        dataItem.addChild(v5Expression);
        selection.addChild(dataItem);
        V5MultiPartIdentifier identifier = (V5MultiPartIdentifier)factory.createNode(201030);
        identifier.setIdentifier(level.getV5UniqueName());
        v5Expression.addChild(identifier);
        if (explicitMundetailFilter != null) {
            v5Query.addChild(factory.deepCopyNode(explicitMundetailFilter));
        }
        V5DetailFilter detailFilter = (V5DetailFilter)factory.createNode(101008);
        detailFilter.setPostAutoAggregation(false);
        v5Query.addChild(detailFilter);
        V5SimpleNode logicaExpr = this.buildLogicalExpr(node, "", level, factory);
        detailFilter.addChild(logicaExpr);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(qrd);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        MACollection memberCollection = this.getMemberCollection(node);
        this.buildEdgeGroup(edgeGroup, factory, memberCollection);
        edge.addChild(edgeGroup);
        edge.setPropertyValue("name", "edge1");
        qrd.setPropertyValue("name", "rs1" + pos);
        qrd.setRefQueryProperty(v5Query.getV5QueryName());
    }
}

