/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.provider.BindMAIdentifier;

public class BindMAMultiPartIdentifier
extends BindMAIdentifier {
    public BindMAMultiPartIdentifier() {
        this.mName = "Bind multi-part identifier to the model for MA member query.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101021, 1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        if (maMetadataQuery.isExplicitMemberQuery() || maMetadataQuery.isSAPVariableMemberOperator()) {
            this.traceNodeCondition(false, "The MAMetadataQuery is an explicit member query or an explicit member operation against an SAP variable.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to bind the meta data reference in the MAMetadataQuery.", trace);
        return true;
    }

    @Override
    void setLevelAndMember(MAMetadataQuery maQuery, PlanningEnvironment environment) {
        boolean searchWithDescendants;
        MAMetadataItem metaDataItem = maQuery.getReferencedMetaItem();
        MACollection memberCollection = maQuery.getMemberCollection();
        IHierarchy hierarchy = metaDataItem.getHierarchy();
        ILevel level = metaDataItem.getLevel();
        if (level != null) {
            String lun = level.getUniqueName();
            memberCollection.setPropertyValue("levelUniqueName", lun);
        }
        if (hierarchy != null && null == level && !(searchWithDescendants = metaDataItem.searchWithDescendants(maQuery))) {
            level = hierarchy.getLevel(0);
            memberCollection.setPropertyValue("levelNumber", Integer.toString(level.getIndex()));
        }
    }
}

