/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.ast.maExp.MAConstraint;
import java.util.List;

public class MASearchCriteria {
    protected MARequestedPropertiesEnum property;
    protected List<String> searchValues;
    protected MABlockConstraint.Operation operator;
    protected int depth;
    protected boolean caseInsensitive;
    protected SearchCondition searchCondition;
    public static final String DIMENSION_UNIQUE_NAME = "DIMENSION_UNIQUE_NAME";
    public static final String HIERARCHY_UNIQUE_NAME = "HIERARCHY_UNIQUE_NAME";
    public static final String PARENT_UNIQUE_NAME = "PARENT_UNIQUE_NAME";
    public static final String PARENT_LEVEL = "PARENT_LEVEL";
    public static final String PARENT_COUNT = "PARENT_COUNT";
    public static final String LEVEL_UNIQUE_NAME = "LEVEL_UNIQUE_NAME";
    public static final String LEVEL_NUMBER = "LEVEL_NUMBER";
    public static final String MEMBER_CAPTION = "MEMBER_CAPTION";
    public static final String MEMBER_UNIQUE_NAME = "MEMBER_UNIQUE_NAME";
    public static final String MEMBER_NAME = "MEMBER_NAME";

    public MASearchCriteria() {
    }

    public MASearchCriteria(MARequestedPropertiesEnum theProperty, MAConstraint.Function function, List<String> values, MABlockConstraint.Operation theOperator, boolean isCaseInsensitive) {
        this.property = theProperty;
        this.searchCondition = this.convertFunctionToCondition(function);
        this.searchValues = values;
        this.operator = theOperator;
        this.caseInsensitive = isCaseInsensitive;
    }

    public MASearchCriteria(MARequestedPropertiesEnum theProperty, MAConstraint.Function function, List<String> values, MABlockConstraint.Operation theOperator) {
        this(theProperty, function, values, theOperator, true);
    }

    public MASearchCriteria(MARequestedPropertiesEnum theProperty, MAConstraint.Function function, List<String> values) {
        this(theProperty, function, values, MABlockConstraint.Operation.NOT_DEFINED, true);
    }

    public MASearchCriteria(MAConstraint.Function function, List<String> values) {
        this(MARequestedPropertiesEnum.CAPTION, function, values);
    }

    private SearchCondition convertFunctionToCondition(MAConstraint.Function function) {
        SearchCondition toCondition = SearchCondition.NOT_DEFINED;
        if (null == function) {
            toCondition = SearchCondition.EQUALS;
        } else if (function == MAConstraint.Function.STARTS_WITH) {
            toCondition = SearchCondition.STARTS_WITH;
        } else if (function == MAConstraint.Function.ENDS_WITH) {
            toCondition = SearchCondition.ENDS_WITH;
        } else if (function == MAConstraint.Function.CONTAINS) {
            toCondition = SearchCondition.CONTAINS;
        }
        return toCondition;
    }

    public MARequestedPropertiesEnum getProperty() {
        return this.property;
    }

    public void setProperty(MARequestedPropertiesEnum theProperty) {
        this.property = theProperty;
    }

    public List<String> getSearchValues() {
        return this.searchValues;
    }

    public void setSearchValues(List<String> theValues) {
        this.searchValues = theValues;
    }

    public void setDepth(int dep) {
        this.depth = dep;
    }

    public int getDepth() {
        return this.depth;
    }

    public MABlockConstraint.Operation getOperator() {
        return this.operator;
    }

    public void setOperator(MABlockConstraint.Operation theOperator) {
        this.operator = theOperator;
    }

    public boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean theCaseInsensitive) {
        this.caseInsensitive = theCaseInsensitive;
    }

    public SearchCondition getSearchCondition() {
        return this.searchCondition;
    }

    public void setSearchCondition(SearchCondition theSearchCondition) {
        this.searchCondition = theSearchCondition;
    }

    public String getPropertyName() {
        return this.property.getPropertyName();
    }

    public String getPropertyUniqueName() {
        return this.property.getPropertyUniqueName();
    }

    public boolean isDynamicProperty() {
        return false;
    }

    public String toString() {
        String eqStr = " = ";
        String colon = ", ";
        String openBracket = "[";
        String closeBracket = "]";
        StringBuilder str = new StringBuilder("SearchCriteria").append(eqStr).append(openBracket);
        if (this.property != null) {
            str.append("propertyName").append(eqStr).append(this.property.getPropertyName()).append(colon);
            str.append("propertyUniqueName").append(eqStr).append(this.property.getPropertyUniqueName()).append(colon);
        }
        str.append("caseInsensitive").append(eqStr).append(this.caseInsensitive).append(colon);
        str.append("operator").append(eqStr).append(this.operator.name()).append(colon);
        if (this.searchValues != null) {
            str.append("searchValues").append(eqStr);
            for (String value : this.searchValues) {
                str.append(value).append(colon);
            }
            str.append(closeBracket).append(colon);
        }
        str.append("SearchCondition").append(eqStr);
        switch (this.searchCondition) {
            case STARTS_WITH: {
                str.append("STARTS_WITH");
                break;
            }
            case ENDS_WITH: {
                str.append("ENDS_WITH");
                break;
            }
            case CONTAINS: {
                str.append("CONTAINS");
                break;
            }
            case EQUALS: {
                str.append("EQUALS");
                break;
            }
            case NOTEQUAL: {
                str.append("NOTEQUAL");
                break;
            }
            default: {
                str.append("NOT_DEFINED");
            }
        }
        str.append(closeBracket);
        return str.toString();
    }

    public static enum SearchCondition {
        NOT_DEFINED,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        EQUALS,
        NOTEQUAL;

    }
}

