/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.provider.SetRestrictionsForMAQuery;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import java.util.EnumSet;

public class SetRestrictionsForGetMembers
extends SetRestrictionsForMAQuery {
    public SetRestrictionsForGetMembers() {
        this.mName = "Set constraints for the provider and build XMAMemberMatadata run tree.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        if (maMetadataQuery.isSAPVariableMAQuery()) {
            this.traceNodeCondition(false, "The MAMetadataQuery is an SAP variable query.", trace);
            return false;
        }
        if (maMetadataQuery.isMemberSearchMAQuery()) {
            this.traceNodeCondition(false, "The MAMetadataQuery is the member search query.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MAMetadataQuery is a member query. Need to generate XMAMemberMetadata.", trace);
        return true;
    }

    @Override
    public void buildRestriction(IXQEQueryNode node, PlanningEnvironment environment, MetadataRestriction restriction) {
        super.buildRestriction(node, environment, restriction);
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MACollection memberCollection = this.getMAMemberCollection(node, maMetadataQuery);
        MetadataHelper.setRestrictionValues(memberCollection, restriction);
        MetadataHelper.addDefaultRestriction(memberCollection, restriction, RestrictionType.DIMENSION_UNIQUE_NAME);
        MetadataHelper.addDefaultRestriction(memberCollection, restriction, RestrictionType.HIERARCHY_UNIQUE_NAME);
        MetadataHelper.addDefaultRestriction(memberCollection, restriction, RestrictionType.LEVEL_NUMBER);
        String stringDepth = (String)maMetadataQuery.getPropertyValue("Depth");
        String memberUniqueName = (String)memberCollection.getPropertyValue("memberUniqueName");
        if (null != memberUniqueName) {
            if (maMetadataQuery.isSAPVariableMemberOperator()) {
                restriction.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.CHILDREN));
            } else if (null != maMetadataQuery.getMunQuery()) {
                restriction.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF, TreeOperatorEnum.ANCESTORS));
            } else if (stringDepth != null && !stringDepth.equals("") && Integer.valueOf(stringDepth) == 1) {
                restriction.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF));
            } else {
                restriction.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF, TreeOperatorEnum.CHILDREN));
            }
        }
    }
}

