/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.util;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.ast.maExp.MAStartAt;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.SecuredOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.runtree.ma.member.response.XMAExplicitMemberResponse;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.runtree.ma.member.response.XMAMemberMetadata;
import com.cognos.xqe.runtree.ma.member.response.XMAMunQueryResponse;
import com.cognos.xqe.runtree.ma.member.response.XMASAPVariableResponse;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMetadataProvider;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextKey;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextManager;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.SecurityContext;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Pair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;

public class MetadataHelper {
    private static final String MUN_PART_DELIMITER = "\\.";
    private static final String METADATA = "Metadata";
    private static final String FUNCTIONS = "Functions";
    private static final String PROPERTIES = "Properties";
    private static final String NAME = "name";
    private static final String[] FULL_MODEL_MA_QUERY_SIGNATURE = new String[]{"./dataSource", "./folder", "./dimension", "./hierarchy", "./level", "./hierarchyFolder", "./measure", "./measureFolder", "./calculation"};
    private static final String[] FULL_FDS_MA_QUERY_SIGNATURE = new String[]{"./group", "group/@", "./function", "function/@id", "function/@name", "function/@qosLevel"};
    private static final String[] SEPARATOR_MA_QUERY_SIGNATURE = new String[]{"/@decimalSeparator", "/@listSeparator"};

    public static void addMemberProperties(MACollection memberCollection, Set<MARequestedPropertiesEnum> requiredProperties) {
        Set<String> collectionProperties = memberCollection.getRequiredProperties();
        for (String property : collectionProperties) {
            if (property.equals("memberCaption")) {
                requiredProperties.add(MARequestedPropertiesEnum.CAPTION);
                continue;
            }
            if (property.equals("dimensionUniqueName")) {
                requiredProperties.add(MARequestedPropertiesEnum.DIMENSION_UNIQUE_NAME);
                continue;
            }
            if (property.equals("hierarchyUniqueName")) {
                requiredProperties.add(MARequestedPropertiesEnum.HIERARCHY_UNIQUE_NAME);
                continue;
            }
            if (property.equals("levelNumber")) {
                requiredProperties.add(MARequestedPropertiesEnum.LEVEL_NUMBER);
                continue;
            }
            if (property.equals("levelUniqueName")) {
                requiredProperties.add(MARequestedPropertiesEnum.LEVEL_UNIQUE_NAME);
                continue;
            }
            if (property.equals("memberUniqueName")) {
                requiredProperties.add(MARequestedPropertiesEnum.MEMBER_UNIQUE_NAME);
                continue;
            }
            if (property.equals("member")) {
                requiredProperties.add(MARequestedPropertiesEnum.MEMBER_NAME);
                continue;
            }
            if (property.equals("parentUniqueName")) {
                requiredProperties.add(MARequestedPropertiesEnum.PARENT_UNIQUE_NAME);
                continue;
            }
            if (property.equals("businessKey")) {
                requiredProperties.add(MARequestedPropertiesEnum.BUSINESS_KEY);
                continue;
            }
            if (property.equals("PPDS_CODE")) {
                requiredProperties.add(MARequestedPropertiesEnum.PPDS_CODE);
                continue;
            }
            if (property.equals("Is_Suppressed")) {
                requiredProperties.add(MARequestedPropertiesEnum.IS_SUPPRESSED);
                continue;
            }
            if (property.equals("Suppressed_Parent_Code")) {
                requiredProperties.add(MARequestedPropertiesEnum.SUPPRESSED_PARENT_CODE);
                continue;
            }
            if (!property.equals(MARequestedPropertiesEnum.ROLLUPTYPE.getPropertyName())) continue;
            requiredProperties.add(MARequestedPropertiesEnum.ROLLUPTYPE);
        }
    }

    public static void setRestrictionValues(MACollection memberCollection, MetadataRestriction restriction) {
        Set<String> collectionProperties = memberCollection.getRequiredProperties();
        for (String key : collectionProperties) {
            RoleTypeEnum rollType = RoleTypeEnum.fromV5("_" + key);
            String restrictionKey = null;
            String restrictionValue = null;
            RestrictionType restrictionType = null;
            switch (rollType) {
                case MEMBER_UNIQUE_NAME: 
                case LEVEL_UNIQUE_NAME: 
                case HIERARCHY_UNIQUE_NAME: 
                case DIMENSION_UNIQUE_NAME: 
                case MEMBER_CAPTION: {
                    restrictionKey = rollType.name();
                    restrictionType = RestrictionType.valueOf(restrictionKey);
                    restrictionValue = (String)memberCollection.getPropertyValue(key);
                    if (null == restrictionValue) break;
                    restriction.add(restrictionType, restrictionValue);
                    break;
                }
                case LEVEL_NUMBER: {
                    restrictionKey = rollType.name();
                    restrictionType = RestrictionType.valueOf(restrictionKey);
                    restrictionValue = (String)memberCollection.getPropertyValue(key);
                    if (null == restrictionValue) break;
                    restriction.add(restrictionType, Integer.valueOf(restrictionValue));
                    break;
                }
            }
        }
        MetadataHelper.addDefaultRestriction(memberCollection, restriction, RestrictionType.MEMBER_UNIQUE_NAME);
    }

    public static void addDefaultRestriction(MACollection collection, MetadataRestriction restriction, RestrictionType type) {
        if (restriction.contains(type)) {
            return;
        }
        Object value = null;
        switch (type) {
            case MEMBER_UNIQUE_NAME: {
                value = collection.getPropertyValue("memberUniqueName");
                break;
            }
            case DIMENSION_UNIQUE_NAME: {
                value = collection.getPropertyValue("dimensionUniqueName");
                break;
            }
            case HIERARCHY_UNIQUE_NAME: {
                value = collection.getPropertyValue("hierarchyUniqueName");
                break;
            }
            case LEVEL_NUMBER: {
                value = collection.getPropertyValue("levelNumber");
                if (value == null) break;
                value = new Integer((String)value);
                break;
            }
            default: {
                return;
            }
        }
        if (null != value) {
            restriction.add(type, value);
        }
    }

    public static void addMemberResponse(IXQEQueryNode node, PlanningEnvironment environment, MetadataRestriction maRestriction) {
        XQENodeFactory xFactory = environment.getNodeFactory();
        MAMetadataQuery maMetadataQuery = null;
        maMetadataQuery = node.getType() == 1101015 ? (MAMetadataQuery)node : ((MASimpleNode)node).getMAMetadataQuery();
        XMAGenerateMemberResponse xMemberResponseNode = MetadataHelper.generateMemberResponse(xFactory, maMetadataQuery);
        XMAMemberMetadata xMemberMANode = (XMAMemberMetadata)xFactory.createXNode(501107);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String defDate = sdf.format(new GregorianCalendar().getTime());
        String keyDate = maRestriction.getValueOf(RestrictionType.KEY_DATE, defDate);
        xMemberResponseNode.setPropertyValue("keyDate", keyDate);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        IModelDataSource modelDS = environment.getMADataSource();
        IDataSource dataSource = execEnv.getDataSourceByModelName(modelDS.getName());
        xMemberResponseNode.setDataSource(dataSource);
        xMemberResponseNode.setCube(modelDS.getCube());
        xMemberMANode.setDataSource(dataSource);
        if (modelDS.getCatalog() != null) {
            xMemberMANode.setCatalog(modelDS.getCatalog().getUniqueName());
        }
        xMemberMANode.setCube(modelDS.getCube());
        xMemberMANode.setRestrictions(maRestriction);
        xMemberResponseNode.addChild(xMemberMANode);
    }

    public static XMAGenerateMemberResponse generateMemberResponse(IXQENodeFactory xFactory, MAMetadataQuery maMetadataQuery) {
        XMAGenerateMemberResponse xMemberResponseNode = (XMAGenerateMemberResponse)xFactory.createXNode(501113);
        if (MetadataHelper.shouldUseMUNResponse(maMetadataQuery)) {
            xMemberResponseNode = (XMAMunQueryResponse)xFactory.createNode(501146);
        } else if (maMetadataQuery.hasSAPVariable()) {
            xMemberResponseNode = MetadataHelper.createSAPVariableResponse(xFactory, maMetadataQuery);
        } else if (maMetadataQuery.isExplicitMemberQuery() || maMetadataQuery.getDescendantsOfType(1101028, false).length > 0) {
            xMemberResponseNode = MetadataHelper.createExplicitMemberResponse(xFactory, maMetadataQuery);
        }
        MACollection memberCollection = maMetadataQuery.getMemberCollection();
        memberCollection.addChild(xMemberResponseNode);
        HashSet<MARequestedPropertiesEnum> requiredProperties = new HashSet<MARequestedPropertiesEnum>();
        MetadataHelper.addMemberProperties(memberCollection, requiredProperties);
        xMemberResponseNode.setMemberProperties(requiredProperties);
        return xMemberResponseNode;
    }

    private static XMAExplicitMemberResponse createExplicitMemberResponse(IXQENodeFactory nf, MAMetadataQuery maQuery) {
        XMAExplicitMemberResponse xmaemr = (XMAExplicitMemberResponse)nf.createNode(501145);
        ArrayList<String> startAtRefList = new ArrayList<String>();
        startAtRefList.add(maQuery.getStartAtRefValue());
        xmaemr.setPropertyValue("explicitMember", maQuery.isExplicitMemberQuery());
        xmaemr.setPropertyValue("requestedMuns", startAtRefList);
        return xmaemr;
    }

    private static XMASAPVariableResponse createSAPVariableResponse(IXQENodeFactory nf, MAMetadataQuery maQuery) {
        XMASAPVariableResponse xmasapvr = (XMASAPVariableResponse)nf.createNode(501147);
        xmasapvr.setPropertyValue("sapHierarchyVariable", maQuery.isSAPHierarchyVariableMAQuery());
        xmasapvr.setPropertyValue("sapVariable", maQuery.isSAPVariableMAQuery());
        xmasapvr.setPropertyValue("variableName", maQuery.getSAPVariableName());
        String savedhierMUN = (String)maQuery.getPropertyValue("hierMUN");
        if (savedhierMUN != null) {
            xmasapvr.setPropertyValue("hierMUN", savedhierMUN);
        }
        return xmasapvr;
    }

    private static boolean shouldUseMUNResponse(MAMetadataQuery maQuery) {
        IModelDataSource ds;
        String munQueryType = maQuery.getMunQuery();
        if (null == munQueryType) {
            return false;
        }
        if (!munQueryType.equals("physical")) {
            return false;
        }
        MAMetadataItem dataItem = maQuery.getReferencedMetaItem();
        return dataItem == null || (ds = dataItem.getDatasource()) == null || !DataSourceTypeEnum.isSAPBW(ds.getInterface()) && !DataSourceTypeEnum.isEssbase(ds.getInterface()) && !DataSourceTypeEnum.isTMR(ds.getInterface());
    }

    public static IDataSource isDMRExplicitMemberMAQueryOptimizationSupported(List<IModelDataSource> dataSources, PlanningEnvironment planEnv, ExecutionEnvironment execEnv) {
        if (!QueryEngine.getInstance().getCacheManager().cacheMAQueryResult()) {
            return null;
        }
        if (dataSources == null || dataSources.isEmpty() || dataSources.size() != 1) {
            return null;
        }
        IModelDataSource modelDS = dataSources.get(0);
        String cmDataSourceName = modelDS.getCMDataSourceName();
        if (MacroExpander.isMacro(cmDataSourceName) || modelDS.isROLAP()) {
            return null;
        }
        IDataSource dataSource = execEnv.getOrAddDataSource(modelDS.getName(), cmDataSourceName, null, modelDS.getMetadataProperties());
        IDataSourceCapabilities capabilities = dataSource.getCapabilities();
        if (!capabilities.isSupported("enableDMRcubeReuse") || !capabilities.isSupported("enableDMRmemberStorage")) {
            return null;
        }
        String value = planEnv.getPlanningPAC().get("_governor", Governors.AllGovernors.LOCAL_CACHE.getKey());
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return dataSource;
        }
        return null;
    }

    public static boolean isMACacheSupported(List<IModelDataSource> dataSources, ExecutionEnvironment execEnv) {
        if (dataSources == null || dataSources.isEmpty()) {
            return false;
        }
        for (int i = 0; i < dataSources.size(); ++i) {
            IModelDataSource modelDS = dataSources.get(i);
            String cmDataSourceName = modelDS.getCMDataSourceName();
            if (MacroExpander.isMacro(cmDataSourceName) || modelDS.isROLAP()) {
                return false;
            }
            execEnv.getOrAddDataSource(modelDS.getName(), cmDataSourceName, null, modelDS.getMetadataProperties());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<IMember> getExplicitMembersFromDMRCube(PlanningEnvironment environment, MAMetadataQuery maMetadataQuery, MACollection memberCollection) {
        Cube cube;
        ArrayList<String> startAt;
        block11: {
            MetadataConnection metadataConnection = memberCollection.getMetadataConnection();
            ExecutionEnvironment execEnv = (ExecutionEnvironment)((RequestEnvironment)environment.getRequestEnvironment()).getExecutionEnvironment();
            List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
            IDataSource dataSource = MetadataHelper.isDMRExplicitMemberMAQueryOptimizationSupported(dataSources, environment, execEnv);
            if (dataSource == null) {
            }
            MAStartAt startAtNode = (MAStartAt)maMetadataQuery.getFirstChildByType(1101028);
            if (startAtNode == null) {
                return null;
            }
            startAt = startAtNode.getPaths();
            HashSet<IDimension> dimensions = MetadataHelper.collectDimensions(startAt, metadataConnection);
            if (dimensions.isEmpty()) {
                return null;
            }
            CubeWrapper cubeWrapper = DMRUtilities.createCubeWrapper(dimensions, dataSources.get(0), metadataConnection, execEnv.getGovernors());
            cube = MetadataHelper.locateDMRCube(cubeWrapper, metadataConnection, dataSource, execEnv);
            if (cube == null) {
            }
            break block11;
            finally {
                return null;
            }
        }
        ArrayList<IMember> requestedMembers = new ArrayList<IMember>();
        List<IHierarchy> hierarchies = cube.getHierarchies(true);
        Iterator iterator = startAt.iterator();
        block3: while (true) {
            IHierarchy aHierarchy;
            if (!iterator.hasNext()) {
                return requestedMembers;
            }
            String expression = (String)iterator.next();
            Pair pair = MetadataHelper.getHierarchyNameAndMunParts(expression);
            String hierarchyName = (String)pair.getFirst();
            String[] munParts = (String[])pair.getSecond();
            Iterator<IHierarchy> iterator2 = hierarchies.iterator();
            do {
                if (!iterator2.hasNext()) continue block3;
            } while (!(aHierarchy = iterator2.next()).getName().equals(hierarchyName));
            String childName = munParts[0].substring(1, munParts[0].length() - 1);
            IMemberCubics member = (IMemberCubics)((Level)aHierarchy.getLevel(0)).getMembersOrderedMap().get(childName);
            for (int i = 1; i < munParts.length && member != null; member = (IMemberCubics)member.searchChildrenOrderedMap(childName), ++i) {
                childName = munParts[i].substring(1, munParts[i].length() - 1);
            }
            if (member == null || !member.getV5UniqueName().equals(expression)) break;
            ContextMember requestedMember = new ContextMember();
            requestedMember.setMember(member);
            requestedMembers.add(requestedMember);
        }
        return null;
    }

    private static Cube locateDMRCube(CubeWrapper cubeWrapper, MetadataConnection metadataConnection, IDataSource dataSource, ExecutionEnvironment execEnv) {
        Cube cube = null;
        ArrayList<IDataSource> ds = new ArrayList<IDataSource>();
        ds.addAll(execEnv.getDataSources());
        if (ds.isEmpty()) {
            return null;
        }
        String modelPath = metadataConnection.getModelPath();
        String localeStr = LocaleConverter.localeToStr(((RequestEnvironment)execEnv.getRequestEnvironment()).getRunLocale());
        SecurityContext securityContext = new SecurityContext((RequestEnvironment)execEnv.getRequestEnvironment(), metadataConnection, ds, execEnv.getGovernors());
        DMRMemberStorage.DMRMemberStorageIdentifier memberProviderMRCKey = new DMRMemberStorage.DMRMemberStorageIdentifier(modelPath, localeStr, metadataConnection.getModelDataSources(), securityContext);
        SecuredOLAPMetadataProvider securedMetadataProvider = execEnv.getMultiRequestContext().getSecuredOLAPMetadataProvider(memberProviderMRCKey);
        if (securedMetadataProvider == null) {
            DMRMetadataProvider metadataProvider = new DMRMetadataProvider();
            MetadataQueryArguments metadataArgs = new MetadataQueryArguments(dataSource, execEnv, null);
            securedMetadataProvider = new SecuredOLAPMetadataProvider(metadataProvider, metadataArgs);
            securedMetadataProvider.initSAL(cubeWrapper, localeStr, securityContext);
            execEnv.getMultiRequestContext().setSecuredOLAPMetadataProvider(memberProviderMRCKey, securedMetadataProvider);
        }
        String memberStorageTS = "";
        DMRMemberStorage requestContextMemberStorage = null;
        requestContextMemberStorage = (DMRMemberStorage)securedMetadataProvider.getSAL().getMemberStorage();
        memberStorageTS = requestContextMemberStorage.toString();
        String passport = ((RequestEnvironment)execEnv.getRequestEnvironment()).getCAMPassport();
        BIBusEnvelope envelope = ((RequestEnvironment)execEnv.getRequestEnvironment()).getRequestEnvelope();
        long modelModificationTime = CubeContextManager.getCubeContextManager().getModelModificationTime(metadataConnection, passport, envelope);
        CubeContextKey cubeKey = new CubeContextKey(modelPath, false, securityContext, memberStorageTS, localeStr, modelModificationTime);
        cube = CubeContextManager.getCubeContextManager().getCube(cubeWrapper, cubeKey, securedMetadataProvider, true, execEnv);
        return cube;
    }

    public static Pair getHierarchyNameAndMunParts(String expression) {
        int munStart = expression.indexOf("]->[") + "]->[".length() - 1;
        String mun = expression.substring(munStart);
        String[] munParts = mun.split(MUN_PART_DELIMITER);
        String[] parts = expression.split(MUN_PART_DELIMITER);
        String hierarchyName = parts[2].substring(1, parts[2].length() - 1);
        return new Pair(hierarchyName, munParts);
    }

    private static HashSet<IDimension> collectDimensions(List<String> expressoins, MetadataConnection metadataConnection) {
        HashSet<IDimension> dimensions = new HashSet<IDimension>();
        for (String expression : expressoins) {
            IDimension dim;
            String[] levelName = expression.split("->");
            IMetadata metadata = metadataConnection.bindMetadataReference(levelName[0]);
            if (metadata.getObjectType() != MetadataType.LEVEL || (dim = ((ILevel)metadata).getDimension()) == null) continue;
            dimensions.add(dim);
        }
        return dimensions;
    }

    public static String getMAQueryTypeForCaching(Element metadataElement) {
        ArrayList metadataProperties = new ArrayList();
        ArrayList functionProperties = new ArrayList();
        for (Object ele : metadataElement.elements(METADATA)) {
            Element properties = ((Element)ele).element(PROPERTIES);
            metadataProperties.addAll(properties.elements());
        }
        boolean isFullModelMAQuery = false;
        if (metadataProperties.size() >= FULL_MODEL_MA_QUERY_SIGNATURE.length) {
            isFullModelMAQuery = true;
            for (String signature : FULL_MODEL_MA_QUERY_SIGNATURE) {
                boolean found = false;
                for (Object p : metadataProperties) {
                    Element property = (Element)p;
                    String name = property.attributeValue(NAME);
                    if (!name.equals(signature)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                isFullModelMAQuery = false;
                break;
            }
        }
        if (isFullModelMAQuery) {
            return METADATA;
        }
        for (Object ele : metadataElement.elements(FUNCTIONS)) {
            Element properties = ((Element)ele).element(PROPERTIES);
            functionProperties.addAll(properties.elements());
        }
        boolean isFullFDSMAQuery = false;
        if (functionProperties.size() >= FULL_FDS_MA_QUERY_SIGNATURE.length) {
            isFullFDSMAQuery = true;
            for (String signature : FULL_FDS_MA_QUERY_SIGNATURE) {
                boolean found = false;
                for (Object p : functionProperties) {
                    Element property = (Element)p;
                    String name = property.attributeValue(NAME);
                    if (!name.equals(signature)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                isFullFDSMAQuery = false;
                break;
            }
        }
        if (isFullFDSMAQuery) {
            return FUNCTIONS;
        }
        boolean isSeparatorMAQuery = false;
        if (functionProperties.size() >= SEPARATOR_MA_QUERY_SIGNATURE.length) {
            isSeparatorMAQuery = true;
            for (String signature : SEPARATOR_MA_QUERY_SIGNATURE) {
                boolean found = false;
                for (Object p : functionProperties) {
                    Element property = (Element)p;
                    String name = property.attributeValue(NAME);
                    if (!name.equals(signature)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                isSeparatorMAQuery = false;
                break;
            }
        }
        if (isSeparatorMAQuery) {
            return FUNCTIONS;
        }
        return null;
    }
}

