/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.trace.XQETrace;

public class AttachMdxASTNodesToParent
extends Transformation {
    public AttachMdxASTNodesToParent() {
        this.mName = "Attaches MDX AST nodes to their parent runtree node.";
        this.mPassNumbers = new int[]{2};
        this.generateNodeTypes();
    }

    private void generateNodeTypes() {
        this.mTypes = new int[55];
        int nodeType = 701007;
        for (int i = 0; i < this.mTypes.length; ++i) {
            this.mTypes[i] = nodeType++;
        }
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!(node.getParent() instanceof XMdxNode)) {
            throw new MDXEngineException(XQEMessageKeys.MDX_RuntreeGenerationFailed);
        }
        XMdxNode xParent = (XMdxNode)node.getParent();
        xParent.addContextNode((MDXQueryNode)xParent.detachChild(node));
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!(node instanceof MDXQueryNode)) {
            this.traceQueryCondition(false, "Attach MDX AST node not applied because the node is not an MDX AST node.", trace);
            return false;
        }
        for (IXQEQueryNode curNode = node.getParent(); curNode != null && !(curNode instanceof XMdxLocal); curNode = curNode.getParent()) {
            if (curNode instanceof XMdxNode) continue;
            this.traceQueryCondition(false, "Attach MDX AST node not applied because there are non-runtree MDX nodes in the hierarchy.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Attach MDX AST node applied.", trace);
        return true;
    }
}

