/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.ASTCharacterStringLiteral;
import com.cognos.xqe.ast.mdx.parser.ASTMDXNode;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetTerminal;
import com.cognos.xqe.ast.olap.util.MDXParserUtility;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxMemberPropertyDefinition;
import com.cognos.xqe.runtree.olap.mdx.XMdxSetSpecification;
import com.cognos.xqe.runtree.olap.mdx.XMdxSetTerminal;
import com.cognos.xqe.runtree.olap.mdx.XMdxStringValueExpression;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;

public class GenerateNamedSetAST
extends Transformation {
    public static final String DOUBLE_QUOTE = "''";
    public static final String SINGLE_QUOTE = "'";
    public static final String STRLOCAL = "LOCAL";
    public static final String STRREMOTE = "REMOTE";
    public static final String STREXECUTIONLOCATION = "EXECUTION_LOCATION";

    public GenerateNamedSetAST() {
        this.mName = "Generates an AST for a named set expression string.";
        this.mPassNumbers = new int[]{1};
        this.mTypes = new int[]{501071};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XMdxMemberPropertyDefinition propertyNode;
        IXQEQueryNode childNode;
        XMdxStringValueExpression expressionNode = (XMdxStringValueExpression)node.getChild(1);
        IXQEQueryNode localNode = node.getAncestorOfType(501053);
        MDXQuery mdxQuery = ((XMdxLocal)localNode).getMDXQuery();
        Boolean localProcessing = true;
        MDXSetTerminal setTerminalPlanNode = null;
        if (mdxQuery != null) {
            int[] nodeType = new int[]{1180};
            List<IXQEQueryNode> nodes = mdxQuery.getDescendantsOfTypesOrdered(nodeType, false);
            if (nodes.size() > 0) {
                String name = ((ASTMDXNode)((XMdxSetSpecification)node).getChild(0).getChild(0).getChild(0)).getText();
                for (int i = 0; i < nodes.size(); ++i) {
                    setTerminalPlanNode = (MDXSetTerminal)nodes.get(i);
                    if (!name.equals(setTerminalPlanNode.getName())) continue;
                    localProcessing = false;
                    break;
                }
            }
        } else if (node.getNumberChildren() > 2 && (childNode = node.getChild(2)) instanceof XMdxMemberPropertyDefinition && (propertyNode = (XMdxMemberPropertyDefinition)childNode).getNumberChildren() == 2) {
            String propName = null;
            if (propertyNode.getChild(0) instanceof ASTMDXNode) {
                IXQEQueryNode strNode;
                propName = ((ASTMDXNode)propertyNode.getChild(0)).getText();
                if (!propName.equalsIgnoreCase(STREXECUTIONLOCATION)) throw new MDXEngineException("X01433", new String[]{propName, STREXECUTIONLOCATION});
                if (propertyNode.getChild(1) instanceof XMdxStringValueExpression && (strNode = propertyNode.getChild(1).getChild(0).getChild(0)) instanceof ASTMDXNode) {
                    String propString = ((ASTMDXNode)strNode).getText();
                    if ((propString = propString.substring(1, propString.length() - 1)).equalsIgnoreCase(STRREMOTE)) {
                        localProcessing = false;
                    } else {
                        if (!propString.equalsIgnoreCase(STRLOCAL)) throw new MDXEngineException("X01433", new String[]{propString, "REMOTE, LOCAL"});
                        localProcessing = true;
                    }
                }
            }
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        XDataContext dataContext = execEnv.pushDataContext();
        try {
            if (localProcessing.booleanValue()) {
                String setString = expressionNode.execute(dataContext).toString();
                if ((setString = setString.replaceAll(DOUBLE_QUOTE, SINGLE_QUOTE)).trim().indexOf(39) == 0) {
                    setString = setString.substring(setString.indexOf(39) + 1, setString.lastIndexOf(39));
                }
                MDXQueryNode setExpression = MDXParserUtility.parseMDX(setString, environment, MDXParserUtility.ParseType.SET);
                node.exchangeChildNode(expressionNode, setExpression, false);
                return;
            } else {
                XQENodeFactory nodeFactory = environment.getNodeFactory();
                XMdxSetTerminal xNode = (XMdxSetTerminal)nodeFactory.createNode(501135);
                if (setTerminalPlanNode != null) {
                    xNode.setPlanNode(setTerminalPlanNode);
                } else {
                    String setString = expressionNode.execute(dataContext).toString();
                    if ((setString = setString.replaceAll(DOUBLE_QUOTE, SINGLE_QUOTE)).trim().indexOf(39) == 0) {
                        setString = setString.substring(setString.indexOf(39) + 1, setString.lastIndexOf(39));
                    }
                    xNode.setMDXStatement(setString);
                }
                node.exchangeChildNode(expressionNode, xNode, false);
                xNode.setLocalNode((XMdxLocal)xNode.getAncestorOfType(501053));
            }
            return;
        }
        finally {
            execEnv.popDataContext(dataContext);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getNumberChildren() < 2) {
            this.traceQueryCondition(false, "GenerateNamedSetAST not applied because there are less than 2 child nodes in the tree", trace);
            return false;
        }
        IXQEQueryNode expressionNode = node.getChild(1);
        if (!(expressionNode instanceof XMdxStringValueExpression)) {
            this.traceQueryCondition(false, "GenerateNamedSetAST not applied because expression node is not a string.", trace);
            return false;
        }
        List<IXQEQueryNode> nodes = expressionNode.getDescendantsOfCategory(701009, false);
        if (nodes.size() > 0) {
            for (int i = 0; i < nodes.size(); ++i) {
                if (nodes.get(i) instanceof ASTCharacterStringLiteral) continue;
                this.traceQueryCondition(false, "GenerateNamedSetAST not applied because there are still MDX AST child nodes in the tree.", trace);
                return false;
            }
        }
        this.traceQueryCondition(true, "GenerateNamedSetAST applied.", trace);
        return true;
    }
}

