/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.NagXTabRelationalSubquery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;

public class GenerateXRelationalCrossTabNode
extends Transformation {
    private static final String APPLY_MESSAGE = "GenerateXRelationalCrosstab will add XRelationalCrosstab as a parent of XMdxLocal";

    public GenerateXRelationalCrossTabNode() {
        this.mName = "Generate The XRelationalCrosstab node, the runtree node that will run the tabular stream query to prime the cache for relational crosstabs.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{501053};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] datasets;
        IXQEQueryNode parentNode = node.getParent();
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode relationalCrosstabNode = nodeFactory.createNode(501088);
        parentNode.exchangeChildNode(node, relationalCrosstabNode, false);
        relationalCrosstabNode.addChild(node);
        XMdxLocal mdxLocal = (XMdxLocal)node;
        String resultName = mdxLocal.getTabularResultSetName();
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        for (IXQEQueryNode dataset : datasets = querySet.getChildrenOfType(401005)) {
            RSAPIDataset rsapiDataset = (RSAPIDataset)dataset;
            if (!rsapiDataset.getName().equals(resultName)) continue;
            IXQEQueryNode detached = rsapiDataset.detach();
            relationalCrosstabNode.addChild(detached);
            this.addSQLNags(environment, mdxLocal, rsapiDataset);
            return;
        }
        mdxLocal.setTabularResultSetName(null);
    }

    private void addSQLNags(PlanningEnvironment planningEnv, XMdxLocal mdxLocal, RSAPIDataset subqueryDataset) {
        RequestEnvironment requestEnv = (RequestEnvironment)planningEnv.getRequestEnvironment();
        if (requestEnv.getMaxSeverityLevel() < 2) {
            return;
        }
        String reportQuery = mdxLocal.getMDXQuery().getRefQueryProperty();
        String cognosSQL = subqueryDataset.getCognosSQL();
        NagXTabRelationalSubquery nag = new NagXTabRelationalSubquery();
        nag.setReportQueryName(reportQuery);
        nag.setActualQueryName(subqueryDataset.getName());
        nag.setCognosSQL(cognosSQL);
        for (IXQEQueryNode xSql : DMRUtilities.findNativeSqlNodes(subqueryDataset)) {
            nag.addNativeSQL(((XSql)xSql).getSqlText());
        }
        ((ExecutionEnvironment)planningEnv.getExecutionEnvironment()).addNag(nag);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getParent().getType() == 501088) {
            this.traceQueryCondition(false, "GenerateXRelationalCrosstab is not applied as the XRelationalCrosstab node already exists.", trace);
            return false;
        }
        this.traceQueryCondition(true, APPLY_MESSAGE, trace);
        return true;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XMdxLocal mdxLocal = (XMdxLocal)node;
        XQETrace trace = environment.getTrace();
        if (mdxLocal.isDMR()) {
            this.traceQueryCondition(false, "GenerateXRelationalCrosstab is not applied since the query is DMR.", trace);
            return false;
        }
        IDataSource dataSource = mdxLocal.getDataSource();
        if (dataSource == null) {
            this.traceQueryCondition(false, "GenerateXRelationalCrosstab is not applied for the MDX Interpreter Test Suite", trace);
            return false;
        }
        if (!dataSource.isRelational()) {
            this.traceQueryCondition(false, "GenerateXRelationalCrosstab is not applied since the query is OLAP.", trace);
            return false;
        }
        if (mdxLocal.getTabularResultSetName() == null) {
            this.traceQueryCondition(false, "GenerateXRelationalCrosstab is not applied as the tabular result does not exist.", trace);
            return false;
        }
        this.traceQueryCondition(true, APPLY_MESSAGE, trace);
        return true;
    }
}

