/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.transformation.moser.GenerateModuleMetadataForPackage;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.MoserOlapPackageGenerator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public class GenerateModuleMetadataForOLAP {
    public static final String RESPONSE = "olapMetadataResponse";
    public static final String RESULT = "olapMetadataResult";
    private String cmDataSource;
    private String catalog;
    private String cube;
    private String modelPath;
    private String providerType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element generateResponse(ExecutionEnvironment environment, Element inFunctionSpec) {
        GenerateModuleMetadataForOLAP generator = new GenerateModuleMetadataForOLAP();
        try {
            generator.extractCommandParameters(environment, inFunctionSpec);
            generator.setModelPath(LocaleConverter.localeToStr(((RequestEnvironment)environment.getRequestEnvironment()).getRunLocale()));
            Element functionSpec = generator.createFunctionSpecForPackageMetadata(inFunctionSpec);
            Element response = GenerateModuleMetadataForPackage.generateResponse(environment, functionSpec);
            response.setName(RESPONSE);
            Element result = response.element("packageMetadataResult");
            result.setName(RESULT);
            Element element = response;
            return element;
        }
        finally {
            generator.deleteTempFile();
        }
    }

    private void deleteTempFile() {
        if (this.modelPath != null) {
            File tempFile = new File(this.modelPath);
            tempFile.delete();
        }
    }

    private void setModelPath(String contentLocale) {
        try {
            this.modelPath = MoserOlapPackageGenerator.writePackageContentToTempFile(this.providerType, this.cmDataSource, this.catalog, this.cube, contentLocale);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private Element createFunctionSpecForPackageMetadata(Element inFunctionSpec) {
        Element functionSpec = inFunctionSpec.createCopy();
        GenerateModuleMetadataForOLAP.addParameter("modelPath", this.modelPath, functionSpec);
        GenerateModuleMetadataForOLAP.addParameter("packageName", this.cmDataSource, functionSpec);
        GenerateModuleMetadataForOLAP.addParameter("version", "4", functionSpec);
        return functionSpec;
    }

    public static void addParameter(String parmName, String parmValue, Element moserFunction) {
        Element item = moserFunction.addElement("item");
        Element name = item.addElement("name");
        name.setText(parmName);
        Element value = item.addElement("value");
        value.setText(parmValue);
    }

    private void extractCommandParameters(ExecutionEnvironment environment, Element functionSpec) {
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            Pair keyValue = MoserCommandUtil.getNameAndValueMap(child);
            if (keyValue == null) continue;
            if ("cmDataSource".equals(keyValue.getFirst())) {
                this.cmDataSource = (String)keyValue.getSecond();
                continue;
            }
            if ("catalog".equals(keyValue.getFirst())) {
                this.catalog = (String)keyValue.getSecond();
                continue;
            }
            if ("cube".equals(keyValue.getFirst())) {
                this.cube = (String)keyValue.getSecond();
                continue;
            }
            if (!"providerCode".equals(keyValue.getFirst())) continue;
            this.providerType = (String)keyValue.getSecond();
        }
    }
}

