/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.model.ModelNotFoundException;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.UnknownType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMeasureDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IProject;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataBindingException;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.moser.GenerateJoinGraph;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.transformation.moser.ReferenceResolver;
import com.cognos.xqe.transformation.moser.util.JoinGraphCache;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqemoser.MoserModuleUtil;
import com.ibm.bi.platform.moser.common.utils.FormatConverter;
import com.ibm.bi.platform.moser.common.utils.MoserException;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public class GenerateModuleMetadataForPackage {
    private static final String NAMED_SET = "namedSet";
    public static final String RESPONSE = "packageMetadataResponse";
    public static final String RESULT = "packageMetadataResult";
    private static final String REUSE = "reUse";
    private static final String FM = "FM_Package";
    private static final String MDTV = "metadataTreeView";
    private static final String FOLDERITEM = "folderItem";
    public static final String PACKAGENAME = "packageName";
    private static final String EMPTY_QS = "emptyQuerySubject";
    private static final String FOLDER = "folder";
    private static final String DEFLINK = "defLink";
    private static final String ID_PREFIX = "idPrefix";
    public static final String JSONPRETTY = "jsonPrettyPrint";
    public static final String VERSION = "version";
    private static final int VERSION3 = 3;
    public static final String CM_DATA_SOURCE = "cmDataSource";
    public static final String CUBE = "cube";
    private static final String DOT_OPEN_SQUARE_BRACKET = ".[";
    private static final String ITEMIDS = "itemIDs";
    private static final HashSet<MetadataType> SUPPORTED_TYPES_RELATIONAL_AND_OLAP = new HashSet();
    public static final XQELogger INFO_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MoserFMConvertion", LogLevel.INFO);
    private static final HashSet<MetadataType> SUPPORTED_TYPES_RELATIONAL_ONLY;
    private HashSet<MetadataType> supportedTypes = SUPPORTED_TYPES_RELATIONAL_ONLY;
    protected MetadataConnection connection = null;
    protected String modelPath = null;
    protected String packageName = null;
    protected String cmDataSource = null;
    protected String idPrefix = null;
    protected JSONObject mdResponse = null;
    protected JSONArray jCubes = null;
    protected JSONArray jQuerySubjects = null;
    protected JSONArray jCalculations = null;
    protected JSONArray jFilters = null;
    protected JSONArray jMDTV = null;
    protected FormatConverter fc = new FormatConverter();
    protected ArrayList<ArrayList<IMetadata>> allObjects = new ArrayList();
    private boolean prettyPrint;
    private JSONArray jNamedSets;
    protected boolean version30 = true;
    private JSONArray jDrillGroups = null;
    private Set<IMetadata> allQuerySubjects = new LinkedHashSet<IMetadata>();
    private Set<IMetadata> allCalculationsNamedSet = new LinkedHashSet<IMetadata>();
    private Set<IMetadata> allFilters = new LinkedHashSet<IMetadata>();
    private List<String> itemIDs = null;
    private boolean onlyCheckIfAccessible = false;
    private GenerateJoinGraph.InfoClass joinGraphCollector = null;

    public static Element generateResponse(ExecutionEnvironment environment, Element functionSpec) {
        GenerateModuleMetadataForPackage generator = new GenerateModuleMetadataForPackage();
        generator.setCommandParameters(environment, functionSpec);
        generator.collectMetadataObjects();
        generator.createMDTV();
        generator.createMetadataResponse();
        JoinGraphCache.getInstance().cacheJoinGraph(environment, generator.joinGraphCollector);
        return generator.generateMetadataResponse();
    }

    protected GenerateModuleMetadataForPackage() {
    }

    protected void setCommandParameters(ExecutionEnvironment environment, Element functionSpec) {
        Boolean reUse = Boolean.TRUE;
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            Pair keyValue = MoserCommandUtil.getNameAndValueMap(child);
            if (keyValue == null) continue;
            if ("modelPath".equals(keyValue.getFirst())) {
                this.modelPath = (String)keyValue.getSecond();
                continue;
            }
            if (REUSE.equals(keyValue.getFirst())) {
                reUse = Boolean.valueOf((String)keyValue.getSecond());
                continue;
            }
            if (PACKAGENAME.equals(keyValue.getFirst())) {
                this.packageName = (String)keyValue.getSecond();
                continue;
            }
            if (ID_PREFIX.equals(keyValue.getFirst())) {
                this.idPrefix = (String)keyValue.getSecond();
                continue;
            }
            if (JSONPRETTY.equals(keyValue.getFirst())) {
                String booleanValue = (String)keyValue.getSecond();
                this.prettyPrint = Boolean.valueOf(booleanValue);
                continue;
            }
            if (VERSION.equals(keyValue.getFirst())) {
                String intValue = (String)keyValue.getSecond();
                int version = Integer.valueOf(intValue);
                this.version30 = version == 3;
                continue;
            }
            if (CM_DATA_SOURCE.equals(keyValue.getFirst())) {
                this.cmDataSource = (String)keyValue.getSecond();
                continue;
            }
            if (!ITEMIDS.equals(keyValue.getFirst())) continue;
            this.itemIDs = MoserCommandUtil.parseJsonArrayString((String)keyValue.getSecond());
        }
        if (this.modelPath == null && this.cmDataSource == null) {
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, (Object)"getPackageMetadata", (Object)"1", (Object)0);
        }
        String connectionString = this.modelPath;
        String metadataService = "MFW4J";
        if (this.modelPath == null) {
            metadataService = "JSON";
            connectionString = this.cmDataSource;
        }
        boolean metadataRequest = true;
        boolean forceMetadataRefresh = true;
        boolean reuseCachedConnection = reUse;
        boolean forceCMTrusted = false;
        boolean[] connectionOptions = MetadataService.getConnectionOptions(forceCMTrusted, forceMetadataRefresh, metadataRequest);
        try {
            this.connection = MetadataService.getInstance().getConnection(metadataService, connectionString, environment, reuseCachedConnection, connectionOptions);
        }
        catch (ModelNotFoundException ex) {
            this.connection = null;
        }
        catch (RuntimeException t) {
            this.connection = null;
            throw t;
        }
        if (this.idPrefix != null) {
            this.idPrefix = this.idPrefix + ".";
        }
        this.mdResponse = new JSONObject();
    }

    protected void collectMetadataObjects() {
        if (this.connection == null) {
            this.mdResponse.put((Object)"label", (Object)this.packageName);
            return;
        }
        this.supportedTypes = this.version30 ? SUPPORTED_TYPES_RELATIONAL_ONLY : SUPPORTED_TYPES_RELATIONAL_AND_OLAP;
        INamespace rootNS = this.connection.getRootNamespace();
        this.mdResponse.put((Object)"identifier", (Object)GenerateModuleMetadataForPackage.getLastNamePart(rootNS));
        if (this.packageName != null) {
            this.mdResponse.put((Object)"label", (Object)this.packageName);
        } else {
            this.mdResponse.put((Object)"label", (Object)rootNS.getCaption());
        }
        this.mdResponse.put((Object)"expressionLocale", (Object)this.connection.getExpressionLocale().toString());
        this.mdResponse.put((Object)"container", (Object)FM);
        if (this.itemIDs != null && !this.itemIDs.isEmpty()) {
            this.collectSpecifiedMetadataObjects();
        } else {
            this.joinGraphCollector = new GenerateJoinGraph.InfoClass();
            this.joinGraphCollector.mc = this.connection;
            this.joinGraphCollector.bOlap = true;
            if (this.idPrefix != null) {
                this.joinGraphCollector.prefixTrim = this.idPrefix.length();
            }
            LinkedList<IMetadata> stack = new LinkedList<IMetadata>();
            this.visitMetadataObject(rootNS, false, stack);
        }
        this.visitCubes(this.connection.getCubes());
    }

    private void collectSpecifiedMetadataObjects() {
        this.onlyCheckIfAccessible = true;
        HashSet<IMetadata> visited = new HashSet<IMetadata>();
        for (String itemID : this.itemIDs) {
            try {
                INamedSet ns;
                IMetadata md = this.connection.bindMetadataReference(itemID);
                this.addRequestedItemAndParents(visited, md);
                if (!(md instanceof ICalculation) || !NAMED_SET.equals(((ICalculation)md).getCalcType()) || (ns = (INamedSet)md).getHierarchy() == null) continue;
                this.addRequestedItemAndParents(visited, ns.getHierarchy());
            }
            catch (MetadataBindingException e) {
                INFO_LOGGER.log("Metadata item " + itemID + " is not found in the package");
            }
        }
    }

    public void addRequestedItemAndParents(HashSet<IMetadata> visited, IMetadata md) {
        IMetadata parentQS = this.getParentQSOrDim(md);
        IMetadata mdToVisit = parentQS != null ? parentQS : md;
        if (!visited.contains(mdToVisit)) {
            this.visitMetadataObject(mdToVisit, this.onlyCheckIfAccessible, this.getParentStack(mdToVisit));
            visited.add(mdToVisit);
        }
    }

    private IMetadata getParentQSOrDim(IMetadata md) {
        for (IMetadata parent = md; parent != null; parent = parent.getParentObject()) {
            if (!(parent instanceof IQuerySubject) && !(parent instanceof IDimension) && !(parent instanceof IShortcut)) continue;
            if (parent instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)parent).isAccessedViaShortcut()) {
                return ((IAccessedViaShortcut)parent).getShortcut();
            }
            return parent;
        }
        return null;
    }

    private LinkedList<IMetadata> getParentStack(IMetadata md) {
        LinkedList<IMetadata> stack = new LinkedList<IMetadata>();
        for (IMetadata parent = md.getParentObject(); parent != null && !(parent instanceof IProject); parent = parent.getParentObject()) {
            stack.addFirst(parent);
        }
        return stack;
    }

    private void visitCubes(ICube[] cubes) {
        if (cubes != null) {
            this.jCubes = new JSONArray();
            for (ICube cube : cubes) {
                JSONObject jCube = new JSONObject();
                jCube.put((Object)"name", (Object)(this.getIdPrefix() + cube.getUniqueName()));
                jCube.put(MoserModuleUtil.MOSER_CUBE, (Object)cube.getCaption());
                jCube.put((Object)"description", (Object)cube.getDescription());
                IMeasure measure = cube.getDefaultMeasure();
                if (measure != null) {
                    String measureId = this.idPrefix == null ? measure.getID() : this.idPrefix + measure.getID();
                    jCube.put(MoserModuleUtil.MOSER_DEFAULT_MEASURE, (Object)measureId);
                }
                String schemaUpdatedDate = "";
                if (cube.getSchemaUpdatedDate() != null) {
                    schemaUpdatedDate = cube.getSchemaUpdatedDate().toString();
                }
                jCube.put(MoserModuleUtil.MOSER_SCHEMA_UPDATED_DATE, (Object)schemaUpdatedDate);
                String updatedDate = "";
                if (cube.getUpdatedDate() != null) {
                    updatedDate = cube.getUpdatedDate().toString();
                }
                jCube.put(MoserModuleUtil.MOSER_UPDATED_DATE, (Object)updatedDate);
                String createdDate = "";
                if (cube.getCreatedDate() != null) {
                    createdDate = cube.getCreatedDate().toString();
                }
                jCube.put(MoserModuleUtil.MOSER_CREATED_DATE, (Object)createdDate);
                String currentPeriod = "";
                if (cube.getCubeCurrentPeriod() != null) {
                    currentPeriod = cube.getCubeCurrentPeriod();
                }
                jCube.put(MoserModuleUtil.MOSER_CURRENT_PERIOD, (Object)currentPeriod);
                this.jCubes.add((Object)jCube);
            }
        }
    }

    protected boolean isVisible(IMetadata obj, boolean inShortcut) {
        try {
            ICalculation calc;
            MetadataType tp = obj.getObjectType();
            if (!this.supportedTypes.contains((Object)tp)) {
                return false;
            }
            if (MetadataType.NAMESPACE.equals((Object)tp) || MetadataType.FOLDER.equals((Object)tp)) {
                if (MetadataType.NAMESPACE.equals((Object)tp) && ((INamespace)obj).isCube()) {
                    return obj.isVisible(this.onlyCheckIfAccessible);
                }
                return true;
            }
            if (MetadataType.CALCULATION.equals((Object)tp) && NAMED_SET.equals((calc = (ICalculation)obj).getCalcType()) && !this.supportedTypes.contains((Object)MetadataType.NAMED_SET)) {
                return false;
            }
            return obj.isVisible(inShortcut || this.onlyCheckIfAccessible);
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
    }

    protected void visitMetadataObject(IMetadata obj, boolean inShortcut, LinkedList<IMetadata> stack) {
        if (!this.isVisible(obj, inShortcut)) {
            return;
        }
        boolean included = true;
        MetadataType tp = obj.getObjectType();
        if (!this.version30 && (MetadataType.NAMESPACE.equals((Object)tp) || MetadataType.FOLDER.equals((Object)tp))) {
            included = obj.isVisible(inShortcut);
        }
        if (included) {
            stack.addLast(obj);
        }
        switch (tp) {
            case QUERY_SUBJECT: 
            case CALCULATION: 
            case FILTER: 
            case DIMENSION: 
            case NAMED_SET: {
                this.registerObject(obj, stack);
                break;
            }
            case FOLDER: 
            case NAMESPACE: {
                List<IMetadata> children = obj.getChildMetadataObjects();
                for (IMetadata child : children) {
                    this.visitMetadataObject(child, inShortcut, stack);
                }
                break;
            }
            case SHORTCUT: {
                this.visitShortcut(obj, stack);
                break;
            }
        }
        if (included) {
            stack.removeLast();
        }
    }

    protected void registerObject(IMetadata obj, LinkedList<IMetadata> stack) {
        ArrayList<IMetadata> objs = new ArrayList<IMetadata>(stack);
        this.allObjects.add(objs);
    }

    protected void visitShortcut(IMetadata shortcut, LinkedList<IMetadata> stack) {
        boolean inShortcut = true;
        IShortcut sc = (IShortcut)shortcut;
        IMetadata obj = sc.getTarget();
        if (obj == null || !obj.isAccessible()) {
            return;
        }
        MetadataType targetType = obj.getObjectType();
        switch (targetType) {
            case QUERY_SUBJECT: 
            case CALCULATION: 
            case FILTER: 
            case DIMENSION: {
                this.registerObject(shortcut, stack);
                break;
            }
            case FOLDER: 
            case NAMESPACE: {
                List<IMetadata> children = obj.getChildMetadataObjects();
                for (IMetadata child : children) {
                    this.visitMetadataObject(child, inShortcut, stack);
                }
                break;
            }
        }
    }

    protected String getReferencedObjectInternalId(ArrayList<IMetadata> objChain) {
        boolean bInShortcut = false;
        for (IMetadata obj : objChain) {
            if (obj.getObjectType() != MetadataType.SHORTCUT) continue;
            bInShortcut = true;
            break;
        }
        IMetadata origObj = objChain.get(objChain.size() - 1);
        String id = this.getIdentifier(origObj);
        IMetadata obj = origObj.getObjectType() == MetadataType.SHORTCUT ? ((IShortcut)origObj).getTarget() : origObj;
        MetadataType tp = obj.getObjectType();
        switch (tp) {
            case QUERY_SUBJECT: 
            case DIMENSION: {
                if (this.joinGraphCollector != null && tp == MetadataType.DIMENSION) {
                    this.joinGraphCollector.addOLAPObject(obj, origObj, bInShortcut);
                }
                JSONArray jQueryItems = new JSONArray();
                List<IMetadata> children = obj.getChildMetadataObjects();
                for (IMetadata child : children) {
                    this.collectItems(id, child, jQueryItems, bInShortcut);
                }
                if (jQueryItems.isEmpty()) {
                    id = EMPTY_QS;
                    break;
                }
                id = this.addQuerySubject(origObj, jQueryItems);
                break;
            }
            case CALCULATION: {
                this.addCalculationOrNamedSet(origObj, id, bInShortcut);
                break;
            }
            case FILTER: {
                this.addFilter(origObj, id);
                break;
            }
            default: {
                id = EMPTY_QS;
            }
        }
        return id;
    }

    protected String getIdentifier(IMetadata mdObj) {
        if (this.idPrefix != null) {
            return this.idPrefix + mdObj.getID();
        }
        return mdObj.getID();
    }

    protected void collectItems(String parentId, IMetadata obj, JSONArray jQueryItems, boolean inShortcut) {
        if (!this.isVisible(obj, inShortcut)) {
            return;
        }
        MetadataType tp = obj.getObjectType();
        JSONObject jObj = null;
        switch (tp) {
            case FOLDER: {
                jObj = this.addFolder(obj, jQueryItems);
                break;
            }
            case QUERY_ITEM: {
                jObj = this.addQueryItem(parentId, obj, jQueryItems, inShortcut);
                parentId = parentId + "." + GenerateModuleMetadataForPackage.getLastNamePart(obj);
                if (this.joinGraphCollector == null || obj instanceof IProperty) break;
                this.joinGraphCollector.addRelationObject(parentId, obj);
                break;
            }
            case HIERARCHY: {
                jObj = this.addHierarchy(parentId, obj, jQueryItems);
                parentId = parentId + "." + GenerateModuleMetadataForPackage.getLastNamePart(obj);
                break;
            }
            case LEVEL: {
                jObj = this.addLevel(parentId, obj, jQueryItems);
                parentId = parentId + "." + GenerateModuleMetadataForPackage.getLastNamePart(obj);
                break;
            }
            case MEMBER: {
                jObj = this.addMember(parentId, obj, jQueryItems);
                parentId = parentId + "." + GenerateModuleMetadataForPackage.getLastNamePart(obj);
                break;
            }
            case CALCULATION: 
            case NAMED_SET: {
                jObj = this.addNamedSet(parentId, obj, jQueryItems);
                parentId = parentId + "." + GenerateModuleMetadataForPackage.getLastNamePart(obj);
                break;
            }
        }
        List<IMetadata> children = obj.getChildMetadataObjects();
        if (children != null && !children.isEmpty()) {
            JSONArray jChildren = null;
            if (this.version30 && MetadataType.FOLDER.equals((Object)tp)) {
                jChildren = jQueryItems;
            } else if (jObj != null) {
                jChildren = new JSONArray();
                if (this.version30) {
                    jObj.put((Object)"queryItem", (Object)jChildren);
                } else {
                    jObj.put((Object)"item", (Object)jChildren);
                }
            }
            if (jChildren != null) {
                for (IMetadata child : children) {
                    if (!this.isPropertyWithVisibleRoles(child)) continue;
                    this.collectItems(parentId, child, jChildren, inShortcut);
                }
                if (jObj != null && tp.equals((Object)MetadataType.FOLDER) && jChildren.isEmpty() && !obj.isVisible(inShortcut || this.onlyCheckIfAccessible)) {
                    jObj.put((Object)"hidden", (Object)true);
                }
            }
        }
    }

    private JSONObject addNamedSet(String parentId, IMetadata obj, JSONArray jQueryItems) {
        JSONObject namedSet = new JSONObject();
        this.setIdForExpression(namedSet, this.getIdForExpression(parentId, obj));
        namedSet.put((Object)"identifier", (Object)GenerateModuleMetadataForPackage.getLastNamePart(obj));
        JSONObject jItem = null;
        if (this.version30) {
            jItem = namedSet;
        } else {
            jItem = new JSONObject();
            jItem.put((Object)NAMED_SET, (Object)namedSet);
        }
        this.setGenericAttributes(namedSet, obj);
        if (obj instanceof ICalculation) {
            this.addCalcProperties((ICalculation)obj, namedSet);
        } else {
            this.addNamedSetProperties((INamedSet)obj, namedSet);
        }
        jQueryItems.add((Object)jItem);
        return namedSet;
    }

    public JSONObject addFolder(IMetadata obj, JSONArray jQueryItems) {
        if (this.version30) {
            return null;
        }
        JSONObject jItem = null;
        JSONObject jFolder = new JSONObject();
        jItem = new JSONObject();
        jItem.put((Object)FOLDER, (Object)jFolder);
        this.setGenericAttributes(jFolder, obj);
        IDataType dt = this.getDataType(obj);
        if (dt != null) {
            jFolder.put((Object)"identifier", (Object)GenerateModuleMetadataForPackage.getLastNamePart(obj));
        }
        if (obj instanceof IQueryItemFolder && ((IQueryItemFolder)obj).isHidden()) {
            jFolder.put((Object)"hidden", (Object)true);
        }
        jQueryItems.add((Object)jItem);
        return jFolder;
    }

    private IDataType getDataType(IMetadata obj) {
        IDataType dt = UnknownType.UNKNOWNTYPE;
        try {
            dt = obj.getDataType();
        }
        catch (Throwable t) {
            dt = UnknownType.UNKNOWNTYPE;
        }
        return dt;
    }

    private void setGenericAttributes(JSONObject jObj, IMetadata mdObj) {
        String value = mdObj.getCaption();
        if (value != null && !value.isEmpty()) {
            jObj.put((Object)"label", (Object)value);
        }
        if ((value = mdObj.getDescription()) != null && !value.isEmpty()) {
            jObj.put((Object)"description", (Object)value);
        }
        if ((value = mdObj.getScreenTip()) != null && !value.isEmpty()) {
            jObj.put((Object)"screenTip", (Object)value);
        }
        if (mdObj.isHidden()) {
            jObj.put((Object)"hidden", (Object)true);
        }
    }

    public static String getLastNamePart(IMetadata obj) {
        String id = obj.getID();
        return GenerateModuleMetadataForPackage.getLastNamePart(id);
    }

    public static String getLastNamePart(String id) {
        String[] nameParts = UniqueNameParser.parseNoThrow(id);
        if (nameParts != null && nameParts.length > 0) {
            return UniqueNameGenerator.createSingleNamePart(nameParts[nameParts.length - 1]);
        }
        return null;
    }

    private JSONObject addMember(String parentId, IMetadata obj, JSONArray jQueryItems) {
        if (obj instanceof IMeasure) {
            IMeasure measure = (IMeasure)obj;
            JSONObject jMember = new JSONObject();
            JSONObject jItem = null;
            if (this.version30) {
                jItem = jMember;
            } else {
                jItem = new JSONObject();
                jItem.put((Object)"queryItem", (Object)jMember);
                jMember.put((Object)"sourceCategory", (Object)"measure");
            }
            jMember.put((Object)"identifier", (Object)GenerateModuleMetadataForPackage.getLastNamePart(measure));
            this.setIdForExpression(jMember, this.getIdForExpression(parentId, obj));
            this.setGenericAttributes(jMember, measure);
            String dt = this.getDataType(measure).toString();
            this.setDataType(jMember, dt);
            jMember.put((Object)"usage", (Object)"fact");
            jMember.put((Object)"regularAggregate", (Object)GenerateModuleMetadataForPackage.convertFMAggregate(measure.getRegularAggregate().toV5Type()));
            this.setHighLevelDataType(jMember, dt);
            if (measure.isDMR()) {
                jMember.put((Object)"aggregateMode", (Object)"dynamic");
            } else {
                jMember.put((Object)"aggregateMode", (Object)"static");
            }
            this.setFormat(jMember, measure.getFormat());
            jQueryItems.add((Object)jItem);
            return jMember;
        }
        return null;
    }

    public void setDataType(JSONObject jObj, String dt) {
        if (dt != null && !UnknownType.UNKNOWNTYPE.toString().equals(dt)) {
            jObj.put((Object)"datatype", (Object)dt);
        }
    }

    private JSONObject addLevel(String parentId, IMetadata obj, JSONArray jQueryItems) {
        ILevel level = (ILevel)obj;
        JSONObject jLevel = new JSONObject();
        JSONObject jItem = null;
        if (this.version30) {
            jItem = jLevel;
        } else {
            jItem = new JSONObject();
            jItem.put((Object)"queryItem", (Object)jLevel);
            jLevel.put((Object)"sourceCategory", (Object)"level");
        }
        this.setIdForExpression(jLevel, this.getIdForExpression(parentId, obj));
        jLevel.put((Object)"identifier", (Object)GenerateModuleMetadataForPackage.getLastNamePart(level));
        this.setGenericAttributes(jLevel, level);
        jLevel.put((Object)"aggregateMode", (Object)"static");
        jLevel.put((Object)"regularAggregate", (Object)"count");
        jQueryItems.add((Object)jItem);
        return jLevel;
    }

    protected boolean isPropertyWithVisibleRoles(IMetadata md) {
        if (md instanceof IProperty) {
            IProperty property = (IProperty)md;
            return this.anyRolesVisible(property.getRoles());
        }
        return true;
    }

    private boolean anyRolesVisible(List<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return true;
        }
        for (String roleName : roles) {
            if (!MetadataUtil.isVisibleRole(roleName)) continue;
            return true;
        }
        return false;
    }

    private JSONObject addHierarchy(String parentId, IMetadata obj, JSONArray jQueryItems) {
        IHierarchy hierarchy = (IHierarchy)obj;
        JSONObject jHierarchy = new JSONObject();
        JSONObject jItem = null;
        if (this.version30) {
            jItem = jHierarchy;
        } else {
            IMember rootMember;
            jItem = new JSONObject();
            jItem.put((Object)"queryItem", (Object)jHierarchy);
            if (hierarchy.isParentChild()) {
                jHierarchy.put((Object)"sourceCategory", (Object)"hierarchy/parent-child");
            } else {
                jHierarchy.put((Object)"sourceCategory", (Object)"hierarchy/level");
            }
            if (!hierarchy.isMultiRoot() && (rootMember = hierarchy.getRootMember()) != null) {
                if (hierarchy.isDMR()) {
                    jHierarchy.put((Object)"rootMember", (Object)this.getV5MUNForDMR(hierarchy, rootMember));
                } else {
                    jHierarchy.put((Object)"rootMember", (Object)rootMember.getV5MUN());
                }
            }
        }
        this.setIdForExpression(jHierarchy, this.getIdForExpression(parentId, obj));
        jHierarchy.put((Object)"identifier", (Object)GenerateModuleMetadataForPackage.getLastNamePart(hierarchy));
        this.setGenericAttributes(jHierarchy, hierarchy);
        jHierarchy.put((Object)"hierarchyHasMultipleRoots", (Object)hierarchy.isMultiRoot());
        jHierarchy.put((Object)"aggregateMode", (Object)"static");
        jHierarchy.put((Object)"regularAggregate", (Object)"count");
        jQueryItems.add((Object)jItem);
        return jHierarchy;
    }

    private String getIdPrefix() {
        if (this.idPrefix == null) {
            return "";
        }
        return this.idPrefix;
    }

    public String getV5MUNForDMR(IHierarchy hierarchy, IMember rootMember) {
        String firstPart;
        String[] nameParts;
        String lastPart = GenerateModuleMetadataForPackage.getLastNamePart(rootMember.getUniqueName());
        if (lastPart == null) {
            lastPart = rootMember.getUniqueName().substring(rootMember.getUniqueName().lastIndexOf("->") + 2);
        }
        if ((nameParts = UniqueNameParser.parseNoThrow(firstPart = hierarchy.getLevel(0).getV5UniqueName())) != null && nameParts.length > 1) {
            firstPart = UniqueNameGenerator.createUniqueName(nameParts[nameParts.length - 2], nameParts[nameParts.length - 1]);
        }
        String rootMemberName = UniqueNameGenerator.joinModelLogicalPhysicalParts(firstPart, lastPart, null);
        return rootMemberName;
    }

    protected JSONObject addQueryItem(String parentId, IMetadata obj, JSONArray jQueryItems, boolean inShortcut) {
        JSONObject jQI = new JSONObject();
        JSONObject jItem = null;
        IQueryItem qi = (IQueryItem)obj;
        this.setUsage(jQI, qi.getUsage());
        this.setFormat(jQI, qi.getFormat());
        jQI.put((Object)"regularAggregate", (Object)GenerateModuleMetadataForPackage.convertFMAggregate(qi.getRegularAggregate()));
        if (this.version30) {
            jItem = jQI;
        } else {
            jItem = new JSONObject();
            jItem.put((Object)"queryItem", (Object)jQI);
            if (obj instanceof IProperty) {
                jQI.put((Object)"sourceCategory", (Object)"property");
                jQI.put((Object)"aggregateMode", (Object)"static");
                if (!obj.isDMR()) {
                    jQI.put((Object)"regularAggregate", (Object)"doNotUse");
                }
            } else {
                jQI.put((Object)"sourceCategory", (Object)"column");
                jQI.put((Object)"aggregateMode", (Object)"dynamic");
            }
        }
        this.setIdForExpression(jQI, this.getIdForExpression(parentId, obj));
        jQI.put((Object)"identifier", (Object)GenerateModuleMetadataForPackage.getLastNamePart(qi));
        jQI.put((Object)"nullable", (Object)qi.isNullable());
        this.setGenericAttributes(jQI, qi);
        IDataType dt = this.getDataType(qi);
        if (dt != null) {
            this.setDataType(jQI, dt.toString());
            this.setHighLevelDataType(jQI, dt.toString());
        }
        if (!(obj instanceof IProperty)) {
            jQI.put((Object)"facetDefinition", (Object)this.getFacetDefinition(qi, qi.getUsage()));
        }
        if (qi.isHidden()) {
            jQI.put((Object)"hidden", (Object)true);
        }
        if (obj.getAvailableProperties().contains(MoserModuleUtil.PROMPT_TYPE)) {
            JSONObject jPromptInfo = new JSONObject();
            jQI.put(MoserModuleUtil.PROMPT_INFO, (Object)jPromptInfo);
            for (String prop : obj.getAvailableProperties()) {
                String value = (String)obj.getProperty(prop);
                if (MoserModuleUtil.PROMPT_TYPE.equals(prop)) {
                    jPromptInfo.put(MoserModuleUtil.PROMPT_TYPE, obj.getProperty(prop));
                    continue;
                }
                if (!MoserModuleUtil.PROMPT_CASCADE_ON_REF.equals(prop) && !MoserModuleUtil.PROMPT_FILTER_ITEM_REF.equals(prop) && !MoserModuleUtil.PROMPT_DISPLAY_ITEM_REF.equals(prop) && !MoserModuleUtil.PROMPT_USE_ITEM_REF.equals(prop)) continue;
                value = this.adjustPromptRefValue(value, parentId, obj.getID(), inShortcut);
                jPromptInfo.put((Object)prop, (Object)value);
            }
        }
        jQueryItems.add((Object)jItem);
        return jQI;
    }

    private String adjustPromptRefValue(String value, String parentId, String itemId, boolean inShortcut) {
        int idIndex;
        String leftIdParts;
        int valueIndex;
        String leftValueParts;
        if (inShortcut && (leftValueParts = value.substring(0, valueIndex = value.lastIndexOf(DOT_OPEN_SQUARE_BRACKET))).equals(leftIdParts = itemId.substring(0, idIndex = itemId.lastIndexOf(DOT_OPEN_SQUARE_BRACKET)))) {
            String rightValueParts = value.substring(valueIndex);
            return parentId + rightValueParts;
        }
        return this.idPrefix == null ? value : this.idPrefix + value;
    }

    protected String getIdForExpression(String parentId, IMetadata obj) {
        return parentId + "." + GenerateModuleMetadataForPackage.getLastNamePart(obj);
    }

    private void setFormat(JSONObject jObj, String format) {
        block4: {
            if (format == null || format.isEmpty()) {
                return;
            }
            try {
                jObj.put((Object)"format", (Object)this.fc.convert(format));
            }
            catch (MoserException e) {
                Throwable cause = e.getCause();
                if (cause == null || !(cause instanceof SAXException)) {
                    throw e;
                }
                if (!INFO_LOGGER.isOn()) break block4;
                INFO_LOGGER.log("Invalid format string: " + format);
            }
        }
    }

    private void setUsage(JSONObject jObj, String usage) {
        if (usage != null && !"unknown".equalsIgnoreCase(usage)) {
            jObj.put((Object)"usage", (Object)usage);
        }
    }

    public JSONObject getFacetDefinition(IMetadata mdObj, String usage) {
        String facetEnabled = "automatic";
        if (MoserModuleUtil.isFacetEnabled(mdObj, usage) == Boolean.FALSE) {
            facetEnabled = "false";
        }
        JSONObject jEnabled = new JSONObject();
        jEnabled.put((Object)"enabled", (Object)facetEnabled);
        return jEnabled;
    }

    protected static String convertFMAggregate(String fmAggr) {
        String rt = "automatic";
        if (fmAggr != null) {
            rt = "sum".equals(fmAggr) ? "total" : ("unsupported".equals(fmAggr) ? "none" : ("UNKNOWN".equals(fmAggr) || "unknown".equals(fmAggr) ? "automatic" : fmAggr));
        }
        return rt;
    }

    protected String addQuerySubject(IMetadata mdObj, JSONArray jQueryItems) {
        String identifier = this.getIdentifier(mdObj);
        if (this.allQuerySubjects.contains(mdObj)) {
            return identifier;
        }
        this.allQuerySubjects.add(mdObj);
        String name = mdObj.getCaption();
        if (this.jQuerySubjects == null) {
            this.jQuerySubjects = new JSONArray();
        }
        JSONObject jQS = new JSONObject();
        jQS.put((Object)"identifier", (Object)identifier);
        this.setIdForExpression(jQS, identifier);
        if (mdObj instanceof IShortcut) {
            String shortcutId = this.getIdentifier(((IShortcut)mdObj).getTarget());
            jQS.put((Object)"shortcutTargetQuerySubjectRef", (Object)shortcutId);
        }
        this.setGenericAttributes(jQS, mdObj);
        if (this.version30) {
            jQS.put((Object)"queryItem", (Object)jQueryItems);
        } else {
            jQS.put((Object)"item", (Object)jQueryItems);
            this.setSourceCategory(mdObj, jQS);
        }
        this.jQuerySubjects.add((Object)jQS);
        return identifier;
    }

    public void setSourceCategory(IMetadata mdObj, JSONObject jQS) {
        if (MetadataType.SHORTCUT.equals((Object)mdObj.getObjectType())) {
            this.setSourceCategory(((IShortcut)mdObj).getTarget(), jQS);
            return;
        }
        if (MetadataType.DIMENSION.equals((Object)mdObj.getObjectType())) {
            IDimension dim = (IDimension)mdObj;
            if (dim.isMeasuresDimension()) {
                jQS.put((Object)"sourceCategory", (Object)"dimension/measure");
            } else {
                jQS.put((Object)"sourceCategory", (Object)"dimension/regular");
            }
        } else {
            jQS.put((Object)"sourceCategory", (Object)"table");
        }
    }

    protected void addCalculationOrNamedSet(IMetadata obj, String internalId, boolean bInShortcut) {
        if (this.allCalculationsNamedSet.contains(obj)) {
            return;
        }
        this.allCalculationsNamedSet.add(obj);
        ICalculation cal = null;
        cal = obj instanceof IShortcut ? (ICalculation)((IShortcut)obj).getTarget() : (ICalculation)obj;
        JSONArray container = null;
        if (NAMED_SET.equals(cal.getCalcType())) {
            if (this.jNamedSets == null) {
                this.jNamedSets = new JSONArray();
            }
            container = this.jNamedSets;
            if (this.joinGraphCollector != null) {
                this.joinGraphCollector.addOLAPObject(cal, obj, bInShortcut);
            }
        } else {
            if (this.jCalculations == null) {
                this.jCalculations = new JSONArray();
            }
            container = this.jCalculations;
            if (this.joinGraphCollector != null) {
                this.joinGraphCollector.addRelationObject(internalId, cal);
            }
        }
        JSONObject jCal = new JSONObject();
        jCal.put((Object)"identifier", (Object)internalId);
        this.setIdForExpression(jCal, internalId);
        this.setGenericAttributes(jCal, obj);
        this.addCalcProperties(cal, jCal);
        container.add((Object)jCal);
    }

    private void addCalcProperties(ICalculation cal, JSONObject jCal) {
        if (NAMED_SET.equals(cal.getCalcType())) {
            jCal.put((Object)"usage", (Object)"attribute");
            INamedSet ns = (INamedSet)((Object)cal);
            if (ns.getHierarchy() != null) {
                jCal.put((Object)"refToHierarchy", (Object)(this.getIdPrefix() + ns.getHierarchy().getV5UniqueName()));
            }
            jCal.put((Object)"usage", (Object)"attribute");
            jCal.put((Object)"aggregateMode", (Object)"static");
            jCal.put((Object)"regularAggregate", (Object)"count");
        } else {
            String dt = null;
            IDataType datatype = this.getDataType(cal);
            if (datatype != null) {
                dt = datatype.toString();
            }
            this.setDataType(jCal, dt);
            this.setUsage(jCal, cal.getUsage());
            if ("macros".equals(cal.getCalcType())) {
                jCal.put((Object)"aggregateMode", (Object)"static");
            } else {
                jCal.put((Object)"aggregateMode", (Object)"dynamic");
            }
            jCal.put((Object)"regularAggregate", (Object)GenerateModuleMetadataForPackage.convertFMAggregate(cal.getRegularAggregate()));
            this.setHighLevelDataType(jCal, dt);
            if (!this.version30) {
                this.setFormat(jCal, cal.getFormat());
            }
        }
        if (!this.version30) {
            String srcCategory = "calculation";
            if (NAMED_SET.equals(cal.getCalcType())) {
                srcCategory = NAMED_SET;
            }
            jCal.put((Object)"sourceCategory", (Object)srcCategory);
        }
    }

    public void setHighLevelDataType(JSONObject jObj, String dt) {
        String hlDT = null;
        if (dt != null && !UnknownType.UNKNOWNTYPE.toString().equals(dt)) {
            hlDT = ReferenceResolver.generateHighLevelDatatype(dt);
        }
        if (hlDT != null) {
            jObj.put((Object)"highlevelDatatype", (Object)ReferenceResolver.generateHighLevelDatatype(dt));
        }
    }

    public void addNamedSetProperties(INamedSet namedSet, JSONObject jNamedSet) {
        jNamedSet.put((Object)"usage", (Object)"attribute");
        if (namedSet.getHierarchy() != null) {
            jNamedSet.put((Object)"refToHierarchy", (Object)(this.getIdPrefix() + namedSet.getHierarchy().getV5UniqueName()));
        }
        jNamedSet.put((Object)"usage", (Object)"attribute");
        jNamedSet.put((Object)"aggregateMode", (Object)"static");
        jNamedSet.put((Object)"regularAggregate", (Object)"count");
        if (!this.version30) {
            String srcCategory = NAMED_SET;
            jNamedSet.put((Object)"sourceCategory", (Object)srcCategory);
        }
    }

    protected void addFilter(IMetadata obj, String internalId) {
        if (this.allFilters.contains(obj)) {
            return;
        }
        this.allFilters.add(obj);
        if (this.jFilters == null) {
            this.jFilters = new JSONArray();
        }
        JSONObject jFilter = new JSONObject();
        jFilter.put((Object)"identifier", (Object)internalId);
        this.setIdForExpression(jFilter, internalId);
        this.setGenericAttributes(jFilter, obj);
        this.jFilters.add((Object)jFilter);
    }

    public void setIdForExpression(JSONObject jObj, String idForExpression) {
        jObj.put((Object)"idForExpression", (Object)idForExpression);
    }

    protected void createMDTV() {
        if (this.allObjects.isEmpty()) {
            return;
        }
        INamespace root = this.connection.getRootNamespace();
        HashMap<List<IMetadata>, JSONObject> seenFolders = new HashMap<List<IMetadata>, JSONObject>();
        this.jMDTV = new JSONArray();
        JSONObject jRootFolder = this.createFolder(root);
        this.jMDTV.add((Object)jRootFolder);
        for (int objPos = 0; objPos < this.allObjects.size(); ++objPos) {
            ArrayList<IMetadata> objChain = this.allObjects.get(objPos);
            String interalRefId = this.getReferencedObjectInternalId(objChain);
            if (EMPTY_QS.equals(interalRefId)) continue;
            ArrayList<IMetadata> ancestors = new ArrayList<IMetadata>();
            int start = 1;
            if (!this.version30 && objChain.size() > 0 && objChain.get(0) != root) {
                start = 0;
            }
            int pos = objChain.size() - 1;
            for (int i = start; i < pos; ++i) {
                ancestors.add(objChain.get(i));
            }
            IMetadata obj = objChain.get(pos);
            JSONObject jFolder = this.createFolders(ancestors, jRootFolder, seenFolders);
            JSONArray folderItems = (JSONArray)jFolder.get((Object)FOLDERITEM);
            if (folderItems == null) {
                folderItems = new JSONArray();
                jFolder.put((Object)FOLDERITEM, (Object)folderItems);
            }
            JSONObject aRefItem = this.createDefLink(obj, interalRefId);
            folderItems.add((Object)aRefItem);
            this.createDrillGroupForOLAP(obj);
        }
    }

    private void createDrillGroupForOLAP(IMetadata obj) {
        IMetadata localObj = obj;
        boolean inShortcut = false;
        if (localObj instanceof IShortcut) {
            localObj = ((IShortcut)localObj).getTarget();
            inShortcut = true;
        }
        if (!(localObj instanceof IDimension) || localObj instanceof IMeasureDimension) {
            return;
        }
        if (!this.isVisible(obj, inShortcut)) {
            return;
        }
        IDimension dim = (IDimension)localObj;
        for (IHierarchy hierarchy : dim.getHierarchies()) {
            if (!this.isVisible(hierarchy, inShortcut)) continue;
            String hierarchyID = this.getIdentifier(obj) + "." + GenerateModuleMetadataForPackage.getLastNamePart(hierarchy.getID());
            JSONObject drillGroup = null;
            JSONArray segments = null;
            for (IMetadata hierarchyChild : hierarchy.getChildMetadataObjects()) {
                if (!(hierarchyChild instanceof ILevel)) continue;
                ILevel level = (ILevel)hierarchyChild;
                if (drillGroup == null) {
                    drillGroup = new JSONObject();
                    drillGroup.put((Object)"identifier", (Object)hierarchyID);
                    this.setGenericAttributes(drillGroup, hierarchy);
                    drillGroup.put((Object)"hidden", (Object)true);
                    segments = new JSONArray();
                    drillGroup.put((Object)"segment", (Object)segments);
                    if (this.jDrillGroups == null) {
                        this.jDrillGroups = new JSONArray();
                    }
                    this.jDrillGroups.add((Object)drillGroup);
                }
                JSONObject segmentForLevel = new JSONObject();
                String levelName = GenerateModuleMetadataForPackage.getLastNamePart(level.getID());
                String levelID = hierarchyID + "." + levelName;
                segmentForLevel.put((Object)"identifier", (Object)levelName);
                this.setGenericAttributes(segmentForLevel, level);
                segmentForLevel.put((Object)"ref", (Object)levelID);
                segments.add((Object)segmentForLevel);
            }
        }
    }

    private boolean isNamespaceOrShortcutToNamespace(IMetadata obj) {
        MetadataType tp = obj.getObjectType();
        if (MetadataType.NAMESPACE.equals((Object)tp)) {
            return true;
        }
        if (MetadataType.SHORTCUT.equals((Object)tp)) {
            IMetadata target = ((IShortcut)obj).getTarget();
            return MetadataType.NAMESPACE.equals((Object)target.getObjectType());
        }
        return false;
    }

    protected JSONObject createDefLink(IMetadata obj, String interalRefId) {
        JSONObject rt = new JSONObject();
        JSONObject def = new JSONObject();
        this.setIdentifier(obj, def);
        this.setGenericAttributes(def, obj);
        def.put((Object)"ref", (Object)interalRefId);
        rt.put((Object)DEFLINK, (Object)def);
        return rt;
    }

    public void setIdentifier(IMetadata obj, JSONObject md) {
        if (this.isNamespaceOrShortcutToNamespace(obj) && !obj.isVisible(this.onlyCheckIfAccessible)) {
            return;
        }
        String identifier = null;
        identifier = obj.getID();
        if (identifier != null) {
            md.put((Object)"identifier", (Object)identifier);
        }
    }

    protected JSONObject createFolders(ArrayList<IMetadata> ancestors, JSONObject jRootFolder, HashMap<List<IMetadata>, JSONObject> seen) {
        if (ancestors.isEmpty()) {
            return jRootFolder;
        }
        JSONObject parent = jRootFolder;
        for (int i = 0; i < ancestors.size(); ++i) {
            ArrayList<IMetadata> folders = new ArrayList<IMetadata>(i + 1);
            for (int j = 0; j <= i; ++j) {
                folders.add(ancestors.get(j));
            }
            JSONObject current = seen.get(folders);
            if (current != null) {
                parent = current;
                continue;
            }
            IMetadata aFolder = ancestors.get(i);
            current = this.createFolder(aFolder);
            JSONArray folderItems = (JSONArray)parent.get((Object)FOLDERITEM);
            if (folderItems == null) {
                folderItems = new JSONArray();
                parent.put((Object)FOLDERITEM, (Object)folderItems);
            }
            JSONObject folderItem = new JSONObject();
            folderItem.put((Object)FOLDER, (Object)current);
            folderItems.add((Object)folderItem);
            parent = current;
            seen.put(folders, parent);
        }
        return parent;
    }

    protected JSONObject createFolder(IMetadata folder) {
        JSONObject rt = new JSONObject();
        this.setGenericAttributes(rt, folder);
        return rt;
    }

    protected void createMetadataResponse() {
        JSONArray use = new JSONArray();
        if (this.modelPath != null && this.modelPath.endsWith("model.xml")) {
            use.add((Object)this.packageName);
        } else {
            use.add((Object)this.modelPath);
        }
        this.mdResponse.put((Object)"use", (Object)use);
        if (this.jQuerySubjects != null) {
            this.mdResponse.put((Object)"querySubject", (Object)this.jQuerySubjects);
        }
        if (this.jCalculations != null) {
            this.mdResponse.put((Object)"calculation", (Object)this.jCalculations);
        }
        if (this.jNamedSets != null) {
            this.mdResponse.put((Object)NAMED_SET, (Object)this.jNamedSets);
        }
        if (this.jFilters != null) {
            this.mdResponse.put((Object)"filter", (Object)this.jFilters);
        }
        if (this.jDrillGroups != null) {
            this.mdResponse.put((Object)"drillGroup", (Object)this.jDrillGroups);
        }
        if (this.jMDTV != null) {
            this.mdResponse.put((Object)MDTV, (Object)this.jMDTV);
        }
        if (this.jCubes != null && !this.jCubes.isEmpty()) {
            this.mdResponse.put((Object)"dataSource", (Object)this.jCubes);
        }
    }

    private Element generateMetadataResponse() {
        return this.generateMetadataResponse(this.mdResponse.toString());
    }

    protected Element generateMetadataResponse(String response) {
        Element elemResponse = DocumentHelper.createElement((String)RESPONSE);
        Element result = DocumentHelper.createElement((String)RESULT);
        elemResponse.add(result);
        Element itemEle = DocumentHelper.createElement((String)"item");
        result.add(itemEle);
        if (this.getPrettyPrint()) {
            itemEle.setText(JSONUtil.prettyPrint(response));
        } else {
            itemEle.setText(response);
        }
        return elemResponse;
    }

    protected boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    protected void setPrettyPrint(boolean v) {
        this.prettyPrint = v;
    }

    static {
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.QUERY_SUBJECT);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.CALCULATION);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.FILTER);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.FOLDER);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.SHORTCUT);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.NAMESPACE);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.QUERY_ITEM);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.DIMENSION);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.HIERARCHY);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.LEVEL);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.MEASURE);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.MEMBER);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.NAMED_SET);
        SUPPORTED_TYPES_RELATIONAL_AND_OLAP.add(MetadataType.DATASOURCE);
        SUPPORTED_TYPES_RELATIONAL_ONLY = new HashSet();
        SUPPORTED_TYPES_RELATIONAL_ONLY.add(MetadataType.QUERY_SUBJECT);
        SUPPORTED_TYPES_RELATIONAL_ONLY.add(MetadataType.CALCULATION);
        SUPPORTED_TYPES_RELATIONAL_ONLY.add(MetadataType.FILTER);
        SUPPORTED_TYPES_RELATIONAL_ONLY.add(MetadataType.FOLDER);
        SUPPORTED_TYPES_RELATIONAL_ONLY.add(MetadataType.SHORTCUT);
        SUPPORTED_TYPES_RELATIONAL_ONLY.add(MetadataType.NAMESPACE);
        SUPPORTED_TYPES_RELATIONAL_ONLY.add(MetadataType.QUERY_ITEM);
    }
}

