/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.V5Constants;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.RelationalCrosstabCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.rsapi.RSAPIRowCallback;
import com.cognos.xqe.transformation.moser.GenerateV5QueryForTableStatistics;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class GenerateV5QueryFromMoserTableQuery {
    private static final String MODULE = "module";
    private static final String QUERYSUBJECT = "querySubject";
    private static final String RESULTCOUNT = "resultCount";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ITEM = "item";
    private static final String NAGS = "nags";
    private static final String QUERY_NAME = "QueryMoserValues";
    private static final String QRD_NAME = "QueryMoserValuesQRD";
    private static final String EDGE_NAME = "QueryMoserValuesEdge";
    private static final String VALUESET_NAME = "QueryMoserValuesValueSet";
    private static final String GROUPBODY_NAME = "QueryMoserValuesGroupBody";
    public static final String RESPONSE = "getTableValuesResponse";
    public static final String RESULT = "getTableValuesResult";
    private static final String COLUMN_NAMES = "columnNames";
    private static final String COLUMN_LABELS = "columnLabels";
    private static final String ROWS = "rows";
    private static final String COLUMNS = "columns";
    private static final String TABULAR = "tabular";
    private static final String OUPUT_TYPE = "outputType";
    private static final String QUERYITEMS = "projections";
    private static final String IDENTIFIER = "identifier";
    private static final String AUTOSUMMARIZE = "autoSummary";

    public static V5QuerySet generateV5QuerySet(PlanningEnvironment environment, Element functionSpec) {
        List<IModelDataSource> dataSources;
        XQENodeFactory factory = environment.getNodeFactory();
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        environment.getNodeIndex().addNode(querySet);
        environment.setRoot(querySet);
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        v5Query.setPropertyValue(NAME, QUERY_NAME);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), "true");
        V5Source source = (V5Source)factory.createNode(101007);
        v5Query.addChild(source);
        String module = null;
        String querySubject = null;
        String resultCount = null;
        String offset = "0";
        String queryItems = null;
        String autoSummarize = null;
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String v;
            Element child = (Element)children.get(i);
            List nameValue = child.elements();
            HashMap<String, String> mp = new HashMap<String, String>();
            for (int j = 0; j < nameValue.size(); ++j) {
                Element e = (Element)nameValue.get(j);
                String eName = e.getName();
                mp.put(eName, e.getText());
            }
            String key = (String)mp.get(NAME);
            if (key == null || (v = (String)mp.get(VALUE)) == null) continue;
            if (MODULE.equals(key)) {
                module = v;
                continue;
            }
            if (QUERYSUBJECT.equals(key)) {
                querySubject = v;
                continue;
            }
            if (RESULTCOUNT.equals(key)) {
                resultCount = v;
                continue;
            }
            if ("offset".equals(key)) {
                offset = v;
                continue;
            }
            if (QUERYITEMS.equals(key)) {
                queryItems = v;
                continue;
            }
            if (!AUTOSUMMARIZE.equals(key)) continue;
            autoSummarize = v;
        }
        if (module == null || querySubject == null || resultCount == null) {
            int numParam = 0;
            if (module != null) {
                ++numParam;
            }
            if (querySubject != null) {
                ++numParam;
            }
            if (resultCount != null) {
                ++numParam;
            }
            throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidMoserCommandSpec, (Object)"getTableValues", (Object)"3", (Object)numParam);
        }
        querySet.setPropertyValue("modelPath", module);
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (metadataConnection == null) {
            source.setModel(module);
            source.setModelType(MODULE);
        } else {
            source.setModel(metadataConnection.getModelPath());
            source.setModelType(metadataConnection.getModelType());
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
            metadataConnection = MetadataService.getInstance().getConnection("MOSER", module, execEnv, true);
            MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        }
        if ((dataSources = metadataConnection.getModelDataSources()) != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        environment.setMetdataConnection(metadataConnection);
        source.setIsBound();
        IXQEQueryNode selection = factory.createNode(101009);
        v5Query.addChild(selection);
        if (autoSummarize == null || autoSummarize.equals("false")) {
            ((V5Selection)selection).setAutoSummary(false);
        }
        MoserMetadataConnection moserConn = (MoserMetadataConnection)metadataConnection;
        IMetadata metadata = moserConn.bindQuerySubjectReference(querySubject);
        JSONArray projections = null;
        if (queryItems != null) {
            try {
                projections = JSONArray.parse((String)queryItems);
            }
            catch (IOException e1) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat);
            }
        }
        List<Object> attList = null;
        if (metadata instanceof IShortcut) {
            metadata = ((IShortcut)metadata).getTarget();
        }
        if (metadata instanceof IQuerySubject) {
            IQuerySubject qs = (IQuerySubject)metadata;
            attList = qs.getQueryItemsAndMeasures();
            if (attList == null || attList.isEmpty()) {
                throw new XQERuntimeException(XQEMessageKeys.MSR_InvalidQuerySubject, qs.getName());
            }
        } else {
            attList = new ArrayList<IMetadata>();
            attList.add(metadata);
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(qrd);
        if (!resultCount.equals("-1")) {
            String topNRows = Long.toString(Long.valueOf(resultCount) + Long.valueOf(offset));
            qrd.setPropertyValue("topNRows", topNRows);
        }
        qrd.setPropertyValue(NAME, QRD_NAME);
        qrd.setRefQueryProperty(QUERY_NAME);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        edge.setPropertyValue(NAME, EDGE_NAME);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
        edgeGroup.addChild(valueSet);
        valueSet.setNameProperty(VALUESET_NAME);
        IXQEQueryNode groupBody = factory.createNode(101051);
        valueSet.addChild(groupBody);
        groupBody.setPropertyValue(NAME, GROUPBODY_NAME);
        int ci = 0;
        if (projections != null) {
            for (Object p : projections.toArray()) {
                JSONObject projection = (JSONObject)p;
                String id = (String)projection.get((Object)IDENTIFIER);
                String[] nameParts = id.split("\\.");
                id = nameParts[nameParts.length - 1];
                for (IMetadata iMetadata : attList) {
                    if (!iMetadata.getName().equals(id)) continue;
                    String diName = GenerateV5QueryFromMoserTableQuery.createDataItemName(Integer.toString(ci++));
                    GenerateV5QueryFromMoserTableQuery.createDataItem(metadataConnection, iMetadata, factory, selection, diName, (String)projection.get((Object)"aggregate"));
                    String sort = (String)projection.get((Object)"sort");
                    if (sort != null) {
                        V5SortItem sortItem = (V5SortItem)factory.createNode(101056);
                        sortItem.setPropertyValue("refDataItem", diName);
                        sortItem.setPropertyValue("sortOrder", sort);
                        valueSet.addChild(sortItem);
                    }
                    IXQEQueryNode dataItemRef = factory.createNode(101015);
                    dataItemRef.setPropertyValue("refDataItem", diName);
                    groupBody.addChild(dataItemRef);
                }
            }
        } else {
            for (IMetadata iMetadata : attList) {
                String diName = GenerateV5QueryFromMoserTableQuery.createDataItemName(Integer.toString(ci++));
                GenerateV5QueryFromMoserTableQuery.createDataItem(metadataConnection, iMetadata, factory, selection, diName, null);
                IXQEQueryNode dataItemRef = factory.createNode(101015);
                dataItemRef.setPropertyValue("refDataItem", diName);
                groupBody.addChild(dataItemRef);
            }
        }
        return querySet;
    }

    public static String createDataItemName(String name) {
        return "c" + name;
    }

    private static void createDataItem(MetadataConnection metadataConnection, IMetadata md, XQENodeFactory factory, IXQEQueryNode selection, String name, String aggregate) {
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        selection.addChild(dataItem);
        dataItem.setPropertyValue(NAME, name);
        if (aggregate != null) {
            if (aggregate.equals("count")) {
                dataItem.setAggregateProperty("countDistinct");
            } else {
                dataItem.setAggregateProperty(aggregate);
            }
        }
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)factory.createNode(201116);
        boundNode.setMetadata(md);
        dataItem.addChild(boundNode);
    }

    public static Element generateResponse(ExecutionEnvironment executionEnvironment, RSAPIDataset dataset, Element functionSpec) {
        GenerateV5QueryFromMoserTableQuery q = new GenerateV5QueryFromMoserTableQuery();
        return q.generateResponseLoadDataSet(executionEnvironment, dataset, functionSpec);
    }

    public static void addJsonStringValueToResponse(Element input, String key, String value) {
        Element item = input.element(RESULT).element(ITEM);
        String str = item.getText();
        try {
            JSONObject json = JSONObject.parse((String)str);
            json.put((Object)key, (Object)value);
            item.setText(json.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Element generateResponseLoadDataSet(ExecutionEnvironment executionEnvironment, RSAPIDataset dataset, Element functionSpec) {
        Element elemResponse = DocumentHelper.createElement((String)RESPONSE);
        Element elemResult = DocumentHelper.createElement((String)RESULT);
        elemResponse.add(elemResult);
        Element elemItem = DocumentHelper.createElement((String)ITEM);
        elemResult.add(elemItem);
        JSONObject result = new JSONObject();
        JSONArray nagArray = new JSONArray();
        List<Nag> nagsList = executionEnvironment.getNagCollector().getNagMessages();
        for (Nag nag : nagsList) {
            nagArray.add((Object)nag.getMessage());
        }
        result.put((Object)NAGS, (Object)nagArray);
        String outputType = MoserCommandUtil.getNamedValue(functionSpec, OUPUT_TYPE);
        String offset = MoserCommandUtil.getNamedValue(functionSpec, "offset");
        long off = 0L;
        if (offset != null) {
            off = Long.valueOf(offset);
        }
        JSONArray projections = null;
        String moserFunctionType = MoserCommandUtil.getNamedValue(functionSpec, "moserFunctionType");
        if (V5Constants.GETJOINVALUES.equals(moserFunctionType)) {
            String joinSpecStr = MoserCommandUtil.getNamedValue(functionSpec, "joinSpec");
            JSONObject joinSpec = null;
            try {
                joinSpec = JSONObject.parse((String)joinSpecStr);
            }
            catch (IOException e1) {
                throw new XQERuntimeException(XQEMessageKeys.EXE_InvalidJSONFormat);
            }
            projections = (JSONArray)joinSpec.get((Object)QUERYITEMS);
        }
        RSAPIRowCallback callback = null;
        if ("getTableStatistics".equals(moserFunctionType)) {
            GenerateV5QueryForTableStatistics generateV5QueryForTableStatistics = new GenerateV5QueryForTableStatistics();
            generateV5QueryForTableStatistics.getClass();
            callback = new GenerateV5QueryForTableStatistics.RowHandler(generateV5QueryForTableStatistics, result, dataset);
        } else {
            callback = TABULAR.equals(outputType) ? new TabularRowHandler(result, projections, dataset, off) : new ColumnarRowHandler(result, projections, dataset, off);
        }
        RelationalCrosstabCube.loadFromTabularQuery(dataset, callback);
        elemItem.setText(result.toString());
        return elemResponse;
    }

    private final class ColumnarRowHandler
    implements RSAPIRowCallback {
        private JSONObject root;
        private JSONArray columns;
        private long offset;

        ColumnarRowHandler(JSONObject r, JSONArray projections, RSAPIDataset dataset, long off) {
            this.root = r;
            this.offset = off;
            this.columns = new JSONArray();
            JSONArray colNames = new JSONArray();
            JSONArray colLabels = new JSONArray();
            RSAPIColumn[] rsColumns = dataset.getEdge(0).getRowset(0).getColumns();
            for (int i = 0; i < rsColumns.length; ++i) {
                RSAPIColumn c = rsColumns[i];
                if (projections == null) {
                    if (c.getBaseRefDataItem().getModelReference() != null) {
                        colNames.add((Object)MoserCommandUtil.generateColumnNameForRespones(c.getBaseRefDataItem().getModelReference()));
                    } else {
                        colNames.add((Object)c.getBaseRefDataItem().getName());
                    }
                } else {
                    JSONObject projection = (JSONObject)projections.get(i);
                    colNames.add(projection.get((Object)GenerateV5QueryFromMoserTableQuery.IDENTIFIER));
                }
                colLabels.add((Object)c.getLabel());
                this.columns.add((Object)new JSONArray());
            }
            this.root.put((Object)GenerateV5QueryFromMoserTableQuery.COLUMN_NAMES, (Object)colNames);
            this.root.put((Object)GenerateV5QueryFromMoserTableQuery.COLUMN_LABELS, (Object)colLabels);
            this.root.put((Object)GenerateV5QueryFromMoserTableQuery.COLUMNS, (Object)this.columns);
        }

        @Override
        public void consumeRow(RSAPIRow aRow, RSAPIColumn[] rsColumns, FormatId[] formatIDs) {
            if (this.offset > 0L) {
                --this.offset;
                return;
            }
            for (int i = 0; i < rsColumns.length; ++i) {
                JSONObject jObj;
                Value v = (Value)aRow.getColumn(i);
                if (v == null) {
                    jObj = new JSONObject();
                    jObj.put((Object)ValueState.NULL.toString(), (Object)"true");
                    ((JSONArray)this.columns.get(i)).add((Object)jObj);
                    continue;
                }
                if (!v.isOK()) {
                    jObj = new JSONObject();
                    jObj.put((Object)v.getState().toString(), (Object)"true");
                    ((JSONArray)this.columns.get(i)).add((Object)jObj);
                    continue;
                }
                v.setFormatId(formatIDs[i]);
                try {
                    String value = v.getV5formattedString();
                    ((JSONArray)this.columns.get(i)).add((Object)value);
                    continue;
                }
                catch (Exception e) {
                    JSONObject jObj2 = new JSONObject();
                    jObj2.put((Object)ValueState.ERROR.toString(), (Object)e.getMessage());
                    ((JSONArray)this.columns.get(i)).add((Object)jObj2);
                }
            }
        }

        @Override
        public boolean reRun() {
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }
    }

    private final class TabularRowHandler
    implements RSAPIRowCallback {
        private JSONObject root;
        private JSONArray rows;
        private long offset;

        TabularRowHandler(JSONObject r, JSONArray projections, RSAPIDataset dataset, long off) {
            this.root = r;
            this.offset = off;
            JSONArray colNames = new JSONArray();
            JSONArray colLabels = new JSONArray();
            RSAPIColumn[] columns = dataset.getEdge(0).getRowset(0).getColumns();
            for (int i = 0; i < columns.length; ++i) {
                RSAPIColumn c = columns[i];
                if (projections == null) {
                    colNames.add((Object)MoserCommandUtil.generateColumnNameForRespones(c.getBaseRefDataItem().getModelReference()));
                } else {
                    JSONObject projection = (JSONObject)projections.get(i);
                    colNames.add(projection.get((Object)GenerateV5QueryFromMoserTableQuery.IDENTIFIER));
                }
                colLabels.add((Object)c.getLabel());
            }
            this.root.put((Object)GenerateV5QueryFromMoserTableQuery.COLUMN_NAMES, (Object)colNames);
            this.root.put((Object)GenerateV5QueryFromMoserTableQuery.COLUMN_LABELS, (Object)colLabels);
            this.rows = new JSONArray();
            this.root.put((Object)GenerateV5QueryFromMoserTableQuery.ROWS, (Object)this.rows);
        }

        @Override
        public void consumeRow(RSAPIRow aRow, RSAPIColumn[] columns, FormatId[] formatIDs) {
            if (this.offset > 0L) {
                --this.offset;
                return;
            }
            JSONArray row = new JSONArray();
            for (int i = 0; i < columns.length; ++i) {
                Value v = (Value)aRow.getColumn(i);
                if (v == null) continue;
                if (!v.isOK()) {
                    JSONObject jObj = new JSONObject();
                    jObj.put((Object)v.getState().toString(), (Object)"true");
                    row.add((Object)jObj);
                    continue;
                }
                v.setFormatId(formatIDs[i]);
                String value = v.getV5formattedString();
                row.add((Object)value);
            }
            this.rows.add((Object)row);
        }

        @Override
        public boolean reRun() {
            return false;
        }

        @Override
        public boolean needReIterateRows() {
            return false;
        }
    }
}

