/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.modquery.ModDataItem;
import com.cognos.xqe.ast.v5.modquery.ModFilter;
import com.cognos.xqe.ast.v5.modquery.ModQuery;
import com.cognos.xqe.ast.v5.modquery.ModQueryUtil;
import com.cognos.xqe.ast.v5.modquery.ModSet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5JoinOperand;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5OrderedValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.moser.util.ConvertModQueryToV5QueryUtil;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class ContextDependentModQueryToV5QueryUtil {
    protected static final String BASE_QUERY = "_baseQuery";
    protected static final String SUB_QUERY = "_subQuery";
    protected static final String FILTER_QUERY = "_filterQuery";
    protected static final String SORT_QUERY = "_sortQuery";
    protected static final String S_COLUMN = "_s";
    protected static final String A_COLUMN = "_a";
    protected static final String R_COLUMN = "_r";
    public static final String KEEP_DEFINED_AUTOSUMMARY = "keepDefinedAutoSummary";

    public static boolean hasContextDependentSet(V5QueryResultDefinition qrd, ModQuery modQuery) {
        IXQEQueryNode[] items;
        Set<String> requiredItems = ConvertModQueryToV5QueryUtil.getReferencedDataItemNames(qrd);
        for (IXQEQueryNode item : items = modQuery.getDescendantsOfType(101081, false)) {
            String name = (String)item.getPropertyValue("name");
            if (!requiredItems.contains(name) || !ContextDependentModQueryToV5QueryUtil.hasContextDependentSet(item)) continue;
            return true;
        }
        IXQEQueryNode modFilters = modQuery.getFirstChildByType(101091);
        if (modFilters == null) {
            return false;
        }
        for (IXQEQueryNode modFilter : modFilters.getDescendantsOfType(101092, false)) {
            IXQEQueryNode[] filterdef;
            String use = (String)modFilter.getPropertyValue("use");
            if (use != null && use.equals(ModFilter.USE_DISABLED)) continue;
            if (ContextDependentModQueryToV5QueryUtil.hasContextDependentSet(modFilter)) {
                return true;
            }
            for (IXQEQueryNode f : filterdef = modFilter.getDescendantsOfTypes(ModQueryUtil.MOD_FILTER_TYPES, false)) {
                String refItem = (String)f.getPropertyValue("refDataItem");
                ModDataItem itemDef = modQuery.getModDataItemByName(refItem);
                if (itemDef == null || !ContextDependentModQueryToV5QueryUtil.hasContextDependentSet(itemDef)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean hasContextDependentSet(IXQEQueryNode itemDef) {
        List<IXQEQueryNode> sets = itemDef.getDescendantsOfCategory(101108, false);
        for (IXQEQueryNode st : sets) {
            ModSet modSet = (ModSet)st;
            if (!modSet.isContextDependent()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertContextDependentModQueryToV5Query(PlanningEnvironment environment, ModQuery modQuery, V5QueryResultDefinition qrd) {
        CommonObjectsParam param = new CommonObjectsParam();
        param.modQuery = modQuery;
        param.environment = environment;
        param.nodeFactory = environment.getNodeFactory();
        param.querySet = (V5QuerySet)qrd.getParent();
        param.bXtab = !qrd.isList();
        MetadataConnectionContext mc = null;
        V5Query[] v5Query = new V5Query[]{null};
        MetadataConnection[] metadataConnection = new MetadataConnection[]{null};
        try {
            String use;
            mc = ConvertModQueryToV5QueryUtil.generateV5QueryFromModQuery(environment, modQuery, param.querySet, v5Query, metadataConnection);
            param.v5Query = v5Query[0];
            param.v5Query.setPropertyValue("isTabular", Boolean.TRUE);
            param.v5Query.setPropertyValue("isRelStyle", Boolean.TRUE);
            param.v5Query.setIsReferenced();
            param.qName = param.v5Query.getV5QueryName();
            param.metadataConnection = metadataConnection[0];
            param.projectedItemName = ConvertModQueryToV5QueryUtil.getReferencedDataItemNames(qrd);
            ContextDependentModQueryToV5QueryUtil.preConvertModFilters(param);
            IXQEQueryNode[] edges = qrd.getChildrenOfType(101049);
            for (IXQEQueryNode edge : edges) {
                IXQEQueryNode[] children = edge.getChildrenOfType(101050);
                LinkedList<String> contextStack = new LinkedList<String>();
                ContextDependentModQueryToV5QueryUtil.convertEdgeGroup(param, children[0], contextStack);
            }
            for (IXQEQueryNode preModFilter : param.preAggregateDetailFilters) {
                V5DetailFilter detailFilter = ContextDependentModQueryToV5QueryUtil.createV5DetailFilterFromModFilter(param, preModFilter, false);
                detailFilter.setPostAutoAggregation(false);
                use = (String)preModFilter.getPropertyValue("use");
                if (use.equals(ModFilter.USE_REQUIRED)) {
                    detailFilter.setUseProperty("required");
                } else if (use.equals(ModFilter.USE_OPTIONAL)) {
                    detailFilter.setUseProperty("optional");
                }
                for (Pair sortP : param.modSortQueries) {
                    IXQEQueryNode sortQuery = (IXQEQueryNode)sortP.getFirst();
                    sortQuery.addChild(param.nodeFactory.deepCopyNode(detailFilter));
                }
                for (Pair filterP : param.modFilterQueries) {
                    IXQEQueryNode filterQuery = (IXQEQueryNode)filterP.getFirst();
                    filterQuery.addChild(param.nodeFactory.deepCopyNode(detailFilter));
                }
                param.v5Query.addChild(detailFilter);
            }
            for (int i = 0; i < param.postAggregateAttributeDetailFilters.size(); ++i) {
                Pair postAttributeModFilterP = (Pair)param.postAggregateAttributeDetailFilters.get(i);
                IXQEQueryNode postAttributeModFilter = (IXQEQueryNode)postAttributeModFilterP.getFirst();
                V5DetailFilter detailFilter = ContextDependentModQueryToV5QueryUtil.createV5DetailFilterFromModFilter(param, postAttributeModFilter, false);
                detailFilter.setPostAutoAggregation(false);
                String use2 = (String)postAttributeModFilter.getPropertyValue("use");
                if (use2.equals(ModFilter.USE_REQUIRED)) {
                    detailFilter.setUseProperty("required");
                } else if (use2.equals(ModFilter.USE_OPTIONAL)) {
                    detailFilter.setUseProperty("optional");
                }
                for (Pair sortP : param.modSortQueries) {
                    IXQEQueryNode sortQuery = (IXQEQueryNode)sortP.getFirst();
                    SubQueryInfo info = (SubQueryInfo)sortP.getSecond();
                    if (!info.postAggregateFilters.contains(i)) continue;
                    sortQuery.addChild(param.nodeFactory.deepCopyNode(detailFilter));
                }
                boolean bApplied = false;
                for (Pair filterP : param.modFilterQueries) {
                    IXQEQueryNode filterQuery = (IXQEQueryNode)filterP.getFirst();
                    SubQueryInfo info = (SubQueryInfo)filterP.getSecond();
                    if (!info.postAggregateFilters.contains(i)) continue;
                    bApplied = true;
                    filterQuery.addChild(param.nodeFactory.deepCopyNode(detailFilter));
                }
                if (bApplied) continue;
                param.v5Query.addChild(detailFilter);
            }
            for (IXQEQueryNode postModFilter : param.postAggregateMeasureDetailFilters) {
                V5DetailFilter detailFilter = ContextDependentModQueryToV5QueryUtil.createV5DetailFilterFromModFilter(param, postModFilter, true);
                detailFilter.setPostAutoAggregation(true);
                use = (String)postModFilter.getPropertyValue("use");
                if (use.equals(ModFilter.USE_REQUIRED)) {
                    detailFilter.setUseProperty("required");
                } else if (use.equals(ModFilter.USE_OPTIONAL)) {
                    detailFilter.setUseProperty("optional");
                }
                param.v5Query.addChild(detailFilter);
            }
            V5Query topQuery = param.v5Query;
            for (int i = 0; i < param.modSortQueries.size(); ++i) {
                Pair p = (Pair)param.modSortQueries.get(i);
                String reName = param.qName;
                reName = i > 0 ? reName + SUB_QUERY + i : reName + BASE_QUERY;
                topQuery.setPropertyValue("name", reName);
                topQuery = ContextDependentModQueryToV5QueryUtil.createLOJV5Query(param, topQuery, p);
            }
            IXQEQueryNode detailSortListNode = modQuery.getFirstChildByType(101089);
            if (detailSortListNode != null) {
                ConvertModQueryToV5QueryUtil.convertModDefinitionToV5(null, detailSortListNode, param.nodeFactory, param.metadataConnection, false);
            }
        }
        finally {
            if (mc != null) {
                mc.close();
            }
        }
    }

    protected static void preConvertModFilters(CommonObjectsParam param) {
        IXQEQueryNode modFilters = param.modQuery.getFirstChildByType(101091);
        if (modFilters == null) {
            return;
        }
        for (IXQEQueryNode modFilter : modFilters.getChildren()) {
            String use = (String)modFilter.getPropertyValue("use");
            if (use != null && use.equals(ModFilter.USE_DISABLED)) continue;
            ArrayList<String> dataItems = new ArrayList<String>();
            ConvertModQueryToV5QueryUtil.getFilteredDataItems(modFilter, dataItems);
            HashSet<String> distinctItemNames = new HashSet<String>(dataItems);
            if (distinctItemNames.isEmpty()) {
                param.preAggregateDetailFilters.add(modFilter);
                continue;
            }
            HashSet<String> temp = new HashSet<String>(param.projectedItemName);
            temp.retainAll(distinctItemNames);
            distinctItemNames.removeAll(temp);
            param.unprojectedItemName.addAll(distinctItemNames);
            if (temp.isEmpty()) {
                param.preAggregateDetailFilters.add(modFilter);
                continue;
            }
            ModDataItem.ModDataItemType tp = ContextDependentModQueryToV5QueryUtil.validatePostAggregateModFilter(param, temp);
            if (tp == ModDataItem.ModDataItemType.TP_MEASURE) {
                param.postAggregateMeasureDetailFilters.add(modFilter);
                continue;
            }
            Pair p = new Pair(modFilter, temp);
            param.postAggregateAttributeDetailFilters.add(p);
        }
    }

    protected static ModDataItem.ModDataItemType validatePostAggregateModFilter(CommonObjectsParam param, Set<String> items) {
        ModDataItem.ModDataItemType rt = null;
        for (String name : items) {
            ModDataItem item = param.modQuery.getModDataItemByName(name);
            ModDataItem.ModDataItemType tp = item.getModDataItemType();
            if (tp == ModDataItem.ModDataItemType.TP_SUMMARY) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Filters referencing summary data items are not supported.");
            }
            if (rt != null && tp != ModDataItem.ModDataItemType.TP_MEASURE) continue;
            rt = tp;
        }
        return rt;
    }

    protected static void convertEdgeGroup(CommonObjectsParam param, IXQEQueryNode edgeGroup, LinkedList<String> contextStack) {
        IXQEQueryNode[] children;
        IXQEQueryNode[] vsNode = edgeGroup.getChildrenOfType(101057);
        V5ValueSet vs = (V5ValueSet)vsNode[0];
        String diRef = vs.getRefDataItemProperty();
        boolean bPushed = false;
        ArrayList newSortItems = new ArrayList();
        param.newSorts = newSortItems;
        IXQEQueryNode[] itemInGroupBody = vs.getDescendantsOfType(101015, false);
        IXQEQueryNode[] itemInGroupSort = vs.getDescendantsOfType(101056, false);
        if (diRef != null && (bPushed = ContextDependentModQueryToV5QueryUtil.convertModDataItemToV5DataItem(param, contextStack, diRef))) {
            contextStack.addLast(diRef);
        }
        for (IXQEQueryNode gbItem : itemInGroupBody) {
            V5DataItemRef dataItemRef = (V5DataItemRef)gbItem;
            diRef = dataItemRef.getDataItemRefProperty();
            ContextDependentModQueryToV5QueryUtil.convertModDataItemToV5DataItem(param, contextStack, diRef);
        }
        for (IXQEQueryNode sItem : itemInGroupSort) {
            V5SortItem sortItem = (V5SortItem)sItem;
            diRef = sortItem.getRefDataItem();
            ContextDependentModQueryToV5QueryUtil.convertModDataItemToV5DataItem(param, contextStack, diRef);
        }
        for (V5SortItem aSortItem : newSortItems) {
            vs.addChild(aSortItem);
        }
        for (IXQEQueryNode child : children = edgeGroup.getChildrenOfType(101050)) {
            ContextDependentModQueryToV5QueryUtil.convertEdgeGroup(param, child, contextStack);
        }
        if (bPushed) {
            contextStack.removeLast();
        }
    }

    protected static boolean convertModDataItemToV5DataItem(CommonObjectsParam param, LinkedList<String> contextStack, String diRef) {
        boolean bContext;
        ModDataItem modDataItem = param.modQuery.getModDataItemByName(diRef);
        boolean bl = bContext = modDataItem.getModDataItemType() == ModDataItem.ModDataItemType.TP_ATTRIBUTE;
        if (param.v5Query.getDataItemByName(diRef) != null) {
            return bContext;
        }
        if (!bContext || !ContextDependentModQueryToV5QueryUtil.hasContextDependentSet(modDataItem)) {
            V5Selection selection = param.v5Query.getV5Selection();
            V5DataItem dataItem = ConvertModQueryToV5QueryUtil.getOrCreateV5DataItem(param.nodeFactory, selection, diRef);
            dataItem.setIsReferenced();
            ConvertModQueryToV5QueryUtil.convertModDefinitionToV5(dataItem, modDataItem, param.nodeFactory, param.metadataConnection, param.bXtab);
        } else {
            IXQEQueryNode def = modDataItem.getChild(0).getChild(0);
            ContextDependentModQueryToV5QueryUtil.throwIfNotSimple(def);
            IXQEQueryNode modAttr = def.getFirstChildByType(101088).getChild(0);
            int tp = def.getType();
            switch (tp) {
                case 101087: {
                    ContextDependentModQueryToV5QueryUtil.createSortQuery(param, def, modAttr, diRef, contextStack);
                    break;
                }
                case 101109: 
                case 101110: {
                    ContextDependentModQueryToV5QueryUtil.createTopBottomCountQuery(param, def, modAttr, diRef, contextStack, tp);
                    break;
                }
            }
        }
        return bContext;
    }

    protected static void createSortQuery(CommonObjectsParam param, IXQEQueryNode def, IXQEQueryNode modAttr, String diRef, LinkedList<String> contextStack) {
        ContextDependentModQueryToV5QueryUtil.addModAttribteToQuery(param, param.v5Query, modAttr, diRef);
        V5Query sortQuery = ContextDependentModQueryToV5QueryUtil.createV5QueryFromBaseQuery(param, SORT_QUERY);
        sortQuery.setPropertyValue("isTabular", Boolean.TRUE);
        sortQuery.setPropertyValue("isRelStyle", Boolean.TRUE);
        sortQuery.setIsReferenced();
        ArrayList<String> joinItems = new ArrayList<String>(contextStack);
        ContextDependentModQueryToV5QueryUtil.copyContextDataItemsFromBaseQueryToSortQuery(param, joinItems, sortQuery);
        ContextDependentModQueryToV5QueryUtil.addModAttribteToQuery(param, sortQuery, modAttr, diRef);
        String sortItemName = ContextDependentModQueryToV5QueryUtil.addModTupleToQuery(param, sortQuery, def.getFirstChildByType(101097).getChild(0), S_COLUMN);
        SubQueryInfo info = new SubQueryInfo();
        joinItems.add(diRef);
        info.joinItems = joinItems;
        info.sortItemName = sortItemName;
        info.postAggregateFilters = ContextDependentModQueryToV5QueryUtil.getRequiredPostAggregateFilters(param, joinItems);
        Pair p = new Pair(sortQuery, info);
        param.modSortQueries.add(p);
        V5SortItem newSItem = ConvertModQueryToV5QueryUtil.createV5SortItemFromSortNode(param.nodeFactory, def, sortItemName);
        param.newSorts.add(newSItem);
    }

    protected static List<Integer> getRequiredPostAggregateFilters(CommonObjectsParam param, List<String> joinItems) {
        ArrayList<Integer> rt = new ArrayList<Integer>();
        if (!joinItems.isEmpty()) {
            for (int i = 0; i < param.postAggregateAttributeDetailFilters.size(); ++i) {
                Pair p = (Pair)param.postAggregateAttributeDetailFilters.get(i);
                HashSet temp = new HashSet((Set)p.getSecond());
                temp.retainAll(joinItems);
                if (temp.size() != joinItems.size()) continue;
                rt.add(i);
            }
        }
        return rt;
    }

    protected static void addModAttribteToQuery(CommonObjectsParam param, V5Query query, IXQEQueryNode modAttr, String dataItemName) {
        V5Selection selection = query.getV5Selection();
        V5DataItem dataItem = ConvertModQueryToV5QueryUtil.getOrCreateV5DataItem(param.nodeFactory, selection, dataItemName);
        dataItem.setIsReferenced();
        ConvertModQueryToV5QueryUtil.convertAttributeMeasure(dataItem, modAttr, param.nodeFactory, param.metadataConnection, false);
    }

    protected static String addModTupleToQuery(CommonObjectsParam param, V5Query v5Query, IXQEQueryNode modTuple, String ext) {
        IXQEQueryNode modMeasure = null;
        IXQEQueryNode tupleFacets = null;
        for (IXQEQueryNode child : modTuple.getChildren()) {
            if (child.getType() == 101084) {
                modMeasure = child;
                continue;
            }
            tupleFacets = child;
        }
        String dataItemName = null;
        if (modMeasure == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "tuple must have measure.");
        }
        V5Selection selection = v5Query.getV5Selection();
        V5DataItem dataItem = (V5DataItem)param.nodeFactory.createNode(101003);
        dataItem.setIsReferenced();
        selection.addChild(dataItem);
        ConvertModQueryToV5QueryUtil.convertAttributeMeasure(dataItem, modMeasure, param.nodeFactory, param.metadataConnection, false);
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)dataItem.getChild(0);
        dataItemName = boundNode.getMetadata().getName() + ext + param.nSubQueries;
        dataItem.setPropertyValue("name", dataItemName);
        param.tempMeasureName = boundNode.getMetadata().getName();
        if (tupleFacets != null) {
            ContextDependentModQueryToV5QueryUtil.convertTupleFacetsToV5QueryDetailFilter(param, v5Query, tupleFacets);
        }
        return dataItemName;
    }

    protected static void convertTupleFacetsToV5QueryDetailFilter(CommonObjectsParam param, V5Query v5Query, IXQEQueryNode tupleFacets) {
        TreeMap<String, TreeSet<String>> facetsMap = new TreeMap<String, TreeSet<String>>();
        for (IXQEQueryNode modTupleFacet : tupleFacets.getChildren()) {
            String refAttribute = (String)modTupleFacet.getPropertyValue("refAttribute");
            String refFacet = (String)modTupleFacet.getPropertyValue("refFacet");
            TreeSet<String> facets = (TreeSet<String>)facetsMap.get(refAttribute);
            if (facets == null) {
                facets = new TreeSet<String>();
                facetsMap.put(refAttribute, facets);
            }
            facets.add(refFacet);
        }
        for (Map.Entry entry : facetsMap.entrySet()) {
            TreeSet facetValues = (TreeSet)entry.getValue();
            String refAttribute = (String)entry.getKey();
            if (facetValues.isEmpty()) continue;
            V5DetailFilter filter = (V5DetailFilter)param.nodeFactory.createNode(101008);
            IXQEQueryNode in = param.nodeFactory.createNode(201011);
            filter.addChild(in);
            v5Query.addChild(filter);
            V5BoundModelIdentifier boundNode = ConvertModQueryToV5QueryUtil.createV5BoundModelIdentifierForMetadata(refAttribute, param.nodeFactory, param.metadataConnection);
            in.addChild(boundNode);
            IDataType dt = boundNode.getMetadata().getDataType();
            for (String v : facetValues) {
                V5LiteralValue valueNode = (V5LiteralValue)param.nodeFactory.createNode(201026);
                valueNode.setDataType(dt);
                valueNode.setValue(v);
                in.addChild(valueNode);
            }
        }
    }

    protected static void throwIfNotSimple(IXQEQueryNode node) {
        List<IXQEQueryNode> sets;
        boolean bError = false;
        int type = node.getType();
        if (type != 101087 && type != 101109 && type != 101110) {
            bError = true;
        }
        if (!bError && !(sets = node.getDescendantsOfCategory(101108, false)).isEmpty()) {
            bError = true;
        }
        if (!bError) {
            IXQEQueryNode[] baseSet = node.getChildrenOfType(101088);
            if (baseSet.length != 1) {
                bError = true;
            } else {
                IXQEQueryNode modBaseSetChild = baseSet[0].getChild(0);
                if (modBaseSetChild.getType() != 101083) {
                    bError = true;
                }
            }
        }
        if (bError) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "not yet.");
        }
    }

    protected static V5Query createV5QueryFromBaseQuery(CommonObjectsParam param, String ext) {
        param.nSubQueries++;
        V5Query v5Query = (V5Query)param.nodeFactory.createNode(101006);
        String metadataPath = param.v5Query.getMetadataPath();
        if (metadataPath != null) {
            v5Query.setMetadataPath(metadataPath);
        }
        param.querySet.addChild(v5Query);
        v5Query.setPropertyValue("name", param.qName + ext + param.nSubQueries);
        V5Source srcSource = param.v5Query.getV5Source();
        v5Query.addChild(param.nodeFactory.deepCopyNode(srcSource));
        IXQEQueryNode selection = param.nodeFactory.createNode(101009);
        v5Query.addChild(selection);
        return v5Query;
    }

    protected static V5DetailFilter createV5DetailFilterFromModFilter(CommonObjectsParam param, IXQEQueryNode modFilter, boolean bKeepProjectedMeasureRef) {
        V5DetailFilter detailFilter = (V5DetailFilter)param.nodeFactory.createNode(101008);
        HashSet<String> refs = new HashSet<String>();
        if (bKeepProjectedMeasureRef) {
            for (String item : param.projectedItemName) {
                ModDataItem di = param.modQuery.getModDataItemByName(item);
                if (di.getModDataItemType() != ModDataItem.ModDataItemType.TP_MEASURE) continue;
                refs.add(item);
            }
        }
        ConvertModQueryToV5QueryUtil.convertModFilterToBinaryV5DetailFilter(param.environment, param.v5Query, detailFilter, (ModFilter)modFilter, param.nodeFactory, param.metadataConnection, refs);
        return detailFilter;
    }

    protected static void createTopBottomCountQuery(CommonObjectsParam param, IXQEQueryNode def, IXQEQueryNode modAttr, String diRef, LinkedList<String> contextStack, int tp) {
        param.v5Query.setPropertyValue("NormalizeSubQueryRef", Boolean.TRUE);
        String value = (String)def.getPropertyValue("value");
        ContextDependentModQueryToV5QueryUtil.addModAttribteToQuery(param, param.v5Query, modAttr, diRef);
        V5Query baseFilterQuery = ContextDependentModQueryToV5QueryUtil.createV5QueryFromBaseQuery(param, FILTER_QUERY);
        baseFilterQuery.setPropertyValue("isTabular", Boolean.TRUE);
        baseFilterQuery.setPropertyValue("isRelStyle", Boolean.TRUE);
        baseFilterQuery.setIsReferenced();
        ArrayList<String> groupingItems = new ArrayList<String>(contextStack);
        ContextDependentModQueryToV5QueryUtil.copyContextDataItemsFromBaseQueryToSortQuery(param, groupingItems, baseFilterQuery);
        ContextDependentModQueryToV5QueryUtil.addModAttribteToQuery(param, baseFilterQuery, modAttr, diRef);
        String filterItemName = ContextDependentModQueryToV5QueryUtil.addModTupleToQuery(param, baseFilterQuery, def.getFirstChildByType(101098), A_COLUMN);
        V5DataItem rankItem = ContextDependentModQueryToV5QueryUtil.addDataItemForRank(param, baseFilterQuery, tp, filterItemName, groupingItems);
        String rankItemName = rankItem.getNameProperty();
        SubQueryInfo info = new SubQueryInfo();
        groupingItems.add(diRef);
        info.joinItems = groupingItems;
        info.sortItemName = rankItemName;
        info.postAggregateFilters = ContextDependentModQueryToV5QueryUtil.getRequiredPostAggregateFilters(param, groupingItems);
        Pair p = new Pair(baseFilterQuery, info);
        param.modFilterQueries.add(p);
        V5Query rankFilterQuery = ContextDependentModQueryToV5QueryUtil.addFilterQueryForTopBottomN(param, baseFilterQuery, groupingItems, rankItem, value);
        V5DetailFilter topCountDetailFilter = (V5DetailFilter)param.nodeFactory.createNode(101008);
        topCountDetailFilter.setPostAutoAggregation(false);
        param.v5Query.addChild(topCountDetailFilter);
        V5Source mainSourc = param.v5Query.getV5Source();
        mainSourc.setQueryRef(rankFilterQuery.getV5QueryName());
        IXQEQueryNode in = param.nodeFactory.createNode(201011);
        topCountDetailFilter.addChild(in);
        IXQEQueryNode first = null;
        if (groupingItems.size() > 1) {
            first = param.nodeFactory.createNode(201141);
            for (String gp : groupingItems) {
                V5BoundDataItemReference refV5Query = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, param.v5Query.getDataItemByName(gp), param.v5Query.getV5QueryName());
                refV5Query.setPropertyValue("isQueryRefItem", Boolean.FALSE);
                first.addChild(refV5Query);
            }
        } else {
            V5BoundDataItemReference refV5Query = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, param.v5Query.getDataItemByName((String)groupingItems.get(0)), param.v5Query.getV5QueryName());
            refV5Query.setPropertyValue("isQueryRefItem", Boolean.FALSE);
            first = refV5Query;
        }
        in.addChild(first);
        for (String gp : groupingItems) {
            V5BoundDataItemReference refRank = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, rankFilterQuery.getDataItemByName(gp), rankFilterQuery.getV5QueryName());
            refRank.setIsQueryRefItem();
            in.addChild(refRank);
        }
    }

    protected static V5DataItem addDataItemForRank(CommonObjectsParam param, V5Query baseFilterQuery, int tp, String filterItemName, List<String> groupingItems) {
        String rankItemName = param.tempMeasureName + R_COLUMN + param.nSubQueries;
        V5Selection baseFilterSelection = baseFilterQuery.getV5Selection();
        V5DataItem rankItem = (V5DataItem)param.nodeFactory.createNode(101003);
        rankItem.setIsReferenced();
        baseFilterSelection.addChild(rankItem);
        rankItem.setNameProperty(rankItemName);
        rankItem.setAggregateProperty("calculated");
        V5ValueAnalyticFunction rankExpression = (V5ValueAnalyticFunction)param.nodeFactory.createNode(201033);
        rankExpression.setSubType(14);
        rankItem.addChild(rankExpression);
        V5OrderedValueExpression orderedValueExpr = (V5OrderedValueExpression)param.nodeFactory.createNode(201114);
        if (tp == 101109) {
            orderedValueExpr.setSubType(2);
        } else {
            orderedValueExpr.setSubType(1);
        }
        rankExpression.addChild(orderedValueExpr);
        V5BoundDataItemReference refMeasure = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, baseFilterQuery.getDataItemByName(filterItemName), baseFilterQuery.getV5QueryName());
        refMeasure.setPropertyValue("isQueryRefItem", Boolean.FALSE);
        orderedValueExpr.addChild(refMeasure);
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)param.nodeFactory.createNode(201037);
        rankExpression.addChild(forClause);
        if (groupingItems.isEmpty()) {
            forClause.setSubType(0);
        } else {
            for (String cItem : groupingItems) {
                V5BoundDataItemReference ref = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, baseFilterQuery.getDataItemByName(cItem), baseFilterQuery.getV5QueryName());
                ref.setPropertyValue("isQueryRefItem", Boolean.FALSE);
                forClause.addChild(ref);
            }
        }
        return rankItem;
    }

    protected static V5Query addFilterQueryForTopBottomN(CommonObjectsParam param, V5Query baseFilterQuery, List<String> groupingItems, V5DataItem rankItem, String value) {
        param.nSubQueries++;
        V5Query rankFilterQuery = (V5Query)param.nodeFactory.createNode(101006);
        rankFilterQuery.setPropertyValue("isTabular", Boolean.TRUE);
        rankFilterQuery.setPropertyValue("isRelStyle", Boolean.TRUE);
        rankFilterQuery.setIsReferenced();
        param.querySet.addChild(rankFilterQuery);
        rankFilterQuery.setPropertyValue("name", param.qName + FILTER_QUERY + param.nSubQueries);
        rankFilterQuery.setPropertyValue("NormalizeSubQueryRef", Boolean.TRUE);
        V5Source source = (V5Source)param.nodeFactory.createNode(101007);
        rankFilterQuery.addChild(source);
        source.setQueryRef(baseFilterQuery.getV5QueryName());
        V5Selection selection = (V5Selection)param.nodeFactory.createNode(101009);
        selection.setAutoSummary(false);
        rankFilterQuery.addChild(selection);
        for (String item : groupingItems) {
            V5DataItem baseItem = baseFilterQuery.getDataItemByName(item);
            V5BoundDataItemReference ref = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, baseItem, baseFilterQuery.getV5QueryName());
            ref.setIsQueryRefItem();
            V5DataItem dataItem = (V5DataItem)param.nodeFactory.createNode(101003);
            dataItem.setIsReferenced();
            selection.addChild(dataItem);
            dataItem.setPropertyValue("name", item);
            dataItem.addChild(ref);
        }
        V5DetailFilter rankDetailFilter = (V5DetailFilter)param.nodeFactory.createNode(101008);
        rankFilterQuery.addChild(rankDetailFilter);
        rankDetailFilter.setPostAutoAggregation(false);
        V5ComparisonExpression comparisonExpr = (V5ComparisonExpression)param.nodeFactory.createNode(201013);
        comparisonExpr.setSubType(1);
        rankDetailFilter.addChild(comparisonExpr);
        V5BoundDataItemReference refItemBaseFilterQuery = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, rankItem, baseFilterQuery.getV5QueryName());
        refItemBaseFilterQuery.setPropertyValue("isQueryRefItem", Boolean.TRUE);
        comparisonExpr.addChild(refItemBaseFilterQuery);
        V5LiteralValue valueNode = (V5LiteralValue)param.nodeFactory.createNode(201026);
        valueNode.setDataType(IntegerType.INTEGERTYPE);
        valueNode.setValue(value);
        comparisonExpr.addChild(valueNode);
        return rankFilterQuery;
    }

    protected static V5Query createLOJV5Query(CommonObjectsParam param, V5Query leftQuery, Pair p) {
        V5Query rightQuery = (V5Query)p.getFirst();
        SubQueryInfo info = (SubQueryInfo)p.getSecond();
        V5Query topV5Query = (V5Query)param.nodeFactory.createNode(101006);
        topV5Query.setPropertyValue("isTabular", Boolean.TRUE);
        topV5Query.setPropertyValue("isRelStyle", Boolean.TRUE);
        topV5Query.setIsReferenced();
        param.querySet.addChild(topV5Query);
        topV5Query.setPropertyValue("name", param.qName);
        V5Source topSource = (V5Source)param.nodeFactory.createNode(101007);
        topV5Query.addChild(topSource);
        V5JoinOperation joinOperation = (V5JoinOperation)param.nodeFactory.createNode(101019);
        topSource.addChild(joinOperation);
        V5JoinOperand leftOperand = (V5JoinOperand)param.nodeFactory.createNode(101021);
        String leftQueryName = leftQuery.getV5QueryName();
        leftOperand.setPropertyValue("queryRef", leftQueryName);
        leftOperand.setPropertyValue("cardinality", "1:1");
        V5JoinOperand rightOperand = (V5JoinOperand)param.nodeFactory.createNode(101021);
        String rightQueryName = rightQuery.getV5QueryName();
        rightOperand.setPropertyValue("queryRef", rightQueryName);
        rightOperand.setPropertyValue("cardinality", "0:1");
        joinOperation.addChild(leftOperand);
        joinOperation.addChild(rightOperand);
        Object topExpr = null;
        for (String joinItem : info.joinItems) {
            IXQEQueryNode[] equalNode = (IXQEQueryNode[])param.nodeFactory.createNode(201013);
            V5BoundDataItemReference leftRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, leftQuery.getDataItemByName(joinItem), leftQueryName);
            V5BoundDataItemReference rightRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, rightQuery.getDataItemByName(joinItem), rightQueryName);
            equalNode.setSubType(2);
            equalNode.addChild(leftRef);
            equalNode.addChild(rightRef);
            if (topExpr == null) {
                topExpr = equalNode;
                continue;
            }
            V5LogicalExpression andNode = (V5LogicalExpression)param.nodeFactory.createNode(201003);
            andNode.setSubType(0);
            topExpr.insertParent(andNode);
            andNode.addChild((IXQEQueryNode)equalNode);
            topExpr = andNode;
        }
        joinOperation.addChild((IXQEQueryNode)topExpr);
        V5Selection topSelection = (V5Selection)param.nodeFactory.createNode(101009);
        topSelection.setAutoSummary(false);
        topSelection.setPropertyValue(KEEP_DEFINED_AUTOSUMMARY, Boolean.TRUE);
        topV5Query.addChild(topSelection);
        V5Selection leftQuerySelection = leftQuery.getV5Selection();
        for (IXQEQueryNode item : leftQuerySelection.getChildren()) {
            V5DataItem leftDataItem = (V5DataItem)item;
            if (!leftDataItem.isReferenced()) {
                leftDataItem.setIsReferenced();
            }
            String leftDataItemName = leftDataItem.getNameProperty();
            V5BoundDataItemReference leftRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, leftQuery.getDataItemByName(leftDataItemName), leftQueryName);
            V5DataItem topDataItem = (V5DataItem)param.nodeFactory.createNode(101003);
            topDataItem.setIsReferenced();
            topSelection.addChild(topDataItem);
            topDataItem.setPropertyValue("name", leftDataItemName);
            topDataItem.addChild(leftRef);
        }
        V5BoundDataItemReference rightRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(param.nodeFactory, rightQuery.getDataItemByName(info.sortItemName), rightQueryName);
        V5DataItem topDataItem = (V5DataItem)param.nodeFactory.createNode(101003);
        topDataItem.setIsReferenced();
        topSelection.addChild(topDataItem);
        topDataItem.setPropertyValue("name", info.sortItemName);
        topDataItem.addChild(rightRef);
        return topV5Query;
    }

    protected static void copyContextDataItemsFromBaseQueryToSortQuery(CommonObjectsParam param, List<String> joinItems, V5Query sortQuery) {
        V5Selection sortSelect = sortQuery.getV5Selection();
        for (String cItem : joinItems) {
            V5DataItem srcItem = param.v5Query.getDataItemByName(cItem);
            sortSelect.addChild(param.nodeFactory.deepCopyNode(srcItem));
        }
    }

    private static final class CommonObjectsParam {
        private ModQuery modQuery;
        private int nSubQueries = 0;
        private PlanningEnvironment environment;
        private XQENodeFactory nodeFactory;
        private MetadataConnection metadataConnection;
        private V5QuerySet querySet;
        private V5Query v5Query;
        private String qName;
        private Set<String> projectedItemName;
        private Set<String> unprojectedItemName = new HashSet<String>();
        private List<IXQEQueryNode> preAggregateDetailFilters = new ArrayList<IXQEQueryNode>();
        private List<IXQEQueryNode> postAggregateMeasureDetailFilters = new ArrayList<IXQEQueryNode>();
        private List<Pair> postAggregateAttributeDetailFilters = new ArrayList<Pair>();
        private List<Pair> modSortQueries = new ArrayList<Pair>();
        private List<Pair> modFilterQueries = new ArrayList<Pair>();
        private List<V5SortItem> newSorts;
        private String tempMeasureName;
        private boolean bXtab;

        private CommonObjectsParam() {
        }
    }

    private static final class SubQueryInfo {
        private List<String> joinItems;
        private String sortItemName;
        private List<Integer> postAggregateFilters;

        private SubQueryInfo() {
        }
    }
}

