/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.modquery.ModDataItem;
import com.cognos.xqe.ast.v5.modquery.ModDataItems;
import com.cognos.xqe.ast.v5.modquery.ModFilter;
import com.cognos.xqe.ast.v5.modquery.ModFilterCompare;
import com.cognos.xqe.ast.v5.modquery.ModFilterFacets;
import com.cognos.xqe.ast.v5.modquery.ModFilterNulls;
import com.cognos.xqe.ast.v5.modquery.ModFilterRange;
import com.cognos.xqe.ast.v5.modquery.ModFilterStringCompare;
import com.cognos.xqe.ast.v5.modquery.ModQuery;
import com.cognos.xqe.ast.v5.modquery.ModQueryUtil;
import com.cognos.xqe.ast.v5.modquery.ModSort;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateWithinClause;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5InRangeExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralRange;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5StringFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueExpression;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.SmallintType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.types.TinyintType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IFacet;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.DynamicSQS.CreateV5QueryForDynamicSQS;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.MoserBaseMetadata;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserQueryItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class ConvertModQueryToV5QueryUtil {
    public static final String NEED_TO_ADJUST_DATATYPE = "needToAdjustDataType";
    public static final String MODQUERY_TO_V5QUERY_APPLIED = "modQueryToV5QueryApplied";
    public static final String SINGLE_QUOTE = "'";
    public static final String CLOSING_BRACE = ")";
    public static final String LIST_SEPARATOR = ";";
    public static final String OPEN_NOT_CLAUSE = "NOT (";
    public static final String QUESTION_MARK = "?";
    public static final String IS_NULL = " is null";
    public static final String PROP_DATA_ITEM = "associatedV5DataItem";
    public static final String PROP_CREATED_FOR_MOD_SORT_BY = "createdForModSortBy";
    public static final String PROP_NAME_TO_DATA_ITEMS = "nameToDataItemsMap";
    public static final String STR_NAME = "name";
    public static final String DOT = ".";
    protected static final String NOT = "Not";
    public static final String YES = "yes";
    protected static final String PERCENT = "%";
    protected static final String IN_RANGE = "in_range";
    protected static final String STR_ERROR = "invalid modFilter as it does not have exactly one child";

    public static ModQuery getReferencedModQuery(V5QueryResultDefinition qrd) {
        IXQEQueryNode[] modQueries;
        IXQEQueryNode parent = qrd.getParent();
        if (parent == null || parent.getType() != 101002) {
            return null;
        }
        String refQName = qrd.getRefQueryProperty();
        if (refQName == null) {
            return null;
        }
        for (IXQEQueryNode q : modQueries = parent.getChildrenOfType(101079)) {
            ModQuery modQuery = (ModQuery)q;
            if (!refQName.equals(modQuery.getPropertyValue(STR_NAME))) continue;
            return modQuery;
        }
        return null;
    }

    public static Set<String> getReferencedDataItemNames(V5QueryResultDefinition qrd) {
        TreeSet<String> rt = new TreeSet<String>();
        int[] types = new int[]{101057, 101015, 101056};
        IXQEQueryNode[] nodes = qrd.getDescendantsOfTypes(types, false);
        String diRef = null;
        block5: for (IXQEQueryNode node : nodes) {
            int t = node.getType();
            switch (t) {
                case 101057: {
                    V5ValueSet vs = (V5ValueSet)node;
                    diRef = vs.getRefDataItemProperty();
                    if (diRef == null) continue block5;
                    rt.add(diRef);
                    continue block5;
                }
                case 101015: {
                    V5DataItemRef dataItemRef = (V5DataItemRef)node;
                    diRef = dataItemRef.getDataItemRefProperty();
                    if (diRef == null) continue block5;
                    rt.add(diRef);
                    continue block5;
                }
                case 101056: {
                    V5SortItem sortItem = (V5SortItem)node;
                    diRef = sortItem.getRefDataItem();
                    if (diRef == null) continue block5;
                    rt.add(diRef);
                    continue block5;
                }
            }
        }
        return rt;
    }

    public static boolean needToSwitchMetadataConnection(PlanningEnvironment environment, V5QuerySet querySet) {
        Set<String> modules = ConvertModQueryToV5QueryUtil.getMetadataPathFromReferencedModQuery(querySet);
        if (modules.isEmpty()) {
            return false;
        }
        String topModelPath = querySet.getModelPath();
        if (modules.size() > 1) {
            return true;
        }
        return !modules.contains(topModelPath);
    }

    public static void switchMetadataConnection(PlanningEnvironment environment, V5QuerySet querySet) {
        Set<String> modules = ConvertModQueryToV5QueryUtil.getMetadataPathFromReferencedModQuery(querySet);
        if (modules.size() > 1) {
            String cmd = ((RequestEnvironment)environment.getRequestEnvironment()).getOperationName();
            if ("execute".equals(cmd) || "validate".equals(cmd)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMultiModels, modules.toString());
            }
            environment.enableMultiModelForQuery();
            return;
        }
        String modelPath = modules.iterator().next();
        MetadataConnection metadataConnection = MetadataService.getInstance().getConnection("MOSER", modelPath, (IExecutionEnvironment)environment.getExecutionEnvironment(), true);
        environment.setMetdataConnection(metadataConnection);
        ((RequestEnvironment)environment.getRequestEnvironment()).setModelPath(modelPath);
        String org = querySet.getModelPath();
        querySet.setPropertyValue("modelPath", modelPath);
        if (org != null) {
            querySet.setPropertyValue("orgModelPath", org);
        }
    }

    protected static ModQuery getModQueryByName(V5QuerySet querySet, String name) {
        IXQEQueryNode[] modQueries;
        for (IXQEQueryNode c : modQueries = querySet.getChildrenOfType(101079)) {
            ModQuery modQuery = (ModQuery)c;
            if (!name.equals(modQuery.getName())) continue;
            return modQuery;
        }
        return null;
    }

    protected static Set<String> getMetadataPathFromReferencedModQuery(V5QuerySet querySet) {
        IXQEQueryNode[] qrds;
        TreeSet<String> rt = new TreeSet<String>();
        for (IXQEQueryNode c : qrds = querySet.getChildrenOfType(101055)) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)c;
            String modQueryName = qrd.getRefQueryProperty();
            ModQuery refModQUery = ConvertModQueryToV5QueryUtil.getModQueryByName(querySet, modQueryName);
            if (refModQUery == null) continue;
            String metadataPath = (String)refModQUery.getPropertyValue("metadataPath");
            if (metadataPath != null) {
                rt.add(metadataPath);
                continue;
            }
            rt.add(querySet.getModelPath());
        }
        return rt;
    }

    protected static MetadataConnection ensureMetadataConnectionModelPath(PlanningEnvironment environment, String modelPath) {
        MetadataConnection mc = environment.getMetadataConnectionMetadataPath(null);
        if (mc != null && modelPath.equals(mc.getModelName())) {
            return mc;
        }
        mc = ConvertModQueryToV5QueryUtil.getOrAddMetadataConnection(environment, modelPath);
        environment.setMetdataConnection(mc);
        ((RequestEnvironment)environment.getRequestEnvironment()).setModelPath(modelPath);
        return mc;
    }

    protected static MetadataConnection getOrAddMetadataConnection(PlanningEnvironment environment, String modelPath) {
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
        MetadataConnection mc = MetadataService.getInstance().getConnection("MOSER", modelPath, execEnv, true);
        MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        return mc;
    }

    protected static MetadataConnection getOrAddMetadataConnectionForMetadataPathModQuery(PlanningEnvironment environment, String metadataPath) {
        MetadataConnection mc = environment.getMetadataConnectionMetadataPath(metadataPath);
        if (mc != null) {
            return mc;
        }
        mc = ConvertModQueryToV5QueryUtil.getOrAddMetadataConnection(environment, metadataPath);
        environment.addMetadataConnectionMetadataPath(metadataPath, mc);
        return mc;
    }

    protected static MetadataConnectionContext generateV5QueryFromModQuery(PlanningEnvironment environment, ModQuery modQuery, V5QuerySet querySet, V5Query[] query, MetadataConnection[] metadataConnection) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        query[0] = (V5Query)nodeFactory.createNode(101006);
        String metadataPath = (String)modQuery.getPropertyValue("metadataPath");
        String modelPath = querySet.getModelPath();
        MetadataConnection globalMC = ConvertModQueryToV5QueryUtil.ensureMetadataConnectionModelPath(environment, modelPath);
        MetadataConnectionContext mc = null;
        if (environment.isMultiModelForQueryEnabled()) {
            if (metadataPath != null && !metadataPath.equals(modelPath)) {
                ConvertModQueryToV5QueryUtil.getOrAddMetadataConnectionForMetadataPathModQuery(environment, metadataPath);
            }
            mc = environment.pushMetadataConnectionContext(metadataPath);
            metadataPath = environment.getModelPath();
            query[0].setPropertyValue("metadataPath", metadataPath);
            metadataConnection[0] = mc.getMetadataConnection();
        } else {
            if (metadataPath != null && !metadataPath.equals(modelPath)) {
                TreeSet<String> modules = new TreeSet<String>();
                modules.add(metadataPath);
                modules.add(modelPath);
                throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedMultiModels, modules.toString());
            }
            metadataConnection[0] = globalMC;
            String org = (String)querySet.getPropertyValue("orgModelPath");
            if (metadataPath != null && org != null && !metadataPath.equals(org)) {
                query[0].setPropertyValue("metadataPath", metadataPath);
            }
        }
        querySet.addChild(query[0]);
        query[0].setPropertyValue(STR_NAME, modQuery.getPropertyValue(STR_NAME));
        V5Source source = (V5Source)nodeFactory.createNode(101007);
        query[0].setPropertyValue("sourceModule", true);
        query[0].addChild(source);
        source.setModel(metadataConnection[0].getModelName());
        source.setModelType(metadataConnection[0].getModelType());
        List<IModelDataSource> dataSources = metadataConnection[0].getModelDataSources();
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        if (dataSources != null) {
            for (int i = 0; i < dataSources.size(); ++i) {
                IModelDataSource modelDS = dataSources.get(i);
                execEnv.getOrAddDataSource(modelDS);
            }
        }
        source.setIsBound();
        IXQEQueryNode selection = nodeFactory.createNode(101009);
        query[0].addChild(selection);
        if (!modQuery.getAutoSummary()) {
            ((V5Selection)selection).setAutoSummary(false);
        }
        return mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertSimpleModQueryToV5Query(PlanningEnvironment environment, ModQuery modQuery, V5QueryResultDefinition qrd) {
        V5QuerySet querySet = (V5QuerySet)qrd.getParent();
        MetadataConnectionContext mc = null;
        V5Query[] v5Query = new V5Query[]{null};
        MetadataConnection[] metadataConnection = new MetadataConnection[]{null};
        try {
            IXQEQueryNode modFilters;
            mc = ConvertModQueryToV5QueryUtil.generateV5QueryFromModQuery(environment, modQuery, querySet, v5Query, metadataConnection);
            V5Selection selection = v5Query[0].getV5Selection();
            XQENodeFactory nodeFactory = environment.getNodeFactory();
            HashMap<String, V5DataItem> nameToDataItemMap = new HashMap<String, V5DataItem>();
            IXQEQueryNode modDataItems = modQuery.getFirstChildByType(101080);
            modDataItems.setPropertyValue(PROP_NAME_TO_DATA_ITEMS, nameToDataItemMap);
            for (IXQEQueryNode modItem : modDataItems.getChildren()) {
                String dataItemName = (String)modItem.getPropertyValue(STR_NAME);
                V5DataItem dataItem = ConvertModQueryToV5QueryUtil.getOrCreateV5DataItem(nodeFactory, selection, dataItemName);
                ConvertModQueryToV5QueryUtil.convertModDefinitionToV5(dataItem, modItem, nodeFactory, metadataConnection[0], !qrd.isList());
                nameToDataItemMap.put(dataItemName, dataItem);
                if (!"attribute".equals(dataItem.getPropertyValue("modType"))) continue;
                dataItem.setAggregateProperty("none");
            }
            IXQEQueryNode detailSortListNode = modQuery.getFirstChildByType(101089);
            if (detailSortListNode != null) {
                ConvertModQueryToV5QueryUtil.convertModDefinitionToV5(null, detailSortListNode, nodeFactory, metadataConnection[0], false);
            }
            if ((modFilters = modQuery.getFirstChildByType(101091)) != null) {
                for (IXQEQueryNode modFilter : modFilters.getChildren()) {
                    String use = (String)modFilter.getPropertyValue("use");
                    if (use != null && use.equals(ModFilter.USE_DISABLED)) continue;
                    ArrayList<String> dataItems = new ArrayList<String>();
                    ConvertModQueryToV5QueryUtil.getFilteredDataItems(modFilter, dataItems);
                    ConvertModQueryToV5QueryUtil.validateFilteredDataItems(dataItems, nameToDataItemMap);
                    boolean isPostAutoAggregateFilter = ConvertModQueryToV5QueryUtil.isPostAutoAggregateFilter(dataItems, qrd, nameToDataItemMap);
                    V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
                    v5Query[0].addChild(detailFilter);
                    if (use != null) {
                        if (use.equals(ModFilter.USE_REQUIRED)) {
                            detailFilter.setUseProperty("required");
                        } else if (use.equals(ModFilter.USE_OPTIONAL)) {
                            detailFilter.setUseProperty("optional");
                        }
                    }
                    detailFilter.setPostAutoAggregation(isPostAutoAggregateFilter);
                    ConvertModQueryToV5QueryUtil.convertModFilterToBinaryV5DetailFilter(environment, v5Query[0], detailFilter, (ModFilter)modFilter, nodeFactory, metadataConnection[0], null);
                }
            }
        }
        finally {
            if (mc != null) {
                mc.close();
            }
        }
    }

    public static V5DataItem getOrCreateV5DataItem(XQENodeFactory nodeFactory, V5Selection selection, String dataItemName) {
        V5DataItem dataItem = selection.getDataItemByRefName(dataItemName);
        if (dataItem == null) {
            dataItem = (V5DataItem)nodeFactory.createNode(101003);
            selection.addChild(dataItem);
            dataItem.setPropertyValue(STR_NAME, dataItemName);
        }
        return dataItem;
    }

    private static boolean isPostAutoAggregateFilter(List<String> dataItems, V5QueryResultDefinition qrd, Map<String, V5DataItem> nameToDataItemMap) {
        Boolean isPostAutoAggregate = null;
        for (String name : dataItems) {
            V5DataItem dataItem = nameToDataItemMap.get(name);
            boolean isProjectedMeasure = false;
            if (dataItem != null && dataItem.getPropertyValue("modType") != null && dataItem.getPropertyValue("modType").equals("measure") && ConvertModQueryToV5QueryUtil.isDataItemProjected(name, qrd)) {
                isProjectedMeasure = true;
            }
            if (isPostAutoAggregate == null) {
                isPostAutoAggregate = isProjectedMeasure;
                continue;
            }
            if (isProjectedMeasure == isPostAutoAggregate) continue;
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The filter is not supported, at least one projected measure is filtered in combination with a non-projected measure or attribute.");
        }
        return isPostAutoAggregate;
    }

    private static void validateFilteredDataItems(List<String> dataItemNames, Map<String, V5DataItem> nameToDataItemMap) {
        for (String name : dataItemNames) {
            V5DataItem dataItem = nameToDataItemMap.get(name);
            if (dataItem == null || dataItem.getPropertyValue("modType") == null || !dataItem.getPropertyValue("modType").equals("summary")) continue;
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Filters referencing summary data items are not supported.");
        }
    }

    protected static void getFilteredDataItems(IXQEQueryNode modFilter, List<String> dataItems) {
        for (IXQEQueryNode child : modFilter.getChildren()) {
            if (child.getPropertyValue("refDataItem") != null) {
                dataItems.add((String)child.getPropertyValue("refDataItem"));
            }
            ConvertModQueryToV5QueryUtil.getFilteredDataItems(child, dataItems);
        }
    }

    private static boolean isDataItemProjected(String dataItem, V5QueryResultDefinition qrd) {
        IXQEQueryNode[] valueSets;
        IXQEQueryNode[] dataItemRefs;
        for (IXQEQueryNode dataItemRef : dataItemRefs = qrd.getDescendantsOfType(101015, false)) {
            if (!((V5DataItemRef)dataItemRef).getDataItemRefProperty().equals(dataItem)) continue;
            return true;
        }
        for (IXQEQueryNode valueSet : valueSets = qrd.getDescendantsOfType(101057, false)) {
            if (((V5ValueSet)valueSet).getRefDataItemProperty() == null || !((V5ValueSet)valueSet).getRefDataItemProperty().equals(dataItem)) continue;
            return true;
        }
        return false;
    }

    private static void throwUnsupported(int type) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "modFilter type '" + type + "' not supported yet.");
    }

    protected static void convertModFilterToBinaryV5DetailFilter(PlanningEnvironment environment, V5Query v5Query, V5DetailFilter detailFilter, ModFilter modFilter, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, Set<String> refs) {
        if (modFilter.getNumberChildren() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, STR_ERROR);
        }
        IXQEQueryNode child = modFilter.getChild(0);
        int type = child.getType();
        IXQEQueryNode v5Expr = null;
        switch (type) {
            case 101093: {
                v5Expr = ConvertModQueryToV5QueryUtil.convertFilterCompareToV5BinaryExpression(environment, v5Query, (ModFilterCompare)child, nodeFactory, metadataConnection, refs);
                break;
            }
            case 101094: {
                v5Expr = ConvertModQueryToV5QueryUtil.convertFilterFacetsToV5BinaryExpression(environment, v5Query, (ModFilterFacets)child, nodeFactory, metadataConnection, refs);
                break;
            }
            case 101095: {
                v5Expr = ConvertModQueryToV5QueryUtil.convertFilterStringCompareToV5BinaryExpression(environment, v5Query, (ModFilterStringCompare)child, nodeFactory, metadataConnection, refs);
                break;
            }
            case 101096: {
                v5Expr = ConvertModQueryToV5QueryUtil.convertFilterRangeToV5BinaryExpression(environment, v5Query, (ModFilterRange)child, nodeFactory, metadataConnection, refs);
                break;
            }
            case 101107: {
                v5Expr = ConvertModQueryToV5QueryUtil.convertFilterNullsToV5BinaryExpression(v5Query, (ModFilterNulls)child, nodeFactory, metadataConnection, refs);
                break;
            }
            default: {
                ConvertModQueryToV5QueryUtil.throwUnsupported(type);
            }
        }
        detailFilter.addChild(v5Expr);
    }

    protected static V5SimpleNode createDataItemRef(XQENodeFactory nodeFactory, V5Query v5Query, String dataItemName, Set<String> refs, ModQuery modQuery, MetadataConnection metadataConnection) {
        if (refs == null || refs.contains(dataItemName)) {
            V5DataItem di = v5Query.getDataItemByName(dataItemName);
            V5BoundDataItemReference ref = CreateV5QueryForDynamicSQS.createV5QueryRefItem(nodeFactory, di, v5Query.getV5QueryName());
            ref.setPropertyValue("isQueryRefItem", Boolean.FALSE);
            di.setIsReferenced();
            return ref;
        }
        V5DataItem v5DI = v5Query.getDataItemByName(dataItemName);
        if (v5DI != null) {
            return (V5SimpleNode)nodeFactory.deepCopyNode(v5DI.getChild(0));
        }
        ModDataItem modItem = modQuery.getModDataItemByName(dataItemName);
        IXQEQueryNode def = modItem.getChild(0).getChild(0);
        int tp = def.getType();
        if (tp == 101083 || tp == 101084) {
            String modRef = (String)def.getPropertyValue("refModelItem");
            return ConvertModQueryToV5QueryUtil.createV5BoundModelIdentifierForMetadata(modRef, nodeFactory, metadataConnection);
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Complex filter is not supported.");
    }

    protected static IDataType ensureNotNullDataType(IDataType dataType, boolean[] bAdjustLater) {
        if (dataType == null) {
            bAdjustLater[0] = true;
            return StringType.DEFAULTSTRINGTYPE;
        }
        if (dataType instanceof SmallintType || dataType instanceof TinyintType) {
            return IntegerType.INTEGERTYPE;
        }
        if (dataType instanceof FloatType) {
            return DoubleType.DOUBLETYPE;
        }
        return dataType;
    }

    protected static IXQEQueryNode createV5Parameter(XQENodeFactory nodeFactory, String name, String metadataPath, String moduleItem) {
        V5Parameter v5Param = (V5Parameter)nodeFactory.createNode(201024);
        v5Param.setValue(name);
        if (metadataPath != null) {
            v5Param.setModulePath(metadataPath);
        }
        if (moduleItem != null) {
            v5Param.setModelFilterItem(moduleItem);
        }
        return v5Param;
    }

    protected static IXQEQueryNode createV5Literal(PlanningEnvironment environment, XQENodeFactory nodeFactory, String value, IDataType dt, boolean b) {
        if (!b) {
            if (dt.isTextType() || dt.isBlob() || dt.isClob()) {
                V5LiteralValue literal = (V5LiteralValue)nodeFactory.createNode(201026);
                ConvertModQueryToV5QueryUtil.setDataTypeAndValueInV5LiteralValue(literal, dt, value, false);
                return literal;
            }
            return RQPUtilities.createV5ValueExpression(value, environment, null, ((RequestEnvironment)environment.getRequestEnvironment()).getExpressionLocale());
        }
        V5LiteralValue literal = (V5LiteralValue)nodeFactory.createNode(201026);
        ConvertModQueryToV5QueryUtil.setDataTypeAndValueInV5LiteralValue(literal, dt, value, true);
        literal.setPropertyValue(NEED_TO_ADJUST_DATATYPE, Boolean.TRUE);
        return literal;
    }

    public static boolean setDataTypeAndValueInV5LiteralValue(V5LiteralValue literal, IDataType dt, String value, boolean bAdjustLater) {
        if (bAdjustLater) {
            literal.setDataType(dt);
            literal.setValue(value);
            return true;
        }
        if (dt.isTextType()) {
            if (dt.getLength() < value.length()) {
                dt = DataTypeFactory.getVarcharType(value.length());
            }
            literal.setDataType(dt);
            literal.setValue(value);
            return true;
        }
        if (dt.isBlob() || dt.isClob()) {
            literal.setDataType(dt);
            literal.setValue(value);
            return true;
        }
        return false;
    }

    protected static IXQEQueryNode createOrForIncludeNulls(XQENodeFactory nodeFactory, IXQEQueryNode v5Expr, IXQEQueryNode firstOp) {
        IXQEQueryNode firstOp1 = nodeFactory.deepCopyNode(firstOp);
        IXQEQueryNode isNull = nodeFactory.createNode(201010);
        isNull.addChild(firstOp1);
        V5LogicalExpression v5Or = (V5LogicalExpression)nodeFactory.createNode(201003);
        v5Or.setSubType(1);
        v5Or.addChild(v5Expr);
        v5Or.addChild(isNull);
        return v5Or;
    }

    protected static String getIdForExpression(V5SimpleNode node, MetadataConnection metadataConnection) {
        if (node.getType() == 201060) {
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)node;
            node = dataItemRef.getReferencedExpression();
        }
        if (node.getType() != 201116) {
            return null;
        }
        IMetadata meta = ((V5BoundModelIdentifier)node).getMetadata();
        if (meta instanceof MoserBaseMetadata) {
            return ((MoserBaseMetadata)((Object)meta)).getIdForExpression();
        }
        return null;
    }

    protected static IXQEQueryNode convertFilterCompareToV5BinaryExpression(PlanningEnvironment environment, V5Query v5Query, ModFilterCompare filterDef, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, Set<String> refs) {
        boolean parameterized = filterDef.getBooleanPropertyValue("parameterized", Boolean.FALSE);
        String parameterName = (String)filterDef.getPropertyValue("parameterName");
        String dataItemName = (String)filterDef.getPropertyValue("refDataItem");
        String op = (String)filterDef.getPropertyValue("operator");
        V5ComparisonExpression v5Expr = (V5ComparisonExpression)nodeFactory.createNode(201013);
        if (op.equals("equal")) {
            v5Expr.setSubType(2);
        } else if (op.equals("notEqual")) {
            v5Expr.setSubType(3);
        } else if (op.equals("greaterThan")) {
            v5Expr.setSubType(5);
        } else if (op.equals("greaterThanEqual")) {
            v5Expr.setSubType(4);
        } else if (op.equals("lessThan")) {
            v5Expr.setSubType(0);
        } else if (op.equals("lessThanEqual")) {
            v5Expr.setSubType(1);
        }
        V5SimpleNode firstOp = ConvertModQueryToV5QueryUtil.createDataItemRef(nodeFactory, v5Query, dataItemName, refs, (ModQuery)filterDef.getAncestorOfType(101079), metadataConnection);
        boolean[] bAdjustLater = new boolean[]{false};
        IDataType dt = ConvertModQueryToV5QueryUtil.ensureNotNullDataType(firstOp.getDataType(), bAdjustLater);
        IXQEQueryNode secondOp = null;
        if (parameterized) {
            String pname = QUESTION_MARK + parameterName + QUESTION_MARK;
            secondOp = ConvertModQueryToV5QueryUtil.createV5Parameter(nodeFactory, pname, v5Query.getMetadataPath(), ConvertModQueryToV5QueryUtil.getIdForExpression(firstOp, metadataConnection));
        } else {
            String value = (String)filterDef.getPropertyValue("filterValue");
            secondOp = ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, value, dt, bAdjustLater[0]);
        }
        Boolean includeNulls = filterDef.getBooleanPropertyValue("includeNulls", Boolean.FALSE);
        if (includeNulls.booleanValue()) {
            IXQEQueryNode v5Or = ConvertModQueryToV5QueryUtil.createOrForIncludeNulls(nodeFactory, v5Expr, firstOp);
            v5Expr.addChild(firstOp);
            v5Expr.addChild(secondOp);
            return v5Or;
        }
        v5Expr.addChild(firstOp);
        v5Expr.addChild(secondOp);
        return v5Expr;
    }

    protected static V5LogicalExpression wrapInNot(XQENodeFactory nodeFactory, IXQEQueryNode v5Expr) {
        V5LogicalExpression v5NotExpr = (V5LogicalExpression)nodeFactory.createNode(201003);
        v5NotExpr.setSubType(2);
        v5NotExpr.addChild(v5Expr);
        return v5NotExpr;
    }

    protected static IXQEQueryNode convertFilterFacetsToV5BinaryExpression(PlanningEnvironment environment, V5Query v5Query, ModFilterFacets modFilterFacets, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, Set<String> refs) {
        IXQEQueryNode v5Operator;
        String dataItemName = (String)modFilterFacets.getPropertyValue("refDataItem");
        boolean notOpAfter = modFilterFacets.getBooleanPropertyValue("out", Boolean.FALSE);
        boolean parameterized = modFilterFacets.getBooleanPropertyValue("parameterized", Boolean.FALSE);
        String parameterName = (String)modFilterFacets.getPropertyValue("parameterName");
        List filterValues = (List)modFilterFacets.getPropertyValue("facetValues");
        Boolean includeNulls = modFilterFacets.getBooleanPropertyValue("includeNulls", Boolean.FALSE);
        V5SimpleNode firstOp = ConvertModQueryToV5QueryUtil.createDataItemRef(nodeFactory, v5Query, dataItemName, refs, (ModQuery)modFilterFacets.getAncestorOfType(101079), metadataConnection);
        boolean[] bAdjustLater = new boolean[]{false};
        IDataType dt = ConvertModQueryToV5QueryUtil.ensureNotNullDataType(firstOp.getDataType(), bAdjustLater);
        ArrayList<IXQEQueryNode> secondOp = new ArrayList<IXQEQueryNode>();
        if (parameterized) {
            String pname = QUESTION_MARK + parameterName + QUESTION_MARK;
            secondOp.add(ConvertModQueryToV5QueryUtil.createV5Parameter(nodeFactory, pname, v5Query.getMetadataPath(), ConvertModQueryToV5QueryUtil.getIdForExpression(firstOp, metadataConnection)));
        } else {
            for (String value : filterValues) {
                secondOp.add(ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, value, dt, bAdjustLater[0]));
            }
        }
        IXQEQueryNode v5Expr = null;
        v5Expr = v5Operator = nodeFactory.createNode(201011);
        if (includeNulls.booleanValue()) {
            v5Expr = ConvertModQueryToV5QueryUtil.createOrForIncludeNulls(nodeFactory, v5Expr, firstOp);
        }
        v5Operator.addChild(firstOp);
        for (IXQEQueryNode s : secondOp) {
            v5Operator.addChild(s);
        }
        if (notOpAfter) {
            v5Expr = ConvertModQueryToV5QueryUtil.wrapInNot(nodeFactory, v5Expr);
        }
        return v5Expr;
    }

    protected static V5StringFunction wrapInLower(XQENodeFactory nodeFactory, IXQEQueryNode v5Expr) {
        V5StringFunction lower = (V5StringFunction)nodeFactory.createNode(201041);
        lower.setSubType(1);
        lower.addChild(v5Expr);
        return lower;
    }

    protected static IXQEQueryNode convertOperator(PlanningEnvironment environment, XQENodeFactory nodeFactory, String operator, IXQEQueryNode valueNode, IDataType dt) {
        if (operator.equals(ModQueryUtil.OPERATOR_STARTS_WITH)) {
            if (valueNode.getType() == 201026) {
                V5LiteralValue literal = (V5LiteralValue)valueNode;
                Value value = literal.getValue();
                String sValue = value.getString();
                sValue = sValue + PERCENT;
                literal.setValue(sValue);
                return valueNode;
            }
            V5ValueExpression concate = (V5ValueExpression)nodeFactory.createNode(201014);
            concate.setSubType(0);
            concate.addChild(valueNode);
            IXQEQueryNode second = ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, PERCENT, dt, false);
            concate.addChild(second);
            return concate;
        }
        if (operator.equals(ModQueryUtil.OPERATOR_ENDS_WITH)) {
            if (valueNode.getType() == 201026) {
                V5LiteralValue literal = (V5LiteralValue)valueNode;
                Value value = literal.getValue();
                String sValue = value.getString();
                sValue = PERCENT + sValue;
                literal.setValue(sValue);
                return valueNode;
            }
            V5ValueExpression concate = (V5ValueExpression)nodeFactory.createNode(201014);
            concate.setSubType(0);
            IXQEQueryNode first = ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, PERCENT, dt, false);
            concate.addChild(first);
            concate.addChild(valueNode);
            return concate;
        }
        if (operator.equals(ModQueryUtil.OPERATOR_MATCHES)) {
            return valueNode;
        }
        if (operator.equals(ModQueryUtil.OPERATOR_CONTAINS)) {
            if (valueNode.getType() == 201026) {
                V5LiteralValue literal = (V5LiteralValue)valueNode;
                Value value = literal.getValue();
                String sValue = value.getString();
                sValue = PERCENT + sValue + PERCENT;
                literal.setValue(sValue);
                return valueNode;
            }
            V5ValueExpression concateFirst = (V5ValueExpression)nodeFactory.createNode(201014);
            concateFirst.setSubType(0);
            IXQEQueryNode first = ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, PERCENT, dt, false);
            concateFirst.addChild(first);
            concateFirst.addChild(valueNode);
            V5ValueExpression concate = (V5ValueExpression)nodeFactory.createNode(201014);
            concate.setSubType(0);
            concate.addChild(concateFirst);
            IXQEQueryNode second = ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, PERCENT, dt, false);
            concate.addChild(second);
            return concate;
        }
        ConvertModQueryToV5QueryUtil.throwUnsupported(0);
        return null;
    }

    protected static IXQEQueryNode createV5ExprFromOperator(XQENodeFactory nodeFactory, String operator) {
        if (operator.equals(ModQueryUtil.OPERATOR_STARTS_WITH)) {
            return nodeFactory.createNode(201006);
        }
        if (operator.equals(ModQueryUtil.OPERATOR_ENDS_WITH)) {
            return nodeFactory.createNode(201007);
        }
        if (operator.equals(ModQueryUtil.OPERATOR_MATCHES)) {
            return nodeFactory.createNode(201004);
        }
        if (operator.equals(ModQueryUtil.OPERATOR_CONTAINS)) {
            return nodeFactory.createNode(201005);
        }
        ConvertModQueryToV5QueryUtil.throwUnsupported(0);
        return null;
    }

    public static IXQEQueryNode convertFilterStringCompareToV5BinaryExpression(PlanningEnvironment environment, V5Query v5Query, ModFilterStringCompare filterDef, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, Set<String> refs) {
        boolean parameterized = filterDef.getBooleanPropertyValue("parameterized", Boolean.FALSE);
        String parameterName = (String)filterDef.getPropertyValue("parameterName");
        String operator = (String)filterDef.getPropertyValue("operator");
        boolean notOp = false;
        if (operator.endsWith(NOT)) {
            notOp = true;
            operator = operator.substring(0, operator.length() - NOT.length());
        }
        String caseInsensitive = (String)filterDef.getPropertyValue("caseInsensitive");
        boolean wrapInLower = YES.equals(caseInsensitive);
        String escapeCharacter = (String)filterDef.getPropertyValue("escapeCharacter");
        String dataItemName = (String)filterDef.getPropertyValue("refDataItem");
        Boolean includeNulls = filterDef.getBooleanPropertyValue("includeNulls", Boolean.FALSE);
        V5SimpleNode firstOp = ConvertModQueryToV5QueryUtil.createDataItemRef(nodeFactory, v5Query, dataItemName, refs, (ModQuery)filterDef.getAncestorOfType(101079), metadataConnection);
        boolean[] bAdjustLater = new boolean[]{false};
        IDataType dt = ConvertModQueryToV5QueryUtil.ensureNotNullDataType(firstOp.getDataType(), bAdjustLater);
        IXQEQueryNode secondOp = null;
        if (parameterized) {
            String pname = QUESTION_MARK + parameterName + QUESTION_MARK;
            secondOp = ConvertModQueryToV5QueryUtil.createV5Parameter(nodeFactory, pname, v5Query.getMetadataPath(), null);
        } else {
            String value = (String)filterDef.getPropertyValue("filterValue");
            secondOp = ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, value, dt, false);
        }
        IXQEQueryNode v5Expr = null;
        if (escapeCharacter != null) {
            IXQEQueryNode v5LikeExpr = nodeFactory.createNode(201004);
            v5Expr = notOp ? ConvertModQueryToV5QueryUtil.wrapInNot(nodeFactory, v5LikeExpr) : v5LikeExpr;
            if (includeNulls.booleanValue()) {
                v5Expr = ConvertModQueryToV5QueryUtil.createOrForIncludeNulls(nodeFactory, v5Expr, firstOp);
            }
            if (wrapInLower) {
                firstOp = ConvertModQueryToV5QueryUtil.wrapInLower(nodeFactory, firstOp);
                secondOp = ConvertModQueryToV5QueryUtil.wrapInLower(nodeFactory, secondOp);
            }
            v5LikeExpr.addChild(firstOp);
            v5LikeExpr.addChild(ConvertModQueryToV5QueryUtil.convertOperator(environment, nodeFactory, operator, secondOp, dt));
            v5LikeExpr.addChild(ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, escapeCharacter, dt, false));
        } else {
            IXQEQueryNode v5Operator = ConvertModQueryToV5QueryUtil.createV5ExprFromOperator(nodeFactory, operator);
            v5Expr = notOp ? ConvertModQueryToV5QueryUtil.wrapInNot(nodeFactory, v5Operator) : v5Operator;
            if (includeNulls.booleanValue()) {
                v5Expr = ConvertModQueryToV5QueryUtil.createOrForIncludeNulls(nodeFactory, v5Expr, firstOp);
            }
            if (wrapInLower) {
                firstOp = ConvertModQueryToV5QueryUtil.wrapInLower(nodeFactory, firstOp);
                secondOp = ConvertModQueryToV5QueryUtil.wrapInLower(nodeFactory, secondOp);
            }
            v5Operator.addChild(firstOp);
            v5Operator.addChild(secondOp);
        }
        return v5Expr;
    }

    protected static IXQEQueryNode convertFilterRangeToV5BinaryExpression(PlanningEnvironment environment, V5Query v5Query, ModFilterRange modFilterRange, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, Set<String> refs) {
        String dataItemName = (String)modFilterRange.getPropertyValue("refDataItem");
        boolean notOpAfter = modFilterRange.getBooleanPropertyValue("out", Boolean.FALSE);
        boolean parameterized = modFilterRange.getBooleanPropertyValue("parameterized", Boolean.FALSE);
        String parameterName = (String)modFilterRange.getPropertyValue("parameterName");
        String from = (String)modFilterRange.getPropertyValue("modFilterFrom");
        String to = (String)modFilterRange.getPropertyValue("modFilterTo");
        Boolean includeNulls = modFilterRange.getBooleanPropertyValue("includeNulls", Boolean.FALSE);
        V5SimpleNode firstOp = ConvertModQueryToV5QueryUtil.createDataItemRef(nodeFactory, v5Query, dataItemName, refs, (ModQuery)modFilterRange.getAncestorOfType(101079), metadataConnection);
        boolean[] bAdjustLater = new boolean[]{false};
        IDataType dt = ConvertModQueryToV5QueryUtil.ensureNotNullDataType(firstOp.getDataType(), bAdjustLater);
        IXQEQueryNode secondOp = null;
        if (parameterized) {
            String pname = QUESTION_MARK + parameterName + QUESTION_MARK;
            secondOp = ConvertModQueryToV5QueryUtil.createV5Parameter(nodeFactory, pname, v5Query.getMetadataPath(), ConvertModQueryToV5QueryUtil.getIdForExpression(firstOp, metadataConnection));
        } else {
            V5LiteralRange literalRange = (V5LiteralRange)nodeFactory.createNode(201022);
            if (from != null && to != null) {
                literalRange.setSubType(2);
            } else {
                if (from == null) {
                    literalRange.setSubType(0);
                }
                if (to == null) {
                    literalRange.setSubType(1);
                }
            }
            secondOp = literalRange;
            if (from != null) {
                secondOp.addChild(ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, from, dt, bAdjustLater[0]));
            }
            if (to != null) {
                secondOp.addChild(ConvertModQueryToV5QueryUtil.createV5Literal(environment, nodeFactory, to, dt, bAdjustLater[0]));
            }
        }
        IXQEQueryNode v5Expr = null;
        V5InRangeExpression v5Operator = (V5InRangeExpression)nodeFactory.createNode(201012);
        v5Operator.setNativeName(IN_RANGE);
        v5Expr = v5Operator;
        if (includeNulls.booleanValue()) {
            v5Expr = ConvertModQueryToV5QueryUtil.createOrForIncludeNulls(nodeFactory, v5Expr, firstOp);
        }
        v5Operator.addChild(firstOp);
        v5Operator.addChild(secondOp);
        if (notOpAfter) {
            v5Expr = ConvertModQueryToV5QueryUtil.wrapInNot(nodeFactory, v5Expr);
        }
        return v5Expr;
    }

    protected static IXQEQueryNode convertFilterNullsToV5BinaryExpression(V5Query v5Query, ModFilterNulls modFilterNulls, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, Set<String> refs) {
        String dataItemName = (String)modFilterNulls.getPropertyValue("refDataItem");
        boolean notOp = modFilterNulls.getBooleanPropertyValue("out", Boolean.FALSE);
        V5SimpleNode firstOp = ConvertModQueryToV5QueryUtil.createDataItemRef(nodeFactory, v5Query, dataItemName, refs, (ModQuery)modFilterNulls.getAncestorOfType(101079), metadataConnection);
        IXQEQueryNode v5Expr = nodeFactory.createNode(201010);
        v5Expr.addChild(firstOp);
        if (notOp) {
            v5Expr = ConvertModQueryToV5QueryUtil.wrapInNot(nodeFactory, v5Expr);
        }
        return v5Expr;
    }

    protected static void convertModDefinitionToV5(V5DataItem dataItem, IXQEQueryNode modQueryNode, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, boolean addFacetSort) {
        if (modQueryNode.getNumberChildren() > 0) {
            for (IXQEQueryNode child : modQueryNode.getChildren()) {
                ConvertModQueryToV5QueryUtil.convertModDefinitionToV5(dataItem, child, nodeFactory, metadataConnection, addFacetSort);
            }
        }
        switch (modQueryNode.getType()) {
            case 101083: {
                IMetadata meta = ConvertModQueryToV5QueryUtil.convertAttributeMeasure(dataItem, modQueryNode, nodeFactory, metadataConnection, true);
                if (!addFacetSort || modQueryNode.getParent().getType() != 101082) break;
                ConvertModQueryToV5QueryUtil.addSortItemForExplicitFacetSort(meta, dataItem, nodeFactory, metadataConnection, (ModQuery)modQueryNode.getAncestorOfType(101079));
                break;
            }
            case 101084: {
                ConvertModQueryToV5QueryUtil.convertAttributeMeasure(dataItem, modQueryNode, nodeFactory, metadataConnection, true);
                break;
            }
            case 101085: {
                ConvertModQueryToV5QueryUtil.convertListSummary(dataItem, modQueryNode, nodeFactory);
                break;
            }
            case 101086: {
                ConvertModQueryToV5QueryUtil.convertEdgeSummary(dataItem, modQueryNode, nodeFactory);
                break;
            }
            case 101087: {
                ConvertModQueryToV5QueryUtil.convertSort(dataItem, modQueryNode, nodeFactory, metadataConnection);
                break;
            }
            case 101090: {
                String sortItemName = (String)modQueryNode.getPropertyValue("refDataItem");
                ConvertModQueryToV5QueryUtil.convertSortOfAttributeOrMeasure(sortItemName, sortItemName, modQueryNode, nodeFactory);
                break;
            }
        }
    }

    private static void addSortItemForExplicitFacetSort(IMetadata meta, V5DataItem dataItem, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, ModQuery modQuery) {
        if (!(meta instanceof IQueryItem)) {
            return;
        }
        IFacet facet = null;
        if (meta instanceof MoserQueryItem) {
            facet = ((MoserQueryItem)meta).getFacet();
        }
        if (facet == null) {
            return;
        }
        if (!facet.isEnabled() || !facet.isExplicitlySetByModeler()) {
            return;
        }
        ISortItem[] sorts = facet.getSortItems();
        if (sorts == null || sorts.length == 0) {
            return;
        }
        List<V5ValueSet> valueSets = ConvertModQueryToV5QueryUtil.getValueSetsReferencingSortItem((V5QuerySet)modQuery.getParent(), modQuery.getName(), dataItem.getNameProperty());
        V5Selection selection = (V5Selection)dataItem.getParent();
        for (V5ValueSet vs : valueSets) {
            for (ISortItem s : sorts) {
                String ref = s.getRefObject();
                IMetadata mdSort = ConvertModQueryToV5QueryUtil.bindMetadataReference(ref, metadataConnection);
                V5DataItem sortDataItem = dataItem;
                if (!meta.equals(mdSort)) {
                    String sortItemName = dataItem.getNameProperty() + "_sortby_" + mdSort.getName();
                    sortDataItem = ConvertModQueryToV5QueryUtil.getOrCreateV5DataItem(nodeFactory, selection, sortItemName);
                    sortDataItem.addChild(ConvertModQueryToV5QueryUtil.createV5BoundModelIdentifierForMetadataObject(mdSort, nodeFactory));
                }
                V5SortItem sortItemNode = (V5SortItem)nodeFactory.createNode(101056);
                sortItemNode.setPropertyValue("refDataItem", sortDataItem.getNameProperty());
                sortItemNode.setPropertyValue("sortOrder", s.getSort().toString());
                ISortItem.NullPlacementType nullPlace = s.getNullPlacement();
                if (nullPlace == null || nullPlace == ISortItem.NullPlacementType.NULL_LAST) {
                    sortItemNode.setPropertyValue("nullPlace", "last");
                } else if (nullPlace == ISortItem.NullPlacementType.NULL_FIRST) {
                    sortItemNode.setPropertyValue("nullPlace", "first");
                }
                vs.addChild(sortItemNode);
            }
        }
    }

    private static void convertSort(V5DataItem dataItem, IXQEQueryNode node, XQENodeFactory nodeFactory, MetadataConnection metadataConnection) {
        ModSort modSortNode = (ModSort)node;
        IXQEQueryNode modSortBy = null;
        IXQEQueryNode modBaseSet = null;
        for (IXQEQueryNode child : modSortNode.getChildren()) {
            if (child.getType() == 101088) {
                modBaseSet = child;
                continue;
            }
            if (child.getType() != 101097) continue;
            modSortBy = child;
        }
        IXQEQueryNode modBaseSetChild = modBaseSet.getChild(0);
        if (modBaseSetChild.getType() == 101083) {
            if (modSortBy == null) {
                String attributeName = ((V5DataItem)modBaseSetChild.getPropertyValue(PROP_DATA_ITEM)).getNameProperty();
                ConvertModQueryToV5QueryUtil.convertSortOfAttributeOrMeasure(attributeName, attributeName, node, nodeFactory);
                dataItem.setPropertyValue("modType", "attribute");
            } else {
                ConvertModQueryToV5QueryUtil.convertModSortBy(dataItem, modSortBy, nodeFactory);
            }
        } else {
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, modBaseSetChild.getNodeTypeName(), modBaseSet.getNodeTypeName());
        }
    }

    private static void convertModSortBy(V5DataItem dataItem, IXQEQueryNode modSortBy, XQENodeFactory nodeFactory) {
        V5DataItem modSortByItem = null;
        IXQEQueryNode modSortNode = modSortBy.getParent();
        IXQEQueryNode modSortByChild = modSortBy.getChild(0);
        if (modSortByChild.getType() == 101083) {
            modSortByItem = (V5DataItem)modSortByChild.getPropertyValue(PROP_DATA_ITEM);
            ConvertModQueryToV5QueryUtil.convertSortOfAttributeOrMeasure(dataItem.getNameProperty(), modSortByItem.getNameProperty(), modSortNode, nodeFactory);
            return;
        }
        IXQEQueryNode modMeasure = null;
        for (IXQEQueryNode child : modSortByChild.getChildren()) {
            if (child.getType() != 101084) continue;
            modMeasure = child;
        }
        modSortByItem = (V5DataItem)modMeasure.getPropertyValue(PROP_DATA_ITEM);
        ConvertModQueryToV5QueryUtil.convertSortOfAttributeOrMeasure(dataItem.getNameProperty(), modSortByItem.getNameProperty(), modSortNode, nodeFactory);
    }

    private static void convertSortOfAttributeOrMeasure(String sortItemName, String sortByName, IXQEQueryNode sortNode, XQENodeFactory nodeFactory) {
        ModQuery modQuery = (ModQuery)sortNode.getAncestorOfType(101079);
        List<V5ValueSet> valueSets = ConvertModQueryToV5QueryUtil.getValueSetsReferencingSortItem((V5QuerySet)modQuery.getParent(), modQuery.getName(), sortItemName);
        for (V5ValueSet vs : valueSets) {
            V5SortItem sortItem = ConvertModQueryToV5QueryUtil.createV5SortItemFromSortNode(nodeFactory, sortNode, sortByName);
            vs.addChild(sortItem);
        }
    }

    protected static V5SortItem createV5SortItemFromSortNode(XQENodeFactory nodeFactory, IXQEQueryNode sortNode, String sortByName) {
        V5SortItem sortItem = (V5SortItem)nodeFactory.createNode(101056);
        sortItem.setPropertyValue("refDataItem", sortByName);
        if (sortNode.getBooleanPropertyValue("sortAscending").booleanValue()) {
            sortItem.setStringPropertyValue("sortOrder", "ascending");
        } else {
            sortItem.setStringPropertyValue("sortOrder", "descending");
        }
        String nullPosition = (String)sortNode.getPropertyValue("nullPosition");
        if (nullPosition != null) {
            sortItem.setStringPropertyValue("nullPlace", nullPosition);
        }
        return sortItem;
    }

    private static List<V5ValueSet> getValueSetsReferencingSortItem(V5QuerySet querySet, String queryName, String sortItemName) {
        IXQEQueryNode[] qrds;
        ArrayList<V5ValueSet> valueSets = new ArrayList<V5ValueSet>();
        block0: for (IXQEQueryNode qrdNode : qrds = querySet.getDescendantsOfType(101055, false)) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)qrdNode;
            if (!qrd.getRefQueryProperty().equals(queryName)) continue;
            IXQEQueryNode[] valueSetsOfQrd = qrd.getDescendantsOfType(101057, false);
            boolean found = false;
            for (IXQEQueryNode vsNode : valueSetsOfQrd) {
                block5: {
                    V5ValueSet vs;
                    block4: {
                        vs = (V5ValueSet)vsNode;
                        String refDataItem = vs.getRefDataItemProperty();
                        if (refDataItem == null) break block4;
                        if (!sortItemName.equals(refDataItem)) break block5;
                        valueSets.add(vs);
                        found = true;
                        break block5;
                    }
                    IXQEQueryNode[] gb = vs.getDescendantsOfType(101051, false);
                    if (gb.length > 0) {
                        IXQEQueryNode[] diRefs;
                        for (IXQEQueryNode diRefNode : diRefs = gb[0].getDescendantsOfType(101015, false)) {
                            if (!sortItemName.equals(diRefNode.getPropertyValue("refDataItem"))) continue;
                            valueSets.add(vs);
                            found = true;
                            break;
                        }
                    }
                }
                if (found) continue block0;
            }
        }
        return valueSets;
    }

    protected static V5BoundModelIdentifier createV5BoundModelIdentifierForMetadata(String modRef, XQENodeFactory nodeFactory, MetadataConnection metadataConnection) {
        IMetadata md = ConvertModQueryToV5QueryUtil.bindMetadataReference(modRef, metadataConnection);
        return ConvertModQueryToV5QueryUtil.createV5BoundModelIdentifierForMetadataObject(md, nodeFactory);
    }

    protected static V5BoundModelIdentifier createV5BoundModelIdentifierForMetadataObject(IMetadata md, XQENodeFactory nodeFactory) {
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        boundNode.setMetadata(md);
        boundNode.setIdentifier(md.getUniqueID());
        return boundNode;
    }

    protected static IMetadata bindMetadataReference(String modRef, MetadataConnection metadataConnection) {
        String newModRef = modRef;
        MoserMetadataConnection moserConn = (MoserMetadataConnection)metadataConnection;
        MoserModule moserModule = moserConn.getModule();
        String old = moserModule.getContainer() + DOT + moserModule.getIdentifier() + DOT;
        if (newModRef.startsWith(old)) {
            newModRef = newModRef.substring(old.length());
            newModRef = moserModule.getUniqueName() + DOT + newModRef;
        }
        IMetadata md = metadataConnection.bindMetadataReference(newModRef);
        return md;
    }

    protected static IMetadata convertAttributeMeasure(V5DataItem dataItem, IXQEQueryNode modAttrOrMeasure, XQENodeFactory nodeFactory, MetadataConnection metadataConnection, boolean bCheckSort) {
        String modRef = (String)modAttrOrMeasure.getPropertyValue("refModelItem");
        if (modAttrOrMeasure.getType() == 101084) {
            String groupRollup;
            String detailRollup = (String)modAttrOrMeasure.getPropertyValue("detailRollup");
            if (detailRollup != null) {
                dataItem.setAggregateProperty(detailRollup);
            }
            if ((groupRollup = (String)modAttrOrMeasure.getPropertyValue("groupRollup")) != null) {
                dataItem.setRollupAggregateProperty(groupRollup);
            }
        }
        V5BoundModelIdentifier boundNode = ConvertModQueryToV5QueryUtil.createV5BoundModelIdentifierForMetadata(modRef, nodeFactory, metadataConnection);
        IMetadata rt = boundNode.getMetadata();
        IXQEQueryNode modSortBy = null;
        if (bCheckSort) {
            modSortBy = modAttrOrMeasure.getAncestorOfType(101097);
        }
        if (modSortBy == null) {
            dataItem.addChild(boundNode);
            if (modAttrOrMeasure.getType() == 101083) {
                dataItem.setPropertyValue("modType", "attribute");
            } else {
                dataItem.setPropertyValue("modType", "measure");
            }
            modAttrOrMeasure.setPropertyValue(PROP_DATA_ITEM, dataItem);
        } else {
            V5DataItem newDataItem = ConvertModQueryToV5QueryUtil.createV5DataItem(dataItem, modAttrOrMeasure, nodeFactory, boundNode, boundNode.getMetadata().getName());
            newDataItem.setPropertyValue(PROP_CREATED_FOR_MOD_SORT_BY, true);
            if (modAttrOrMeasure.getType() == 101083) {
                newDataItem.setPropertyValue("modType", "attribute");
            } else {
                newDataItem.setPropertyValue("modType", "measure");
            }
            modAttrOrMeasure.setPropertyValue(PROP_DATA_ITEM, newDataItem);
        }
        return rt;
    }

    private static V5DataItem createV5DataItem(V5DataItem existingDataItem, IXQEQueryNode modQueryNode, XQENodeFactory nodeFactory, IXQEQueryNode newDataItemExpr, String newDataItemName) {
        V5Selection selection = (V5Selection)existingDataItem.getParent();
        V5DataItem newDataItem = selection.getDataItemByExpression(newDataItemExpr);
        if (newDataItem != null) {
            return newDataItem;
        }
        newDataItem = (V5DataItem)nodeFactory.createNode(101003);
        selection.addChild(newDataItem);
        newDataItem.setPropertyValue(STR_NAME, newDataItemName);
        newDataItem.addChild(newDataItemExpr);
        modQueryNode.setPropertyValue(PROP_DATA_ITEM, newDataItem);
        return newDataItem;
    }

    protected static void convertListSummary(V5DataItem dataItem, IXQEQueryNode child, XQENodeFactory nodeFactory) {
        String refDataItem = (String)child.getPropertyValue("refDataItem");
        String rollupAggr = (String)child.getPropertyValue("groupRollup");
        if (rollupAggr == null) {
            rollupAggr = ConvertModQueryToV5QueryUtil.getGroupRollupFromDetailRow(child, refDataItem);
        }
        dataItem.setAggregateProperty(RefineAutomaticXtab.AggrTypeEnum.CALCULATED.getV5Name());
        if (rollupAggr != null) {
            dataItem.setRollupAggregateProperty(rollupAggr);
        }
        V5Query v5Query = (V5Query)dataItem.getAncestorOfType(101006);
        V5DataItem refDataItemNode = ConvertModQueryToV5QueryUtil.getOrCreateV5DataItem(nodeFactory, v5Query.getV5Selection(), refDataItem);
        V5BoundDataItemReference boundDataItemRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(nodeFactory, refDataItemNode, v5Query.getV5QueryName());
        boundDataItemRef.setPropertyValue("isQueryRefItem", Boolean.FALSE);
        dataItem.addChild(boundDataItemRef);
        dataItem.setPropertyValue("modType", "summary");
    }

    private static String getGroupRollupFromDetailRow(IXQEQueryNode summaryNode, String refDataItem) {
        ModDataItems modDataItemsNode = (ModDataItems)summaryNode.getAncestorOfType(101080);
        Map nameToDataItems = (Map)modDataItemsNode.getPropertyValue(PROP_NAME_TO_DATA_ITEMS);
        V5DataItem di = (V5DataItem)nameToDataItems.get(refDataItem);
        if (di != null) {
            return di.getRollupAggregateProperty();
        }
        return null;
    }

    protected static void convertEdgeSummary(V5DataItem dataItem, IXQEQueryNode child, XQENodeFactory nodeFactory) {
        String refDataItem = (String)child.getPropertyValue("refDataItem");
        String rollupAggr = (String)child.getPropertyValue("groupRollup");
        if (rollupAggr == null) {
            rollupAggr = ConvertModQueryToV5QueryUtil.getGroupRollupFromDetailRow(child, refDataItem);
        }
        String aggregateFunction = "aggregate";
        if (rollupAggr != null && !"default".equals(rollupAggr) && !"calculated".equals(rollupAggr)) {
            aggregateFunction = "standardDeviation".equals(rollupAggr) ? "standard-deviation" : rollupAggr;
        }
        V5MemberSummaryFunction aggrFunc = (V5MemberSummaryFunction)nodeFactory.createNode(201032);
        aggrFunc.setNativeName(aggregateFunction);
        Pair v5AggregateFunctionSubtype = AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(aggregateFunction, null);
        Integer aggSubType = (Integer)v5AggregateFunctionSubtype.getFirst();
        aggrFunc.setSubType(aggSubType);
        aggrFunc.setDistinct((Boolean)v5AggregateFunctionSubtype.getSecond());
        IXQEQueryNode currentMeasure = nodeFactory.createNode(201058);
        aggrFunc.addChild(currentMeasure);
        V5AggregateWithinClause withinDetail = (V5AggregateWithinClause)nodeFactory.createNode(201039);
        withinDetail.setSubType(1);
        aggrFunc.addChild(withinDetail);
        V5Query v5Query = (V5Query)dataItem.getAncestorOfType(101006);
        V5DataItem refDataItemNode = ConvertModQueryToV5QueryUtil.getOrCreateV5DataItem(nodeFactory, v5Query.getV5Selection(), refDataItem);
        V5BoundDataItemReference boundDataItemRef = CreateV5QueryForDynamicSQS.createV5QueryRefItem(nodeFactory, refDataItemNode, v5Query.getV5QueryName());
        boundDataItemRef.setPropertyValue("isQueryRefItem", Boolean.FALSE);
        withinDetail.addChild(boundDataItemRef);
        dataItem.addChild(aggrFunc);
        dataItem.setPropertyValue("modType", "summary");
    }

    public static enum ModQueryStatus {
        MODQUERY_COMPLETE,
        MODQUERY_IN_PROCESS;

    }
}

