/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.aggregation_distribution;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.aggregation_distribution.DistributeMDXSummaryFunction;
import com.cognos.xqe.transformation.olap.aggregation_distribution.InsertErrorCellUpdateDecorationForNoneRollup;
import com.cognos.xqe.transformation.olap.aggregation_distribution.IntersectCogMDXAggreagateWithMeasures;

public class ConvertCogMDXAggregateWithVEToMDXSummaryFunction
extends Transformation {
    public ConvertCogMDXAggregateWithVEToMDXSummaryFunction() {
        this.mName = "Converts CogMDXAggregate to MDXSummaryFunction when aggregate distribution is not required.";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{1012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)node;
        IXQEQueryNode[] cogMDXGroupNodes = node.getDescendantsOfType(1027, false);
        for (int i = 0; i < cogMDXGroupNodes.length; ++i) {
            ((CogMDXGroup)cogMDXGroupNodes[i]).setProjectDetailsOnly();
        }
        MDXSummaryFunction mdxSummary = (MDXSummaryFunction)nodeFactory.createNode(1060);
        mdxSummary.setIsWithinDetailCalc(cogMDXAggregate.isWithinDetailCalc());
        mdxSummary.setIntersectingMeasures(cogMDXAggregate.getIntersectingMeasures());
        node.getParent().exchangeChildNode(node, mdxSummary, true);
        if (mdxSummary.getNumberChildren() == 2) {
            mdxSummary.applyMeasureRollupAggregate(nodeFactory);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        node.throwOnInvalidChildCategories();
        XQETrace trace = environment.getTrace();
        boolean status = false;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            status = false;
            this.traceNodeCondition(status, "The node is not within a MDXQuery node.", trace);
            return status;
        }
        status = node.getNumberChildren() == 2;
        String msgStr = null;
        if (status) {
            MDXCalculatedMemberDefinition ancestorCalcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
            CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)node;
            if (!cogMDXAggregate.hasExplicitMeasureContext() && ancestorCalcDef != null && !mdxQuery.getProjectedReferences(ancestorCalcDef).isEmpty() && mdxQuery.getHierarchyInfo().projectsMeasures() && cogMDXAggregate.getIntersectingMeasures().isEmpty()) {
                this.traceNodeCondition(false, "The node is a projected cogMDXAggregate which is not referencing a measure. The measures intersecting with it have not been resolved yet.", trace);
                return false;
            }
            if (InsertErrorCellUpdateDecorationForNoneRollup.nodeCondition(node, null)) {
                msgStr = "Insert error cell update decoration is required first.";
                status = false;
            } else if (this.nodeRequiresIntersectionWithMeasure(node) && IntersectCogMDXAggreagateWithMeasures.nodeCondition(mdxQuery, node, null)) {
                status = false;
                msgStr = "Intersection with measures is required first.";
            } else if (DistributeMDXSummaryFunction.nodeCondition(mdxQuery, node, null)) {
                msgStr = "Aggregate distribution is required first.";
                status = false;
            } else {
                msgStr = "The CogMDXAggregate can be converted to a MXSummaryFunction.";
            }
        } else {
            msgStr = "The CogMDXAggregate can not be converted to a MDXSummaryFunction.";
        }
        this.traceNodeCondition(status, msgStr, trace);
        return status;
    }

    private boolean nodeRequiresIntersectionWithMeasure(IXQEQueryNode node) {
        return !node.getChild(1).isOfCategory(1085) && !node.getChild(1).isOfCategory(1064);
    }
}

