/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.aggregation_distribution;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXNumericPropertiesWrapper;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class WrapCogMDXPropertiesWhenNumeric
extends Transformation {
    public WrapCogMDXPropertiesWhenNumeric() {
        this.mName = "Wrap numeric MDXProperties";
        this.mPassNumbers = new int[]{27};
        this.mTypes = new int[]{1016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXNumericPropertiesWrapper wrapper = (CogMDXNumericPropertiesWrapper)nodeFactory.createNode(1186);
        node.insertParent(wrapper);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getParent().getType() == 1186) {
            this.traceNodeCondition(false, "The property has already been wrapped.", trace);
            return false;
        }
        if (((CogMDXProperties)node).isNumeric()) {
            this.traceNodeCondition(true, "The property is numeric.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The property is not numeric.", trace);
        return false;
    }
}

