/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.axisgeneration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.TNodeApplyHeadSuppression;
import com.cognos.xqe.ast.olap.TNodeBuildTagTuple;
import com.cognos.xqe.ast.olap.TNodeHeadCount;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class ConvertCogMDXGroupToMDXCrossjoin
extends Transformation {
    public ConvertCogMDXGroupToMDXCrossjoin() {
        this.mName = "Convert CogMDXGroup To MDXCrossjoin.";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXGroup targetCogMDXGroup = (CogMDXGroup)node;
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)nodeFactory.createNode(1030);
        boolean injectTags = !targetCogMDXGroup.projectDetailsOnly() && !targetCogMDXGroup.projectNonDetailsOnly() && !targetCogMDXGroup.isEmpty();
        node.getParent().exchangeChildNode(node, mdxCrossjoin, true);
        if (injectTags && targetCogMDXGroup.getTagType() != null) {
            MDXHierInfo hierInfo = mdxCrossjoin.getHierarchyInfo();
            TNodeBuildTagTuple tNodeBuildTagTuple = (TNodeBuildTagTuple)nodeFactory.createNode(1124);
            tNodeBuildTagTuple.setTagType(targetCogMDXGroup.getTagType());
            for (int i = 0; i < hierInfo.getNumProjectedHierarchies(); ++i) {
                tNodeBuildTagTuple.addHierarchy(hierInfo.getProjectedHierarchy(i));
            }
            tNodeBuildTagTuple.setCogMDXGroup(targetCogMDXGroup);
            IXQEQueryNode mdxSet = nodeFactory.createNode(1039);
            mdxCrossjoin.insertParent(mdxSet);
            mdxSet.addChild(tNodeBuildTagTuple, 0);
            if (targetCogMDXGroup.getSuppressWhenNoNestedDetails() && mdxCrossjoin.couldResolveToEmptySet(true, false, false)) {
                IXQEQueryNode tNodeApplyHeadSuppression = nodeFactory.createNode(1083);
                TNodeHeadCount tCount = (TNodeHeadCount)nodeFactory.createNode(1182);
                ((TNodeApplyHeadSuppression)tNodeApplyHeadSuppression).setTNodeHeadCount(tCount);
                tNodeBuildTagTuple.insertParent(tNodeApplyHeadSuppression);
                tNodeBuildTagTuple.insertParent(nodeFactory.createNode(1039));
                mdxCrossjoin.move(tNodeApplyHeadSuppression);
                MDXQuery mdxQuery = (MDXQuery)mdxCrossjoin.getAncestorOfType(1002);
                MDXSetAliasReference aliasRef = MDXBuilder.buildMDXSetAlias(nodeFactory, mdxQuery, mdxCrossjoin);
                mdxSet.addChild(aliasRef);
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean suppressOnNonEmpty;
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] cogMDXGroups = node.getAncestorsOfType(1027);
        for (int i = 0; i < cogMDXGroups.length; ++i) {
            if (!((CogMDXGroup)cogMDXGroups[i]).isProjectedDescendant((CogMDXGroup)node) || cogMDXGroups[i].getPropertyValue("PrepareOuterNestedGroupDiffHierarchyApplied") == Boolean.TRUE || cogMDXGroups[i].getPropertyValue("PrepareOuterNestedGroupSameHierarchyApplied") == Boolean.TRUE) continue;
            this.traceNodeCondition(false, "The target CogMDXGroup node is nested under a CogMDXGroup node that has not yet been transformed by PrepareNestedGroupDifferentHierarchy or PrepareNestedGroupSameHierarchy.", trace);
            return false;
        }
        if (((CogMDXGroup)node).getTagType() != null && ((CogMDXGroup)node).getTagType() != "firstTuple" && ((CogMDXGroup)node).getTagType() != "eachTuple") {
            this.traceNodeCondition(false, "The target CogMDXGroup node has an unrecognized CogMDXGroup.PROPERTY_TAG_TYPE_REQ property value.", trace);
            return false;
        }
        if (node.getNumberChildren() != 2 || !((CogMDXGroup)node).validateChildCategories()) {
            this.traceNodeCondition(false, "The target CogMDXGroup node either does not have 2 operands or the operands are not AbstractMDXSet instances.", trace);
            return false;
        }
        if (((AbstractMDXSet)node.getChild(1)).getDescendantsOfType(1027, true).length > 0 || ((AbstractMDXSet)node.getChild(1)).getDescendantsOfType(1026, true).length > 0) {
            this.traceNodeCondition(false, "The second operand of the target CogMDXGroup node has not been planned yet.", trace);
            return false;
        }
        MDXHierInfo firstSetInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        if (firstSetInfo.getNumProjectedHierarchies() != 1) {
            this.traceNodeCondition(false, "The first AbstractMDXSet operand of the target CogMDXGroup node projects more than one hierarchy.", trace);
            return false;
        }
        MDXHierInfo secondSetInfo = ((AbstractMDXSet)node.getChild(1)).getHierarchyInfo();
        if (firstSetInfo.projectedHierarchiesOverlap(secondSetInfo)) {
            this.traceNodeCondition(false, "The projected hierarchies of the first and second AbstractMDXSet operands overlap.", trace);
            return false;
        }
        if (((AbstractMDXSet)node.getChild(1)).isContextDependent(firstSetInfo.getProjectedHierarchy(0))) {
            this.traceNodeCondition(false, "The second AbstractMDXSet operand is context dependent on the hierarchy projected by the first AbstractMDXSet operand.", trace);
            return false;
        }
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge != null && (suppressOnNonEmpty = edge.applyExcludeEmptyHeadSuppression())) {
            this.traceNodeCondition(false, "MDX Non Empty specified on the edge..", trace);
            return false;
        }
        this.traceNodeCondition(true, "The second AbstractMDXSet operand is not context dependent on the hierarchy projected by the first AbstractMDXSet operand.", trace);
        return true;
    }
}

